%%
%% %CopyrightBegin%
%% 
%% Copyright Ericsson AB 2006-2010. All Rights Reserved.
%% 
%% The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved online at http://www.erlang.org/.
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% %CopyrightEnd%
%%
%%
%%% Purpose : Test suite for the xmerl application

%% Do NOT edit this file. It is generated by the generate_xsd_suite module
%% For more info read the comments in the header of that file.

-module('xmerl_xsd_NIST2002-01-16_SUITE').

-compile(export_all).

-include_lib("test_server/include/test_server.hrl").
-include_lib("xmerl/include/xmerl.hrl").
-include_lib("xmerl/include/xmerl_xsd.hrl").


all() -> 
    ['NISTSchema-anyURI', 'NISTSchema-base64Binary',
     'NISTSchema-boolean', 'NISTSchema-byte',
     'NISTSchema-date-', 'NISTSchema-dateTime',
     'NISTSchema-decimal', 'NISTSchema-double',
     'NISTSchema-duration', 'NISTSchema-float',
     'NISTSchema-gDay', 'NISTSchema-gMonth-',
     'NISTSchema-gMonthDay', 'NISTSchema-gYear-',
     'NISTSchema-gYearMonth', 'NISTSchema-hexBinary',
     'NISTSchema-ID', 'NISTSchema-int-',
     'NISTSchema-integer', 'NISTSchema-language',
     'NISTSchema-long', 'NISTSchema-Name',
     'NISTSchema-NCName', 'NISTSchema-negativeInteger',
     'NISTSchema-NMTOKEN', 'NISTSchema-nonNegativeInteger',
     'NISTSchema-nonPositiveInteger',
     'NISTSchema-normalizedString',
     'NISTSchema-positiveInteger', 'NISTSchema-QName',
     'NISTSchema-short', 'NISTSchema-string',
     'NISTSchema-time', 'NISTSchema-token',
     'NISTSchema-unsignedByte', 'NISTSchema-unsignedInt',
     'NISTSchema-unsignedLong', 'NISTSchema-unsignedShort'].

groups() -> 
    [].

init_per_group(_GroupName, Config) ->
    Config.

end_per_group(_GroupName, Config) ->
    Config.



%% initialization before the test suite
init_per_suite(Config) ->
  Dog=test_server:timetrap({minutes,10}),
  xmerl_xsd_lib:unpack(Config,nist),
  {ok,LogFile} = xmerl_xsd_lib:create_error_log_file(Config,nist),
  test_server:timetrap_cancel(Dog),
  [{suite,nist},{xmerl_error_log,LogFile}|Config].

end_per_suite(Config) ->
  xmerl_xsd_lib:rmdir(Config,nist),
  xmerl_xsd_lib:close_error_log_file(Config),
  ok.

%% initialization before each testcase
init_per_testcase(TestCase,Config) ->
  Dog=test_server:timetrap({minutes,3}),
  [{testcase,TestCase},{watchdog, Dog}|Config].

%% clean up after each testcase
end_per_testcase(_Func,Config) ->
  Dog=?config(watchdog, Config),
  test_server:timetrap_cancel(Dog),
  ok.

%% Data type derived by restriction of anyURI by facets

'NISTSchema-anyURI'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./NISTTestsAll/NISTSchema-anyURI-maxLength-1.xsd','./NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-maxLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-maxLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-maxLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-maxLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-5-2.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-5-3.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-5-4.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-maxLength-5-5.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList25 = [ITRes24|ITResList24],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-minLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList30 = [ITRes29|ITResList29],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-minLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList35 = [ITRes34|ITResList34],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-minLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList40 = [ITRes39|ITResList39],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-minLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList42 = [ITRes41|ITResList41],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList43 = [ITRes42|ITResList42],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList44 = [ITRes43|ITResList43],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-minLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-5-2.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-5-3.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-5-4.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList48 = [ITRes47|ITResList47],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-minLength-5-5.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList49 = [ITRes48|ITResList48],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-length-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-1-2.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-1-3.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-1-4.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList53 = [ITRes52|ITResList52],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-1-5.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList54 = [ITRes53|ITResList53],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-length-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList58 = [ITRes57|ITResList57],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList59 = [ITRes58|ITResList58],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-length-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList63 = [ITRes62|ITResList62],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-length-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-length-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-length-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-anyURI-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-anyURI-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList129 = [ITRes128|ITResList128],


  xmerl_xsd_lib:compare_test_results(Config,STResList26,ITResList129).

%% Data type derived by restriction of base64binary by facets

'NISTSchema-base64Binary'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-maxLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-maxLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-maxLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-maxLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-maxLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-5-2.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-5-3.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-5-4.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-maxLength-5-5.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList25 = [ITRes24|ITResList24],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-minLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList30 = [ITRes29|ITResList29],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-minLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList35 = [ITRes34|ITResList34],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-minLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList40 = [ITRes39|ITResList39],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-minLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList42 = [ITRes41|ITResList41],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList43 = [ITRes42|ITResList42],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList45 = [ITRes44|ITResList44],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-minLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-5-2.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-5-3.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList48 = [ITRes47|ITResList47],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-5-4.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-minLength-5-5.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList50 = [ITRes49|ITResList49],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-length-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-1-2.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-1-3.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList53 = [ITRes52|ITResList52],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-1-4.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-1-5.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList55 = [ITRes54|ITResList54],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-length-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList58 = [ITRes57|ITResList57],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList60 = [ITRes59|ITResList59],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-length-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList63 = [ITRes62|ITResList62],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList64 = [ITRes63|ITResList63],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList65 = [ITRes64|ITResList64],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-length-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList69 = [ITRes68|ITResList68],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList70 = [ITRes69|ITResList69],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-length-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList74 = [ITRes73|ITResList73],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-length-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList75 = [ITRes74|ITResList74],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList79 = [ITRes78|ITResList78],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList80 = [ITRes79|ITResList79],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList84 = [ITRes83|ITResList83],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList85 = [ITRes84|ITResList84],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList89 = [ITRes88|ITResList88],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList90 = [ITRes89|ITResList89],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList94 = [ITRes93|ITResList93],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList95 = [ITRes94|ITResList94],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList99 = [ITRes98|ITResList98],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList100 = [ITRes99|ITResList99],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList104 = [ITRes103|ITResList103],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList105 = [ITRes104|ITResList104],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList109 = [ITRes108|ITResList108],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList110 = [ITRes109|ITResList109],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList114 = [ITRes113|ITResList113],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList115 = [ITRes114|ITResList114],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList119 = [ITRes118|ITResList118],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList120 = [ITRes119|ITResList119],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList124 = [ITRes123|ITResList123],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList125 = [ITRes124|ITResList124],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-base64Binary-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList129 = [ITRes128|ITResList128],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-base64Binary-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList130 = [ITRes129|ITResList129],


  xmerl_xsd_lib:compare_test_results(Config,STResList26,ITResList130).

%% Data type derived by restriction of boolean by facets

'NISTSchema-boolean'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-boolean-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-boolean-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-boolean-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-boolean-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList2 = [ITRes1|ITResList1],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-boolean-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-boolean-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList3 = [ITRes2|ITResList2],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-boolean-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-boolean-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList4 = [ITRes3|ITResList3],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-boolean-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-boolean-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList5 = [ITRes4|ITResList4],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-boolean-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-boolean-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-boolean-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-boolean-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList9 = [ITRes8|ITResList8],


  xmerl_xsd_lib:compare_test_results(Config,STResList5,ITResList9).

%% Data type derived by restriction of byte by facets

'NISTSchema-byte'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-fractionDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-fractionDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-fractionDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-fractionDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-fractionDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-fractionDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-totalDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-totalDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-totalDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-totalDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-totalDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-totalDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-totalDigits-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-totalDigits-2-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-totalDigits-2-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-totalDigits-2-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-totalDigits-2-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-totalDigits-2-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-totalDigits-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-totalDigits-3-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-totalDigits-3-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-totalDigits-3-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-totalDigits-3-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-totalDigits-3-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  ?line {STRes31,S31} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList32 = [STRes31|STResList31],
  ?line ITRes139 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList140 = [ITRes139|ITResList139],
  ?line ITRes140 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList141 = [ITRes140|ITResList140],
  ?line ITRes141 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList142 = [ITRes141|ITResList141],
  ?line ITRes142 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList143 = [ITRes142|ITResList142],
  ?line ITRes143 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList144 = [ITRes143|ITResList143],


  ?line {STRes32,S32} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList33 = [STRes32|STResList32],
  ?line ITRes144 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList145 = [ITRes144|ITResList144],
  ?line ITRes145 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList146 = [ITRes145|ITResList145],
  ?line ITRes146 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList147 = [ITRes146|ITResList146],
  ?line ITRes147 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList148 = [ITRes147|ITResList147],
  ?line ITRes148 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList149 = [ITRes148|ITResList148],


  ?line {STRes33,S33} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList34 = [STRes33|STResList33],
  ?line ITRes149 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList150 = [ITRes149|ITResList149],
  ?line ITRes150 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList151 = [ITRes150|ITResList150],
  ?line ITRes151 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList152 = [ITRes151|ITResList151],
  ?line ITRes152 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList153 = [ITRes152|ITResList152],
  ?line ITRes153 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList154 = [ITRes153|ITResList153],


  ?line {STRes34,S34} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-byte-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList35 = [STRes34|STResList34],
  ?line ITRes154 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList155 = [ITRes154|ITResList154],
  ?line ITRes155 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList156 = [ITRes155|ITResList155],
  ?line ITRes156 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList157 = [ITRes156|ITResList156],
  ?line ITRes157 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList158 = [ITRes157|ITResList157],
  ?line ITRes158 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-byte-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList159 = [ITRes158|ITResList158],


  xmerl_xsd_lib:compare_test_results(Config,STResList35,ITResList159).

%% Data type derived by restriction of date by facets

'NISTSchema-date-'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-date-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-date-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  xmerl_xsd_lib:compare_test_results(Config,STResList31,ITResList139).

%% Data type derived by restriction of dateTime by facets

'NISTSchema-dateTime'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-dateTime-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-dateTime-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  xmerl_xsd_lib:compare_test_results(Config,STResList31,ITResList139).

%% Data type derived by restriction of decimal by facets

'NISTSchema-decimal'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-fractionDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-fractionDigits-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-fractionDigits-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-fractionDigits-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-fractionDigits-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-fractionDigits-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-totalDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-totalDigits-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-2-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-2-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-2-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-2-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-2-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-totalDigits-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-3-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-3-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-3-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-3-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-3-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-totalDigits-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-4-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-4-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-4-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-4-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-4-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-totalDigits-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-5-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-5-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-5-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-5-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-totalDigits-5-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  ?line {STRes31,S31} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList32 = [STRes31|STResList31],
  ?line ITRes139 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList140 = [ITRes139|ITResList139],
  ?line ITRes140 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList141 = [ITRes140|ITResList140],
  ?line ITRes141 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList142 = [ITRes141|ITResList141],
  ?line ITRes142 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList143 = [ITRes142|ITResList142],
  ?line ITRes143 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList144 = [ITRes143|ITResList143],


  ?line {STRes32,S32} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList33 = [STRes32|STResList32],
  ?line ITRes144 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList145 = [ITRes144|ITResList144],
  ?line ITRes145 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList146 = [ITRes145|ITResList145],
  ?line ITRes146 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList147 = [ITRes146|ITResList146],
  ?line ITRes147 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList148 = [ITRes147|ITResList147],
  ?line ITRes148 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList149 = [ITRes148|ITResList148],


  ?line {STRes33,S33} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList34 = [STRes33|STResList33],
  ?line ITRes149 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList150 = [ITRes149|ITResList149],
  ?line ITRes150 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList151 = [ITRes150|ITResList150],
  ?line ITRes151 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList152 = [ITRes151|ITResList151],
  ?line ITRes152 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList153 = [ITRes152|ITResList152],
  ?line ITRes153 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList154 = [ITRes153|ITResList153],


  ?line {STRes34,S34} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList35 = [STRes34|STResList34],
  ?line ITRes154 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList155 = [ITRes154|ITResList154],
  ?line ITRes155 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList156 = [ITRes155|ITResList155],
  ?line ITRes156 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList157 = [ITRes156|ITResList156],
  ?line ITRes157 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList158 = [ITRes157|ITResList157],
  ?line ITRes158 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList159 = [ITRes158|ITResList158],


  ?line {STRes35,S35} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList36 = [STRes35|STResList35],
  ?line ITRes159 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList160 = [ITRes159|ITResList159],
  ?line ITRes160 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList161 = [ITRes160|ITResList160],
  ?line ITRes161 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList162 = [ITRes161|ITResList161],
  ?line ITRes162 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList163 = [ITRes162|ITResList162],
  ?line ITRes163 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList164 = [ITRes163|ITResList163],


  ?line {STRes36,S36} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList37 = [STRes36|STResList36],
  ?line ITRes164 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList165 = [ITRes164|ITResList164],
  ?line ITRes165 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList166 = [ITRes165|ITResList165],
  ?line ITRes166 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList167 = [ITRes166|ITResList166],
  ?line ITRes167 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList168 = [ITRes167|ITResList167],
  ?line ITRes168 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList169 = [ITRes168|ITResList168],


  ?line {STRes37,S37} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList38 = [STRes37|STResList37],
  ?line ITRes169 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S37),
  ITResList170 = [ITRes169|ITResList169],
  ?line ITRes170 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S37),
  ITResList171 = [ITRes170|ITResList170],
  ?line ITRes171 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S37),
  ITResList172 = [ITRes171|ITResList171],
  ?line ITRes172 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S37),
  ITResList173 = [ITRes172|ITResList172],
  ?line ITRes173 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S37),
  ITResList174 = [ITRes173|ITResList173],


  ?line {STRes38,S38} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList39 = [STRes38|STResList38],
  ?line ITRes174 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S38),
  ITResList175 = [ITRes174|ITResList174],
  ?line ITRes175 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S38),
  ITResList176 = [ITRes175|ITResList175],
  ?line ITRes176 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S38),
  ITResList177 = [ITRes176|ITResList176],
  ?line ITRes177 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S38),
  ITResList178 = [ITRes177|ITResList177],
  ?line ITRes178 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S38),
  ITResList179 = [ITRes178|ITResList178],


  ?line {STRes39,S39} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList40 = [STRes39|STResList39],
  ?line ITRes179 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S39),
  ITResList180 = [ITRes179|ITResList179],
  ?line ITRes180 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S39),
  ITResList181 = [ITRes180|ITResList180],
  ?line ITRes181 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S39),
  ITResList182 = [ITRes181|ITResList181],
  ?line ITRes182 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S39),
  ITResList183 = [ITRes182|ITResList182],
  ?line ITRes183 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S39),
  ITResList184 = [ITRes183|ITResList183],


  ?line {STRes40,S40} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-decimal-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList41 = [STRes40|STResList40],
  ?line ITRes184 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S40),
  ITResList185 = [ITRes184|ITResList184],
  ?line ITRes185 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S40),
  ITResList186 = [ITRes185|ITResList185],
  ?line ITRes186 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S40),
  ITResList187 = [ITRes186|ITResList186],
  ?line ITRes187 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S40),
  ITResList188 = [ITRes187|ITResList187],
  ?line ITRes188 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-decimal-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S40),
  ITResList189 = [ITRes188|ITResList188],


  xmerl_xsd_lib:compare_test_results(Config,STResList41,ITResList189).

%% Data type derived by restriction of double by facets

'NISTSchema-double'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-double-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-double-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  xmerl_xsd_lib:compare_test_results(Config,STResList31,ITResList139).

%% Data type derived by restriction of duration by facets

'NISTSchema-duration'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-duration-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-duration-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  xmerl_xsd_lib:compare_test_results(Config,STResList31,ITResList139).

%% Data type derived by restriction of float by facets

'NISTSchema-float'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-float-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-float-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  xmerl_xsd_lib:compare_test_results(Config,STResList31,ITResList139).

%% Data type derived by restriction of gDay by facets

'NISTSchema-gDay'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList79 = [ITRes78|ITResList78],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList84 = [ITRes83|ITResList83],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList89 = [ITRes88|ITResList88],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList94 = [ITRes93|ITResList93],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList99 = [ITRes98|ITResList98],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList104 = [ITRes103|ITResList103],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList109 = [ITRes108|ITResList108],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList114 = [ITRes113|ITResList113],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList119 = [ITRes118|ITResList118],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList124 = [ITRes123|ITResList123],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList129 = [ITRes128|ITResList128],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gDay-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList134 = [ITRes133|ITResList133],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gDay-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],


  xmerl_xsd_lib:compare_test_results(Config,STResList31,ITResList135).

%% Data type derived by restriction of gMonth by facets

'NISTSchema-gMonth-'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonth-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonth-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  xmerl_xsd_lib:compare_test_results(Config,STResList31,ITResList139).

%% Data type derived by restriction of gMonthDay by facets

'NISTSchema-gMonthDay'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gMonthDay-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gMonthDay-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  xmerl_xsd_lib:compare_test_results(Config,STResList31,ITResList139).

%% Data type derived by restriction of gYear by facets

'NISTSchema-gYear-'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList69 = [ITRes68|ITResList68],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList74 = [ITRes73|ITResList73],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList79 = [ITRes78|ITResList78],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList84 = [ITRes83|ITResList83],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList89 = [ITRes88|ITResList88],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList94 = [ITRes93|ITResList93],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList99 = [ITRes98|ITResList98],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList104 = [ITRes103|ITResList103],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList109 = [ITRes108|ITResList108],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList114 = [ITRes113|ITResList113],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList119 = [ITRes118|ITResList118],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList124 = [ITRes123|ITResList123],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList129 = [ITRes128|ITResList128],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYear-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList134 = [ITRes133|ITResList133],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYear-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],


  xmerl_xsd_lib:compare_test_results(Config,STResList31,ITResList135).

%% Data type derived by restriction of gYearMonth by facets

'NISTSchema-gYearMonth'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-gYearMonth-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-gYearMonth-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  xmerl_xsd_lib:compare_test_results(Config,STResList31,ITResList139).

%% Data type derived by restriction of hexBinary by facets

'NISTSchema-hexBinary'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-maxLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-maxLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-maxLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-maxLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-maxLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-5-2.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-5-3.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-5-4.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-maxLength-5-5.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList25 = [ITRes24|ITResList24],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-minLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList30 = [ITRes29|ITResList29],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-minLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList35 = [ITRes34|ITResList34],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-minLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList40 = [ITRes39|ITResList39],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-minLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList42 = [ITRes41|ITResList41],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList43 = [ITRes42|ITResList42],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList45 = [ITRes44|ITResList44],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-minLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-5-2.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-5-3.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList48 = [ITRes47|ITResList47],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-5-4.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-minLength-5-5.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList50 = [ITRes49|ITResList49],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-length-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-1-2.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-1-3.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList53 = [ITRes52|ITResList52],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-1-4.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-1-5.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList55 = [ITRes54|ITResList54],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-length-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList58 = [ITRes57|ITResList57],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList60 = [ITRes59|ITResList59],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-length-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList63 = [ITRes62|ITResList62],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList64 = [ITRes63|ITResList63],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList65 = [ITRes64|ITResList64],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-length-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList69 = [ITRes68|ITResList68],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList70 = [ITRes69|ITResList69],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-length-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList74 = [ITRes73|ITResList73],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-length-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList75 = [ITRes74|ITResList74],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList79 = [ITRes78|ITResList78],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList80 = [ITRes79|ITResList79],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList84 = [ITRes83|ITResList83],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList85 = [ITRes84|ITResList84],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList89 = [ITRes88|ITResList88],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList90 = [ITRes89|ITResList89],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList94 = [ITRes93|ITResList93],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList95 = [ITRes94|ITResList94],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList99 = [ITRes98|ITResList98],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList100 = [ITRes99|ITResList99],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList104 = [ITRes103|ITResList103],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList105 = [ITRes104|ITResList104],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList109 = [ITRes108|ITResList108],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList110 = [ITRes109|ITResList109],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList114 = [ITRes113|ITResList113],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList115 = [ITRes114|ITResList114],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList119 = [ITRes118|ITResList118],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList120 = [ITRes119|ITResList119],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList124 = [ITRes123|ITResList123],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList125 = [ITRes124|ITResList124],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-hexBinary-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList129 = [ITRes128|ITResList128],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-hexBinary-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList130 = [ITRes129|ITResList129],


  xmerl_xsd_lib:compare_test_results(Config,STResList26,ITResList130).

%% Data type derived by restriction of ID by facets

'NISTSchema-ID'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-maxLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-maxLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-maxLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-maxLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-maxLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-5-2.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-5-3.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-5-4.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-maxLength-5-5.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList25 = [ITRes24|ITResList24],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-minLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList30 = [ITRes29|ITResList29],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-minLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList35 = [ITRes34|ITResList34],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-minLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList40 = [ITRes39|ITResList39],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-minLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList42 = [ITRes41|ITResList41],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList43 = [ITRes42|ITResList42],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList45 = [ITRes44|ITResList44],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-minLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-5-2.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-5-3.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList48 = [ITRes47|ITResList47],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-5-4.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-minLength-5-5.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList50 = [ITRes49|ITResList49],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-length-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-1-2.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-1-3.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList53 = [ITRes52|ITResList52],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-1-4.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-1-5.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList55 = [ITRes54|ITResList54],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-length-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList58 = [ITRes57|ITResList57],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList60 = [ITRes59|ITResList59],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-length-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList63 = [ITRes62|ITResList62],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList64 = [ITRes63|ITResList63],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList65 = [ITRes64|ITResList64],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-length-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList69 = [ITRes68|ITResList68],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList70 = [ITRes69|ITResList69],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-length-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList74 = [ITRes73|ITResList73],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-length-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList75 = [ITRes74|ITResList74],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList79 = [ITRes78|ITResList78],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList80 = [ITRes79|ITResList79],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList84 = [ITRes83|ITResList83],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList85 = [ITRes84|ITResList84],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList89 = [ITRes88|ITResList88],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList90 = [ITRes89|ITResList89],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList94 = [ITRes93|ITResList93],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList95 = [ITRes94|ITResList94],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList99 = [ITRes98|ITResList98],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList100 = [ITRes99|ITResList99],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList104 = [ITRes103|ITResList103],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList105 = [ITRes104|ITResList104],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList109 = [ITRes108|ITResList108],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList110 = [ITRes109|ITResList109],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList114 = [ITRes113|ITResList113],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList115 = [ITRes114|ITResList114],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList119 = [ITRes118|ITResList118],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList120 = [ITRes119|ITResList119],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList124 = [ITRes123|ITResList123],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList125 = [ITRes124|ITResList124],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-ID-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList129 = [ITRes128|ITResList128],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-ID-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList130 = [ITRes129|ITResList129],


  xmerl_xsd_lib:compare_test_results(Config,STResList26,ITResList130).

%% Data type derived by restriction of int by facets

'NISTSchema-int-'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-fractionDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-fractionDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-fractionDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-fractionDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-fractionDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-fractionDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-totalDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-totalDigits-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-2-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-2-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-2-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-2-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-2-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-totalDigits-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-3-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-3-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-3-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-3-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-3-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-totalDigits-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-4-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-4-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-4-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-4-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-4-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-totalDigits-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-5-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-5-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-5-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-5-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-totalDigits-5-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  ?line {STRes31,S31} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList32 = [STRes31|STResList31],
  ?line ITRes139 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList140 = [ITRes139|ITResList139],
  ?line ITRes140 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList141 = [ITRes140|ITResList140],
  ?line ITRes141 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList142 = [ITRes141|ITResList141],
  ?line ITRes142 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList143 = [ITRes142|ITResList142],
  ?line ITRes143 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList144 = [ITRes143|ITResList143],


  ?line {STRes32,S32} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList33 = [STRes32|STResList32],
  ?line ITRes144 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList145 = [ITRes144|ITResList144],
  ?line ITRes145 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList146 = [ITRes145|ITResList145],
  ?line ITRes146 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList147 = [ITRes146|ITResList146],
  ?line ITRes147 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList148 = [ITRes147|ITResList147],
  ?line ITRes148 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList149 = [ITRes148|ITResList148],


  ?line {STRes33,S33} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList34 = [STRes33|STResList33],
  ?line ITRes149 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList150 = [ITRes149|ITResList149],
  ?line ITRes150 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList151 = [ITRes150|ITResList150],
  ?line ITRes151 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList152 = [ITRes151|ITResList151],
  ?line ITRes152 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList153 = [ITRes152|ITResList152],
  ?line ITRes153 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList154 = [ITRes153|ITResList153],


  ?line {STRes34,S34} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList35 = [STRes34|STResList34],
  ?line ITRes154 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList155 = [ITRes154|ITResList154],
  ?line ITRes155 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList156 = [ITRes155|ITResList155],
  ?line ITRes156 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList157 = [ITRes156|ITResList156],
  ?line ITRes157 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList158 = [ITRes157|ITResList157],
  ?line ITRes158 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList159 = [ITRes158|ITResList158],


  ?line {STRes35,S35} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList36 = [STRes35|STResList35],
  ?line ITRes159 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList160 = [ITRes159|ITResList159],
  ?line ITRes160 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList161 = [ITRes160|ITResList160],
  ?line ITRes161 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList162 = [ITRes161|ITResList161],
  ?line ITRes162 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList163 = [ITRes162|ITResList162],
  ?line ITRes163 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList164 = [ITRes163|ITResList163],


  ?line {STRes36,S36} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-int-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList37 = [STRes36|STResList36],
  ?line ITRes164 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList165 = [ITRes164|ITResList164],
  ?line ITRes165 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList166 = [ITRes165|ITResList165],
  ?line ITRes166 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList167 = [ITRes166|ITResList166],
  ?line ITRes167 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList168 = [ITRes167|ITResList167],
  ?line ITRes168 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-int-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList169 = [ITRes168|ITResList168],


  xmerl_xsd_lib:compare_test_results(Config,STResList37,ITResList169).

%% Data type derived by restriction of integer by facets

'NISTSchema-integer'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-fractionDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-fractionDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-fractionDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-fractionDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-fractionDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-fractionDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-totalDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-totalDigits-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-2-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-2-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-2-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-2-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-2-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-totalDigits-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-3-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-3-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-3-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-3-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-3-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-totalDigits-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-4-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-4-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-4-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-4-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-4-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-totalDigits-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-5-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-5-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-5-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-5-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-totalDigits-5-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  ?line {STRes31,S31} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList32 = [STRes31|STResList31],
  ?line ITRes139 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList140 = [ITRes139|ITResList139],
  ?line ITRes140 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList141 = [ITRes140|ITResList140],
  ?line ITRes141 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList142 = [ITRes141|ITResList141],
  ?line ITRes142 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList143 = [ITRes142|ITResList142],
  ?line ITRes143 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList144 = [ITRes143|ITResList143],


  ?line {STRes32,S32} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList33 = [STRes32|STResList32],
  ?line ITRes144 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList145 = [ITRes144|ITResList144],
  ?line ITRes145 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList146 = [ITRes145|ITResList145],
  ?line ITRes146 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList147 = [ITRes146|ITResList146],
  ?line ITRes147 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList148 = [ITRes147|ITResList147],
  ?line ITRes148 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList149 = [ITRes148|ITResList148],


  ?line {STRes33,S33} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList34 = [STRes33|STResList33],
  ?line ITRes149 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList150 = [ITRes149|ITResList149],
  ?line ITRes150 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList151 = [ITRes150|ITResList150],
  ?line ITRes151 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList152 = [ITRes151|ITResList151],
  ?line ITRes152 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList153 = [ITRes152|ITResList152],
  ?line ITRes153 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList154 = [ITRes153|ITResList153],


  ?line {STRes34,S34} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList35 = [STRes34|STResList34],
  ?line ITRes154 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList155 = [ITRes154|ITResList154],
  ?line ITRes155 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList156 = [ITRes155|ITResList155],
  ?line ITRes156 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList157 = [ITRes156|ITResList156],
  ?line ITRes157 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList158 = [ITRes157|ITResList157],
  ?line ITRes158 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList159 = [ITRes158|ITResList158],


  ?line {STRes35,S35} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList36 = [STRes35|STResList35],
  ?line ITRes159 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList160 = [ITRes159|ITResList159],
  ?line ITRes160 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList161 = [ITRes160|ITResList160],
  ?line ITRes161 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList162 = [ITRes161|ITResList161],
  ?line ITRes162 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList163 = [ITRes162|ITResList162],
  ?line ITRes163 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList164 = [ITRes163|ITResList163],


  ?line {STRes36,S36} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-integer-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList37 = [STRes36|STResList36],
  ?line ITRes164 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList165 = [ITRes164|ITResList164],
  ?line ITRes165 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList166 = [ITRes165|ITResList165],
  ?line ITRes166 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList167 = [ITRes166|ITResList166],
  ?line ITRes167 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList168 = [ITRes167|ITResList167],
  ?line ITRes168 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-integer-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList169 = [ITRes168|ITResList168],


  xmerl_xsd_lib:compare_test_results(Config,STResList37,ITResList169).

%% Data type derived by restriction of language by facets

'NISTSchema-language'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-maxLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-maxLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-maxLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList10 = [ITRes9|ITResList9],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-maxLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList15 = [ITRes14|ITResList14],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-maxLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-5-2.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-5-3.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-5-4.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList20 = [ITRes19|ITResList19],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-maxLength-5-5.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-minLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-minLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-minLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-minLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-minLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-5-2.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList43 = [ITRes42|ITResList42],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-5-3.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-5-4.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-minLength-5-5.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList46 = [ITRes45|ITResList45],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-length-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-1-2.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList48 = [ITRes47|ITResList47],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-1-3.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-1-4.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-1-5.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList51 = [ITRes50|ITResList50],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-length-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList53 = [ITRes52|ITResList52],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList56 = [ITRes55|ITResList55],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-length-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList58 = [ITRes57|ITResList57],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList61 = [ITRes60|ITResList60],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-length-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList63 = [ITRes62|ITResList62],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList64 = [ITRes63|ITResList63],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList66 = [ITRes65|ITResList65],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-length-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList69 = [ITRes68|ITResList68],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-length-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList71 = [ITRes70|ITResList70],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList74 = [ITRes73|ITResList73],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList76 = [ITRes75|ITResList75],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList79 = [ITRes78|ITResList78],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList81 = [ITRes80|ITResList80],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList84 = [ITRes83|ITResList83],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList86 = [ITRes85|ITResList85],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList89 = [ITRes88|ITResList88],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList91 = [ITRes90|ITResList90],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList94 = [ITRes93|ITResList93],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList96 = [ITRes95|ITResList95],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList99 = [ITRes98|ITResList98],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList101 = [ITRes100|ITResList100],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList104 = [ITRes103|ITResList103],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList106 = [ITRes105|ITResList105],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList109 = [ITRes108|ITResList108],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList111 = [ITRes110|ITResList110],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList114 = [ITRes113|ITResList113],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList116 = [ITRes115|ITResList115],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList119 = [ITRes118|ITResList118],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList121 = [ITRes120|ITResList120],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-language-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList124 = [ITRes123|ITResList123],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-language-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList126 = [ITRes125|ITResList125],


  xmerl_xsd_lib:compare_test_results(Config,STResList26,ITResList126).

%% Data type derived by restriction of long by facets

'NISTSchema-long'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-fractionDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-fractionDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-fractionDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-fractionDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-fractionDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-fractionDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-totalDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-totalDigits-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-2-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-2-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-2-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-2-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-2-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-totalDigits-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-3-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-3-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-3-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-3-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-3-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-totalDigits-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-4-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-4-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-4-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-4-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-4-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-totalDigits-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-5-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-5-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-5-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-5-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-totalDigits-5-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  ?line {STRes31,S31} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList32 = [STRes31|STResList31],
  ?line ITRes139 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList140 = [ITRes139|ITResList139],
  ?line ITRes140 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList141 = [ITRes140|ITResList140],
  ?line ITRes141 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList142 = [ITRes141|ITResList141],
  ?line ITRes142 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList143 = [ITRes142|ITResList142],
  ?line ITRes143 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList144 = [ITRes143|ITResList143],


  ?line {STRes32,S32} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList33 = [STRes32|STResList32],
  ?line ITRes144 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList145 = [ITRes144|ITResList144],
  ?line ITRes145 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList146 = [ITRes145|ITResList145],
  ?line ITRes146 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList147 = [ITRes146|ITResList146],
  ?line ITRes147 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList148 = [ITRes147|ITResList147],
  ?line ITRes148 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList149 = [ITRes148|ITResList148],


  ?line {STRes33,S33} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList34 = [STRes33|STResList33],
  ?line ITRes149 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList150 = [ITRes149|ITResList149],
  ?line ITRes150 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList151 = [ITRes150|ITResList150],
  ?line ITRes151 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList152 = [ITRes151|ITResList151],
  ?line ITRes152 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList153 = [ITRes152|ITResList152],
  ?line ITRes153 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList154 = [ITRes153|ITResList153],


  ?line {STRes34,S34} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList35 = [STRes34|STResList34],
  ?line ITRes154 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList155 = [ITRes154|ITResList154],
  ?line ITRes155 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList156 = [ITRes155|ITResList155],
  ?line ITRes156 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList157 = [ITRes156|ITResList156],
  ?line ITRes157 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList158 = [ITRes157|ITResList157],
  ?line ITRes158 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList159 = [ITRes158|ITResList158],


  ?line {STRes35,S35} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList36 = [STRes35|STResList35],
  ?line ITRes159 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList160 = [ITRes159|ITResList159],
  ?line ITRes160 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList161 = [ITRes160|ITResList160],
  ?line ITRes161 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList162 = [ITRes161|ITResList161],
  ?line ITRes162 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList163 = [ITRes162|ITResList162],
  ?line ITRes163 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList164 = [ITRes163|ITResList163],


  ?line {STRes36,S36} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-long-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList37 = [STRes36|STResList36],
  ?line ITRes164 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList165 = [ITRes164|ITResList164],
  ?line ITRes165 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList166 = [ITRes165|ITResList165],
  ?line ITRes166 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList167 = [ITRes166|ITResList166],
  ?line ITRes167 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList168 = [ITRes167|ITResList167],
  ?line ITRes168 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-long-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList169 = [ITRes168|ITResList168],


  xmerl_xsd_lib:compare_test_results(Config,STResList37,ITResList169).

%% Data type derived by restriction of Name by facets

'NISTSchema-Name'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-maxLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-maxLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-maxLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-maxLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-maxLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-5-2.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-5-3.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-5-4.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-maxLength-5-5.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList25 = [ITRes24|ITResList24],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-minLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList30 = [ITRes29|ITResList29],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-minLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList35 = [ITRes34|ITResList34],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-minLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList40 = [ITRes39|ITResList39],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-minLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList42 = [ITRes41|ITResList41],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList43 = [ITRes42|ITResList42],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList45 = [ITRes44|ITResList44],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-minLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-5-2.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-5-3.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList48 = [ITRes47|ITResList47],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-5-4.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-minLength-5-5.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList50 = [ITRes49|ITResList49],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-length-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-1-2.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-1-3.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList53 = [ITRes52|ITResList52],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-1-4.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-1-5.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList55 = [ITRes54|ITResList54],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-length-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList58 = [ITRes57|ITResList57],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList60 = [ITRes59|ITResList59],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-length-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList63 = [ITRes62|ITResList62],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList64 = [ITRes63|ITResList63],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList65 = [ITRes64|ITResList64],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-length-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList69 = [ITRes68|ITResList68],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList70 = [ITRes69|ITResList69],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-length-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList74 = [ITRes73|ITResList73],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-length-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList75 = [ITRes74|ITResList74],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList79 = [ITRes78|ITResList78],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList80 = [ITRes79|ITResList79],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList84 = [ITRes83|ITResList83],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList85 = [ITRes84|ITResList84],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList89 = [ITRes88|ITResList88],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList90 = [ITRes89|ITResList89],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList94 = [ITRes93|ITResList93],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList95 = [ITRes94|ITResList94],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList99 = [ITRes98|ITResList98],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList100 = [ITRes99|ITResList99],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList104 = [ITRes103|ITResList103],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList105 = [ITRes104|ITResList104],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList109 = [ITRes108|ITResList108],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList110 = [ITRes109|ITResList109],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList114 = [ITRes113|ITResList113],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList115 = [ITRes114|ITResList114],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList119 = [ITRes118|ITResList118],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList120 = [ITRes119|ITResList119],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList124 = [ITRes123|ITResList123],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList125 = [ITRes124|ITResList124],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-Name-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList129 = [ITRes128|ITResList128],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-Name-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList130 = [ITRes129|ITResList129],


  xmerl_xsd_lib:compare_test_results(Config,STResList26,ITResList130).

%% Data type derived by restriction of NCName by facets

'NISTSchema-NCName'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-maxLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-maxLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-maxLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-maxLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-maxLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-5-2.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-5-3.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-5-4.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-maxLength-5-5.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList25 = [ITRes24|ITResList24],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-minLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList30 = [ITRes29|ITResList29],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-minLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList35 = [ITRes34|ITResList34],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-minLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList40 = [ITRes39|ITResList39],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-minLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList42 = [ITRes41|ITResList41],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList43 = [ITRes42|ITResList42],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList45 = [ITRes44|ITResList44],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-minLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-5-2.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-5-3.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList48 = [ITRes47|ITResList47],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-5-4.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-minLength-5-5.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList50 = [ITRes49|ITResList49],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-length-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-1-2.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-1-3.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList53 = [ITRes52|ITResList52],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-1-4.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-1-5.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList55 = [ITRes54|ITResList54],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-length-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList58 = [ITRes57|ITResList57],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList60 = [ITRes59|ITResList59],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-length-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList63 = [ITRes62|ITResList62],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList64 = [ITRes63|ITResList63],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList65 = [ITRes64|ITResList64],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-length-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList69 = [ITRes68|ITResList68],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList70 = [ITRes69|ITResList69],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-length-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList74 = [ITRes73|ITResList73],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-length-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList75 = [ITRes74|ITResList74],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList79 = [ITRes78|ITResList78],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList80 = [ITRes79|ITResList79],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList84 = [ITRes83|ITResList83],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList85 = [ITRes84|ITResList84],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList89 = [ITRes88|ITResList88],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList90 = [ITRes89|ITResList89],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList94 = [ITRes93|ITResList93],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList95 = [ITRes94|ITResList94],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList99 = [ITRes98|ITResList98],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList100 = [ITRes99|ITResList99],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList104 = [ITRes103|ITResList103],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList105 = [ITRes104|ITResList104],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList109 = [ITRes108|ITResList108],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList110 = [ITRes109|ITResList109],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList114 = [ITRes113|ITResList113],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList115 = [ITRes114|ITResList114],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList119 = [ITRes118|ITResList118],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList120 = [ITRes119|ITResList119],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList124 = [ITRes123|ITResList123],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList125 = [ITRes124|ITResList124],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NCName-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList129 = [ITRes128|ITResList128],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NCName-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList130 = [ITRes129|ITResList129],


  xmerl_xsd_lib:compare_test_results(Config,STResList26,ITResList130).

%% Data type derived by restriction of negativeInteger by facets

'NISTSchema-negativeInteger'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-fractionDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-fractionDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-fractionDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-fractionDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-fractionDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-fractionDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-totalDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-totalDigits-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-2-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-2-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-2-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-2-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-2-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-totalDigits-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-3-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-3-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-3-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-3-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-3-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-totalDigits-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-4-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-4-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-4-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-4-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-4-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-totalDigits-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-5-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-5-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-5-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-5-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-totalDigits-5-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  ?line {STRes31,S31} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList32 = [STRes31|STResList31],
  ?line ITRes139 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList140 = [ITRes139|ITResList139],
  ?line ITRes140 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList141 = [ITRes140|ITResList140],
  ?line ITRes141 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList142 = [ITRes141|ITResList141],
  ?line ITRes142 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList143 = [ITRes142|ITResList142],
  ?line ITRes143 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList144 = [ITRes143|ITResList143],


  ?line {STRes32,S32} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList33 = [STRes32|STResList32],
  ?line ITRes144 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList145 = [ITRes144|ITResList144],
  ?line ITRes145 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList146 = [ITRes145|ITResList145],
  ?line ITRes146 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList147 = [ITRes146|ITResList146],
  ?line ITRes147 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList148 = [ITRes147|ITResList147],
  ?line ITRes148 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList149 = [ITRes148|ITResList148],


  ?line {STRes33,S33} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList34 = [STRes33|STResList33],
  ?line ITRes149 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList150 = [ITRes149|ITResList149],
  ?line ITRes150 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList151 = [ITRes150|ITResList150],
  ?line ITRes151 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList152 = [ITRes151|ITResList151],
  ?line ITRes152 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList153 = [ITRes152|ITResList152],
  ?line ITRes153 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList154 = [ITRes153|ITResList153],


  ?line {STRes34,S34} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList35 = [STRes34|STResList34],
  ?line ITRes154 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList155 = [ITRes154|ITResList154],
  ?line ITRes155 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList156 = [ITRes155|ITResList155],
  ?line ITRes156 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList157 = [ITRes156|ITResList156],
  ?line ITRes157 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList158 = [ITRes157|ITResList157],
  ?line ITRes158 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList159 = [ITRes158|ITResList158],


  ?line {STRes35,S35} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList36 = [STRes35|STResList35],
  ?line ITRes159 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList160 = [ITRes159|ITResList159],
  ?line ITRes160 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList161 = [ITRes160|ITResList160],
  ?line ITRes161 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList162 = [ITRes161|ITResList161],
  ?line ITRes162 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList163 = [ITRes162|ITResList162],
  ?line ITRes163 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList164 = [ITRes163|ITResList163],


  ?line {STRes36,S36} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-negativeInteger-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList37 = [STRes36|STResList36],
  ?line ITRes164 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList165 = [ITRes164|ITResList164],
  ?line ITRes165 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList166 = [ITRes165|ITResList165],
  ?line ITRes166 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList167 = [ITRes166|ITResList166],
  ?line ITRes167 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList168 = [ITRes167|ITResList167],
  ?line ITRes168 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-negativeInteger-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList169 = [ITRes168|ITResList168],


  xmerl_xsd_lib:compare_test_results(Config,STResList37,ITResList169).

%% Data type derived by restriction of NMTOKEN by facets

'NISTSchema-NMTOKEN'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-maxLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-maxLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-maxLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-maxLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-maxLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-5-2.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-5-3.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-5-4.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-maxLength-5-5.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList25 = [ITRes24|ITResList24],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-minLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList30 = [ITRes29|ITResList29],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-minLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList35 = [ITRes34|ITResList34],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-minLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList40 = [ITRes39|ITResList39],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-minLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList42 = [ITRes41|ITResList41],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList43 = [ITRes42|ITResList42],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList45 = [ITRes44|ITResList44],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-minLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-5-2.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-5-3.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList48 = [ITRes47|ITResList47],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-5-4.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-minLength-5-5.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList50 = [ITRes49|ITResList49],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-length-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-1-2.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-1-3.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList53 = [ITRes52|ITResList52],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-1-4.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-1-5.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList55 = [ITRes54|ITResList54],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-length-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList58 = [ITRes57|ITResList57],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList60 = [ITRes59|ITResList59],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-length-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList63 = [ITRes62|ITResList62],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList64 = [ITRes63|ITResList63],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList65 = [ITRes64|ITResList64],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-length-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList69 = [ITRes68|ITResList68],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList70 = [ITRes69|ITResList69],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-length-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList74 = [ITRes73|ITResList73],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-length-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList75 = [ITRes74|ITResList74],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList79 = [ITRes78|ITResList78],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList80 = [ITRes79|ITResList79],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList84 = [ITRes83|ITResList83],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList85 = [ITRes84|ITResList84],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList89 = [ITRes88|ITResList88],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList90 = [ITRes89|ITResList89],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList94 = [ITRes93|ITResList93],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList95 = [ITRes94|ITResList94],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList99 = [ITRes98|ITResList98],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList100 = [ITRes99|ITResList99],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList104 = [ITRes103|ITResList103],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList105 = [ITRes104|ITResList104],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList109 = [ITRes108|ITResList108],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList110 = [ITRes109|ITResList109],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList114 = [ITRes113|ITResList113],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList115 = [ITRes114|ITResList114],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList118 = [ITRes117|ITResList117],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList119 = [ITRes118|ITResList118],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList123 = [ITRes122|ITResList122],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-NMTOKEN-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList124 = [ITRes123|ITResList123],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-NMTOKEN-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList128 = [ITRes127|ITResList127],


  xmerl_xsd_lib:compare_test_results(Config,STResList26,ITResList128).

%% Data type derived by restriction of nonNegativeInteger by facets

'NISTSchema-nonNegativeInteger'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-fractionDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-fractionDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-fractionDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-fractionDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-fractionDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-fractionDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-totalDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-totalDigits-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-2-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-2-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-2-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-2-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-2-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-totalDigits-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-3-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-3-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-3-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-3-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-3-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-totalDigits-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-4-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-4-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-4-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-4-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-4-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-totalDigits-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-5-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-5-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-5-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-5-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-totalDigits-5-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  ?line {STRes31,S31} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList32 = [STRes31|STResList31],
  ?line ITRes139 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList140 = [ITRes139|ITResList139],
  ?line ITRes140 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList141 = [ITRes140|ITResList140],
  ?line ITRes141 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList142 = [ITRes141|ITResList141],
  ?line ITRes142 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList143 = [ITRes142|ITResList142],
  ?line ITRes143 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList144 = [ITRes143|ITResList143],


  ?line {STRes32,S32} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList33 = [STRes32|STResList32],
  ?line ITRes144 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList145 = [ITRes144|ITResList144],
  ?line ITRes145 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList146 = [ITRes145|ITResList145],
  ?line ITRes146 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList147 = [ITRes146|ITResList146],
  ?line ITRes147 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList148 = [ITRes147|ITResList147],
  ?line ITRes148 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList149 = [ITRes148|ITResList148],


  ?line {STRes33,S33} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList34 = [STRes33|STResList33],
  ?line ITRes149 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList150 = [ITRes149|ITResList149],
  ?line ITRes150 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList151 = [ITRes150|ITResList150],
  ?line ITRes151 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList152 = [ITRes151|ITResList151],
  ?line ITRes152 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList153 = [ITRes152|ITResList152],
  ?line ITRes153 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList154 = [ITRes153|ITResList153],


  ?line {STRes34,S34} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList35 = [STRes34|STResList34],
  ?line ITRes154 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList155 = [ITRes154|ITResList154],
  ?line ITRes155 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList156 = [ITRes155|ITResList155],
  ?line ITRes156 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList157 = [ITRes156|ITResList156],
  ?line ITRes157 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList158 = [ITRes157|ITResList157],
  ?line ITRes158 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList159 = [ITRes158|ITResList158],


  ?line {STRes35,S35} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList36 = [STRes35|STResList35],
  ?line ITRes159 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList160 = [ITRes159|ITResList159],
  ?line ITRes160 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList161 = [ITRes160|ITResList160],
  ?line ITRes161 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList162 = [ITRes161|ITResList161],
  ?line ITRes162 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList163 = [ITRes162|ITResList162],
  ?line ITRes163 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList164 = [ITRes163|ITResList163],


  ?line {STRes36,S36} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonNegativeInteger-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList37 = [STRes36|STResList36],
  ?line ITRes164 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList165 = [ITRes164|ITResList164],
  ?line ITRes165 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList166 = [ITRes165|ITResList165],
  ?line ITRes166 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList167 = [ITRes166|ITResList166],
  ?line ITRes167 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList168 = [ITRes167|ITResList167],
  ?line ITRes168 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonNegativeInteger-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList169 = [ITRes168|ITResList168],


  xmerl_xsd_lib:compare_test_results(Config,STResList37,ITResList169).

%% Data type derived by restriction of nonPositiveInteger by facets

'NISTSchema-nonPositiveInteger'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-fractionDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-fractionDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-fractionDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-fractionDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-fractionDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-fractionDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-totalDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-totalDigits-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-2-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-2-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-2-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-2-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-2-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-totalDigits-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-3-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-3-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-3-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-3-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-3-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-totalDigits-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-4-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-4-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-4-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-4-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-4-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-totalDigits-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-5-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-5-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-5-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-5-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-totalDigits-5-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  ?line {STRes31,S31} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList32 = [STRes31|STResList31],
  ?line ITRes139 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList140 = [ITRes139|ITResList139],
  ?line ITRes140 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList141 = [ITRes140|ITResList140],
  ?line ITRes141 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList142 = [ITRes141|ITResList141],
  ?line ITRes142 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList143 = [ITRes142|ITResList142],
  ?line ITRes143 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList144 = [ITRes143|ITResList143],


  ?line {STRes32,S32} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList33 = [STRes32|STResList32],
  ?line ITRes144 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList145 = [ITRes144|ITResList144],
  ?line ITRes145 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList146 = [ITRes145|ITResList145],
  ?line ITRes146 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList147 = [ITRes146|ITResList146],
  ?line ITRes147 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList148 = [ITRes147|ITResList147],
  ?line ITRes148 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList149 = [ITRes148|ITResList148],


  ?line {STRes33,S33} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList34 = [STRes33|STResList33],
  ?line ITRes149 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList150 = [ITRes149|ITResList149],
  ?line ITRes150 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList151 = [ITRes150|ITResList150],
  ?line ITRes151 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList152 = [ITRes151|ITResList151],
  ?line ITRes152 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList153 = [ITRes152|ITResList152],
  ?line ITRes153 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList154 = [ITRes153|ITResList153],


  ?line {STRes34,S34} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList35 = [STRes34|STResList34],
  ?line ITRes154 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList155 = [ITRes154|ITResList154],
  ?line ITRes155 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList156 = [ITRes155|ITResList155],
  ?line ITRes156 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList157 = [ITRes156|ITResList156],
  ?line ITRes157 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList158 = [ITRes157|ITResList157],
  ?line ITRes158 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList159 = [ITRes158|ITResList158],


  ?line {STRes35,S35} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList36 = [STRes35|STResList35],
  ?line ITRes159 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList160 = [ITRes159|ITResList159],
  ?line ITRes160 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList161 = [ITRes160|ITResList160],
  ?line ITRes161 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList162 = [ITRes161|ITResList161],
  ?line ITRes162 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList163 = [ITRes162|ITResList162],
  ?line ITRes163 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList164 = [ITRes163|ITResList163],


  ?line {STRes36,S36} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-nonPositiveInteger-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList37 = [STRes36|STResList36],
  ?line ITRes164 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList165 = [ITRes164|ITResList164],
  ?line ITRes165 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList166 = [ITRes165|ITResList165],
  ?line ITRes166 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList167 = [ITRes166|ITResList166],
  ?line ITRes167 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList168 = [ITRes167|ITResList167],
  ?line ITRes168 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-nonPositiveInteger-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList169 = [ITRes168|ITResList168],


  xmerl_xsd_lib:compare_test_results(Config,STResList37,ITResList169).

%% Data type derived by restriction of normalizedString by facets

'NISTSchema-normalizedString'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-maxLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-maxLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList5 = [ITRes4|ITResList4],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-maxLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList10 = [ITRes9|ITResList9],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-maxLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList15 = [ITRes14|ITResList14],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-maxLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-5-2.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-5-3.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-5-4.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList20 = [ITRes19|ITResList19],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-maxLength-5-5.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-minLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-minLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-minLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-minLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-minLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-5-2.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList43 = [ITRes42|ITResList42],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-5-3.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-5-4.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-minLength-5-5.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList46 = [ITRes45|ITResList45],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-length-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList47 = [ITRes46|ITResList46],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-length-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList52 = [ITRes51|ITResList51],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-length-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList57 = [ITRes56|ITResList56],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-length-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList62 = [ITRes61|ITResList61],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-length-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList64 = [ITRes63|ITResList63],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-length-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList67 = [ITRes66|ITResList66],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList69 = [ITRes68|ITResList68],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList72 = [ITRes71|ITResList71],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList74 = [ITRes73|ITResList73],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList77 = [ITRes76|ITResList76],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList79 = [ITRes78|ITResList78],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList82 = [ITRes81|ITResList81],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList84 = [ITRes83|ITResList83],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList87 = [ITRes86|ITResList86],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList89 = [ITRes88|ITResList88],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList92 = [ITRes91|ITResList91],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList94 = [ITRes93|ITResList93],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList97 = [ITRes96|ITResList96],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList99 = [ITRes98|ITResList98],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList102 = [ITRes101|ITResList101],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList104 = [ITRes103|ITResList103],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList107 = [ITRes106|ITResList106],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList109 = [ITRes108|ITResList108],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList112 = [ITRes111|ITResList111],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList114 = [ITRes113|ITResList113],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList117 = [ITRes116|ITResList116],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList119 = [ITRes118|ITResList118],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList122 = [ITRes121|ITResList121],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-normalizedString-whiteSpace-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-whiteSpace-2-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-whiteSpace-2-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList124 = [ITRes123|ITResList123],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-whiteSpace-2-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-whiteSpace-2-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-normalizedString-whiteSpace-2-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList127 = [ITRes126|ITResList126],


  xmerl_xsd_lib:compare_test_results(Config,STResList27,ITResList127).

%% Data type derived by restriction of positiveInteger by facets

'NISTSchema-positiveInteger'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-minExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-minExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-minExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-minExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-minInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList25 = [ITRes24|ITResList24],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-minInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList30 = [ITRes29|ITResList29],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-minInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList35 = [ITRes34|ITResList34],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-minInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList40 = [ITRes39|ITResList39],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-minInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-minInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList42 = [ITRes41|ITResList41],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-maxExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList43 = [ITRes42|ITResList42],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-maxExclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList45 = [ITRes44|ITResList44],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList48 = [ITRes47|ITResList47],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-maxExclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList50 = [ITRes49|ITResList49],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList53 = [ITRes52|ITResList52],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-maxExclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList55 = [ITRes54|ITResList54],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList58 = [ITRes57|ITResList57],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-maxExclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList60 = [ITRes59|ITResList59],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxExclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList63 = [ITRes62|ITResList62],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-maxInclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList64 = [ITRes63|ITResList63],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-maxInclusive-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList65 = [ITRes64|ITResList64],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList69 = [ITRes68|ITResList68],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-maxInclusive-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList70 = [ITRes69|ITResList69],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList74 = [ITRes73|ITResList73],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-maxInclusive-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList75 = [ITRes74|ITResList74],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList79 = [ITRes78|ITResList78],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-maxInclusive-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList80 = [ITRes79|ITResList79],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-maxInclusive-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList84 = [ITRes83|ITResList83],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-fractionDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-fractionDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList85 = [ITRes84|ITResList84],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-fractionDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-fractionDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-fractionDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-fractionDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList89 = [ITRes88|ITResList88],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-totalDigits-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-1-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList90 = [ITRes89|ITResList89],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-1-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-1-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-1-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-1-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList94 = [ITRes93|ITResList93],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-totalDigits-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-2-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList95 = [ITRes94|ITResList94],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-2-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-2-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-2-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-2-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList99 = [ITRes98|ITResList98],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-totalDigits-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-3-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList100 = [ITRes99|ITResList99],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-3-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-3-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-3-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-3-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList104 = [ITRes103|ITResList103],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-totalDigits-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-4-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList105 = [ITRes104|ITResList104],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-4-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-4-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-4-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-4-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList109 = [ITRes108|ITResList108],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-totalDigits-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-5-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList110 = [ITRes109|ITResList109],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-5-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-5-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-5-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-totalDigits-5-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList114 = [ITRes113|ITResList113],


  ?line {STRes26,S26} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList27 = [STRes26|STResList26],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList115 = [ITRes114|ITResList114],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S26),
  ITResList119 = [ITRes118|ITResList118],


  ?line {STRes27,S27} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList28 = [STRes27|STResList27],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList120 = [ITRes119|ITResList119],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S27),
  ITResList124 = [ITRes123|ITResList123],


  ?line {STRes28,S28} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList29 = [STRes28|STResList28],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList125 = [ITRes124|ITResList124],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S28),
  ITResList129 = [ITRes128|ITResList128],


  ?line {STRes29,S29} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList30 = [STRes29|STResList29],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList130 = [ITRes129|ITResList129],
  ?line ITRes130 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList131 = [ITRes130|ITResList130],
  ?line ITRes131 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList132 = [ITRes131|ITResList131],
  ?line ITRes132 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList133 = [ITRes132|ITResList132],
  ?line ITRes133 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S29),
  ITResList134 = [ITRes133|ITResList133],


  ?line {STRes30,S30} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList31 = [STRes30|STResList30],
  ?line ITRes134 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList135 = [ITRes134|ITResList134],
  ?line ITRes135 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList136 = [ITRes135|ITResList135],
  ?line ITRes136 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList137 = [ITRes136|ITResList136],
  ?line ITRes137 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList138 = [ITRes137|ITResList137],
  ?line ITRes138 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S30),
  ITResList139 = [ITRes138|ITResList138],


  ?line {STRes31,S31} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList32 = [STRes31|STResList31],
  ?line ITRes139 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList140 = [ITRes139|ITResList139],
  ?line ITRes140 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList141 = [ITRes140|ITResList140],
  ?line ITRes141 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList142 = [ITRes141|ITResList141],
  ?line ITRes142 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList143 = [ITRes142|ITResList142],
  ?line ITRes143 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S31),
  ITResList144 = [ITRes143|ITResList143],


  ?line {STRes32,S32} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList33 = [STRes32|STResList32],
  ?line ITRes144 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList145 = [ITRes144|ITResList144],
  ?line ITRes145 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList146 = [ITRes145|ITResList145],
  ?line ITRes146 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList147 = [ITRes146|ITResList146],
  ?line ITRes147 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList148 = [ITRes147|ITResList147],
  ?line ITRes148 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S32),
  ITResList149 = [ITRes148|ITResList148],


  ?line {STRes33,S33} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList34 = [STRes33|STResList33],
  ?line ITRes149 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList150 = [ITRes149|ITResList149],
  ?line ITRes150 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList151 = [ITRes150|ITResList150],
  ?line ITRes151 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList152 = [ITRes151|ITResList151],
  ?line ITRes152 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList153 = [ITRes152|ITResList152],
  ?line ITRes153 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S33),
  ITResList154 = [ITRes153|ITResList153],


  ?line {STRes34,S34} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList35 = [STRes34|STResList34],
  ?line ITRes154 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList155 = [ITRes154|ITResList154],
  ?line ITRes155 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList156 = [ITRes155|ITResList155],
  ?line ITRes156 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList157 = [ITRes156|ITResList156],
  ?line ITRes157 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList158 = [ITRes157|ITResList157],
  ?line ITRes158 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S34),
  ITResList159 = [ITRes158|ITResList158],


  ?line {STRes35,S35} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList36 = [STRes35|STResList35],
  ?line ITRes159 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList160 = [ITRes159|ITResList159],
  ?line ITRes160 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList161 = [ITRes160|ITResList160],
  ?line ITRes161 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList162 = [ITRes161|ITResList161],
  ?line ITRes162 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList163 = [ITRes162|ITResList162],
  ?line ITRes163 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S35),
  ITResList164 = [ITRes163|ITResList163],


  ?line {STRes36,S36} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-positiveInteger-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList37 = [STRes36|STResList36],
  ?line ITRes164 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList165 = [ITRes164|ITResList164],
  ?line ITRes165 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList166 = [ITRes165|ITResList165],
  ?line ITRes166 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList167 = [ITRes166|ITResList166],
  ?line ITRes167 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList168 = [ITRes167|ITResList167],
  ?line ITRes168 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-positiveInteger-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S36),
  ITResList169 = [ITRes168|ITResList168],


  xmerl_xsd_lib:compare_test_results(Config,STResList37,ITResList169).

%% Data type derived by restriction of QName by facets

'NISTSchema-QName'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-maxLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-1-5.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList5 = [ITRes4|ITResList4],


  ?line {STRes1,S1} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-maxLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList2 = [STRes1|STResList1],
  ?line ITRes5 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-2-1.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList6 = [ITRes5|ITResList5],
  ?line ITRes6 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-2-2.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList7 = [ITRes6|ITResList6],
  ?line ITRes7 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-2-3.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList8 = [ITRes7|ITResList7],
  ?line ITRes8 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-2-4.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList9 = [ITRes8|ITResList8],
  ?line ITRes9 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-2-5.xml','./nisttest/NISTTestsAll',valid,S1),
  ITResList10 = [ITRes9|ITResList9],


  ?line {STRes2,S2} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-maxLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList3 = [STRes2|STResList2],
  ?line ITRes10 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-3-1.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList11 = [ITRes10|ITResList10],
  ?line ITRes11 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-3-2.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList12 = [ITRes11|ITResList11],
  ?line ITRes12 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-3-3.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList13 = [ITRes12|ITResList12],
  ?line ITRes13 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-3-4.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList14 = [ITRes13|ITResList13],
  ?line ITRes14 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-3-5.xml','./nisttest/NISTTestsAll',valid,S2),
  ITResList15 = [ITRes14|ITResList14],


  ?line {STRes3,S3} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-maxLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList4 = [STRes3|STResList3],
  ?line ITRes15 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-4-1.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList16 = [ITRes15|ITResList15],
  ?line ITRes16 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-4-2.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList17 = [ITRes16|ITResList16],
  ?line ITRes17 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-4-3.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList18 = [ITRes17|ITResList17],
  ?line ITRes18 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-4-4.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList19 = [ITRes18|ITResList18],
  ?line ITRes19 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-4-5.xml','./nisttest/NISTTestsAll',valid,S3),
  ITResList20 = [ITRes19|ITResList19],


  ?line {STRes4,S4} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-maxLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList5 = [STRes4|STResList4],
  ?line ITRes20 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-5-1.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList21 = [ITRes20|ITResList20],
  ?line ITRes21 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-5-2.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList22 = [ITRes21|ITResList21],
  ?line ITRes22 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-5-3.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList23 = [ITRes22|ITResList22],
  ?line ITRes23 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-5-4.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList24 = [ITRes23|ITResList23],
  ?line ITRes24 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-maxLength-5-5.xml','./nisttest/NISTTestsAll',valid,S4),
  ITResList25 = [ITRes24|ITResList24],


  ?line {STRes5,S5} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-minLength-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList6 = [STRes5|STResList5],
  ?line ITRes25 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-1-1.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList26 = [ITRes25|ITResList25],
  ?line ITRes26 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-1-2.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList27 = [ITRes26|ITResList26],
  ?line ITRes27 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-1-3.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList28 = [ITRes27|ITResList27],
  ?line ITRes28 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-1-4.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList29 = [ITRes28|ITResList28],
  ?line ITRes29 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-1-5.xml','./nisttest/NISTTestsAll',valid,S5),
  ITResList30 = [ITRes29|ITResList29],


  ?line {STRes6,S6} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-minLength-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList7 = [STRes6|STResList6],
  ?line ITRes30 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-2-1.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList31 = [ITRes30|ITResList30],
  ?line ITRes31 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-2-2.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList32 = [ITRes31|ITResList31],
  ?line ITRes32 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-2-3.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList33 = [ITRes32|ITResList32],
  ?line ITRes33 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-2-4.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList34 = [ITRes33|ITResList33],
  ?line ITRes34 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-2-5.xml','./nisttest/NISTTestsAll',valid,S6),
  ITResList35 = [ITRes34|ITResList34],


  ?line {STRes7,S7} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-minLength-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList8 = [STRes7|STResList7],
  ?line ITRes35 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-3-1.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList36 = [ITRes35|ITResList35],
  ?line ITRes36 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-3-2.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList37 = [ITRes36|ITResList36],
  ?line ITRes37 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-3-3.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList38 = [ITRes37|ITResList37],
  ?line ITRes38 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-3-4.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList39 = [ITRes38|ITResList38],
  ?line ITRes39 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-3-5.xml','./nisttest/NISTTestsAll',valid,S7),
  ITResList40 = [ITRes39|ITResList39],


  ?line {STRes8,S8} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-minLength-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList9 = [STRes8|STResList8],
  ?line ITRes40 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-4-1.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList41 = [ITRes40|ITResList40],
  ?line ITRes41 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-4-2.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList42 = [ITRes41|ITResList41],
  ?line ITRes42 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-4-3.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList43 = [ITRes42|ITResList42],
  ?line ITRes43 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-4-4.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList44 = [ITRes43|ITResList43],
  ?line ITRes44 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-4-5.xml','./nisttest/NISTTestsAll',valid,S8),
  ITResList45 = [ITRes44|ITResList44],


  ?line {STRes9,S9} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-minLength-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList10 = [STRes9|STResList9],
  ?line ITRes45 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-5-1.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList46 = [ITRes45|ITResList45],
  ?line ITRes46 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-5-2.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList47 = [ITRes46|ITResList46],
  ?line ITRes47 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-5-3.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList48 = [ITRes47|ITResList47],
  ?line ITRes48 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-5-4.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList49 = [ITRes48|ITResList48],
  ?line ITRes49 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-minLength-5-5.xml','./nisttest/NISTTestsAll',valid,S9),
  ITResList50 = [ITRes49|ITResList49],


  ?line {STRes10,S10} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-length-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList11 = [STRes10|STResList10],
  ?line ITRes50 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-1-1.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList51 = [ITRes50|ITResList50],
  ?line ITRes51 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-1-2.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList52 = [ITRes51|ITResList51],
  ?line ITRes52 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-1-3.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList53 = [ITRes52|ITResList52],
  ?line ITRes53 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-1-4.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList54 = [ITRes53|ITResList53],
  ?line ITRes54 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-1-5.xml','./nisttest/NISTTestsAll',valid,S10),
  ITResList55 = [ITRes54|ITResList54],


  ?line {STRes11,S11} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-length-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList12 = [STRes11|STResList11],
  ?line ITRes55 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-2-1.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList56 = [ITRes55|ITResList55],
  ?line ITRes56 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-2-2.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList57 = [ITRes56|ITResList56],
  ?line ITRes57 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-2-3.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList58 = [ITRes57|ITResList57],
  ?line ITRes58 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-2-4.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList59 = [ITRes58|ITResList58],
  ?line ITRes59 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-2-5.xml','./nisttest/NISTTestsAll',valid,S11),
  ITResList60 = [ITRes59|ITResList59],


  ?line {STRes12,S12} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-length-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList13 = [STRes12|STResList12],
  ?line ITRes60 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-3-1.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList61 = [ITRes60|ITResList60],
  ?line ITRes61 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-3-2.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList62 = [ITRes61|ITResList61],
  ?line ITRes62 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-3-3.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList63 = [ITRes62|ITResList62],
  ?line ITRes63 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-3-4.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList64 = [ITRes63|ITResList63],
  ?line ITRes64 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-3-5.xml','./nisttest/NISTTestsAll',valid,S12),
  ITResList65 = [ITRes64|ITResList64],


  ?line {STRes13,S13} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-length-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList14 = [STRes13|STResList13],
  ?line ITRes65 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-4-1.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList66 = [ITRes65|ITResList65],
  ?line ITRes66 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-4-2.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList67 = [ITRes66|ITResList66],
  ?line ITRes67 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-4-3.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList68 = [ITRes67|ITResList67],
  ?line ITRes68 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-4-4.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList69 = [ITRes68|ITResList68],
  ?line ITRes69 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-4-5.xml','./nisttest/NISTTestsAll',valid,S13),
  ITResList70 = [ITRes69|ITResList69],


  ?line {STRes14,S14} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-length-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList15 = [STRes14|STResList14],
  ?line ITRes70 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-5-1.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList71 = [ITRes70|ITResList70],
  ?line ITRes71 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-5-2.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList72 = [ITRes71|ITResList71],
  ?line ITRes72 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-5-3.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList73 = [ITRes72|ITResList72],
  ?line ITRes73 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-5-4.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList74 = [ITRes73|ITResList73],
  ?line ITRes74 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-length-5-5.xml','./nisttest/NISTTestsAll',valid,S14),
  ITResList75 = [ITRes74|ITResList74],


  ?line {STRes15,S15} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-pattern-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList16 = [STRes15|STResList15],
  ?line ITRes75 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-1-1.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList76 = [ITRes75|ITResList75],
  ?line ITRes76 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-1-2.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList77 = [ITRes76|ITResList76],
  ?line ITRes77 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-1-3.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList78 = [ITRes77|ITResList77],
  ?line ITRes78 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-1-4.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList79 = [ITRes78|ITResList78],
  ?line ITRes79 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-1-5.xml','./nisttest/NISTTestsAll',valid,S15),
  ITResList80 = [ITRes79|ITResList79],


  ?line {STRes16,S16} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-pattern-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList17 = [STRes16|STResList16],
  ?line ITRes80 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-2-1.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList81 = [ITRes80|ITResList80],
  ?line ITRes81 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-2-2.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList82 = [ITRes81|ITResList81],
  ?line ITRes82 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-2-3.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList83 = [ITRes82|ITResList82],
  ?line ITRes83 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-2-4.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList84 = [ITRes83|ITResList83],
  ?line ITRes84 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-2-5.xml','./nisttest/NISTTestsAll',valid,S16),
  ITResList85 = [ITRes84|ITResList84],


  ?line {STRes17,S17} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-pattern-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList18 = [STRes17|STResList17],
  ?line ITRes85 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-3-1.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList86 = [ITRes85|ITResList85],
  ?line ITRes86 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-3-2.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList87 = [ITRes86|ITResList86],
  ?line ITRes87 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-3-3.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList88 = [ITRes87|ITResList87],
  ?line ITRes88 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-3-4.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList89 = [ITRes88|ITResList88],
  ?line ITRes89 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-3-5.xml','./nisttest/NISTTestsAll',valid,S17),
  ITResList90 = [ITRes89|ITResList89],


  ?line {STRes18,S18} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-pattern-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList19 = [STRes18|STResList18],
  ?line ITRes90 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-4-1.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList91 = [ITRes90|ITResList90],
  ?line ITRes91 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-4-2.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList92 = [ITRes91|ITResList91],
  ?line ITRes92 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-4-3.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList93 = [ITRes92|ITResList92],
  ?line ITRes93 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-4-4.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList94 = [ITRes93|ITResList93],
  ?line ITRes94 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-4-5.xml','./nisttest/NISTTestsAll',valid,S18),
  ITResList95 = [ITRes94|ITResList94],


  ?line {STRes19,S19} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-pattern-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList20 = [STRes19|STResList19],
  ?line ITRes95 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-5-1.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList96 = [ITRes95|ITResList95],
  ?line ITRes96 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-5-2.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList97 = [ITRes96|ITResList96],
  ?line ITRes97 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-5-3.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList98 = [ITRes97|ITResList97],
  ?line ITRes98 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-5-4.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList99 = [ITRes98|ITResList98],
  ?line ITRes99 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-pattern-5-5.xml','./nisttest/NISTTestsAll',valid,S19),
  ITResList100 = [ITRes99|ITResList99],


  ?line {STRes20,S20} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-enumeration-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList21 = [STRes20|STResList20],
  ?line ITRes100 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-1-1.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList101 = [ITRes100|ITResList100],
  ?line ITRes101 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-1-2.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList102 = [ITRes101|ITResList101],
  ?line ITRes102 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-1-3.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList103 = [ITRes102|ITResList102],
  ?line ITRes103 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-1-4.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList104 = [ITRes103|ITResList103],
  ?line ITRes104 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-1-5.xml','./nisttest/NISTTestsAll',valid,S20),
  ITResList105 = [ITRes104|ITResList104],


  ?line {STRes21,S21} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-enumeration-2.xsd','./nisttest/NISTTestsAll',valid),
  STResList22 = [STRes21|STResList21],
  ?line ITRes105 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-2-1.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList106 = [ITRes105|ITResList105],
  ?line ITRes106 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-2-2.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList107 = [ITRes106|ITResList106],
  ?line ITRes107 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-2-3.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList108 = [ITRes107|ITResList107],
  ?line ITRes108 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-2-4.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList109 = [ITRes108|ITResList108],
  ?line ITRes109 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-2-5.xml','./nisttest/NISTTestsAll',valid,S21),
  ITResList110 = [ITRes109|ITResList109],


  ?line {STRes22,S22} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-enumeration-3.xsd','./nisttest/NISTTestsAll',valid),
  STResList23 = [STRes22|STResList22],
  ?line ITRes110 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-3-1.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList111 = [ITRes110|ITResList110],
  ?line ITRes111 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-3-2.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList112 = [ITRes111|ITResList111],
  ?line ITRes112 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-3-3.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList113 = [ITRes112|ITResList112],
  ?line ITRes113 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-3-4.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList114 = [ITRes113|ITResList113],
  ?line ITRes114 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-3-5.xml','./nisttest/NISTTestsAll',valid,S22),
  ITResList115 = [ITRes114|ITResList114],


  ?line {STRes23,S23} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-enumeration-4.xsd','./nisttest/NISTTestsAll',valid),
  STResList24 = [STRes23|STResList23],
  ?line ITRes115 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-4-1.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList116 = [ITRes115|ITResList115],
  ?line ITRes116 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-4-2.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList117 = [ITRes116|ITResList116],
  ?line ITRes117 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-4-3.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList118 = [ITRes117|ITResList117],
  ?line ITRes118 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-4-4.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList119 = [ITRes118|ITResList118],
  ?line ITRes119 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-4-5.xml','./nisttest/NISTTestsAll',valid,S23),
  ITResList120 = [ITRes119|ITResList119],


  ?line {STRes24,S24} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-enumeration-5.xsd','./nisttest/NISTTestsAll',valid),
  STResList25 = [STRes24|STResList24],
  ?line ITRes120 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-5-1.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList121 = [ITRes120|ITResList120],
  ?line ITRes121 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-5-2.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList122 = [ITRes121|ITResList121],
  ?line ITRes122 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-5-3.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList123 = [ITRes122|ITResList122],
  ?line ITRes123 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-5-4.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList124 = [ITRes123|ITResList123],
  ?line ITRes124 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-enumeration-5-5.xml','./nisttest/NISTTestsAll',valid,S24),
  ITResList125 = [ITRes124|ITResList124],


  ?line {STRes25,S25} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-QName-whiteSpace-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList26 = [STRes25|STResList25],
  ?line ITRes125 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-whiteSpace-1-1.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList126 = [ITRes125|ITResList125],
  ?line ITRes126 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-whiteSpace-1-2.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList127 = [ITRes126|ITResList126],
  ?line ITRes127 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-whiteSpace-1-3.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList128 = [ITRes127|ITResList127],
  ?line ITRes128 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-whiteSpace-1-4.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList129 = [ITRes128|ITResList128],
  ?line ITRes129 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-QName-whiteSpace-1-5.xml','./nisttest/NISTTestsAll',valid,S25),
  ITResList130 = [ITRes129|ITResList129],


  xmerl_xsd_lib:compare_test_results(Config,STResList26,ITResList130).

%% Data type derived by restriction of short by facets

'NISTSchema-short'(Config) when is_list(Config) ->
  STResList0 = [],

  ?line {STRes0,S0} = xmerl_xsd_lib:schema_test(Config,'./nisttest/NISTTestsAll/NISTSchema-short-minExclusive-1.xsd','./nisttest/NISTTestsAll',valid),
  STResList1 = [STRes0|STResList0],
  ITResList0 = [],
  ?line ITRes0 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-short-minExclusive-1-1.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList1 = [ITRes0|ITResList0],
  ?line ITRes1 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-short-minExclusive-1-2.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList2 = [ITRes1|ITResList1],
  ?line ITRes2 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-short-minExclusive-1-3.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList3 = [ITRes2|ITResList2],
  ?line ITRes3 = xmerl_xsd_lib:instance_test(Config,'./nisttest/NISTTestsAll/NISTXML-short-minExclusive-1-4.xml','./nisttest/NISTTestsAll',valid,S0),
  ITResList4 = [ITRes3|ITResList3],
  ?line ITRes4 = xmerl_xsd_lib:instance_test(C