.\" dpkg manual page - dpkg-query(1)
.\"
.\" Copyright © 2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006-2007 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2011 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-query 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOM
dpkg\-query \- Un outil pour interroger la base de données de dpkg
.
.SH SYNOPSIS
\fBdpkg\-query\fP [\fIoption\fP...] \fIcommande\fP
.
.SH DESCRIPTION
\fBdpkg\-query\fP est un outil pour afficher des informations sur les paquets
connus par la base de données de \fBdpkg\fP.
.
.SH COMMANDES
.TP 
\fB\-l\fP, \fB\-\-list\fP [\fImotif\-de\-nom\-de\-paquet\fP...]
Affiche les paquets correspondant à un ou plusieurs motifs, quelque soit
leur statut, ce qui comprend tout paquet réel ou virtuel référencé dans tout
champ de relation de dépendance (tel que \fBBreaks\fP, \fBEnhances\fP,\ etc.). Si
aucun \fImotif\-de\-nom\-de\-paquet\fP n'est indiqué, affiche tous les paquets de
\fI%ADMINDIR%/status\fP, sauf ceux qui ne sont pas installés (c'est\-à\-dire ceux
qui ont été précédemment purgés). Les métacaractères ordinaires de
l'interpréteur de commandes sont autorisés dans
\fImotif\-de\-nom\-de\-paquet\fP. Il faudra sans doute mettre
\fImotif\-de\-nom\-de\-paquet\fP entre apostrophes pour éviter l'expansion des noms
de fichier par l'interpréteur de commandes. Par exemple, tous les paquets
dont le nom commence par «\ libc6\ » seront affichés par la commande\ :

.nf
\fBdpkg\-query \-l 'libc6*'\fP
.fi

Les trois premières colonnes affichées montrent dans l'ordre\ : l'action
souhaitée, l'état du paquet et les erreurs.

Action souhaitée\ :
.nf
  u = Inconnu (Unknown)
  i = Installer (Install)
  h = Garder (Hold)
  r = Supprimer (Remove)
  p = Purger (Purge)
.fi

État du paquet\ :
.nf
  n = Non installé (Not\-installed)
  c = Fichiers de configuration (Config\-files)
  H = Semi\-installé (Half\-installed)
  U = Décompressé (Unpacked)
  F = Semi\-configuré (Half\-configured)
  W = Attente de déclenchements (Triggers\-awaiting)
  t = Déclenchements en attente (Triggers\-pending)
  i = Installé (Installed)
.fi

Drapeaux d'erreur\ :
.nf
  <empty> = (aucun)
  R = Réinstallation requise (Reinst\-required)
.fi

Un état en majuscules ou une lettre d'erreur indiquent que le paquet peut
provoquer des problèmes graves. Veuillez consulter \fBdpkg\fP(1) à propos des
états et drapeaux ci\-dessus.

On ne peut pas configurer le format de sortie de cette option. Il s'adapte
automatiquement à la largeur du terminal. Ce format est destiné aux humains
et la machine le lit mal. Voyez \fB\-W\fP (\fB\-\-show\fP) et \fB\-\-showformat\fP pour
une possible configuration de ce format.
.TP 
\fB\-W\fP, \fB\-\-show\fP [\fImotif\-de\-nom\-de\-paquet\fP...]
Tout comme l'option \fB\-\-list\fP, cette option affiche la liste des paquets qui
correspondent au motif donné. La sortie peut cependant être formatée en
utilisant l'option \fB\-\-showformat\fP. Le format de sortie par défaut est le
suivant\ : une ligne pour chaque paquet, avec le nom (éventuellement complété
par l'identifiant d'architecture pour les paquets \fBMulti\-Arch\fP \fBsame\fP) et
la version installée, séparés par une tabulation.
.TP 
\fB\-s\fP, \fB\-\-status\fP [\fInom\-du\-paquet\fP ...]
Donne l'état du paquet indiqué. C'est simplement l'affichage de l'entrée de
la base de données concernant les états des paquets installés. Si aucun
\fInom\-de\-paquet\fP n'est indiqué, toutes les entrées de paquet dans la base de
données d'état seront affichées (depuis dpkg\ 1.19.1). Lorsque des entrées de
\fInom\-de\-paquet\fP multiples sont indiquées, les entrées d'état demandées sont
séparées par une ligne vide et sont dans l'ordre utilisé pour la liste de
paramètres.
.TP 
\fB\-L\fP, \fB\-\-listfiles\fP \fInom\-du\-paquet\fP...
Affiche la liste des fichiers du \fInom\-du\-paquet\fP installés sur le
système. Lorsque plusieurs \fInom\-du\-paquet\fP sont indiqués, les différentes
listes de fichiers sont séparées par une ligne vide et elles sont fournies
dans l'ordre de la liste de paramètres. Il faut remarquer cependant que les
fichiers créés par les scripts d'installation propres aux paquets ne sont
pas affichés.
.TP 
\fB\-\-control\-list\fP \fInom\-du\-paquet\fP
Affiche les fichiers de contrôle installés sur le système à partir de
\fInom\-du\-paquet\fP (depuis dpkg\ 1.16.5). Ceux\-ci peuvent être utilisés en
paramètres d'entrée de \fB\-\-control\-show\fP.
.TP 
\fB\-\-control\-show\fP \fInom\-du\-paquet\fP \fIfichier\-de\-contrôle\fP
Affiche sur la sortie standard le \fIfichier\-de\-contrôle\fP installé sur le
système pour \fInom\-du\-paquet\fP (depuis dpkg\ 1.16.5).
.TP 
\fB\-c\fP, \fB\-\-control\-path\fP \fInom\-du\-paquet\fP [\fIfichier\-contrôle\fP]
Affiche les chemins pour les fichiers de contrôle installés sur votre
système pour \fInom\-du\-paquet\fP (depuis dpkg\ 1.15.4). Si \fIfichier\-contrôle\fP
est indiqué, seul le chemin pour ce fichier de contrôle sera affiché, s'il
est présent.

\fBAttention\fP\ : cette commande est obsolète parce qu'elle donne un accès
direct à la base de données interne de dpkg, et il est conseillé d'utiliser
\fB\-\-control\-list\fP et \fB\-\-control\-show\fP à la place dans tous les cas où ces
commandes peuvent donner le même résultat. Néanmoins,aussi longtemps qu'il y
a un cas au moins où cette commande est nécessaire (c'est\-à\-dire quand il
faut supprimer le script d'un responsable endommageant postrm), et tant
qu'il n'y aura pas de bonne solution pour cela, cette commande ne sera pas
supprimée.
.TP 
\fB\-S\fP, \fB\-\-search\fP \fImotif\-de\-nom\-à\-rechercher\fP...
Recherche les paquets propriétaires de fichiers dont le nom correspond au
motif indiqué. On peut utiliser tous les métacaractères de l'interpréteur de
commandes dans le motif, où l'astérisque (\fB*\fP et le point d'interrogation
(\fB?\fP) correspondront à une barre oblique et la barre oblique inverse sert
de caractère d'échappement.

Si le premier caractère du \fImotif\-de\-nom\-à\-rechercher\fP est aucun des
caractères «\ \fB*[?/\fP\ », il sera alors considéré comme une sous\-chaîne de
correspondance et sera implicitement entouré de «\ \fB*\fP\ » (comme
\fB*\fP\fImotif\-de\-nom\-à\-rechercher\fP\fB*\fP). Si la chaîne suivante contient un des
caractères «\ \fB*[?\e\fP\ », il sera géré comme un motif global, sinon tout
«\ \fB/\fP\ » ou «\ \fB/.\fP\ » terminal sera supprimé et une recherche littérale de
chemin sera exécutée.

Cette commande ne donne pas les fichiers supplémentaires créés par les
scripts du responsable de paquet, ni les alternatives.
.TP 
\fB\-p\fP, \fB\-\-print\-avail\fP [\fInom\-du\-paquet\fP...]
Affiche les détails relatifs aux paquets, tels que présents dans
\fI%ADMINDIR%/available\fP. Si aucun \fInom\-de\-paquet\fP n'est indiqué, toutes les
entrées de paquet dans la base de données d'état seront affichées (depuis
dpkg\ 1.19.1). Lorsque des entrées de \fInom\-de\-paquet\fP multiples sont
indiquées, les entrées \fIavailable\fP demandées sont séparées par une ligne
vide et sont dans l'ordre utilisé pour la liste de paramètres.

Les utilisateurs des outils basés sur APT devraient plutôt utiliser la
commande \fBapt\-cache show\fP \fInom\-du\-paquet\fP car le fichier \fIavailable\fP
n'est tenu à jour que lorsque \fBdselect\fP est utilisé.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Affiche un message d'aide puis quitte.
.TP 
\fB\-\-version\fP
Affiche le numéro de version puis quitte.
.
.SH OPTIONS
.TP 
\fB\-\-admindir\fP=\fIrépertoire\fP
Change l'endroit où se trouve la base de données de \fBdpkg\fP. Par défaut,
c'est \fI%ADMINDIR%\fP.
.TP 
\fB\-\-load\-avail\fP
Charge également le fichier \fIavailable\fP à l'utilisation des commandes
\fB\-\-show\fP et \fB\-\-list\fP, ce qui désormais revient à n'interroger que le
fichier d'état (depuis dpkg\ 1.16.2).
.TP 
\fB\-\-no\-pager\fP
Désactive l'utilisation d'un afficheur pour montrer les informations (depuis
dpkg\ 1.19.2).
.TP 
\fB\-f\fP, \fB\-\-showformat=\fP\fIformat\fP
Cette option sert à spécifier le format de sortie de l'option \fB\-\-show\fP
(option courte depuis dpkg\ 1.13.1). Ce format est une chaîne qui sera
utilisée pour chaque paquet listé.

Dans la chaîne, «\ \fB\e\fP\ » préfixe des caractères de contrôle\ :

.nf
    \fB\en\fP  nouvelle ligne
    \fB\er\fP  retour chariot
    \fB\et\fP  tabulation
.fi

“\fB\e\fP” avant n'importe quel caractère supprime la signification spécial du
caractère qui suit. C'est utile pour les caractères «\ \fB\e\fP\ » et «\ \fB$\fP\ ».

L'information relative à un paquet peut être indiquée en insérant des appels
de variables spécifiant des champs du paquet avec la syntaxe suivante\ :
«\ \fB${\fP\fIchamp\fP[\fB;\fP\fIlargeur\fP]\fB}\fP\ ». Les champs sont alignés à droite, à
moins que la largeur ne soit négative, auquel cas ils sont alignés à
gauche. Les champs suivants sont reconnus, mais pas nécessairement
disponibles dans le fichier d'état (seuls les champs internes ou les champs
conservés avec le paquet binaire le sont)\ :

.nf
    \fBArchitecture\fP
    \fBBugs\fP
    \fBConffiles\fP (interne)
    \fBConfig\-Version\fP (interne)
    \fBConflicts\fP
    \fBBreaks\fP
    \fBDepends\fP
    \fBDescription\fP
    \fBEnhances\fP
    \fBEssential\fP
    \fBFilename\fP (interne, lié au programme frontal)
    \fBHomepage\fP
    \fBInstalled\-Size\fP
    \fBMD5sum\fP (interne, lié au programme frontal)
    \fBMSDOS\-Filename\fP (interne, lié au programme frontal)
    \fBMaintainer\fP
    \fBOrigin\fP
    \fBPackage\fP
    \fBPre\-Depends\fP
    \fBPriority\fP
    \fBProvides\fP
    \fBRecommends\fP
    \fBReplaces\fP
    \fBRevision\fP (obsolète)
    \fBSection\fP
    \fBSize\fP (interne, lié au programme frontal)
    \fBSource\fP
    \fBStatus\fP (interne)
    \fBSuggests\fP
    \fBTag\fP (en général pas dans le .deb mais dans les fichiers
            Packages des dépôts)
    \fBTriggers\-Awaited\fP (interne)
    \fBTriggers\-Pending\fP (interne)
    \fBVersion\fP
.fi

Les champs suivants sont virtuels, créés par \fBdpkg\-query\fP à partir des
valeurs d'autres champs (veuillez noter qu'ils utilisent des noms qui ne
sont pas valables comme noms de champs dans le fichiers de contrôle)\ :
.RS
.TP 
\fBbinary:Package\fP
Contient le nom du paquet binaire avec éventuellement le type d'architecture
tel que «\ libc6:amd64\ » (depuis dpkg\ 1.16.2). Le type d'architecture sera
présent pour rendre le nom de paquet non ambigu, par exemple si le champ
\fBMulti\-Arch\fP du paquet a la valeur \fBsame\fP ou si le paquet appartient à une
architecture différente.
.TP 
\fBbinary:Synopsis\fP
Il contient la description courte du paquet (depuis dpkg\ 1.19.1).
.TP 
\fBbinary:Summary\fP
C'est un alias de \fBbinary:Synopsis\fP (depuis dpkg\ 1.16.2).
.TP 
\fBdb:Status\-Abbrev\fP
Il contient l'état du paquet dans sa forme abrégée en trois caractères,
comme «\ ii\ \ » ou «\ iHR\ » (depuis dpkg\ 1.16.2). Voir la description de la
commande \fB\-\-list\fP pour plus de détails.
.TP 
\fBdb:Status\-Want\fP
Il contient l'état désiré du paquet, extrait du champ Status (depuis
dpkg\ 1.17.11).
.TP 
\fBdb:Status\-Status\fP
Il contient l'expression d'état du paquet, extrait du champ Status (depuis
dpkg\ 1.17.11).
.TP 
\fBdb:Status\-Eflag\fP
Il contient le drapeau d'erreur d'état du paquet, extrait du champ Status
(depuis dpkg\ 1.17.11).
.TP 
\fBdb\-fsys:Files\fP
Il contient la liste des entrées de paquets du système de fichiers, séparées
par des sauts de lignes (depuis dpkg\ 1.19.3).
.TP 
\fBdb\-fsys:Last\-Modified\fP
Il contient l'horodatage en seconde de la dernière date à laquelle les
entrées de paquets du système de fichiers ont été modifiées (depuis
dpkg\ 1.19.3).
.TP 
\fBsource:Package\fP
Il contient le nom du paquet source de ce paquet binaire (depuis
dpkg\ 1.16.2).
.TP 
\fBsource:Version\fP
Il contient la version du paquet source de ce paquet binaire (depuis
dpkg\ 1.16.2).
.TP 
\fBsource:Upstream\-Version\fP
Il contient la version du paquet source amont de ce paquet binaire (depuis
dpkg\ 1.18.16).
.RE
.IP
Le format par défaut est le suivant\ :
«\ \fB${binary:Package}\et${Version}\en\fP\ ». Tous les autres champs du fichier
d'état, par exemple des champs définis par l'utilisateur, peuvent être
demandés. Ils seront affichés mais sans aucune mise en forme et aucune
conversion ou vérification n'est faite. Pour obtenir le nom du responsable
de \fBdpkg\fP et la version installée, exécutez par exemple\ :

.nf
  \fBdpkg\-query \-W \-f='${binary:Package} ${Version}\et${Maintainer}\en' dpkg\fP
.fi
.
.SH "CODE DE SORTIE"
.TP 
\fB0\fP
La requête demandée s'est correctement déroulée.
.TP 
\fB1\fP
La requête demandée a échoué soit totalement, soit partiellement, du fait
qu'aucun fichier ni paquet n'a été trouvé (sauf pour \fB\-\-control\-path\fP,
\fB\-\-control\-list\fP et \fB\-\-control\-show\fP où de telles erreurs sont fatales).
.TP 
\fB2\fP
Erreur fatale ou irrécupérable due à l'utilisation d'une ligne de commande
non valable, ou interactions avec le système, telles que des accès à la base
de données, des allocations de mémoire,\ etc.
.
.SH ENVIRONNEMENT
.SS "Environnement externe"
.TP 
\fBSHELL\fP
Définit le programme à exécuter lors du lancement d'une commande avec un
shell (depuis dpkg\ 1.19.2).
.TP 
\fBPAGER\fP
.TQ
\fBDPKG_PAGER\fP
Définit la commande d'afficheur à utiliser (depuis dpkg\ 1.19.1) qui sera
exécutée avec «\ \fB$SHELL \-c\fP\ ». Si \fBSHELL\fP n'est pas défini, «\ \fBsh\fP\ » sera
utilisé à la place. \fBDPKG_PAGER\fP remplace la variable d'environnement
\fBPAGER\fP (depuis dpkg\ 1.19.2).
.TP 
\fBDPKG_ADMINDIR\fP
Si cette variable est positionnée et que l'option \fB\-\-admindir\fP n'est pas
précisée, ce répertoire sera utilisé comme répertoire de données pour
\fBdpkg\fP.
.TP 
\fBDPKG_COLORS\fP
Définit le mode de couleur (depuis dpkg\ 1.18.5). Les valeurs actuellement
acceptées sont \fBauto\fP (par défaut), \fBalways\fP et \fBnever\fP.
.SS "Environnement interne"
.TP 
\fBLESS\fP
Définie à «\ \fB\-FRSXMQ\fP\ » par \fBdpkg\-query\fP, si elle n'est pas déjà fixée,
lors du lancement d'un afficheur (depuis dpkg\ 1.19.2). Pour modifier le
comportement par défaut, cette variable peut être réglée à une autre valeur
y compris une chaîne vide, ou les variables \fBPAGER\fP ou \fBDPKG_PAGER\fP
peuvent être fixées pour désactiver des options spécifiques avec «\ \fB\-+\fP\ »,
par exemple \fBDPKG_PAGER="less \-+F"\fP.
.
.SH "VOIR AUSSI"
\fBdpkg\fP(1).

.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
