/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.LookupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DiscoveryManager {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryManager.class);
    private DiscoveryClient discoveryClient;
    private EurekaClient clientOverride;
    private EurekaInstanceConfig eurekaInstanceConfig;
    private EurekaClientConfig eurekaClientConfig;
    private static final DiscoveryManager s_instance = new DiscoveryManager();

    private DiscoveryManager() {
    }

    public static DiscoveryManager getInstance() {
        return s_instance;
    }

    public void setDiscoveryClient(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    public void setClientOverride(EurekaClient eurekaClient) {
        this.clientOverride = eurekaClient;
    }

    public void setEurekaClientConfig(EurekaClientConfig eurekaClientConfig) {
        this.eurekaClientConfig = eurekaClientConfig;
    }

    public void setEurekaInstanceConfig(EurekaInstanceConfig eurekaInstanceConfig) {
        this.eurekaInstanceConfig = eurekaInstanceConfig;
    }

    public void initComponent(EurekaInstanceConfig config, EurekaClientConfig eurekaConfig, AbstractDiscoveryClientOptionalArgs args) {
        this.eurekaInstanceConfig = config;
        this.eurekaClientConfig = eurekaConfig;
        if (ApplicationInfoManager.getInstance().getInfo() == null) {
            ApplicationInfoManager.getInstance().initComponent(config);
        }
        InstanceInfo info = ApplicationInfoManager.getInstance().getInfo();
        this.discoveryClient = new DiscoveryClient(info, eurekaConfig, args);
    }

    public void initComponent(EurekaInstanceConfig config, EurekaClientConfig eurekaConfig) {
        this.initComponent(config, eurekaConfig, null);
    }

    public void shutdownComponent() {
        if (this.discoveryClient != null) {
            try {
                this.discoveryClient.shutdown();
                this.discoveryClient = null;
            }
            catch (Throwable th) {
                logger.error("Error in shutting down client", th);
            }
        }
    }

    public LookupService getLookupService() {
        return this.getEurekaClient();
    }

    @Deprecated
    public DiscoveryClient getDiscoveryClient() {
        return this.discoveryClient;
    }

    public EurekaClient getEurekaClient() {
        if (this.clientOverride != null) {
            return this.clientOverride;
        }
        return this.discoveryClient;
    }

    public EurekaClientConfig getEurekaClientConfig() {
        return this.eurekaClientConfig;
    }

    public EurekaInstanceConfig getEurekaInstanceConfig() {
        return this.eurekaInstanceConfig;
    }
}

