/*
 * YICS: Connect a FICS interface to the Yahoo! Chess server.
 * Copyright (C) 2004  Chris Howie
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _NETWORK_H
#define _NETWORK_H

#include "types.h"

extern int nconnect(const char *, unsigned short);
extern bool yconnect(const char *, unsigned short);
extern void nclose(void);
extern bool socket_ready(void);
extern void set_keys(signed long, signed long);
extern int ngetc(void);
extern int nread(char *, int);
extern bool nputc(char);
extern bool nprint(const char *, int);
#define nprintString(s) nprint((s)->string, (s)->length)
extern bool nprintrop(char, const char *, int);
#define nprintropString(o, s) nprintrop(o, (s)->string, (s)->length)
extern bool nprinttop(uchar, char, const char *, int);
#define nprinttopString(t, o, s) nprinttop(t, o, (s)->string, (s)->length)
extern bool nprintutf(const char *, unsigned short);
extern short nreadutf(char *);
extern String *nreadutfString(String *);
extern char *ngets(char *, int, int);

#endif
