
#ifndef SVD_VIDFMT_H
#define SVD_VIDFMT_H 1

//VDB: Video Data Block : video modes
/* Notes:
   Parentheses indicate instances where pixels are repeated to meet the minimum speed
   requirements of the interface. For example, in the 720X240p case, the pixels on each line
   are double-clocked. In the (2880)X480i case, the number of pixels on each line, and thus
   the number of times that they are repeated, is variable, and is sent to the DTV monitor by
   the source device.
*/

const vname_map_t vidmd_map[] = {
   {0,   "No Vid. Ident. Code: AVI InfoFrame only"    },

   //   Code Name
   {1,   "DMT0659   4:3  640x480p@59.94/60Hz"         },
   {2,   "480p      4:3  720x480p@59.94/60Hz"         },
   {3,   "480pH    16:9  720x480p@59.94/60Hz"         },
   {4,   "720p     16:9  1280x720p@59.94/60Hz"        },
   {5,   "1080i    16:9  1920x1080i@59.94/60Hz"       },
   {6,   "480i      4:3  720(1440)x480i@59.94/60Hz"   },
   {7,   "480iH    16:9  720(1440)x480i@59.94/60Hz"   },
   {8,   "240p      4:3  720(1440)x240p@59.94/60Hz"   },
   {9,   "240pH    16:9  720(1440)x240p@59.94/60Hz"   },
   {10,  "480i4x    4:3  (2880)x480i@59.94/60Hz"      },
   {11,  "480i4xH  16:9  (2880)x480i@59.94/60Hz"      },
   {12,  "240p4x    4:3  (2880)x240p@59.94/60Hz"      },
   {13,  "240p4xH  16:9  (2880)x240p@59.94/60Hz"      },
   {14,  "480p2x    4:3  1440x480p@59.94/60Hz"        },
   {15,  "480p2xH  16:9  1440x480p@59.94/60Hz"        },
   {16,  "1080p    16:9  1920x1080p@59.94/60Hz"       },
   {17,  "576p      4:3  720x576p@50Hz"               },
   {18,  "576pH    16:9  720x576p@50Hz"               },
   {19,  "720p50   16:9  1280x720p@50Hz"              },
   {20,  "1080i25  16:9  1920x1080i(1125 Vtotal)@50Hz"},
   {21,  "576i      4:3  720(1440)x576i@50Hz"         },
   {22,  "576iH    16:9  720(1440)x576i@50Hz"         },
   {23,  "288p      4:3  720(1440)x288p@50Hz"         },
   {24,  "288pH    16:9  720(1440)x288p@50Hz"         },
   {25,  "576i4x    4:3  (2880)x576i@50Hz"            },
   {26,  "576i4xH  16:9  (2880)x576i@50Hz"            },
   {27,  "288p4x    4:3  (2880)x288p@50Hz"            },
   {28,  "288p4xH  16:9  (2880)x288p@50Hz"            },
   {29,  "576p2x    4:3  1440x576p@50Hz"              },
   {30,  "576p2xH  16:9  1440x576p@50Hz"              },
   {31,  "1080p50  16:9  1920x1080p@50Hz"             },
   {32,  "1080p24  16:9  1920x1080p@23.98/24Hz"       },
   {33,  "1080p25  16:9  1920x1080p@25Hz"             },
   {34,  "1080p30  16:9  1920x1080p@29.97/30Hz"       },
   {35,  "480p4x    4:3  (2880)x480p@59.94/60Hz"      },
   {36,  "480p4xH  16:9  (2880)x480p@59.94/60Hz"      },
   {37,  "576p4x    4:3  (2880)x576p@50Hz"            },
   {38,  "576p4xH  16:9  (2880)x576p@50Hz"            },
   {39,  "1080i25  16:9  1920x1080i(1250 VTotal)@50Hz"},
   {40,  "1080i50  16:9  1920x1080i@100Hz"            },
   {41,  "720p100  16:9  1280x720p@100Hz"             },
   {42,  "576p100   4:3  720x576p@100Hz"              },
   {43,  "576p100H 16:9  720x576p@100Hz"              },
   {44,  "576i50    4:3  720(1440)x576i@100Hz"        },
   {45,  "576i50H  16:9  720(1440)x576i@100Hz"        },
   {46,  "1080i60  16:9  1920x1080i@119.88/120Hz"     },
   {47,  "720p120  16:9  1280x720p@119.88/120Hz"      },
   {48,  "480p119   4:3  720x480p@119.88/120Hz"       },
   {49,  "480p119H 16:9  720x480p@119.88/120Hz"       },
   {50,  "480i59    4:3  720(1440)x480i@119.88/120Hz" },
   {51,  "480i59H  16:9  720(1440)x480i@119.88/120Hz" },
   {52,  "576p200   4:3  720x576p@200Hz"              },
   {53,  "576p200H 16:9  720x576p@200Hz"              },
   {54,  "576i100   4:3  720(1440)x576i@200Hz"        },
   {55,  "576i100H 16:9  720(1440)x576i@200Hz"        },
   {56,  "480p239   4:3  720x480p@239.76/240Hz"       },
   {57,  "480p239H 16:9  720x480p@239.76/240Hz"       },
   {58,  "480i119   4:3  720(1440)x480i@239.76/240Hz" },
   {59,  "480i119H 16:9  720(1440)x480i@239.76/240Hz" },
   {60,  "720p24   16:9  1280x720p@23.98/24Hz"        },
   {61,  "720p25   16:9  1280x720p@25Hz"              },
   {62,  "720p30   16:9  1280x720p@29.97/30Hz"        },
   {63,  "1080p120 16:9  1920x1080p@119.88/120Hz"     },
   //added 2019.12.17:
   //Here Code Name is not official.
   {64,  "1080p100 16:9  1920x1080p@100Hz"            },

   {65,  "720p24   64:27 1280x720p@23.98/24Hz"        },
   {66,  "720p25   64:27 1280x720p@25Hz"              },
   {67,  "720p30   64:27 1280x720p@29.97/30Hz"        },
   {68,  "720p50   64:27 1280x720p@50Hz"              },
   {69,  "720p60   64:27 1280x720p@59.94/60Hz"        },
   {70,  "720p100  64:27 1280x720p@100Hz"             },
   {71,  "720p120  64:27 1280x720p@119.88/120Hz"      },

   {72,  "1080p24  64:27 1920x1080p@23.98/24Hz"       },
   {73,  "1080p25  64:27 1920x1080p@25Hz"             },
   {74,  "1080p30  64:27 1920x1080p@29.97/30Hz"       },
   {75,  "1080p50  64:27 1920x1080p@50Hz"             },
   {76,  "1080p60  64:27 1920x1080p@59.94/60Hz"       },
   {77,  "1080p100 64:27 1920x1080p@100Hz"            },
   {78,  "1080p120 64:27 1920x1080p@119.88/120Hz"     },

   {79,  "720p24   64:27 1680x720p@23.98/24Hz"        },
   {80,  "720p25   64:27 1680x720p@25Hz"              },
   {81,  "720p30   64:27 1680x720p@29.97/30Hz"        },
   {82,  "720p50   64:27 1680x720p@50Hz"              },
   {83,  "720p60   64:27 1680x720p@59.94/60Hz"        },
   {84,  "720p100  64:27 1680x720p@100Hz"             },
   {85,  "720p120  64:27 1680x720p@119.88/120Hz"      },

   {86,  "1080p24  64:27 2560x1080p@23.98/24Hz"       },
   {87,  "1080p25  64:27 2560x1080p@25Hz"             },
   {88,  "1080p30  64:27 2560x1080p@29.97/30Hz"       },
   {89,  "1080p50  64:27 2560x1080p@50Hz"             },
   {90,  "1080p60  64:27 2560x1080p@59.94/60Hz"       },
   {91,  "1080p100 64:27 2560x1080p@100Hz"            },
   {92,  "1080p120 64:27 2560x1080p@119.88/120Hz"     },

   {93,  "2160p24  16:9  3840x2160p@23.98/24Hz"       },
   {94,  "2160p25  16:9  3840x2160p@25Hz"             },
   {95,  "2160p30  16:9  3840x2160p@29.97/30Hz"       },
   {96,  "2160p50  16:9  3840x2160p@50Hz"             },
   {97,  "2160p60  16:9  3840x2160p@59.94/60Hz"       },

   {98,  "2160p24 256:135 4096x2160p@23.98/24Hz"      },
   {99,  "2160p25 256:135 4096x2160p@25Hz"            },
   {100, "2160p30 256:135 4096x2160p@29.97/30Hz"      },
   {101, "2160p50 256:135 4096x2160p@50Hz"            },
   {102, "2160p60 256:135 4096x2160p@59.94/60Hz"      },

   {103, "2160p24  64:27 3840x2160p@23.98/24Hz"       },
   {104, "2160p25  64:27 3840x2160p@25Hz"             },
   {105, "2160p30  64:27 3840x2160p@29.97/30Hz"       },
   {106, "2160p50  64:27 3840x2160p@50Hz"             },
   {107, "2160p60  64:27 3840x2160p@59.94/60Hz"       },

   {108, "720p48   16:9  1280x720p@47.95/48Hz"        },
   {109, "720p48   64:27 1280x720p@47.95/48Hz"        },
   {110, "720p48   64:27 1680x720p@47.95/48Hz"        },
   {111, "1080p48  16:9  1920x1080p@47.95/48Hz"       },
   {112, "1080p48  64:27 1920x1080p@47.95/48Hz"       },
   {113, "1080p48  64:27 2560x1080p@47.95/48Hz"       },
   {114, "2160p48  16:9  3840x2160p@47.95/48Hz"       },
   {115, "2160p48 256:135 4096x2160p@47.95/48Hz"      },
   {116, "2160p48  64:27 3840x2160p@47.95/48Hz"       },

   {117, "2160p100 16:9  3840x2160p@100Hz"            },
   {118, "2160p120 16:9  3840x2160p@119.88/120Hz"     },
   {119, "2160p100 64:27 3840x2160p@100Hz"            },
   {120, "2160p120 64:27 3840x2160p@119.88/120Hz"     },

   {121, "2160p24  64:27 5120x2160p@23.98/24Hz"       },
   {122, "2160p25  64:27 5120x2160p@25Hz"             },
   {123, "2160p30  64:27 5120x2160p@29.97/30Hz"       },
   {124, "2160p48  64:27 5120x2160p@47.95/48Hz"       },
   {125, "2160p50  64:27 5120x2160p@50Hz"             },
   {126, "2160p60  64:27 5120x2160p@59.94/60Hz"       },
   {127, "2160p100 64:27 5120x2160p@100Hz"            },

   //Video codes 128-192 are "Forbidden"

   {193, "2160p120 64:27 5120x2160p@119.88/120Hz"     },

   {194, "4320p24  16:9  7680x4320p@23.98/24Hz"       },
   {195, "4320p25  16:9  7680x4320p@25Hz"             },
   {196, "4320p30  16:9  7680x4320p@29.97/30Hz"       },
   {197, "4320p48  16:9  7680x4320p@47.95/48Hz"       },
   {198, "4320p50  16:9  7680x4320p@50Hz"             },
   {199, "4320p60  16:9  7680x4320p@59.94/60Hz"       },
   {200, "4320p100 16:9  7680x4320p@100Hz"            },
   {201, "4320p120 16:9  7680x4320p@119.88/120Hz"     },

   {202, "4320p24  64:27 7680x4320p@23.98/24Hz"       },
   {203, "4320p25  64:27 7680x4320p@25Hz"             },
   {204, "4320p30  64:27 7680x4320p@29.97/30Hz"       },
   {205, "4320p48  64:27 7680x4320p@47.95/48Hz"       },
   {206, "4320p50  64:27 7680x4320p@50Hz"             },
   {207, "4320p60  64:27 7680x4320p@59.94/60Hz"       },
   {208, "4320p100 64:27 7680x4320p@100Hz"            },
   {209, "4320p120 64:27 7680x4320p@119.88/120Hz"     },

   {210, "4320p24  64:27 10240x4320p@23.98/24Hz"      },
   {211, "4320p25  64:27 10240x4320p@25Hz"            },
   {212, "4320p30  64:27 10240x4320p@29.97/30Hz"      },
   {213, "4320p48  64:27 10240x4320p@47.95/48Hz"      },
   {214, "4320p50  64:27 10240x4320p@50Hz"            },
   {215, "4320p60  64:27 10240x4320p@59.94/60Hz"      },
   {216, "4320p100 64:27 10240x4320p@100Hz"           },
   {217, "4320p120 64:27 10240x4320p@119.88/120Hz"    },

   {218, "2160p100 256:135 4096x2160p@100Hz"          },
   {219, "2160p120 256:135 4096x2160p@119.88/120Hz"   }

   //Video codes 220-255 are reserved for future use
};

const vmap_t CEA_vidm_map = {
   0, 155, //128+27
   vidmd_map
};

#endif /* SVD_VIDFMT_H */
