import java.applet.*;
import java.awt.*;
import java.awt.event.*;

class StarThread extends Thread
{
	protected StarViewer appl;
	public StarThread(StarViewer n_appl)
	{
		appl=n_appl;
	}
	public void run() throws InterruptedException
	{
		while (true)
		{
			appl.panell.go();
			appl.panell.repaint();
			sleep(20);
		}		
	}
}

class StarPanel extends Component
{
	public double laxis, saxis, iangle, speed;
	public int direction; 
	double angle;
	double xmin, xmax, ymin, ymax;
	double focx, focy, x, y;
	int replyx, replyy;
	double replydist;
	public boolean path;
	public boolean replied;
	int curx, cury, curhsize, curvsize;
        Dimension D; 
        
        public void init()
        {
		angle=iangle;
		xmin=-laxis;
		xmax=laxis;
		ymin=-saxis;
		ymax=saxis;
		if (laxis>saxis)
		{
			focx=direction*Math.sqrt(Math.abs(laxis*laxis-saxis*saxis));
			focy=0;
		}
		else
		{
			focx=0;
			focy=direction*Math.sqrt(Math.abs(saxis*saxis-laxis*laxis));
		}
		replied=false;
        }
        
	public void trans(double x, double y)
	{
		curx=(int)(x/(xmax-xmin)*curhsize+D.width/2);
		cury=(int)((-y)/(ymax-ymin)*curvsize+D.height/2);
	}
	
	public double sdist(double x1, double y1, double x2, double y2) // squared distance
	{
		return (x2-x1)*(x2-x1)+(y2-y1)*(y2-y1);
	}
	
	public void go()
	{
		x=laxis*Math.cos(angle);
		y=saxis*Math.sin(angle);
		angle+=speed*0.02*((laxis+saxis)*(laxis+saxis)/4.0)/sdist(focx, focy, x, y);
	}
	 
	public void paint(Graphics g) 
	{
		int x1, y1, x2, y2;
		D=getSize();	
		curvsize=Math.min((int)((D.width-10)*saxis/laxis), D.height-10);
		curhsize=(int)(curvsize*laxis/saxis);
		g.setColor(Color.black);			
		trans(x, y);
		g.fillArc(curx-5, cury-5, 10, 10, 0, 360);
		if (path)
		{
			trans(-laxis, saxis);
			x1=curx; y1=cury;
			trans(laxis, -saxis);
			x2=curx; y2=cury;			
			g.drawArc(x1, y1, x2-x1, y2-y1, 0, 360);
		}
		if (replied)
		{
			g.setColor(Color.red);
			trans(focx, focy);
			g.fillArc(curx-10, cury-10, 20, 20, 0, 360);
			g.setColor(Color.black);
			g.drawLine(replyx-10,replyy,replyx+10,replyy);
			g.drawLine(replyx,replyy-10,replyx,replyy+10);
		}
	} 

	public void onReply(int x, int y)
	{
		replied=true;
		replyx=x;
		replyy=y;
		trans(focx, focy);
		replydist=Math.sqrt(sdist(curx, cury, replyx, replyy));		
	}
}

class StarResultPanel extends Component
{
	double marks[][];
	int curmark;
	public StarResultPanel(int n)
	{
		marks=new double[n][2];
		curmark=0;
	}
	public void addMark(double dist)
	{		
		marks[curmark][0]=dist;
		marks[curmark][1]=Math.random()*2*Math.PI;
		curmark++;
		repaint();
	}
	
	public void paint(Graphics g)
	{
		Dimension D;
		int i;
		int size, psize, ctrx, ctry, markx, marky;
		D=getSize();
		size=Math.min(D.width, D.height);
		psize=(size-4)/10;
		ctrx=D.width/2;
		ctry=D.height/2;
		for (i=0; i<=5; i++) g.drawArc(ctrx-i*psize-1, ctry-i*psize-1, 2*i*psize+2, 2*i*psize+2, 0, 360);
		for (i=0; i<curmark; i++)
			if (marks[i][0]<25)
			{
				markx=ctrx+(int)(marks[i][0]/5*psize*Math.cos(marks[i][1]));
				marky=ctry+(int)(marks[i][0]/5*psize*Math.sin(marks[i][1]));
				g.fillArc(markx-3, marky-3, 6, 6, 0, 360);
			}
	}
	public double getscore()
	{
		int i;
		double total;
		double score;
		if (curmark==0) return 0.0;
		total=0.0;
		for (i=0; i<curmark; i++) total+=marks[i][0];
		score=10.0-total/5.0/curmark;
		score=Math.rint(score*10)/10;
		if (score<0.0) score=0.0;
		return score;
	}
}

class StarListener implements ActionListener
{
	protected StarViewer appl;
	public boolean isactive;
	public StarListener(StarViewer n_appl)
	{
		appl=n_appl;
		isactive=true;
	}
	public void actionPerformed(ActionEvent e)
	{
		if (e.getActionCommand()=="stop")
		{
			if (isactive)
			{
				isactive=false;
				appl.thr.suspend();
				appl.btnstop.setLabel("Resume");
			}
			else
			{
				isactive=true;
				appl.thr.resume();
				appl.btnstop.setLabel("Pause");
			}
		}
		if (e.getActionCommand()=="path")
		{
			appl.panell.path=!appl.panell.path;
			if (appl.panell.path) appl.btnpath.setLabel("Hide Path");
			else appl.btnpath.setLabel("Show Path");
		}
	}
}

class StarMouseListener implements MouseListener
{
	StarViewer appl;
	public StarMouseListener(StarViewer n_appl)
	{
		appl=n_appl;
	}
	public void mouseClicked(MouseEvent e)
	{
		if (!appl.panell.replied)
		{
			appl.panell.onReply(e.getX(), e.getY());
			appl.panelr.addMark(appl.panell.replydist);
			appl.updatelblstatus();
		}
		else if (appl.ctry<appl.ntry)
		{
			appl.ctry++;
			appl.newtry();
			appl.updatelblntry();
			appl.updatelblstatus();			
		}
		else
		{
			appl.lblntry.setText("Game over");
			appl.lblstatus.setText("Your score: "+String.valueOf(appl.panelr.getscore())+"/10");
		}
	}
	public void mouseEntered(MouseEvent e){}
	public void mouseExited(MouseEvent e){}
	public void mousePressed(MouseEvent e){}
	public void mouseReleased(MouseEvent e){}			
}

public class StarViewer extends Applet
{
	public StarThread thr;
	public Button btnstop, btnpath;
	public Label lblntry, lblstatus;
	public StarPanel panell;
	public StarResultPanel panelr;
	public int ntry, ctry;
	public StarViewer()
	{
	}

	public String getAppletInfo()
	{
		return "Name: StarViewer\n" +
		       "Author: WANG Qing Chuan\n" +
		       "Created with Guavac 1.2-4";
	}

	public String[][] getParameterInfo()
	{
		String[][] info =
		{
			{ "ntry", "int", ""},
			{ "speed", "double", ""}
		};
		return info;		
	}

	public void updatelblntry()
	{
		String msg;
		msg="Try "+String.valueOf(ctry)+"/"+String.valueOf(ntry);
		lblntry.setText(msg);
	}
	
	public void updatelblstatus()
	{
		double replymm;
		String msg;
		if (panell.replied)
		{
			replymm=panell.replydist/96*25.4;
			replymm=Math.rint(replymm*10)/10;
			msg="Distance: "+String.valueOf(replymm)+" mm";
		}
		else msg="Click the sun!";
		lblstatus.setText(msg);
	}
	
	public void newtry()
	{
		if (Math.random()<0.5) panell.direction=-1;
		else panell.direction=1;
		panell.laxis=Math.random()*3+2;
		panell.saxis=Math.random()*3+2;
		panell.iangle=Math.random()*Math.PI*2;
		panell.init();
	}
	
	public void init()
	{
		GridBagLayout gridbag;
		GridBagConstraints c=new GridBagConstraints();
		StarListener listen;
		StarMouseListener mouselisten;
		ntry=(new Integer(getParameter("ntry"))).intValue();
		ctry=1;
		thr=new StarThread(this);				
		setFont(new Font("Helvetica", Font.PLAIN, 14));
		setBackground(Color.white);
		listen=new StarListener(this);
		mouselisten=new StarMouseListener(this);
		gridbag=new GridBagLayout();				
		setLayout(gridbag);
		panell=new StarPanel();		
		panell.speed=(new Double(getParameter("speed"))).doubleValue();
		panell.addMouseListener(mouselisten);
		btnstop=new Button("Pause");
		btnstop.addActionListener(listen);
		btnstop.setActionCommand("stop");
		btnpath=new Button("Show path");
		btnpath.addActionListener(listen);
		btnpath.setActionCommand("path");
		lblntry=new Label();
		updatelblntry();
		lblstatus=new Label();
		updatelblstatus();
		panelr=new StarResultPanel(ntry);
		panelr.setSize(80,80);
		panell.setSize(320,240);
		c.fill=GridBagConstraints.BOTH;
		c.weightx=1.0;
		c.weighty=1.0;
		c.gridwidth=1;
		c.gridheight=GridBagConstraints.REMAINDER;
		gridbag.setConstraints(panell, c);
		c.weightx=0.25;
		c.weighty=0.0;
		c.gridheight=1;
		c.gridwidth=GridBagConstraints.REMAINDER;		
		gridbag.setConstraints(btnstop, c);		
		gridbag.setConstraints(btnpath, c);
		gridbag.setConstraints(lblntry, c);
		c.gridheight=GridBagConstraints.RELATIVE;
		gridbag.setConstraints(lblstatus, c);
		c.weighty=1.0;		
		c.gridheight=GridBagConstraints.REMAINDER;
		gridbag.setConstraints(panelr, c);
		add(panell);		
		add(btnstop);
		add(btnpath);
		add(lblntry);
		add(lblstatus);
		add(panelr);
		newtry();
		updatelblntry();
	}

	public void destroy()
	{
	}


	public void start()
	{
		thr.start();
	}
	
	public void stop()
	{
		thr.stop();
	}

}
