/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "vdk/abstract_button.h"
#include "vdk/forms.h"
#include "vdk/colors.h"

VDKAbstractButton::VDKAbstractButton(VDKForm* owner):
    VDKObject(owner),
    Relief("Relief", this, GTK_RELIEF_NORMAL, &VDKAbstractButton::SetRelief, &VDKAbstractButton::GetRelief) {
        s_clicked.obj = this;
        s_clicked.signal = clicked_signal;

        s_enter.obj = this;
        s_enter.signal = enter_signal;

        s_leave.obj = this;
        s_leave.signal = leave_signal;

        s_toggled.obj = this;
        s_toggled.signal = toggled_signal;
}

VDKAbstractButton::~VDKAbstractButton() {
}

#ifdef USE_SIGCPLUSPLUS
void
VDKAbstractButton::make_gtksigc_connection(VDKAbstractButton* obj,
					   GtkWidget* wid)
{
     gtk_signal_connect(GTK_OBJECT(wid), "clicked", 
			GTK_SIGNAL_FUNC(VDKAbstractButton::_handle_clicked),
			reinterpret_cast<gpointer>(obj));

     gtk_signal_connect(GTK_OBJECT(wid), "pressed", 
			GTK_SIGNAL_FUNC(VDKAbstractButton::_handle_pressed),
			reinterpret_cast<gpointer>(obj));
     gtk_signal_connect(GTK_OBJECT(wid), "leave", 
			GTK_SIGNAL_FUNC(VDKAbstractButton::_handle_leave),
			reinterpret_cast<gpointer>(obj));
}

// will be redone using a template ... soon
void
VDKAbstractButton::_handle_clicked(GtkWidget* wid, gpointer gp)
{
     VDKAbstractButton* obj=reinterpret_cast<VDKAbstractButton*>(gp);
     obj->OnButtonClicked(obj);
}

void
VDKAbstractButton::_handle_pressed(GtkWidget* wid, gpointer gp)
{
     VDKAbstractButton* obj=reinterpret_cast<VDKAbstractButton*>(gp);
     obj->OnButtonPressed(obj);
}

void
VDKAbstractButton::_handle_leave(GtkWidget* wid, gpointer gp)
{
     VDKAbstractButton* obj=reinterpret_cast<VDKAbstractButton*>(gp);
     obj->OnButtonLeave(obj);
}
#endif /* USE_SIGCPLUSPLUS */



