#!/bin/sh
# Author: Jamie Strandboge <jamie@ubuntu.com>
# Copyright (C) 2013-2014 Canonical Ltd.
#
# This script is distributed under the terms and conditions of the GNU General
# Public License, Version 3 or later. See http://www.gnu.org/copyleft/gpl.html
# for details.
set -e

usage() {
    cat <<EOM
Usage: make-new-version.sh <previous> <new>
EOM
}

previous_version="$1"
if [ -z "$previous_version" ]; then
    usage
    exit 1
fi
new_version="$2"
if [ -z "$new_version" ]; then
    usage
    exit 1
fi

for t in apparmor seccomp ; do
    for i in policygroups templates ; do
        mkdir data/$t/$i/ubuntu-personal/"$new_version"
        cd data/$t/$i/ubuntu-personal/"$new_version"
        for j in ../"$previous_version"/* ; do
            ln -s $j `basename $j`
        done
        cd - >/dev/null
    done
done
