// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   tools/json_schema_compiler/compiler.py.
// NOTE: The format of types has changed. 'FooType' is now
//   'chrome.languageSettingsPrivate.FooType'.
// Please run the closure compiler before committing changes.
// See https://chromium.googlesource.com/chromium/src/+/master/docs/closure_compilation.md

/** @fileoverview Externs generated from namespace: languageSettingsPrivate */

/**
 * @const
 */
chrome.languageSettingsPrivate = {};

/**
 * @typedef {{
 *   code: string,
 *   displayName: string,
 *   nativeDisplayName: string,
 *   displayNameRTL: (boolean|undefined),
 *   supportsUI: (boolean|undefined),
 *   supportsSpellcheck: (boolean|undefined),
 *   supportsTranslate: (boolean|undefined)
 * }}
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#type-Language
 */
chrome.languageSettingsPrivate.Language;

/**
 * @typedef {{
 *   languageCode: string,
 *   isReady: boolean,
 *   isDownloading: (boolean|undefined),
 *   downloadFailed: (boolean|undefined)
 * }}
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#type-SpellcheckDictionaryStatus
 */
chrome.languageSettingsPrivate.SpellcheckDictionaryStatus;

/**
 * @typedef {{
 *   id: string,
 *   displayName: string,
 *   languageCodes: !Array<string>,
 *   enabled: (boolean|undefined),
 *   hasOptionsPage: (boolean|undefined)
 * }}
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#type-InputMethod
 */
chrome.languageSettingsPrivate.InputMethod;

/**
 * @typedef {{
 *   componentExtensionImes: !Array<!chrome.languageSettingsPrivate.InputMethod>,
 *   thirdPartyExtensionImes: !Array<!chrome.languageSettingsPrivate.InputMethod>
 * }}
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#type-InputMethodLists
 */
chrome.languageSettingsPrivate.InputMethodLists;

/**
 * Gets languages available for translate, spell checking, input and locale.
 * @param {function(!Array<!chrome.languageSettingsPrivate.Language>):void}
 *     callback
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#method-getLanguageList
 */
chrome.languageSettingsPrivate.getLanguageList = function(callback) {};

/**
 * Enables a language, adding it to the Accept-Language list (used to decide
 * which languages to translate, generate the Accept-Language header, etc.).
 * @param {string} languageCode
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#method-enableLanguage
 */
chrome.languageSettingsPrivate.enableLanguage = function(languageCode) {};

/**
 * Disables a language, removing it from the Accept-Language list.
 * @param {string} languageCode
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#method-disableLanguage
 */
chrome.languageSettingsPrivate.disableLanguage = function(languageCode) {};

/**
 * Gets the current status of the chosen spell check dictionaries.
 * @param {function(!Array<!chrome.languageSettingsPrivate.SpellcheckDictionaryStatus>):void}
 *     callback
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#method-getSpellcheckDictionaryStatuses
 */
chrome.languageSettingsPrivate.getSpellcheckDictionaryStatuses = function(callback) {};

/**
 * Gets the custom spell check words, in sorted order.
 * @param {function(!Array<string>):void} callback
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#method-getSpellcheckWords
 */
chrome.languageSettingsPrivate.getSpellcheckWords = function(callback) {};

/**
 * Adds a word to the custom dictionary.
 * @param {string} word
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#method-addSpellcheckWord
 */
chrome.languageSettingsPrivate.addSpellcheckWord = function(word) {};

/**
 * Removes a word from the custom dictionary.
 * @param {string} word
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#method-removeSpellcheckWord
 */
chrome.languageSettingsPrivate.removeSpellcheckWord = function(word) {};

/**
 * Gets the translate target language (in most cases, the display locale).
 * @param {function(string):void} callback
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#method-getTranslateTargetLanguage
 */
chrome.languageSettingsPrivate.getTranslateTargetLanguage = function(callback) {};

/**
 * Gets all supported input methods, including third-party IMEs. Chrome OS only.
 * @param {function(!chrome.languageSettingsPrivate.InputMethodLists):void}
 *     callback
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#method-getInputMethodLists
 */
chrome.languageSettingsPrivate.getInputMethodLists = function(callback) {};

/**
 * Adds the input method to the current user's list of enabled input methods,
 * enabling the input method for the current user. Chrome OS only.
 * @param {string} inputMethodId
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#method-addInputMethod
 */
chrome.languageSettingsPrivate.addInputMethod = function(inputMethodId) {};

/**
 * Removes the input method from the current user's list of enabled input
 * methods, disabling the input method for the current user. Chrome OS only.
 * @param {string} inputMethodId
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#method-removeInputMethod
 */
chrome.languageSettingsPrivate.removeInputMethod = function(inputMethodId) {};

/**
 * Called when the pref for the dictionaries used for spell checking changes or
 * the status of one of the spell check dictionaries changes.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#event-onSpellcheckDictionariesChanged
 */
chrome.languageSettingsPrivate.onSpellcheckDictionariesChanged;

/**
 * Called when words are added to and/or removed from the custom spell check
 * dictionary.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#event-onCustomDictionaryChanged
 */
chrome.languageSettingsPrivate.onCustomDictionaryChanged;

/**
 * Called when an input method is added.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#event-onInputMethodAdded
 */
chrome.languageSettingsPrivate.onInputMethodAdded;

/**
 * Called when an input method is removed.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/languageSettingsPrivate#event-onInputMethodRemoved
 */
chrome.languageSettingsPrivate.onInputMethodRemoved;
