/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FAKEMEDIARECORDERCONTROL_H
#define FAKEMEDIARECORDERCONTROL_H

#include <QMediaRecorderControl>
#include <QTimer>

class FakeCameraService;
class QUrl;

class FakeMediaRecorderControl : public QMediaRecorderControl
{
    Q_OBJECT
public:
    FakeMediaRecorderControl(FakeCameraService *service, QObject *parent = 0);

    void applySettings();
    qint64 duration() const;
    bool isMuted() const;
    QUrl outputLocation() const;
    bool setOutputLocation(const QUrl & location);
    QMediaRecorder::State state() const;
    QMediaRecorder::Status status() const;
    qreal volume() const;

public Q_SLOTS:
    void setMuted(bool muted);
    void setState(QMediaRecorder::State state);
    void setVolume(qreal gain);

private Q_SLOTS:
    void durationIncrease();

private:
    FakeCameraService *m_service;
    QMediaRecorder::State m_state;
    qreal m_duration;
    QTimer m_durationTimer;
};

#endif // FAKEMEDIARECORDERCONTROL_H
