.TH "ZIP_SOURCE_BUFFER" "3" "October 17, 2014" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_source_buffer\fR
\- create zip data source from buffer
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_source_t *\fR
.PD 0
.HP 4n
\fBzip_source_buffer\fR(\fIzip_t\ *archive\fR, \fIconst\ void\ *data\fR, \fIzip_uint64_t\ len\fR, \fIint\ freep\fR);
.PD
.PP
\fIzip_source_t *\fR
.PD 0
.HP 4n
\fBzip_source_buffer_create\fR(\fIconst\ void\ *data\fR, \fIzip_uint64_t\ len\fR, \fIint\ freep\fR, \fIzip_error_t\ *error\fR);
.PD
.SH "DESCRIPTION"
The functions
\fBzip_source_buffer\fR()
and
\fBzip_source_buffer_create\fR()
create a zip source from the buffer
\fIdata\fR
of size
\fIlen\fR.
If
\fIfreep\fR
is non-zero, the buffer will be freed when it is no longer needed.
\fIdata\fR
must remain valid for the lifetime of the created source.
.PP
The source can be used to open a zip archive from.
.SH "RETURN VALUES"
Upon successful completion, the created source is returned.
Otherwise,
\fRNULL\fR
is returned and the error code in
\fIarchive\fR
or
\fIerror\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_source_buffer\fR()
and
\fBzip_source_buffer_create\fR()
fail if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIlen\fR
is greater than zero and
\fIdata\fR
is
\fRNULL\fR.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.SH "SEE ALSO"
libzip(3),
zip_add(3),
zip_open_from_source(3),
zip_replace(3),
zip_source(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
