/* ***************************************************************************
 *
 * Pico Technology USB Device Driver
 *
 *//**
 * \file      PicoDownloader_MacOSX.h 
 * \brief     Background firmware downloader for Pico products: MacOSX-specific implementation
 **//*
 *
 * Copyright (c) 2007, Pico Technology.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * The name of Pico Technology may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY PICO TECHNOLOGY "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL PICO TECHNOLOGY BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Version $Id: PicoDownloader_MacOSX.h,v 1.4 2007/08/01 16:54:49 douglas Exp $
 *
 *************************************************************************** */

#include "PicoPortability.h"

/* Avoid including this header if we are not compiling for Mac OSX */
#ifdef PICO_OS_MACOSX

/* Avoid including this header more than once */
#ifndef PICODOWNLOADER_MACOSX_H
#define PICODOWNLOADER_MACOSX_H

//#define DEBUG 1

// USB chip FW download reg addresses
#define	kFX_FX2_USBCS			0x7f92
#define	kFX1_FX2LP_USBCS		0xe600

// Don't print IO Kit debug messages
#define NARRATEIO 0
#define NARRATEDOWNLOAD 0

#include "PicoDownloader.h"

class PicoDownloader_MacOSX : PicoDownloader {
	private:
		// Configuration
		unsigned short product;
		unsigned short release;
		INTEL_HEX_RECORD *firmware;
		UsbChip chip;
		
		// Other
		pthread_t *thread;
		pid_t pid;
		pthread_mutex_t initialDeviceMutex;
		bool initialized;
		int initialDevices;
		
		// MacOSX specific fields
		IONotificationPortRef notifyPort;
		io_iterator_t deviceAddedIter;
		CFRunLoopRef runLoop;
		
		// Private functions
		static void	*threadProc(void *args);
		void DownloadThread (void);
		int SetupNotification();
		
		// MacOSX specific functions
		static void	callbackProcNewDeviceAdded(void *args,io_iterator_t iterator);
		void NewDeviceAdded(io_iterator_t iterator);
		
	public:
		PicoDownloader_MacOSX(unsigned short product,unsigned short release,INTEL_HEX_RECORD *firmware,UsbChip chip);
		~PicoDownloader_MacOSX();
		int InitialDeviceCount(void); // How many devices did we download firmware to at startup?
};

#endif // not defined PICODOWNLOADER_MACOSX_H

#endif // defined PICO_OS_MACOSX
