/* dl.cc - load dynamic libraries
 * Copyright 2005 Bas Wijnen <wijnen@debian.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "dl.hh"

namespace shevek
{
  dl::dl () : m_handle (NULL)
  {
  }

  dl::~dl ()
  {
    if (m_handle)
      close ();
  }

  void dl::open (std::string const &file)
  {
    if (m_handle)
      close ();
    m_handle = dlopen (file.c_str (), RTLD_NOW);
    if (!m_handle)
      shevek_error (ostring ("unable to open dynamic library: %s", dlerror ()));
  }

  void dl::close ()
  {
    if (!m_handle)
      shevek_error ("unable to close: no valid handle");
    dlclose (m_handle);
    m_handle = NULL;
  }
}
