/*################################################################################
# Linux Management Providers (LMP), Provider Common Library
# Copyright (C) 2008 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#ifndef __OPENDRIM_NET_DEV_H
#define __OPENDRIM_NET_DEV_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <linux/if_ether.h>
#include <arpa/inet.h>
#include <ctype.h>


#define MAXLINE          100
#define ADDR_MAX        32

struct net_proc {
        const char* name;
        unsigned long long tx;
        unsigned long long rx;
};

int CN_getNetDevices(struct net_proc** result);
void CN_releaseNetDevices(struct net_proc** result, int count);
const char* CN_getMacAddress(const char* name);
const char* CN_getIP(const char* name);
const char* CN_getNetMask(const char* name);
const char* CN_getBroadcastAddress(const char* name);

#endif
