; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -fast-isel -mtriple=i386-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512vl | FileCheck %s --check-prefix=ALL --check-prefix=X32
; RUN: llc < %s -fast-isel -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512vl | FileCheck %s --check-prefix=ALL --check-prefix=X64

; NOTE: This should use IR equivalent to what is generated by clang/test/CodeGen/avx512vlbw-builtins.c

define <2 x i64> @test_mm_broadcastb_epi8(<2 x i64> %a0) {
; X32-LABEL: test_mm_broadcastb_epi8:
; X32:       # BB#0:
; X32-NEXT:    vpbroadcastb %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_broadcastb_epi8:
; X64:       # BB#0:
; X64-NEXT:    vpbroadcastb %xmm0, %xmm0
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %res0 = shufflevector <16 x i8> %arg0, <16 x i8> undef, <16 x i32> zeroinitializer
  %res1 = bitcast <16 x i8> %res0 to <2 x i64>
  ret <2 x i64> %res1
}

define <2 x i64> @test_mm_mask_broadcastb_epi8(<2 x i64> %a0, i16 %a1, <2 x i64> %a2) {
; X32-LABEL: test_mm_mask_broadcastb_epi8:
; X32:       # BB#0:
; X32-NEXT:    movw {{[0-9]+}}(%esp), %ax
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastb %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_broadcastb_epi8:
; X64:       # BB#0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastb %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast i16 %a1 to <16 x i1>
  %arg2 = bitcast <2 x i64> %a2 to <16 x i8>
  %res0 = shufflevector <16 x i8> %arg2, <16 x i8> undef, <16 x i32> zeroinitializer
  %res1 = select <16 x i1> %arg1, <16 x i8> %res0, <16 x i8> %arg0
  %res2 = bitcast <16 x i8> %res1 to <2 x i64>
  ret <2 x i64> %res2
}

define <2 x i64> @test_mm_maskz_broadcastb_epi8(i16 %a0, <2 x i64> %a1) {
; X32-LABEL: test_mm_maskz_broadcastb_epi8:
; X32:       # BB#0:
; X32-NEXT:    movw {{[0-9]+}}(%esp), %ax
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastb %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_broadcastb_epi8:
; X64:       # BB#0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastb %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
  %arg0 = bitcast i16 %a0 to <16 x i1>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res0 = shufflevector <16 x i8> %arg1, <16 x i8> undef, <16 x i32> zeroinitializer
  %res1 = select <16 x i1> %arg0, <16 x i8> %res0, <16 x i8> zeroinitializer
  %res2 = bitcast <16 x i8> %res1 to <2 x i64>
  ret <2 x i64> %res2
}

define <4 x i64> @test_mm256_broadcastb_epi8(<2 x i64> %a0) {
; X32-LABEL: test_mm256_broadcastb_epi8:
; X32:       # BB#0:
; X32-NEXT:    vpbroadcastb %xmm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_broadcastb_epi8:
; X64:       # BB#0:
; X64-NEXT:    vpbroadcastb %xmm0, %ymm0
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %res0 = shufflevector <16 x i8> %arg0, <16 x i8> undef, <32 x i32> zeroinitializer
  %res1 = bitcast <32 x i8> %res0 to <4 x i64>
  ret <4 x i64> %res1
}

define <4 x i64> @test_mm256_mask_broadcastb_epi8(<4 x i64> %a0, i32 %a1, <2 x i64> %a2) {
; X32-LABEL: test_mm256_mask_broadcastb_epi8:
; X32:       # BB#0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    kmovd %eax, %k1
; X32-NEXT:    vpbroadcastb %xmm1, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_broadcastb_epi8:
; X64:       # BB#0:
; X64-NEXT:    kmovd %edi, %k1
; X64-NEXT:    vpbroadcastb %xmm1, %ymm0 {%k1}
; X64-NEXT:    retq
  %arg0 = bitcast <4 x i64> %a0 to <32 x i8>
  %arg1 = bitcast i32 %a1 to <32 x i1>
  %arg2 = bitcast <2 x i64> %a2 to <16 x i8>
  %res0 = shufflevector <16 x i8> %arg2, <16 x i8> undef, <32 x i32> zeroinitializer
  %res1 = select <32 x i1> %arg1, <32 x i8> %res0, <32 x i8> %arg0
  %res2 = bitcast <32 x i8> %res1 to <4 x i64>
  ret <4 x i64> %res2
}

define <4 x i64> @test_mm256_maskz_broadcastb_epi8(i32 %a0, <2 x i64> %a1) {
; X32-LABEL: test_mm256_maskz_broadcastb_epi8:
; X32:       # BB#0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    kmovd %eax, %k1
; X32-NEXT:    vpbroadcastb %xmm0, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_broadcastb_epi8:
; X64:       # BB#0:
; X64-NEXT:    kmovd %edi, %k1
; X64-NEXT:    vpbroadcastb %xmm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
  %arg0 = bitcast i32 %a0 to <32 x i1>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res0 = shufflevector <16 x i8> %arg1, <16 x i8> undef, <32 x i32> zeroinitializer
  %res1 = select <32 x i1> %arg0, <32 x i8> %res0, <32 x i8> zeroinitializer
  %res2 = bitcast <32 x i8> %res1 to <4 x i64>
  ret <4 x i64> %res2
}

define <2 x i64> @test_mm_broadcastw_epi16(<2 x i64> %a0) {
; X32-LABEL: test_mm_broadcastw_epi16:
; X32:       # BB#0:
; X32-NEXT:    vpbroadcastw %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_broadcastw_epi16:
; X64:       # BB#0:
; X64-NEXT:    vpbroadcastw %xmm0, %xmm0
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %res0 = shufflevector <8 x i16> %arg0, <8 x i16> undef, <8 x i32> zeroinitializer
  %res1 = bitcast <8 x i16> %res0 to <2 x i64>
  ret <2 x i64> %res1
}

define <2 x i64> @test_mm_mask_broadcastw_epi16(<2 x i64> %a0, i8 %a1, <2 x i64> %a2) {
; X32-LABEL: test_mm_mask_broadcastw_epi16:
; X32:       # BB#0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastw %xmm1, %xmm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_mask_broadcastw_epi16:
; X64:       # BB#0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastw %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %arg2 = bitcast <2 x i64> %a2 to <8 x i16>
  %res0 = shufflevector <8 x i16> %arg2, <8 x i16> undef, <8 x i32> zeroinitializer
  %res1 = select <8 x i1> %arg1, <8 x i16> %res0, <8 x i16> %arg0
  %res2 = bitcast <8 x i16> %res1 to <2 x i64>
  ret <2 x i64> %res2
}

define <2 x i64> @test_mm_maskz_broadcastw_epi16(i8 %a0, <2 x i64> %a1) {
; X32-LABEL: test_mm_maskz_broadcastw_epi16:
; X32:       # BB#0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %al
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastw %xmm0, %xmm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_broadcastw_epi16:
; X64:       # BB#0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastw %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res0 = shufflevector <8 x i16> %arg1, <8 x i16> undef, <8 x i32> zeroinitializer
  %res1 = select <8 x i1> %arg0, <8 x i16> %res0, <8 x i16> zeroinitializer
  %res2 = bitcast <8 x i16> %res1 to <2 x i64>
  ret <2 x i64> %res2
}

define <4 x i64> @test_mm256_broadcastw_epi16(<2 x i64> %a0) {
; X32-LABEL: test_mm256_broadcastw_epi16:
; X32:       # BB#0:
; X32-NEXT:    vpbroadcastw %xmm0, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_broadcastw_epi16:
; X64:       # BB#0:
; X64-NEXT:    vpbroadcastw %xmm0, %ymm0
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %res0 = shufflevector <8 x i16> %arg0, <8 x i16> undef, <16 x i32> zeroinitializer
  %res1 = bitcast <16 x i16> %res0 to <4 x i64>
  ret <4 x i64> %res1
}

define <4 x i64> @test_mm256_mask_broadcastw_epi16(<4 x i64> %a0, i16 %a1, <2 x i64> %a2) {
; X32-LABEL: test_mm256_mask_broadcastw_epi16:
; X32:       # BB#0:
; X32-NEXT:    movw {{[0-9]+}}(%esp), %ax
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastw %xmm1, %ymm0 {%k1}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_mask_broadcastw_epi16:
; X64:       # BB#0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastw %xmm1, %ymm0 {%k1}
; X64-NEXT:    retq
  %arg0 = bitcast <4 x i64> %a0 to <16 x i16>
  %arg1 = bitcast i16 %a1 to <16 x i1>
  %arg2 = bitcast <2 x i64> %a2 to <8 x i16>
  %res0 = shufflevector <8 x i16> %arg2, <8 x i16> undef, <16 x i32> zeroinitializer
  %res1 = select <16 x i1> %arg1, <16 x i16> %res0, <16 x i16> %arg0
  %res2 = bitcast <16 x i16> %res1 to <4 x i64>
  ret <4 x i64> %res2
}

define <4 x i64> @test_mm256_maskz_broadcastw_epi16(i16 %a0, <2 x i64> %a1) {
; X32-LABEL: test_mm256_maskz_broadcastw_epi16:
; X32:       # BB#0:
; X32-NEXT:    movw {{[0-9]+}}(%esp), %ax
; X32-NEXT:    kmovw %eax, %k1
; X32-NEXT:    vpbroadcastw %xmm0, %ymm0 {%k1} {z}
; X32-NEXT:    retl
;
; X64-LABEL: test_mm256_maskz_broadcastw_epi16:
; X64:       # BB#0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastw %xmm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
  %arg0 = bitcast i16 %a0 to <16 x i1>
  %arg1 = bitcast <2 x i64> %a1 to <8 x i16>
  %res0 = shufflevector <8 x i16> %arg1, <8 x i16> undef, <16 x i32> zeroinitializer
  %res1 = select <16 x i1> %arg0, <16 x i16> %res0, <16 x i16> zeroinitializer
  %res2 = bitcast <16 x i16> %res1 to <4 x i64>
  ret <4 x i64> %res2
}

!0 = !{i32 1}

