/*
 *  Copyright 1994-2020 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "events.h"

/*
 * Automagically generated from events.c.in
 * DO NOT EDIT !!!
 */

void
on_key(Context_t *ctx, const BKey_t *k)
{

  /* =============== Context =============== */

  /* [Alt-Shift-r] - Toggle 3D random rotations */
  if (BALTSHIFT(k, SDLK_r)) {
    Context_send_event(ctx, BT_CONTEXT, BC_RANDOM, BA_ROTATIONS);
    return;
  }

  /* [Alt-b] - Next 3D boundary */
  if (BALT(k, SDLK_b)) {
    Context_send_event(ctx, BT_CONTEXT, BC_NEXT, BA_BOUNDARY);
    return;
  }

  /* [Alt-r] - Toggle 3D auto rotations */
  if (BALT(k, SDLK_r)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SWITCH, BA_ROTATIONS);
    return;
  }

  /* [Alt-c] - Display current colormap */
  if (BALT(k, SDLK_c)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SWITCH, BA_OSD_CMAP);
    return;
  }

  /* [Ctrl-f] - Toggle full-screen on/off */
  if (BCTRL(k, SDLK_f)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SWITCH, BA_FULLSCREEN);
    return;
  }

  /* [Alt-m] - Show/hide mouse cursor */
  if (BALT(k, SDLK_m)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SWITCH, BA_CURSOR);
    return;
  }

  /* [Shift-d] - Increase phase-space delay */
  if (BSHIFT(k, SDLK_d)) {
    Context_send_event(ctx, BT_CONTEXT, BC_NEXT, BA_DELAY);
    return;
  }

  /* [Alt-d] - Decrease phase-space delay */
  if (BALT(k, SDLK_d)) {
    Context_send_event(ctx, BT_CONTEXT, BC_PREV, BA_DELAY);
    return;
  }

  /* [Shift-q] - Quit */
  if (BSHIFT(k, SDLK_q)) {
    Context_send_event(ctx, BT_CONTEXT, BC_QUIT, BA_NONE);
    return;
  }

  /* [Shift-x] - Save the current sequence then exit */
  if (BSHIFT(k, SDLK_x)) {
    Context_send_event(ctx, BT_CONTEXT, BC_QUIT, BA_SAVE);
    return;
  }

  /* [Shift-n] - Fill current frame with random pixels */
  if (BSHIFT(k, SDLK_n)) {
    Context_send_event(ctx, BT_CONTEXT, BC_RESET, BA_RANDOM);
    return;
  }

  /* [n] - Clear the current frame */
  if (BKEY(k, SDLK_n)) {
    Context_send_event(ctx, BT_CONTEXT, BC_RESET, BA_SEQUENCE);
    return;
  }

  /* [ESCAPE] - Turn off all auto changes */
  if (BKEY(k, SDLK_ESCAPE)) {
    Context_send_event(ctx, BT_CONTEXT, BC_RESET, BA_NONE);
    return;
  }

  /* [RETURN] - Toggle selected plugin on/off */
  if (BKEY(k, SDLK_RETURN)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SWITCH, BA_SELECTED);
    return;
  }

  /* [Shift-RIGHT] - Use previous sequence */
  if (BSHIFT(k, SDLK_RIGHT)) {
    Context_send_event(ctx, BT_CONTEXT, BC_PREV, BA_SEQUENCE);
    return;
  }

  /* [Shift-LEFT] - Use next sequence */
  if (BSHIFT(k, SDLK_LEFT)) {
    Context_send_event(ctx, BT_CONTEXT, BC_NEXT, BA_SEQUENCE);
    return;
  }

  /* [Shift-PRINTSCREEN] - Take a screenshot */
  if (BSHIFT(k, SDLK_PRINTSCREEN)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SAVE, BA_SCREENSHOT);
    return;
  }

  /* [Ctrl-BACKSPACE] - Make a sequence from system schemes */
  if (BCTRL(k, SDLK_BACKSPACE)) {
    Context_send_event(ctx, BT_CONTEXT, BC_RANDOM, BA_SCHEME);
    return;
  }

  /* [BACKSPACE] - Select a random user sequence */
  if (BKEY(k, SDLK_BACKSPACE)) {
    Context_send_event(ctx, BT_CONTEXT, BC_RANDOM, BA_SEQUENCE);
    return;
  }

  /* [Ctrl-m] - Next random mode */
  if (BCTRL(k, SDLK_m)) {
    Context_send_event(ctx, BT_CONTEXT, BC_NEXT, BA_RANDOM);
    return;
  }

  /* [Shift-m] - Previous random mode */
  if (BSHIFT(k, SDLK_m)) {
    Context_send_event(ctx, BT_CONTEXT, BC_PREV, BA_RANDOM);
    return;
  }

  /* [Ctrl-t] - Auto colormaps on/off */
  if (BCTRL(k, SDLK_t)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SWITCH, BA_COLORMAPS);
    return;
  }

  /* [Ctrl-i] - Auto images on/off */
  if (BCTRL(k, SDLK_i)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SWITCH, BA_IMAGES);
    return;
  }

  /* [Ctrl-p] - Use the most recent sequence */
  if (BCTRL(k, SDLK_p)) {
    Context_send_event(ctx, BT_CONTEXT, BC_RELOAD, BA_SEQUENCE);
    return;
  }

  /* [SPACE] - Bypass mode on/off */
  if (BKEY(k, SDLK_SPACE)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SWITCH, BA_BYPASS);
    return;
  }

  /* [Ctrl-SPACE] - Set webcam reference image */
  if (BCTRL(k, SDLK_SPACE)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SET, BA_WEBCAM);
    return;
  }

  /* [Ctrl-v] - Switch 3d cube on/off */
  if (BCTRL(k, SDLK_v)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SWITCH, BA_BOUNDARY);
    return;
  }

  /* [Ctrl-c] - Toggle 3D world pulse on/off */
  if (BCTRL(k, SDLK_c)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SWITCH, BA_PULSE);
    return;
  }

  /* [TAB] - Select next webcam */
  if (BKEY(k, SDLK_TAB)) {
    Context_send_event(ctx, BT_CONTEXT, BC_NEXT, BA_WEBCAM);
    return;
  }

  /* [Ctrl-l] - Lock selected plugin */
  if (BCTRL(k, SDLK_l)) {
    Context_send_event(ctx, BT_CONTEXT, BC_LOCK, BA_SELECTED);
    return;
  }

  /* [Shift-s] - Increase spline span size */
  if (BSHIFT(k, SDLK_s)) {
    Context_send_event(ctx, BT_CONTEXT, BC_NEXT, BA_SPAN);
    return;
  }

  /* [Alt-s] - Decrease spline span size */
  if (BALT(k, SDLK_s)) {
    Context_send_event(ctx, BT_CONTEXT, BC_PREV, BA_SPAN);
    return;
  }

  /* [Ctrl-TAB] - Freeze sound on/off */
  if (BCTRL(k, SDLK_TAB)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SWITCH, BA_MUTE);
    return;
  }

  /* [Shift-v] - Scale volume up */
  if (BSHIFT(k, SDLK_v)) {
    Context_send_event(ctx, BT_CONTEXT, BC_VOLUME_SCALE, BA_UP);
    return;
  }

  /* [Alt-v] - Scale volume down */
  if (BALT(k, SDLK_v)) {
    Context_send_event(ctx, BT_CONTEXT, BC_VOLUME_SCALE, BA_DOWN);
    return;
  }

  /* =============== Plugins =============== */

  /* [UP] - Select previous plugin */
  if (BKEY(k, SDLK_UP)) {
    Context_send_event(ctx, BT_PLUGINS, BC_PREV, BA_NONE);
    return;
  }

  /* [DOWN] - Select next plugin */
  if (BKEY(k, SDLK_DOWN)) {
    Context_send_event(ctx, BT_PLUGINS, BC_NEXT, BA_NONE);
    return;
  }

  /* [PAGEUP] - Scroll up in the plugins list */
  if (BKEY(k, SDLK_PAGEUP)) {
    Context_send_event(ctx, BT_PLUGINS, BC_SELECT, BA_UP);
    return;
  }

  /* [PAGEDOWN] - Scroll down in the plugins list */
  if (BKEY(k, SDLK_PAGEDOWN)) {
    Context_send_event(ctx, BT_PLUGINS, BC_SELECT, BA_DOWN);
    return;
  }

  /* =============== Sequence =============== */

  /* [Shift-z] - Reset the current sequence */
  if (BSHIFT(k, SDLK_z)) {
    Context_send_event(ctx, BT_SEQMGR, BC_RESET, BA_SEQUENCE);
    return;
  }

  /* [Shift-l] - Toggle selected plugin as a lens on/off */
  if (BSHIFT(k, SDLK_l)) {
    Context_send_event(ctx, BT_SEQMGR, BC_SWITCH, BA_LENS);
    return;
  }

  /* [Shift-UP] - Select previous plugin in the sequence */
  if (BSHIFT(k, SDLK_UP)) {
    Context_send_event(ctx, BT_SEQMGR, BC_PREV, BA_NONE);
    return;
  }

  /* [Shift-DOWN] - Select next plugin in the sequence */
  if (BSHIFT(k, SDLK_DOWN)) {
    Context_send_event(ctx, BT_SEQMGR, BC_NEXT, BA_NONE);
    return;
  }

  /* [Ctrl-UP] - Move selected plugin up in the sequence */
  if (BCTRL(k, SDLK_UP)) {
    Context_send_event(ctx, BT_SEQMGR, BC_MOVE, BA_UP);
    return;
  }

  /* [Ctrl-DOWN] - Move selected plugin down in the sequence */
  if (BCTRL(k, SDLK_DOWN)) {
    Context_send_event(ctx, BT_SEQMGR, BC_MOVE, BA_DOWN);
    return;
  }

  /* [Alt-y] - Select default layer mode for the current plugin */
  if (BALT(k, SDLK_y)) {
    Context_send_event(ctx, BT_SEQMGR, BC_RESET, BA_LAYER_MODE);
    return;
  }

  /* [Shift-y] - Select next layer mode */
  if (BSHIFT(k, SDLK_y)) {
    Context_send_event(ctx, BT_SEQMGR, BC_NEXT, BA_LAYER_MODE);
    return;
  }

  /* [Ctrl-s] - Save current sequence as new (full) */
  if (BCTRL(k, SDLK_s)) {
    Context_send_event(ctx, BT_SEQMGR, BC_SAVE, BA_SEQUENCE_FULL);
    return;
  }

  /* [Ctrl-u] - Update current full sequence */
  if (BCTRL(k, SDLK_u)) {
    Context_send_event(ctx, BT_SEQMGR, BC_SAVE, BA_OVERWRITE_FULL);
    return;
  }

  /* [Ctrl-Shift-s] - Save current sequence as new (bare) */
  if (BCTRLSHIFT(k, SDLK_s)) {
    Context_send_event(ctx, BT_SEQMGR, BC_SAVE, BA_SEQUENCE_BARE);
    return;
  }

  /* [Ctrl-Shift-u] - Update current bare sequence */
  if (BCTRLSHIFT(k, SDLK_u)) {
    Context_send_event(ctx, BT_SEQMGR, BC_SAVE, BA_OVERWRITE_BARE);
    return;
  }

  /* [Alt-UP] - Select previous plugin parameter */
  if (BALT(k, SDLK_UP)) {
    Context_send_event(ctx, BT_SEQMGR, BC_PARAM_PREV, BA_NONE);
    return;
  }

  /* [Alt-DOWN] - Select next plugin parameter */
  if (BALT(k, SDLK_DOWN)) {
    Context_send_event(ctx, BT_SEQMGR, BC_PARAM_NEXT, BA_NONE);
    return;
  }

  /* [Alt-LEFT] - Decrease plugin parameter value */
  if (BALT(k, SDLK_LEFT)) {
    Context_send_event(ctx, BT_SEQMGR, BC_PARAM_DEC, BA_NONE);
    return;
  }

  /* [Alt-RIGHT] - Increase plugin parameter value */
  if (BALT(k, SDLK_RIGHT)) {
    Context_send_event(ctx, BT_SEQMGR, BC_PARAM_INC, BA_NONE);
    return;
  }

  /* [Alt-Shift-LEFT] - Decrease plugin parameter value quickly */
  if (BALTSHIFT(k, SDLK_LEFT)) {
    Context_send_event(ctx, BT_SEQMGR, BC_PARAM_DEC_FAST, BA_NONE);
    return;
  }

  /* [Alt-Shift-RIGHT] - Increase plugin parameter value quickly */
  if (BALTSHIFT(k, SDLK_RIGHT)) {
    Context_send_event(ctx, BT_SEQMGR, BC_PARAM_INC_FAST, BA_NONE);
    return;
  }

  /* =============== Colormaps =============== */

  /* [e] - Select previous colormap */
  if (BKEY(k, SDLK_e)) {
    Context_send_event(ctx, BT_CMAPFADER, BC_SELECT, BA_PREV);
    return;
  }

  /* [r] - Select next colormap */
  if (BKEY(k, SDLK_r)) {
    Context_send_event(ctx, BT_CMAPFADER, BC_SELECT, BA_NEXT);
    return;
  }

  /* [t] - Select random colormap */
  if (BKEY(k, SDLK_t)) {
    Context_send_event(ctx, BT_CMAPFADER, BC_SELECT, BA_RANDOM);
    return;
  }

  /* =============== Images =============== */

  /* [y] - Select previous image */
  if (BKEY(k, SDLK_y)) {
    Context_send_event(ctx, BT_IMAGEFADER, BC_SELECT, BA_PREV);
    return;
  }

  /* [u] - Select next image */
  if (BKEY(k, SDLK_u)) {
    Context_send_event(ctx, BT_IMAGEFADER, BC_SELECT, BA_NEXT);
    return;
  }

  /* [i] - Select random image */
  if (BKEY(k, SDLK_i)) {
    Context_send_event(ctx, BT_IMAGEFADER, BC_SELECT, BA_RANDOM);
    return;
  }

  /* =============== Banks =============== */

  /* [Ctrl-g] - Set bank mode to sequences */
  if (BCTRL(k, SDLK_g)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SET_BANKMODE, 0);
    return;
  }

  /* [Ctrl-h] - Set bank mode to colormaps */
  if (BCTRL(k, SDLK_h)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SET_BANKMODE, 1);
    return;
  }

  /* [Ctrl-j] - Set bank mode to images */
  if (BCTRL(k, SDLK_j)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SET_BANKMODE, 2);
    return;
  }

  /* [Ctrl-Shift-F1] - Clear bank 1 */
  if (BCTRLSHIFT(k, SDLK_F1)) {
    Context_send_event(ctx, BT_CONTEXT, BC_CLEAR_BANK, 0);
    return;
  }

  /* [Ctrl-Shift-F2] - Clear bank 2 */
  if (BCTRLSHIFT(k, SDLK_F2)) {
    Context_send_event(ctx, BT_CONTEXT, BC_CLEAR_BANK, 1);
    return;
  }

  /* [Ctrl-Shift-F3] - Clear bank 3 */
  if (BCTRLSHIFT(k, SDLK_F3)) {
    Context_send_event(ctx, BT_CONTEXT, BC_CLEAR_BANK, 2);
    return;
  }

  /* [Ctrl-Shift-F4] - Clear bank 4 */
  if (BCTRLSHIFT(k, SDLK_F4)) {
    Context_send_event(ctx, BT_CONTEXT, BC_CLEAR_BANK, 3);
    return;
  }

  /* [Ctrl-Shift-F5] - Clear bank 5 */
  if (BCTRLSHIFT(k, SDLK_F5)) {
    Context_send_event(ctx, BT_CONTEXT, BC_CLEAR_BANK, 4);
    return;
  }

  /* [Ctrl-Shift-F6] - Clear bank 6 */
  if (BCTRLSHIFT(k, SDLK_F6)) {
    Context_send_event(ctx, BT_CONTEXT, BC_CLEAR_BANK, 5);
    return;
  }

  /* [Ctrl-Shift-F7] - Clear bank 7 */
  if (BCTRLSHIFT(k, SDLK_F7)) {
    Context_send_event(ctx, BT_CONTEXT, BC_CLEAR_BANK, 6);
    return;
  }

  /* [Ctrl-Shift-F8] - Clear bank 8 */
  if (BCTRLSHIFT(k, SDLK_F8)) {
    Context_send_event(ctx, BT_CONTEXT, BC_CLEAR_BANK, 7);
    return;
  }

  /* [Ctrl-Shift-F9] - Clear bank 9 */
  if (BCTRLSHIFT(k, SDLK_F9)) {
    Context_send_event(ctx, BT_CONTEXT, BC_CLEAR_BANK, 8);
    return;
  }

  /* [Ctrl-Shift-F10] - Clear bank 10 */
  if (BCTRLSHIFT(k, SDLK_F10)) {
    Context_send_event(ctx, BT_CONTEXT, BC_CLEAR_BANK, 9);
    return;
  }

  /* [Ctrl-Shift-F11] - Clear bank 11 */
  if (BCTRLSHIFT(k, SDLK_F11)) {
    Context_send_event(ctx, BT_CONTEXT, BC_CLEAR_BANK, 10);
    return;
  }

  /* [Ctrl-Shift-F12] - Clear bank 12 */
  if (BCTRLSHIFT(k, SDLK_F12)) {
    Context_send_event(ctx, BT_CONTEXT, BC_CLEAR_BANK, 11);
    return;
  }

  /* [Shift-F1] - Assign current sequence/colormap/image to bank 1 */
  if (BSHIFT(k, SDLK_F1)) {
    Context_send_event(ctx, BT_CONTEXT, BC_STORE_BANK, 0);
    return;
  }

  /* [Shift-F2] - Assign current sequence/colormap/image to bank 2 */
  if (BSHIFT(k, SDLK_F2)) {
    Context_send_event(ctx, BT_CONTEXT, BC_STORE_BANK, 1);
    return;
  }

  /* [Shift-F3] - Assign current sequence/colormap/image to bank 3 */
  if (BSHIFT(k, SDLK_F3)) {
    Context_send_event(ctx, BT_CONTEXT, BC_STORE_BANK, 2);
    return;
  }

  /* [Shift-F4] - Assign current sequence/colormap/image to bank 4 */
  if (BSHIFT(k, SDLK_F4)) {
    Context_send_event(ctx, BT_CONTEXT, BC_STORE_BANK, 3);
    return;
  }

  /* [Shift-F5] - Assign current sequence/colormap/image to bank 5 */
  if (BSHIFT(k, SDLK_F5)) {
    Context_send_event(ctx, BT_CONTEXT, BC_STORE_BANK, 4);
    return;
  }

  /* [Shift-F6] - Assign current sequence/colormap/image to bank 6 */
  if (BSHIFT(k, SDLK_F6)) {
    Context_send_event(ctx, BT_CONTEXT, BC_STORE_BANK, 5);
    return;
  }

  /* [Shift-F7] - Assign current sequence/colormap/image to bank 7 */
  if (BSHIFT(k, SDLK_F7)) {
    Context_send_event(ctx, BT_CONTEXT, BC_STORE_BANK, 6);
    return;
  }

  /* [Shift-F8] - Assign current sequence/colormap/image to bank 8 */
  if (BSHIFT(k, SDLK_F8)) {
    Context_send_event(ctx, BT_CONTEXT, BC_STORE_BANK, 7);
    return;
  }

  /* [Shift-F9] - Assign current sequence/colormap/image to bank 9 */
  if (BSHIFT(k, SDLK_F9)) {
    Context_send_event(ctx, BT_CONTEXT, BC_STORE_BANK, 8);
    return;
  }

  /* [Shift-F10] - Assign current sequence/colormap/image to bank 10 */
  if (BSHIFT(k, SDLK_F10)) {
    Context_send_event(ctx, BT_CONTEXT, BC_STORE_BANK, 9);
    return;
  }

  /* [Shift-F11] - Assign current sequence/colormap/image to bank 11 */
  if (BSHIFT(k, SDLK_F11)) {
    Context_send_event(ctx, BT_CONTEXT, BC_STORE_BANK, 10);
    return;
  }

  /* [Shift-F12] - Assign current sequence/colormap/image to bank 12 */
  if (BSHIFT(k, SDLK_F12)) {
    Context_send_event(ctx, BT_CONTEXT, BC_STORE_BANK, 11);
    return;
  }

  /* [F1] - Use sequence/colormap/image in bank 1 */
  if (BKEY(k, SDLK_F1)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANK, 0);
    return;
  }

  /* [F2] - Use sequence/colormap/image in bank 2 */
  if (BKEY(k, SDLK_F2)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANK, 1);
    return;
  }

  /* [F3] - Use sequence/colormap/image in bank 3 */
  if (BKEY(k, SDLK_F3)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANK, 2);
    return;
  }

  /* [F4] - Use sequence/colormap/image in bank 4 */
  if (BKEY(k, SDLK_F4)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANK, 3);
    return;
  }

  /* [F5] - Use sequence/colormap/image in bank 5 */
  if (BKEY(k, SDLK_F5)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANK, 4);
    return;
  }

  /* [F6] - Use sequence/colormap/image in bank 6 */
  if (BKEY(k, SDLK_F6)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANK, 5);
    return;
  }

  /* [F7] - Use sequence/colormap/image in bank 7 */
  if (BKEY(k, SDLK_F7)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANK, 6);
    return;
  }

  /* [F8] - Use sequence/colormap/image in bank 8 */
  if (BKEY(k, SDLK_F8)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANK, 7);
    return;
  }

  /* [F9] - Use sequence/colormap/image in bank 9 */
  if (BKEY(k, SDLK_F9)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANK, 8);
    return;
  }

  /* [F10] - Use sequence/colormap/image in bank 10 */
  if (BKEY(k, SDLK_F10)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANK, 9);
    return;
  }

  /* [F11] - Use sequence/colormap/image in bank 11 */
  if (BKEY(k, SDLK_F11)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANK, 10);
    return;
  }

  /* [F12] - Use sequence/colormap/image in bank 12 */
  if (BKEY(k, SDLK_F12)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANK, 11);
    return;
  }

  /* [Ctrl-F1] - Use bankset 1 */
  if (BCTRL(k, SDLK_F1)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANKSET, 0);
    return;
  }

  /* [Ctrl-F2] - Use bankset 2 */
  if (BCTRL(k, SDLK_F2)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANKSET, 1);
    return;
  }

  /* [Ctrl-F3] - Use bankset 3 */
  if (BCTRL(k, SDLK_F3)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANKSET, 2);
    return;
  }

  /* [Ctrl-F4] - Use bankset 4 */
  if (BCTRL(k, SDLK_F4)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANKSET, 3);
    return;
  }

  /* [Ctrl-F5] - Use bankset 5 */
  if (BCTRL(k, SDLK_F5)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANKSET, 4);
    return;
  }

  /* [Ctrl-F6] - Use bankset 6 */
  if (BCTRL(k, SDLK_F6)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANKSET, 5);
    return;
  }

  /* [Ctrl-F7] - Use bankset 7 */
  if (BCTRL(k, SDLK_F7)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANKSET, 6);
    return;
  }

  /* [Ctrl-F8] - Use bankset 8 */
  if (BCTRL(k, SDLK_F8)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANKSET, 7);
    return;
  }

  /* [Ctrl-F9] - Use bankset 9 */
  if (BCTRL(k, SDLK_F9)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANKSET, 8);
    return;
  }

  /* [Ctrl-F10] - Use bankset 10 */
  if (BCTRL(k, SDLK_F10)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANKSET, 9);
    return;
  }

  /* [Ctrl-F11] - Use bankset 11 */
  if (BCTRL(k, SDLK_F11)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANKSET, 10);
    return;
  }

  /* [Ctrl-F12] - Use bankset 12 */
  if (BCTRL(k, SDLK_F12)) {
    Context_send_event(ctx, BT_CONTEXT, BC_USE_BANKSET, 11);
    return;
  }

  /* [Ctrl-b] - Save the banks file */
  if (BCTRL(k, SDLK_b)) {
    Context_send_event(ctx, BT_CONTEXT, BC_SAVE_BANKS, BA_NONE);
    return;
  }
}
