/*
Copyright (c) 2014 VMware, Inc. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package datacenter

import (
	"flag"

	"github.com/juju/govmomi/find"
	"github.com/juju/govmomi/govc/cli"
	"github.com/juju/govmomi/govc/flags"
	"github.com/juju/govmomi/object"
	"golang.org/x/net/context"
)

type create struct {
	*flags.ClientFlag
}

func init() {
	cli.Register("datacenter.create", &create{})
}

func (cmd *create) Register(f *flag.FlagSet) {}

func (cmd *create) Usage() string {
	return "[DATACENTER NAME]..."
}

func (cmd *create) Process() error { return nil }

func (cmd *create) Run(f *flag.FlagSet) error {
	datacenters := f.Args()
	if len(datacenters) < 1 {
		return flag.ErrHelp
	}

	client, err := cmd.ClientFlag.Client()
	if err != nil {
		return err
	}

	finder := find.NewFinder(client, false)
	rootFolder := object.NewRootFolder(client)
	for _, datacenterToCreate := range datacenters {
		foundDatacenters, err := finder.DatacenterList(context.TODO(), datacenterToCreate)
		if err != nil {
			return err
		}

		if foundDatacenters == nil {
			_, err = rootFolder.CreateDatacenter(context.TODO(), datacenterToCreate)
			if err != nil {
				return err
			}
		}
	}

	return nil
}
