/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.UnmarshalException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonMismatchException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RemoteSearchable;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;

public final class RemoteSearchable_Skel
implements Skeleton {
    private static final Operation[] operations = new Operation[]{new Operation("void close()"), new Operation("org.apache.lucene.document.Document doc(int)"), new Operation("int docFreq(org.apache.lucene.index.Term)"), new Operation("org.apache.lucene.search.Explanation explain(org.apache.lucene.search.Query, int)"), new Operation("int maxDoc()"), new Operation("org.apache.lucene.search.Query rewrite(org.apache.lucene.search.Query)"), new Operation("org.apache.lucene.search.TopDocs search(org.apache.lucene.search.Query, org.apache.lucene.search.Filter, int)"), new Operation("org.apache.lucene.search.TopFieldDocs search(org.apache.lucene.search.Query, org.apache.lucene.search.Filter, int, org.apache.lucene.search.Sort)"), new Operation("void search(org.apache.lucene.search.Query, org.apache.lucene.search.Filter, org.apache.lucene.search.HitCollector)")};
    private static final long interfaceHash = 9187915733717020351L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(Remote remote, RemoteCall remoteCall, int n, long l) throws Exception {
        if (n < 0) {
            if (l == -4742752445160157748L) {
                n = 0;
            } else if (l == -3205250690722925732L) {
                n = 1;
            } else if (l == -7822449680410044026L) {
                n = 2;
            } else if (l == 6631951962358117252L) {
                n = 3;
            } else if (l == -2054052621300804366L) {
                n = 4;
            } else if (l == 6327992687997160630L) {
                n = 5;
            } else if (l == -2779958099349270815L) {
                n = 6;
            } else if (l == 9040332765774971388L) {
                n = 7;
            } else {
                if (l != 8210132726663281038L) throw new UnmarshalException("invalid method hash");
                n = 8;
            }
        } else if (l != 9187915733717020351L) {
            throw new SkeletonMismatchException("interface hash mismatch");
        }
        RemoteSearchable remoteSearchable = (RemoteSearchable)remote;
        switch (n) {
            case 0: {
                remoteCall.releaseInputStream();
                remoteSearchable.close();
                try {
                    remoteCall.getResultStream(true);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 1: {
                ObjectOutput objectOutput;
                int n2;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        n2 = objectInput.readInt();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    objectOutput = null;
                }
                catch (Throwable throwable) {
                    Object var9_32 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                Document document = remoteSearchable.doc(n2);
                try {
                    objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeObject(document);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 2: {
                ObjectOutput objectOutput;
                Term term;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        term = (Term)objectInput.readObject();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                    }
                    objectOutput = null;
                }
                catch (Throwable throwable) {
                    Object var9_35 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                int n3 = remoteSearchable.docFreq(term);
                try {
                    objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeInt(n3);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 3: {
                ObjectOutput objectOutput;
                int n4;
                Query query;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        query = (Query)objectInput.readObject();
                        n4 = objectInput.readInt();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                    }
                    objectOutput = null;
                }
                catch (Throwable throwable) {
                    Object var10_21 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                Explanation explanation = remoteSearchable.explain(query, n4);
                try {
                    objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeObject(explanation);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 4: {
                remoteCall.releaseInputStream();
                int n5 = remoteSearchable.maxDoc();
                try {
                    ObjectOutput objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeInt(n5);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 5: {
                ObjectOutput objectOutput;
                Query query;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        query = (Query)objectInput.readObject();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                    }
                    objectOutput = null;
                }
                catch (Throwable throwable) {
                    Object var9_40 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                Query query2 = remoteSearchable.rewrite(query);
                try {
                    objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeObject(query2);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 6: {
                ObjectOutput objectOutput;
                int n6;
                Filter filter;
                Query query;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        query = (Query)objectInput.readObject();
                        filter = (Filter)objectInput.readObject();
                        n6 = objectInput.readInt();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                    }
                    objectOutput = null;
                }
                catch (Throwable throwable) {
                    Object var11_61 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                TopDocs topDocs = remoteSearchable.search(query, filter, n6);
                try {
                    objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeObject(topDocs);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 7: {
                ObjectOutput objectOutput;
                Sort sort;
                int n7;
                Filter filter;
                Query query;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        query = (Query)objectInput.readObject();
                        filter = (Filter)objectInput.readObject();
                        n7 = objectInput.readInt();
                        sort = (Sort)objectInput.readObject();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                    }
                    objectOutput = null;
                }
                catch (Throwable throwable) {
                    Object var12_71 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                TopFieldDocs topFieldDocs = remoteSearchable.search(query, filter, n7, sort);
                try {
                    objectOutput = remoteCall.getResultStream(true);
                    objectOutput.writeObject(topFieldDocs);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            case 8: {
                HitCollector hitCollector;
                Filter filter;
                Query query;
                try {
                    try {
                        ObjectInput objectInput = remoteCall.getInputStream();
                        query = (Query)objectInput.readObject();
                        filter = (Filter)objectInput.readObject();
                        hitCollector = (HitCollector)objectInput.readObject();
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                    }
                    Object var11_65 = null;
                }
                catch (Throwable throwable) {
                    Object var11_66 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                remoteSearchable.search(query, filter, hitCollector);
                try {
                    remoteCall.getResultStream(true);
                    return;
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            default: {
                throw new UnmarshalException("invalid method number");
            }
        }
    }

    public Operation[] getOperations() {
        return (Operation[])operations.clone();
    }
}

