/* $Id: label.h,v 1.4 2009/01/27 15:40:22 potyra Exp $ 
 *
 * Copyright (C) 2008-2009 FAUcc Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __LABEL_H_INCLUDED
#define __LABEL_H_INCLUDED

#include "stmt.h"

struct label {
	struct label *prev;
	struct label *next;

	const char *identifier;

	struct stmt *ref_first;
	struct stmt *ref_last;
	struct stmt *def_first;
	struct stmt *def_last;

	struct label *clone;
};

extern struct label *
label_new(const char *identifier);

extern void
label_ref_add(struct label *label, struct stmt *s);
extern void
label_ref_del(struct label *label, struct stmt *s);

extern void
label_def_add(struct label *label, struct stmt *s);
extern void
label_def_del(struct label *label, struct stmt *s);

#endif /* __LABEL_H_INCLUDED */
