#!/usr/bin/perl

use strict;
use warnings;

my %dictionary = (
    'import gribapi' => 'import eccodes',
    'from gribapi import' => 'from eccodes import',
    'GRIB_CHECK' => 'CODES_CHECK',
    'grib_clone' => 'codes_clone',
    'grib_context_delete' => 'codes_context_delete',
    'grib_copy_namespace' => 'codes_copy_namespace',
    'grib_count_in_file' => 'codes_count_in_file',
    'grib_find_nearest' => 'codes_grib_find_nearest',
    'grib_find_nearest_multiple' => 'codes_grib_find_nearest_multiple',
    'grib_get' => 'codes_get',
    'grib_get_api_version' => 'codes_get_api_version',
    'grib_get_array' => 'codes_get_array',
    'grib_get_data' => 'codes_grib_get_data',
    'grib_get_double' => 'codes_get_double',
    'grib_get_double_array' => 'codes_get_double_array',
    'grib_get_double_element' => 'codes_get_double_element',
    'grib_get_double_elements' => 'codes_get_double_elements',
    'grib_get_elements' => 'codes_get_elements',
    'grib_get_float_array' => 'codes_get_float_array',
    'grib_get_long' => 'codes_get_long',
    'grib_get_long_array' => 'codes_get_long_array',
    'grib_get_message' => 'codes_get_message',
    'grib_get_message_offset' => 'codes_get_message_offset',
    'grib_get_message_size' => 'codes_get_message_size',
    'grib_get_native_type' => 'codes_get_native_type',
    'grib_get_offset' => 'codes_get_offset',
    'grib_get_size' => 'codes_get_size',
    'grib_get_string' => 'codes_get_string',
    'grib_get_string_array' => 'codes_get_string_array',
    'grib_get_string_length' => 'codes_get_string_length',
    'grib_get_values' => 'codes_get_values',
    'grib_gribex_mode_off' => 'codes_gribex_mode_off',
    'grib_gribex_mode_on' => 'codes_gribex_mode_on',
    'grib_gts_header' => 'codes_gts_header',
    'grib_index_add_file' => 'codes_index_add_file',
    'grib_index_get' => 'codes_index_get',
    'grib_index_get_double' => 'codes_index_get_double',
    'grib_index_get_long' => 'codes_index_get_long',
    'grib_index_get_size' => 'codes_index_get_size',
    'grib_index_get_string' => 'codes_index_get_string',
    'grib_index_new_from_file' => 'codes_index_new_from_file',
    'grib_index_read' => 'codes_index_read',
    'grib_index_release' => 'codes_index_release',
    'grib_index_select' => 'codes_index_select',
    'grib_index_select_double' => 'codes_index_select_double',
    'grib_index_select_long' => 'codes_index_select_long',
    'grib_index_select_string' => 'codes_index_select_string',
    'grib_index_write' => 'codes_index_write',
    'grib_is_defined' => 'codes_is_defined',
    'grib_is_missing' => 'codes_is_missing',
    'grib_iterator_delete' => 'codes_grib_iterator_delete',
    'grib_iterator_new' => 'codes_grib_iterator_new',
    'grib_iterator_next' => 'codes_grib_iterator_next',
    'grib_keys_iterator_delete' => 'codes_keys_iterator_delete',
    'grib_keys_iterator_get_name' => 'codes_keys_iterator_get_name',
    'grib_keys_iterator_new' => 'codes_keys_iterator_new',
    'grib_keys_iterator_next' => 'codes_keys_iterator_next',
    'grib_keys_iterator_rewind' => 'codes_keys_iterator_rewind',
    'grib_multi_append' => 'codes_grib_multi_append',
    'grib_multi_new' => 'codes_grib_multi_new',
    'grib_multi_release' => 'codes_grib_multi_release',
    'grib_multi_support_off' => 'codes_grib_multi_support_off',
    'grib_multi_support_on' => 'codes_grib_multi_support_on',
    'grib_multi_support_reset_file' => 'codes_grib_multi_support_reset_file',
    'grib_multi_write' => 'codes_grib_multi_write',
    'grib_nearest_delete' => 'codes_grib_nearest_delete',
    'grib_nearest_find' => 'codes_grib_nearest_find',
    'grib_nearest_new' => 'codes_grib_nearest_new',
    'grib_new_from_file' => 'codes_grib_new_from_file',
    'grib_new_from_index' => 'codes_new_from_index',
    'grib_new_from_message' => 'codes_new_from_message',
    'grib_new_from_samples' => 'codes_grib_new_from_samples',
    'grib_no_fail_on_wrong_length' => 'codes_no_fail_on_wrong_length',
    'grib_release' => 'codes_release',
    'grib_set' => 'codes_set',
    'grib_set_array' => 'codes_set_array',
    'grib_set_debug' => 'codes_set_debug',
    'grib_set_definitions_path' => 'codes_set_definitions_path',
    'grib_set_double' => 'codes_set_double',
    'grib_set_double_array' => 'codes_set_double_array',
    'grib_set_key_vals' => 'codes_set_key_vals',
    'grib_set_long' => 'codes_set_long',
    'grib_set_long_array' => 'codes_set_long_array',
    'grib_set_missing' => 'codes_set_missing',
    'grib_set_samples_path' => 'codes_set_samples_path',
    'grib_set_string' => 'codes_set_string',
    'grib_set_string_array' => 'codes_set_string_array',
    'grib_set_values' => 'codes_set_values',
    'grib_skip_coded' => 'codes_skip_coded',
    'grib_skip_computed' => 'codes_skip_computed',
    'grib_skip_duplicates' => 'codes_skip_duplicates',
    'grib_skip_edition_specific' => 'codes_skip_edition_specific',
    'grib_skip_function' => 'codes_skip_function',
    'grib_skip_read_only' => 'codes_skip_read_only',
    'grib_write' => 'codes_write',
    'gts_new_from_file' => 'codes_gts_new_from_file',
    'metar_new_from_file' => 'codes_metar_new_from_file'
);

$| = 1;
while (<>) {
    foreach my $key (keys %dictionary) {
        if (/\b$key\b/) {
            s/$key/$dictionary{$key}/g;
        }
    }
    print;
}
