package org.apache.maven.doxia.book.services.indexer;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.doxia.book.model.BookModel;
import org.apache.maven.doxia.book.context.BookContext;
import org.apache.maven.doxia.book.BookDoxiaException;

/**
 * Index a book.
 *
 * @author <a href="mailto:trygvis@inamo.no">Trygve Laugst&oslash;l</a>
 * @version $Id: BookIndexer.java 746976 2009-02-23 12:15:38Z vsiveton $
 */
public interface BookIndexer
{
    /** The plexus lookup role. */
    String ROLE = BookIndexer.class.getName();

    /**
     * Index a book.
     *
     * @param book the book to index.
     * @param bookContext the BookContext.
     * @throws org.apache.maven.doxia.book.BookDoxiaException if the book cannot be indexed.
     */
    void indexBook( BookModel book, BookContext bookContext )
        throws BookDoxiaException;
}
