/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

#ifndef __button
#define __button

#include "widget.h"
#include <string>

class button;
struct click_listener {
	virtual void clicked (button& b) = 0;
};

class button : public widget {
	
	std::string label;
	
	int click;
	enum {not_clicked = 0, almost_clicked = 1, clicked_indeed = 2};
	
	click_listener* lsnr;
	
	public:

		button (int px = 0, int py = 0, const std::string& label = "");

		void set_label (const std::string& label);

		int clicked () {return (click == clicked_indeed);}
		void set_click (int what) {click = what;}

		int handle_input ();
		void draw ();
		
		void set_listener (click_listener* l) {lsnr = l;}

};

#endif
