StringValues="TrueFalseFull" {
	TRUE,
	FALSE
}

StringValues="YesNoLetter" {
	Y = Yes,
	N = No
}

StringValues="YesNoFull" {
	YES,
	NO
}

StringValues="YesNoFullUnknown" {
	YES,
	NO,
	UNKNOWN
}

StringValues="YesLetter" {
	Y = Yes
}

StringValues="NoLetter" {
	N = No
}

StringValues="YesFull" {
	YES
}

StringValues="NoFull" {
	NO
}

StringValues="Priority" {
	LOW,
	MED,
	HIGH
}

StringValues="SmokingStatus" {
	YES,
	NO,
	UNKNOWN
}

StringValues="Orientation" {
	LANDSCAPE,
	PORTRAIT
}

StringValues="DiagnosticCodingSchemes" {
	ACR = ACR Index for Radiological Diagnosis,
	CE  = CEN ECG Diagnostic Codes,
	E   = Euclides,
	I9  = ICD9,
	I9C = ICD9-CM,
	I10 = ICD10,
	LB  = Local Billing Code,
	RC  = Read Classification,
	SNM = SNOMED,
	S3  = SNOMED III,
	UML = Unified Medical Language
}

StringValues="ProcedureCodeScheme" {
	AS4 = ASTM,
	C4  = CPT-4,
	C5  = CPT-5,
	E   = Euclides,
	FDK = FDA K10,
	HB  = HIBCC,
	ICS = ICCS,
	I9C = ICD-9CM,
	IBT = ISBT,
	IUC = IUPAC/IFCC,
	MCR = Medicare,
	MCD = Madicaid,
	UC  = UCDS,
	JC8 = Japanese Chemistry,
	HI  = Health Outcomes,
	E6  = Euclides Lab Method Codes,
	E7  = Euclides Lab Equipment Codes,
	E5  = Euclides Kind Of Quantity Codes,
	CAS = Chemical Abstract Codes,
	NDC = National Drug Codes,
	W1  = WHO Record Number 6 Digit Drug Codes,
	W2  = WHO Record Number 8 Digit Drug Codes,
	W4  = WHO Record Number With ASTM Extensions,
	WC  = WHO ATC,
	UMD = MDNS
}

StringValues="CodingSchemeDesignatorForSNOMEDDICOMMicroglossary"	{
	99SDM = SNOMED DICOM Microglossary
}

StringValues="CodingSchemeDesignatorForSNOMED"	{
	SNM3 = SNOMED
}

StringValues="CodingSchemeDesignatorForSRT"	{
	SRT = SNOMED
}

StringValues="GeneralUnitsCodingSchemeForCG82"	{
	UCUM = Unified Code for Units of Measure
}

StringValues="CodingSchemeUIDForACR" {
	2.16.840.1.113883.6.76 = ACR
}

StringValues="CodingSchemeUIDForASTMSigpurpose" {
	1.2.840.10065.1.12 = ASTM-sigpurpose
}

StringValues="CodingSchemeUIDForC4" {
	2.16.840.1.113883.6.12 = C4
}

StringValues="CodingSchemeUIDForC5" {
	2.16.840.1.113883.6.82 = C5
}

StringValues="CodingSchemeUIDForCD2" {
	2.16.840.1.113883.6.13 = CD2
}

StringValues="CodingSchemeUIDForDCM" {
	1.2.840.10008.2.16.4 = DCM
}

StringValues="CodingSchemeUIDForDCMUID" {
	1.2.840.10008.2.6.1 = DCMUID
}

StringValues="CodingSchemeUIDForHPC" {
	2.16.840.1.113883.6.14 = HPC
}

StringValues="CodingSchemeUIDForI10" {
	2.16.840.1.113883.6.3 = I10
}

StringValues="CodingSchemeUIDForI10P" {
	2.16.840.1.113883.6.4 = I10P
}

StringValues="CodingSchemeUIDForI9" {
	2.16.840.1.113883.6.42 = I9
}

StringValues="CodingSchemeUIDForI9C" {
	2.16.840.1.113883.6.2 = I9C
}

StringValues="CodingSchemeUIDForISO3166_1" {
	2.16.1 = ISO3166_1
}

StringValues="CodingSchemeUIDForISO639_1" {
	2.16.840.1.113883.6.99 = ISO639_1
}

StringValues="CodingSchemeUIDForISO639_2" {
	2.16.840.1.113883.6.100 = ISO639_2
}

StringValues="CodingSchemeUIDForLN" {
	2.16.840.1.113883.6.1 = LN
}

StringValues="CodingSchemeUIDForPOS" {
	2.16.840.1.113883.6.50 = POS
}

StringValues="CodingSchemeUIDForRFC3066" {
	2.16.840.1.113883.6.121 = RFC3066
}

StringValues="CodingSchemeUIDForSNM3" {
	2.16.840.1.113883.6.51 = SNM3
}

StringValues="CodingSchemeUIDForSRT" {
	2.16.840.1.113883.6.5 = SRT
}

StringValues="CodingSchemeUIDForUCUM" {
	2.16.840.1.113883.6.8 = UCUM
}
	
StringValues="CodingSchemeUIDForUMLS" {
	2.16.840.1.113883.6.86 = UMLS
}
	
StringValues="CodingSchemeUIDForUPC" {
	2.16.840.1.113883.6.55 = UPC
}

StringValues="MiscellaneousCodingSchemeUIDs"	{
	2.16.840.1.113883.6.76 = ACR,
	1.2.840.10065.1.12 = ASTM-sigpurpose,
	2.16.840.1.113883.6.12 = C4,
	2.16.840.1.113883.6.82 = C5,
	2.16.840.1.113883.6.13 = CD2,
	1.2.840.10008.2.16.4 = DCM,
	1.2.840.10008.2.6.1 = DCMUID,
	2.16.840.1.113883.6.14 = HPC,
	2.16.840.1.113883.6.3 = I10,
	2.16.840.1.113883.6.4 = I10P,
	2.16.840.1.113883.6.42 = I9,
	2.16.840.1.113883.6.2 = I9C,
	2.16.1 = ISO3166_1,
	2.16.840.1.113883.6.99 = ISO639_1,
	2.16.840.1.113883.6.100 = ISO639_2,
	2.16.840.1.113883.6.1 = LN,
	2.16.840.1.113883.6.50 = POS,
	2.16.840.1.113883.6.256 = RADLEX,
	2.16.840.1.113883.6.121 = RFC3066,
	2.16.840.1.113883.6.51 = SNM3,
	2.16.840.1.113883.6.5 = SRT,
	2.16.840.1.113883.6.8 = UCUM,
	2.16.840.1.113883.6.86 = UMLS,
	2.16.840.1.113883.6.55 = UPC
}

StringValues="MiscellaneousCodingSchemeDesignators"	{
	99HOLX = Hologic,
	99IHE = IHE Connectathon,
	99PDL-rad = PointDX,
	99GEMS = GE,
	99_MI = Siemens,
	99NMG = Siemens NM,
	99SMS_CTMR = Siemens CT MR,
	99PMSBLUS = Philips Ultrasound,
	99RPH = RadPharm,
	99RPANATLOC = RadPharm anatomical locations,
	99RPH_USERS = RadPharm users,
	99PMP = PixelMed Publishing,
	99PMPMRMF = PixelMed Publishing NEMA MRMF,
	99SDM = SNOMED DICOM Microglossary,
	99NCIAIM = NCI Annotation Imaging Markup,
	ACR = ACR Index for Radiological Diagnosis,
	ART = WHO Adverse Reaction terms,
	AS4 = ASTM,
	ASTM-sigpurpose = ASTM E 2084 Signature Purpose codes,
	ATC = American Type Culture Collection,
	BARI = Bypass Angiography Revascularization Inverstigation,
	BI = BI-RADS,
	C4  = CPT-4,
	C5  = CPT-5,
	CAS = Chemical Abstract Codes,
	CD2 = American Dental Association Current Dental Terminology 2,
	CDCA = CDC Analyte Codes,
	CDCM = CDC Methods/Instruments Codes,
	CDS = CDC Surveillance Codes,
	CE  = CEN ECG Diagnostic Codes,
	CST = COSTART coding system for adverse drug reactions,
	DCM = DICOM Controlled Terminology,
	DCMUID = DICOM UID Registry,
	E   = Euclides AFP codes,
	E5  = Euclides Kind Of Quantity Codes,
	E6  = Euclides Lab Method Codes,
	E7  = Euclides Lab Equipment Codes,
	ENZC = 	Enzyme Codes,
	FDK = FDA K10,
	FMA = Digital Anatomist Foundational Model of Anatomy,
	HB  = HIBCC,
	HHCC = Home Health Care Classification System,
	HI  = Health Outcomes Institute codes for outcome variables,
	JC8 = Japanese Chemistry,
	ICS = ICCS,
	I9  = ICD9,
	I9C = ICD9-CM,
	I10 = ICD10,
	I10P = ICD10 Procedure Coding System,
	IBT = ISBT,
	ICS = ICCS,
	ISO3166_1 = ISO 2 letter country codes,
	ISO639_1 = ISO 2 letter language codes,
	ISO639_2 = ISO 3 letter language codes,
	ISO_OID =  ISO OSI Object Identifier Tree,
	IUC = IUPAC/IFCC Recommendations of Quantities and Units in Clinical Chemistry,
	IUPC = IUPAC component (analyte) codes,
	IUPP = IUPAC property codes,
	JC8 = Japanese Chemistry Clinical examination classification code,
	LN = LOINC,
	MCD = Medicaid billing codes/names,
	MCR = Medicare billing codes/names,
	MDDX = Medispan diagnostic codes,
	MDNS = Universal Medical Device Nomenclature System,
	MEDC = Medical Economics Drug Codes,
	MEDR = Medical Dictionary for Drug Regulatory Affairs (MEDDRA),
	MEDX = Medical Economics Diagnostic Codes,
	MGPI = Medispan GPI hierarchical drug codes,
	MVX = CDC Vaccine Codes,
	NCDR = American College of Cardiology National Cardiovascular Data Registry Cath Lab Module,
	NDC = National Drug Codes FDA,
	NIC = Nursing Interventions Iowa Intervention Project,
	NPI = HCFA National Provider Identifier,
	RADLEX = RadLex,
	RC  = Read Clinical Classification of Medicine,
	RFC3066 = IETF RFC 3066 language codes,
	SCPECG = Standard Communications Protocol for Computer-Assisted Electrocardiography,
	SNM3 = SNOMED International Version 3,
	SRT = SNOMED-RT,
	UC  = UCDS,
	UCUM = Unified Code for Units of Measure,
	UMD = Universal Medical Device Nomenclature System MDNS, 
	UML = Unified Medical Language,
	UMLS = UMLS codes as CUIs making up the values in a coding system,
	UPC = Universal Product Code - Universal Code Council,
	UPIN = HCFA Universal Physician Identification Numbers,
	W1  = WHO Record Number 6 Digit Drug Codes,
	W2  = WHO Record Number 8 Digit Drug Codes,
	W4  = WHO Record Number With ASTM Extensions,
	WC  = WHO ATC
}

StringValues="VisitStatusID" {
	CREATED,
	SCHEDULED,
	ADMITTED,
	DISCHARGED
}

StringValues="StudyStatusID" {
	CREATED,
	SCHEDULED,
	ARRIVED,
	STARTED,
	COMPLETED,
	VERIFIED,
	READ
}

StringValues="StudyComponentStatusID" {
	CREATED,
	INCOMPLETE,
	COMPLETED,
	VERIFIED,
	POSTINTERPRET
}

StringValues="InterpretationTypeID" {
	REPORT,
	AMMENDMENT
}

StringValues="InterpretationStatusID" {
	CREATED,
	RECORDED,
	TRANSCRIBED,
	APPROVED
}

StringValues="Sex" {
	M = Male,
	F = Female,
	O = Other
}

StringValues="Laterality" {
	R = Right,
	L = Left
}

StringValues="BodyPartExaminedHuman" {
	ABDOMEN,
	ABDOMENPELVIS,
	ADRENAL,
	ANKLE,
	AORTA,
	ARM,
	AXILLA,
	BACK,
	BLADDER,
	BRAIN,
	BREAST,
	BRONCHUS,
	BUTTOCK,
	CALCANEUS,
	CALF,
	CAROTID,
	CEREBELLUM,
	CSPINE,
	CTSPINE,
	CERVIX,
	CHEEK,
	CHEST,
	CHESTABDOMEN,
	CHESTABDPELVIS,
	CIRCLEOFWILLIS,
	CLAVICLE,
	COCCYX,
	COLON,
	CORNEA,
	CORONARYARTERY,
	DUODENUM,
	EAR,
	ELBOW,
	WHOLEBODY,
	ESOPHAGUS,
	EXTREMITY,
	EYE,
	EYELID,
	FACE,
	FEMUR,
	FINGER,
	FOOT,
	GALLBLADDER,
	HAND,
	HEAD,
	HEADNECK,
	HEART,
	HIP,
	HUMERUS,
	ILEUM,
	ILIUM,
	IAC,
	JAW,
	JEJUNUM,
	KIDNEY,
	KNEE,
	LARYNX,
	LEG,
	LIVER,
	LSPINE,
	LSSPINE,
	LUNG,
	JAW,
	MAXILLA,
	MEDIASTINUM,
	MOUTH,
	NECK,
	NECKCHEST,
	NECKCHESTABDOMEN,
	NECKCHESTABDPELV,
	NOSE,
	ORBIT,
	OVARY,
	PANCREAS,
	PAROTID,
	PATELLA,
	PELVIS,
	PENIS,
	PHARYNX,
	PROSTATE,
	RECTUM,
	RIB,
	SSPINE,
	SCALP,
	SCAPULA,
	SCLERA,
	SCROTUM,
	SHOULDER,
	SKULL,
	SPINE,
	SPLEEN,
	STERNUM,
	STOMACH,
	SUBMANDIBULAR,
	TMJ,
	TESTIS,
	THIGH,
	TSPINE,
	TLSPINE,
	THUMB,
	THYMUS,
	THYROID,
	TOE,
	TONGUE,
	TRACHEA,
	URETER,
	URETHRA,
	UTERUS,
	VAGINA,
	VULVA,
	WRIST,
	ZYGOMA
}

StringValues="BodyPartExaminedAnimal" {
	ABDOMEN,
	LEGS,
	ATLANTOAXIAL,
	ATLANTOOCCIPITAL,
	BLADDER,
	CARPUS,
	CSPINE,
	CTSPINE,
	CHEST,
	CHESTABDOMEN,
	TAIL,
	COLON,
	DIGIT,
	DISTALPHALANX,
	ELBOW,
	WHOLEBODY,
	ESOPHAGUS,
	FEMUR,
	FOREFETLOCK,
	HINDFETLOCK,
	FOREFOOT,
	FRONTALSINUS,
	HINDFOOT,
	HIP,
	HUMERUS,
	LSPINE,
	LSSPINE,
	JAW,
	METACARPUS,
	METATARSUS,
	NAVICULAR,
	FOREPASTERN,
	HINDPASTERN,
	PATELLA,
	PELVIS,
	RADIUSULNA,
	SSPINE,
	SHOULDER,
	SKULL,
	STIFLE,
	TARSUS,
	TSPINE,
	TLSPINE,
	TIBIAFIBULA,
	UGITRACT,
	URETHRA,
	URINARYTRACT,
	WING
}

StringValues="Modality"	{
	AU = Audio,
	BI = Biomagnetic Imaging,
	BDUS = Bone Densitometry (ultrasound),
	BMD	= Bone Densitometry (X-ray),
	CR = Computed Radiography,
	CT = Computed Tomography,
	DG = Diaphanography,
	DOC	= Document,
	DX = Digital Radiography,
	ECG = Electrocardiography,
	EPS = Cardiac Electrophysiology,
	ES = Endoscopy,
	FID = Fiducials,
	GM = General Microscopy,
	HC = Hard Copy,
	HD = Hemodynamic Waveform,
	IO = Intra-oral Radiography,
	IVOCT = Intravascular Optical Coherence Tomography,
	IVUS = Intravascular Ultrasound,
	KO = Key Object Selection,
	LS = Laser Surface Scan,
	MG = Mammography,
	MR = Magnetic Resonance,
	NM = Nuclear Medicine,
	OCT	= Optical Coherence Tomography (non-Ophthalmic),
	OP = Ophthalmic Photography,
	OPM	= Ophthalmic Mapping,
	OPR	= Ophthalmic Refraction,
	OPT	= Ophthalmic Tomography,
	OPV	= Ophthalmic Visual Field,
	OT = Other,
	PR = Presentation State,
	PT = Positron Emmission Tomography,
	PX = Panoramic X-Ray,
	REG	= Registration,
	RF = RadioFluoroscopy,
	RG = Radiographic Imaging Conventional Film Screen,
	RTDOSE = RT Dose,
	RTIMAGE = RT Image,
	RTPLAN = RT Plan,
	RTRECORD = RT Treatment Record,
	RTSTRUCT = RT Structure Set,
	SEG	= Segmentation,
	SM = Slide Microscopy,
	SMR = Stereometric Relationship,
	SR = SR Document,
	TG = Thermography,
	US = Ultrasound,
	XA = X-Ray Angiography,
	XC = External Camera Photography
}

StringValues="PatientPosition" {
	HFP  = Head First Prone,
	HFS  = Head First Supine,
	HFDR = Head First Decubitus Right,
	HFDL = Head First Decubitus Right,
	FFP  = Feet First Prone,
	FFS  = Feet First Supine,
	FFDR = Feet First Decubitus Right,
	FFDL = Feet First Decubitus Right
}

StringValues="ViewPositionHuman" {
	AP  = Anterior Posterior,
	PA  = Posterior Anterior,
	LL  = Left Lateral,
	RL  = Right Lateral,
	RLD = Right Lateral Decubitus,
	LLD = Left Lateral Decubitus,
	RLO = Right Lateral Oblique,
	LLO = Left Lateral Oblique
}

StringValues="ViewPositionAnimal" {
	CDDI_CRPRO,
	CD10DI_CRPRO,
	CDCR,
	DV,
	DL_PAMO,
	D35L_PAMO,
	D40L_PAMO,
	D60L_PAMO,
	DL_PLMO,
	D35L_PLMO,
	D40L_PLMO,
	D45L_PLMO,
	D60L_PLMO,
	DM_PALO,
	D35M_PALO,
	D40M_PALO,
	D45M_PALO,
	D60M_PALO,
	DM_PLLO,
	D35M_PLLO,
	D40M_PLLO,
	D45M_PLLO,
	D60M_PLLO,
	DPA,
	DPL,
	DPR_PADIO,
	D65PR_PADIO,
	DPR_PLDIO,
	D65PR_PLDIO,
	DR_VCDO,
	D20R_VCDO,
	LDPR_MPADIO,
	L45D50PR_MPADIO,
	LDPR_MPLDIO,
	L45D50PR_MPLDIO,
	LM,
	LECD_RTRO,
	LE30CD_RTRO,
	LED_RTVO,
	LE20D_RTVO,
	LE45D_RTVO,
	LER_RTCDO,
	LE20R_RTCDO,
	LEV_RTDO,
	LE20V_RTDO,
	LE45V_RTDO,
	LERTL,
	ML,
	PAM_DLO,
	PA45M_DLO,
	PAPR_DDIO,
	PA75PR_DDIO,
	PLL_DMO,
	PL60L_DMO,
	PLPR_DDIO,
	PL75PR_DDIO,
	PRDI,
	RTCD_LERO,
	RT30CD_LERO,
	RTD_LEVO,
	RT20D_LEVO,
	RT45D_LEVO,
	RTR_LECDO,
	RT20R_LECDO,
	RTV_LEDO,
	RT20V_LEDO,
	RT45V_LEDO,
	RTLEL,
	RCD,
	RD_CDVO,
	R20D_CDVO,
	RV_CDDO,
	R30V_CDDO,
	VLE_DRTO,
	V30LE_DRTO,
	VRT_DLEO,
	V30RT_DLEO,
	VD,
	VR_DCDO,
	V20R_DCDO
}

StringValues="CassetteSize" {
	18CMX24CM,
	8INX10IN,
	24CMX30CM,
	10INX12IN,
	30CMX35CM,
	30CMX40CM,
	11INX14IN,
	35CMX35CM,
	14INX14IN,
	35CMX43CM
	14INX17IN,
}

StringValues="RotationDirection" {
	CW = Clockwise,
	CC = CounterClockwise
}

StringValues="RotationDirectionWithNone" {
	CW = Clockwise,
	CC = CounterClockwise,
	NONE = No Rotation
}

StringValues="ScanningSequence" {
	SE = Spin Echo,
	IR = Inversion Recovery,
	GR = Gradient Recalled,
	EP = Echo Planar,
	RM = Research Mode
}

StringValues="SequenceVariant"	{
	SK   = Segmented K Space,
	MTC  = Magnetization Transfer CDontrast,
	SS   = Steady State,
	TRSS = Time Reversed Steady State,
	SP   = Spoiled,
	MP   = Magnetization Prepared,
	OSP  = Oversampling Phase,
	NONE = No Sequence Variant
}

StringValues="ScanOptions" {
	PER = Phase Encode Reordering,
	RG  = Respiratory Gating,
	CG  = Cardiac Gating,
	PPG = Peripheral Pulse Gating,
	FC  = Flow Compensation,
	PFF = Partial Fourier Frequency,
	PFP = Partial Fourier Phase,
	SP  = Spatial Presaturation,
	FS  = Fat Saturation
}

StringValues="MRAcquisitionType" {
	2D = Frequency x Phase,
	3D = Frequency x Phase x Phase
}

StringValues="AngioFlag" {
	Y = Image is Angio,
	N = Image is not Angio
}

StringValues="PhaseEncodingDirection" {
	ROW = Phase Encoded in Rows,
	COL = Phase Encoded in Columns
}

StringValues="PhotometricInterpretation" {
	MONOCHROME1,
	MONOCHROME2,
	PALETTE COLOR,
	RGB,
	YBR_FULL,
	YBR_FULL_422,
	YBR_PARTIAL_422,
	YBR_PARTIAL_420,
	YBR_RCT,
	YBR_ICT
}

StringValues="PhotometricInterpretationMonochrome" {
	MONOCHROME1,
	MONOCHROME2
}

StringValues="PhotometricInterpretationRGB" {
	RGB
}

StringValues="PhotometricInterpretationMonochrome2OrRGB" {
	MONOCHROME2,
	RGB
}

StringValues="PhotometricInterpretationMonochrome2OrRGBorYBR_FULL422" {
	MONOCHROME2,
	YBR_FULL_422,
	RGB
}

StringValues="PhotometricInterpretationYBRFull422" {
	YBR_FULL_422
}

StringValues="PhotometricInterpretationYBRRCT" {
	YBR_RCT
}

StringValues="PhotometricInterpretationYBRRCTOrICT" {
	YBR_RCT,
	YBR_ICT
}

StringValues="PhotometricInterpretationYBRPartial420" {
	YBR_PARTIAL_420
}

StringValues="PhotometricInterpretationYBRFull" {
	YBR_FULL
}

StringValues="PhotometricInterpretationYBRFullOrRGBorYBR_RCTorYBR_ICT" {
	YBR_FULL,
	YBR_RCT,
	YBR_ICT,
	RGB
}

StringValues="PhotometricInterpretationRGBorYBR_FULL_422orYBR_RCTorYBR_ICTorYBR_PARTIAL_420" {
	YBR_FULL_422,
	YBR_PARTIAL_420,
	YBR_RCT,
	YBR_ICT,
	RGB
}

StringValues="PhotometricInterpretationMonochrome2OrRGBorYBR_FULL_422orYBR_RCTorYBR_ICTorYBR_PARTIAL_420" {
	MONOCHROME2,
	YBR_FULL_422,
	YBR_PARTIAL_420,
	YBR_RCT,
	YBR_ICT,
	RGB
}

StringValues="PhotometricInterpretationRGBorYBR_RCT" {
	YBR_RCT,
	RGB
}

StringValues="ImageType1"	{
	ORIGINAL,
	DERIVED
}

StringValues="ImageType1DerivedOnly"	{
	DERIVED
}

StringValues="ImageType2"	{
	PRIMARY,
	SECONDARY
}

StringValues="ImageType2PrimaryOnly"	{
	PRIMARY
}

StringValues="CTImageType3" {
	AXIAL,
	LOCALIZER
}

StringValues="MRImageType3" {
	MPR,
	PROJECTION IMAGE,
	T1 MAP,
	T2 MAP,
	DIFFUSION MAP,
	DENSITY MAP,
	PHASE MAP,
	VELOCITY MAP,
	IMAGE ADDITION,
	PHASE SUBTRACT,
	MODULUS SUBTRACT,
	OTHER
}

StringValues="ConversionType" {
	DV  = Digitized Video,
	DI  = Digital Interface,
	DF  = Digitized Film,
	WSD = Workstation,
	SD = Scanned Document,
	SI = Scanned Image,
	DRW = Drawing,
	SYN = Synthetic Image
}

StringValues="OverlayType" {
	G = Graphics,
	R = ROI
}

StringValues="CurveTypeOfData" {
	TAC      = Time Activity Curve ,
	PROF     = Image Profile ,
	HIST     = Histogram ,
	ROI      = Polygraphic Region Of Interest,
	TABL     = Table of Values ,
	FILT     = Filter Kernel,
	POLY     = Poly Line ,
	ECG      = ECG Data,
	PRESSURE = Pressure Data,
	FLOW     = Flow Data,
	PHYSIO   = Physiological Data,
	RESP     = Respiration Trace
}

StringValues="CurveAxisUnits" {
	SEC     = Seconds ,
	CNTS    = Counts ,
	MM      = millimeters,
	PIXL    = Pixels   ,
	NONE    = Unitless,
	BPM     = beats/min,
	CM      = centimeters,
	CMS     = centimeters/second ,
	CM2     = cm**2,
	CM2S    = cm**2/second,
	CM3     = cm**3,
	CM3S    = cm**3/second,
	CMS2    = cm/second**2,
	DB      = dB,
	DBS     = dB/second,
	DEG     = degrees,
	GM      = gram,
	GMM2    = gram/meter**2,
	HZ      = Hertz,
	IN      = inch,
	KG      = kg,
	LMIN    = liters/minute,
	LMINM2  = liters/minute/meter**2,
	M2      = meters **2,
	MS2     = meters/sec**2,
	MLM2    = milliliters/meter**2,
	MILS    = milliseconds,
	MILV    = millivolts,
	MMHG    = mmHg,
	PCNT    = percent,
	LB      = pound
}

StringValues="ModalityLUTType" {
	OD = Optical Density (thousandths),
	HU = Hounsfield Units,
	US = Unspecified
}

StringValues="ModalityLUTTypeUnspecified" {
	US = Unspecified
}

StringValues="LossyImageCompression" {
	00 = Image has not been subjected to lossy compression,
	01 = Image has been subjected to lossy compression
}

StringValues="PerformedProcedureStepStatus"	{
	IN PROGRESS,
	DISCONTINUED,
	COMPLETED
}

StringValues="SecondaryCapturePresentationLUTShape"	{
	IDENTITY
}

StringValues="RescaleTypeUnspecified"	{
	US
}

StringValues="TransportDirection"	{
	ROW,
	COLUMN
}

StringValues="MACAlgorithm"	{
	RIPEMD160,
	MD5,
	SHA1
}

StringValues="CertificateType"	{
	X509_1993_SIG
}

StringValues="CertifiedTimestampType"	{
	CMS_TSP
}

StringValues="CodingSchemeRegistries"	{
	HL7
}

StringValues="SEGModality" {
	SEG
}

StringValues="REGModality" {
	REG
}

StringValues="FIDModality" {
	FID
}

StringValues="FrameOfReferenceTransformationMatrixType" {
	RIGID,
	RIGID_SCALE,
	AFFINE
}

StringValues="FiducialShapeType" {
	POINT,
	LINE,
	PLANE,
	SURFACE,
	RULER,
	L_SHAPE,
	T_SHAPE,
	SHAPE
}

StringValues="IdentityPresentationLUTShape"	{
	IDENTITY
}

StringValues="InversePresentationLUTShape"	{
	INVERSE
}

StringValues="IdentityOrInversePresentationLUTShape"	{
	IDENTITY,
	INVERSE
}

# should really have a case insensitive match :(
StringValues="MIMETypeApplicationPDF"	{
	application/pdf,
	application/PDF,
	Application/PDF,
	APPLICATION/PDF
}

# should really have a case insensitive match :(
StringValues="MIMETypeApplicationCDA"	{
	text/xml,
	text/XML,
	Text/XML,
	TEXT/XML
}

StringValues="LossyImageCompressionMethod" {
	ISO_10918_1 = JPEG Lossy Compression,
	ISO_14495_1 = JPEG-LS Near-lossless Compression,
	ISO_15444_1 = JPEG 2000 Irreversible Compression,
	ISO_13818_2 = MPEG2 Compression,
	ISO_14496_10 = MPEG-4 AVC/H.264 Compression
}

StringValues="ContentItemValueTypes" {
	DATETIME,
	DATE,
	TIME,
	PNAME,
	UIDREF,
	TEXT,
	CODE,
	NUMERIC,
	IMAGE,
	COMPOSITE
}

StringValues="PixelIntensityRelationshipLUTFunction" {
	TO_LOG,
	TO_LINEAR
}

StringValues="OverlaySubtype" {
	USER = User created graphic annotation,
	AUTOMATED = Machine created graphic annotation
}

StringValues="RealWorldValueMappingModality" {
	RWV
}

StringValues="TypeOfPatientID" {
	TEXT,
	RFID,
	BARCODE
}

StringValues="ResponsiblePersonRole" {
	OWNER,
	PARENT,
	CHILD,
	SPOUSE,
	SIBLING,
	RELATIVE,
	GUARDIAN,
	CUSTODIAN,
	AGENT
}

StringValues="PatientSexNeutered" {
	ALTERED,
	UNALTERED
}

StringValues="YesNoReorientedOnly" {
	YES,
	NO,
	REORIENTED_ONLY
}


StringValues="EquipmentCoordinateSystemIdentification" {
	ISOCENTER
}

StringValues="CommonEnhancedImageType1" {
	ORIGINAL,
	DERIVED,
	MIXED
}

StringValues="CommonEnhancedFrameType1" {
	ORIGINAL,
	DERIVED
}

StringValues="CommonEnhancedImageAndFrameType2" {
	PRIMARY
}

StringValues="CommonEnhancedImageAndFrameType3" {
	ANGIO,
	CARDIAC,
	CARDIAC_GATED,
	CARDRESP_GATED,
	DYNAMIC,
	FLUOROSCOPY,
	LOCALIZER,
	MOTION,
	PERFUSION,
	PRE_CONTRAST,
	POST_CONTRAST,
	RESP_GATED,
	REST,
	STATIC,
	STRESS,
	VOLUME,
	NON_PARALLEL,
	PARALLEL,
	WHOLE_BODY
}

StringValues="CommonEnhancedImageType4" {
	ADDITION,
	DIVISION,
	MASKED,
	MAXIMUM,
	MEAN,
	MINIMUM,
	MTT,
	MULTIPLICATION,
	RCBF,
	RCBV,
	RESAMPLED,
	STD_DEVIATION,
	SUBTRACTION,
	T_TEST,
	TTP,
	Z_SCORE,
	NONE,
	MIXED
}

StringValues="CommonEnhancedFrameType4" {
	ADDITION,
	DIVISION,
	MASKED,
	MAXIMUM,
	MEAN,
	MINIMUM,
	MTT,
	MULTIPLICATION,
	RCBF,
	RCBV,
	RESAMPLED,
	STD_DEVIATION,
	SUBTRACTION,
	T_TEST,
	TTP,
	Z_SCORE,
	NONE
}

StringValues="RespiratoryPhase" {
	INSPIRATION,
	MAXIMUM,
	EXPIRATION,
	MINIMUM
}

StringValues="CardiacFramingType" {
	FORW = time forward from trigger,
	BACK = time back before trigger,
	PCNT  = percentage of R-R forward from trigger
}

StringValues="RespiratoryTriggerType" {
	TIME,
	AMPLITUDE,
	BOTH
}

StringValues="UniversalEntityIDType" {
	DNS = An Internet dotted name either in ASCII or as integers,
	EUI64 = An IEEE Extended Unique Identifier,
	ISO = An International Standards Organization Object Identifier,
	URI = Uniform Resource Identifier,
	UUID = The DCE Universal Unique Identifier,
	X400 = An X.400 MHS identifier,
	X500 = An X.500 directory name
}

StringValues="HL7Table0203IdentifierType" {
	AM = American Express,
	AN = Account number,
	ANON = Anonymous identifier,
	ANC = Account number Creditor,
	AND = Account number debitor,
	ANT = Temporary Account Number,
	APRN = Advanced Practice Registered Nurse number,
	BA = Bank Account Number,
	BC = Bank Card Number,
	BR = Birth registry number,
	BRN = Breed Registry Number,
	CC = Cost Center number,
	CY = County number,
	DDS = Dentist license number,
	DEA = Drug Enforcement Administration registration number,
	DI = Diner’s Club card,
	DFN = Drug Furnishing or prescriptive authority Number,
	DL = Driver’s license number,
	DN = Doctor number,
	DPM = Podiatrist license number,
	DO = Osteopathic License number,
	DR = Donor Registration Number,
	DS = Discover Card,
	EI = Employee number,
	EN = Employer number,
	FI = Facility ID,
	GI = Guarantor internal identifier,
	GL = General ledger number,
	GN = Guarantor external  identifier,
	HC = Health Card Number,
	JHN = Jurisdictional health number Canada,
	IND = Indigenous/Aboriginal ,
	LI = Labor and industries number,
	LN = License number,
	LR = Local Registry ID,
	MA = Patient Medicaid number,
	MB = Member Number,
	MC = Patients Medicare number,
	MCD = Practitioner Medicaid number,
	MCN = Microchip Number,
	MCR = Practitioner Medicare number,
	MD = Medical License number,
	MI = Military ID number,
	MR = Medical record number,
	MRT = Temporary Medical Record Number,
	MS = MasterCard,
	NE = National employer identifier,
	NH = National Health Plan Identifier,
	NI = National unique individual identifier,
	NII = National Insurance Organization Identifier,
	NIIP = National Insurance Payor Identifier,
	NNxxx = National Person Identifier where the xxx is the ISO table 3166 3-character alphabetic country code,
	NNUSA = National Person Identifier USA,
	NP = Nurse practitioner number,
	NPI = National provider identifier,
	OD = Optometrist license number,
	PA = Physician Assistant number,
	PCN = Penitentiary correctional institution Number,
	PE = Living Subject Enterprise Number,
	PEN = Pension Number,
	PI = Patient internal identifier,
	PN = Person number,
	PNT = Temporary Living Subject Number,
	PPN = Passport number,
	PRC = Permanent Resident Card Number,
	PRN = Provider number,
	PT = Patient external identifier,
	QA = QA number,
	RI = Resource identifier,
	RPH = Pharmacist license number,
	RN = Registered Nurse Number,
	RR = Railroad Retirement number,
	RRI = Regional registry ID,
	SL = State license,
	SN = Subscriber Number,
	SR = State registry ID,
	SS = Social Security number,
	TAX = Tax ID number,
	TN = Treaty Number Canada,
	U = Unspecified identifier,
	UPIN = Medicare CMS Universal Physician Identification numbers,
	VN = Visit number,
	VS = VISA,
	WC = WIC identifier,
	WCN = Workers Comp Number,
	XX = Organization identifier
}

StringValues="SegmentationType" {
	BINARY,
	FRACTIONAL
}

StringValues="SegmentationFractionalType" {
	PROBABILITY,
	OCCUPANCY
}

StringValues="SegmentAlgorithmType" {
	AUTOMATIC,
	SEMIAUTOMATIC,
	MANUAL
}

StringValues="RecommendedPresentationType" {
	SURFACE,
	WIREFRAME,
	POINTS
}

StringValues="DistributionType" {
	NAMED_PROTOCOL,
	RESTRICTED_REUSE,
	PUBLIC_RELEASE
}

StringValues="ConsentForDistributionFlag" {
	NO,
	YES,
	WITHDRAWN 
}

StringValues="AnatomicalOrientationType" {
	BIPED,
	QUADRUPED
}

StringValues="ContainerComponentMaterial" {
	GLASS,
	PLASTIC,
	METAL
}

StringValues="LongitudinalTemporalInformationModified" {
	UNMODIFIED,
	MODIFIED,
	REMOVED
}

StringValues="DimensionOrganizationType" {
	3D,
	3D_TEMPORAL
}

StringValues="IVOCTModality" {
	IVOCT
}

StringValues="IVOCTPixelPresentationImageLevel" {
	COLOR,
	COLOR_REF,
	MONOCHROME
}

StringValues="IVOCTImageAndFrameTypeValue3"	{
	AXIAL,
	LONGITUDINAL
}

StringValues="IVOCTVolumetricProperties"	{
	DISTORTED
}

StringValues="IVOCTInterpolationType"	{
	REPLICATE,
	CUBIC,
	BILINEAR
}

StringValues="OCTAcquisitionDomain"	{
	TIME,
	FREQUENCY,
	SPECTRAL
}

StringValues="IVOCTIVUSAcquisition"	{
	MOTORIZED,
	MANUAL,
	SELECTIVE,
	MEASURED
}

StringValues="IVOCTPixelIntensityRelationship"	{
	LIN,
	LOG
}

StringValues="CatheterDirectionOfRotation"	{
	CW,
	CC
}

StringValues="WellKnownColorPaletteInstanceUIDs" {
	1.2.840.10008.1.5.1 = Hot Iron Color Palette SOP Instance,
	1.2.840.10008.1.5.2 = PET Color Palette SOP Instance,
	1.2.840.10008.1.5.3 = Hot Metal Blue Color Palette SOP Instance,
	1.2.840.10008.1.5.4 = PET 20 Step Color Palette SOP Instance
}

StringValues="Volume"	{
	VOLUME
}

StringValues="None"	{
	NONE
}

StringValues="EmptyValue"	{
}


