/**\file
 *\section License
 * License: GPL
 * Online License Link: http://www.gnu.org/licenses/gpl.html
 *
 *\author Copyright © 2005-2009 Jaakko Keränen <jaakko.keranen@iki.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#include <stdint.h>
typedef uint64_t      io_user_reference_t; 

#import "SDL.h"
#import "../include/DoomsdayRunner.h"

@implementation DoomsdayRunner

+ (void) threadEntryPoint:(id)anObject
{
    extern int gArgc;
    extern char **gArgv;

    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];

    // Hand off to main application code.
    int status = SDL_main(gArgc, gArgv);

    /* We're done, thank you for playing */
    exit(status);
    
    [pool release];
}

@end
