/****************************************************************************
 *    lib/c/Pool.cpp - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "Pool.h"

using namespace C;

Pool::Pool(Variable* var1, Variable* var2) {
	vars_ = vector<Variable*>(1, var1);
	vars_.push_back(var2);
	text_ = var1->getText()+";"+var2->getText();
}

Pool::~Pool ( ) { }


set<Variable*>* Pool::getVariables() {
	set<Variable*>* vars = new set<Variable*>();
	vars->insert(vars_.begin(), vars_.end());
	
	return vars;
}

void Pool::addVariable(Variable* var) {
	vars_.push_back(var);
	text_ += ";"+var->getText();
}
