#ifndef H_CDW_REGEX
#define H_CDW_REGEX

#include <regex.h>

#include "main.h"
#include "cdw_debug.h"


typedef int (* cdw_regex_handler_t)(regex_t *, regmatch_t *);

typedef struct {
	const char         *debug_label;   /* used for debug purposes */
	cdw_id_t            debug_id;      /* used for debug purposes */
	const char         *pattern;       /* what we want to capture */
	regex_t            *regex;         /* compiled pattern */
	regmatch_t         *matches;       /* stores results of successful match */
	int                 regcomp_opts;  /* int args for regcomp() */
	cdw_regex_handler_t handler;       /* function processing information from 'matches' */
} cdw_regex_t;


cdw_rv_t cdw_regex_prepare_regexes_table(cdw_regex_t table[]);
void     cdw_regex_execute_regexes_table(cdw_regex_t table[], const char *buffer);
void     cdw_regex_clean_up_regexes_table(cdw_regex_t table[]);


/* utility functions used in (all) *_regex.c files */
void cdw_regex_regcomp_error_handler(const char *caller_name, int errcode, const regex_t *regex, cdw_id_t id);
int cdw_regex_get_submatch(regmatch_t *matches, unsigned int sub, char *buffer, char *submatch);


/* this will be reused quite a few times in *_regex.c files */
#define cdw_regex_assert_subex_number(is, should_be) \
	cdw_assert (is == should_be, \
		    "ERROR: failed to catch proper number of subexpressions (is %zd, should be %d), something has changed in compiled regex\n", \
		    is, should_be);


#endif /* H_CDW_REGEX */
