#!/bin/sh

# initialy from $FreeBSD: src/usr.bin/kdump/mkioctls,v 1.18 2000/08/02 07:37:44 ru Exp $
# changed by Gal Roualland.

# Validate arg count.
if [ $# -ne 1 ]
then
        echo "usage: $0 include-directory" >&2
        exit 1
fi

# build a list of files with ioctls
ioctl_includes=`
	cd $1
	find * -name '*.h' -follow |
		egrep -v '^(netns)/' |
		xargs egrep -l \
'^#[ 	]*define[ 	]+[A-Za-z_][A-Za-z0-9_]*[ 	]+_IO[^a-z0-9_]'`

# Generate the output file.
echo '/* This file is automatically generated by ioctlent.sh */'
echo
echo '/* XXX obnoxious prerequisites. */'
echo '#define COMPAT_43'
echo
echo '#include <sys/types.h>'
echo '#include <sys/param.h>'
echo '#include <sys/devicestat.h>'
echo '#include <sys/disklabel.h>'
echo '#include <sys/socket.h>'
echo '#include <sys/time.h>'
echo '#include <sys/tty.h>'
echo '#include <net/ethernet.h>'
echo '#include <net/if.h>'
echo '#include <net/if_var.h>'
echo '#include <net/route.h>'
echo '#include <netatm/atm.h>'
echo '#include <netatm/atm_if.h>'
echo '#include <netatm/atm_sap.h>'
echo '#include <netatm/atm_sys.h>'
echo '#include <netinet/in.h>'
echo '#include <netinet/ip_compat.h>'
echo '#include <netinet/ip_fil.h>'
echo '#include <netinet/ip_auth.h>'
echo '#include <netinet/ip_nat.h>'
echo '#include <netinet/ip_frag.h>'
echo '#include <netinet/ip_state.h>'
echo '#include <netinet/ip_mroute.h>'
echo '#include <netinet6/in6_var.h>'
echo '#include <netinet6/nd6.h>'
echo '#include <netinet6/ip6_mroute.h>'
echo '#include <cam/cam.h>'
echo '#include <stdio.h>'
echo
echo "$ioctl_includes" | sed -e 's/^/#include </' -e s'/$/>/'
echo
echo 'struct ioctlent ioctlent [] ='
echo '{'
(cd $1 && for i in $ioctl_includes ; do echo "#include <$i>" | gcc -I$1 -E -dM - | egrep '^#[ 	]*define[ 	]+[A-Za-z_][A-Za-z0-9_]*[ 	]+_IO[^a-z0-9_]' | sed -n -e 's|^#[ 	]*define[ 	]*\([A-Za-z_][A-Za-z0-9_]*\).*|	{ "'$i'", "\1", \1 },|p' ; done )

echo '};'
