/* component-event.c generated by valac 0.28.0, the Vala compiler
 * generated from component-event.vala, do not modify */

/* Copyright 2014-2015 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libical/ical.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_COMPONENT_TYPE_INSTANCE (california_component_instance_get_type ())
#define CALIFORNIA_COMPONENT_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance))
#define CALIFORNIA_COMPONENT_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstanceClass))
#define CALIFORNIA_COMPONENT_IS_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_INSTANCE))
#define CALIFORNIA_COMPONENT_IS_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_INSTANCE))
#define CALIFORNIA_COMPONENT_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstanceClass))

typedef struct _CaliforniaComponentInstance CaliforniaComponentInstance;
typedef struct _CaliforniaComponentInstanceClass CaliforniaComponentInstanceClass;
typedef struct _CaliforniaComponentInstancePrivate CaliforniaComponentInstancePrivate;

#define CALIFORNIA_COMPONENT_TYPE_UID (california_component_uid_get_type ())
#define CALIFORNIA_COMPONENT_UID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_UID, CaliforniaComponentUID))
#define CALIFORNIA_COMPONENT_UID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_UID, CaliforniaComponentUIDClass))
#define CALIFORNIA_COMPONENT_IS_UID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_UID))
#define CALIFORNIA_COMPONENT_IS_UID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_UID))
#define CALIFORNIA_COMPONENT_UID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_UID, CaliforniaComponentUIDClass))

typedef struct _CaliforniaComponentUID CaliforniaComponentUID;
typedef struct _CaliforniaComponentUIDClass CaliforniaComponentUIDClass;

#define CALIFORNIA_BACKING_TYPE_SOURCE (california_backing_source_get_type ())
#define CALIFORNIA_BACKING_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSource))
#define CALIFORNIA_BACKING_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSourceClass))
#define CALIFORNIA_BACKING_IS_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_BACKING_TYPE_SOURCE))
#define CALIFORNIA_BACKING_IS_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_BACKING_TYPE_SOURCE))
#define CALIFORNIA_BACKING_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSourceClass))

typedef struct _CaliforniaBackingSource CaliforniaBackingSource;
typedef struct _CaliforniaBackingSourceClass CaliforniaBackingSourceClass;

#define CALIFORNIA_COMPONENT_TYPE_EVENT (california_component_event_get_type ())
#define CALIFORNIA_COMPONENT_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent))
#define CALIFORNIA_COMPONENT_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEventClass))
#define CALIFORNIA_COMPONENT_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_EVENT))
#define CALIFORNIA_COMPONENT_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_EVENT))
#define CALIFORNIA_COMPONENT_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEventClass))

typedef struct _CaliforniaComponentEvent CaliforniaComponentEvent;
typedef struct _CaliforniaComponentEventClass CaliforniaComponentEventClass;
typedef struct _CaliforniaComponentEventPrivate CaliforniaComponentEventPrivate;

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN (california_calendar_exact_time_span_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpan))
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpanClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN))
#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, CaliforniaCalendarExactTimeSpanClass))

typedef struct _CaliforniaCalendarExactTimeSpan CaliforniaCalendarExactTimeSpan;
typedef struct _CaliforniaCalendarExactTimeSpanClass CaliforniaCalendarExactTimeSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_SPAN (california_calendar_span_get_type ())
#define CALIFORNIA_CALENDAR_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan))
#define CALIFORNIA_CALENDAR_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))
#define CALIFORNIA_CALENDAR_IS_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_IS_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))

typedef struct _CaliforniaCalendarSpan CaliforniaCalendarSpan;
typedef struct _CaliforniaCalendarSpanClass CaliforniaCalendarSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN (california_calendar_unit_span_get_type ())
#define CALIFORNIA_CALENDAR_UNIT_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan))
#define CALIFORNIA_CALENDAR_UNIT_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpanClass))
#define CALIFORNIA_CALENDAR_IS_UNIT_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN))
#define CALIFORNIA_CALENDAR_IS_UNIT_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN))
#define CALIFORNIA_CALENDAR_UNIT_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpanClass))

typedef struct _CaliforniaCalendarUnitSpan CaliforniaCalendarUnitSpan;
typedef struct _CaliforniaCalendarUnitSpanClass CaliforniaCalendarUnitSpanClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE_SPAN (california_calendar_date_span_get_type ())
#define CALIFORNIA_CALENDAR_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan))
#define CALIFORNIA_CALENDAR_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_DATE_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))

typedef struct _CaliforniaCalendarDateSpan CaliforniaCalendarDateSpan;
typedef struct _CaliforniaCalendarDateSpanClass CaliforniaCalendarDateSpanClass;

#define CALIFORNIA_COMPONENT_EVENT_TYPE_STATUS (california_component_event_status_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE (california_backing_calendar_source_get_type ())
#define CALIFORNIA_BACKING_CALENDAR_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE, CaliforniaBackingCalendarSource))
#define CALIFORNIA_BACKING_CALENDAR_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE, CaliforniaBackingCalendarSourceClass))
#define CALIFORNIA_BACKING_IS_CALENDAR_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE))
#define CALIFORNIA_BACKING_IS_CALENDAR_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE))
#define CALIFORNIA_BACKING_CALENDAR_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE, CaliforniaBackingCalendarSourceClass))

typedef struct _CaliforniaBackingCalendarSource CaliforniaBackingCalendarSource;
typedef struct _CaliforniaBackingCalendarSourceClass CaliforniaBackingCalendarSourceClass;

#define CALIFORNIA_COMPONENT_TYPE_DATE_TIME (california_component_date_time_get_type ())
#define CALIFORNIA_COMPONENT_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COMPONENT_TYPE_DATE_TIME, CaliforniaComponentDateTime))
#define CALIFORNIA_COMPONENT_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_COMPONENT_TYPE_DATE_TIME, CaliforniaComponentDateTimeClass))
#define CALIFORNIA_COMPONENT_IS_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COMPONENT_TYPE_DATE_TIME))
#define CALIFORNIA_COMPONENT_IS_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_COMPONENT_TYPE_DATE_TIME))
#define CALIFORNIA_COMPONENT_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_COMPONENT_TYPE_DATE_TIME, CaliforniaComponentDateTimeClass))

typedef struct _CaliforniaComponentDateTime CaliforniaComponentDateTime;
typedef struct _CaliforniaComponentDateTimeClass CaliforniaComponentDateTimeClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_TIMEZONE (california_calendar_timezone_get_type ())
#define CALIFORNIA_CALENDAR_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezone))
#define CALIFORNIA_CALENDAR_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_IS_TIMEZONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_TIMEZONE))
#define CALIFORNIA_CALENDAR_TIMEZONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_TIMEZONE, CaliforniaCalendarTimezoneClass))

typedef struct _CaliforniaCalendarTimezone CaliforniaCalendarTimezone;
typedef struct _CaliforniaCalendarTimezoneClass CaliforniaCalendarTimezoneClass;

#define CALIFORNIA_CALENDAR_TYPE_UNIT (california_calendar_unit_get_type ())
#define CALIFORNIA_CALENDAR_UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit))
#define CALIFORNIA_CALENDAR_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))
#define CALIFORNIA_CALENDAR_IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))

typedef struct _CaliforniaCalendarUnit CaliforniaCalendarUnit;
typedef struct _CaliforniaCalendarUnitClass CaliforniaCalendarUnitClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE (california_calendar_date_get_type ())
#define CALIFORNIA_CALENDAR_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate))
#define CALIFORNIA_CALENDAR_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))
#define CALIFORNIA_CALENDAR_IS_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_IS_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))

typedef struct _CaliforniaCalendarDate CaliforniaCalendarDate;
typedef struct _CaliforniaCalendarDateClass CaliforniaCalendarDateClass;

#define CALIFORNIA_CALENDAR_TYPE_EXACT_TIME (california_calendar_exact_time_get_type ())
#define CALIFORNIA_CALENDAR_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTime))
#define CALIFORNIA_CALENDAR_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_IS_EXACT_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME))
#define CALIFORNIA_CALENDAR_EXACT_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_EXACT_TIME, CaliforniaCalendarExactTimeClass))

typedef struct _CaliforniaCalendarExactTime CaliforniaCalendarExactTime;
typedef struct _CaliforniaCalendarExactTimeClass CaliforniaCalendarExactTimeClass;

#define CALIFORNIA_CALENDAR_TYPE_WALL_TIME (california_calendar_wall_time_get_type ())
#define CALIFORNIA_CALENDAR_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime))
#define CALIFORNIA_CALENDAR_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_WALL_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))

typedef struct _CaliforniaCalendarWallTime CaliforniaCalendarWallTime;
typedef struct _CaliforniaCalendarWallTimeClass CaliforniaCalendarWallTimeClass;

#define CALIFORNIA_CALENDAR_DATE_TYPE_PRETTY_FLAG (california_calendar_date_pretty_flag_get_type ())

#define CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_TYPE_PRETTY_FLAG (california_calendar_exact_time_span_pretty_flag_get_type ())

#define CALIFORNIA_CALENDAR_TYPE_YEAR (california_calendar_year_get_type ())
#define CALIFORNIA_CALENDAR_YEAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear))
#define CALIFORNIA_CALENDAR_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))
#define CALIFORNIA_CALENDAR_IS_YEAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_IS_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_YEAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))

typedef struct _CaliforniaCalendarYear CaliforniaCalendarYear;
typedef struct _CaliforniaCalendarYearClass CaliforniaCalendarYearClass;

#define CALIFORNIA_CALENDAR_TYPE_DURATION (california_calendar_duration_get_type ())
#define CALIFORNIA_CALENDAR_DURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDuration))
#define CALIFORNIA_CALENDAR_DURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDurationClass))
#define CALIFORNIA_CALENDAR_IS_DURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION))
#define CALIFORNIA_CALENDAR_IS_DURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DURATION))
#define CALIFORNIA_CALENDAR_DURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DURATION, CaliforniaCalendarDurationClass))

typedef struct _CaliforniaCalendarDuration CaliforniaCalendarDuration;
typedef struct _CaliforniaCalendarDurationClass CaliforniaCalendarDurationClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaComponentInstance {
	CaliforniaBaseObject parent_instance;
	CaliforniaComponentInstancePrivate * priv;
};

struct _CaliforniaComponentInstanceClass {
	CaliforniaBaseObjectClass parent_class;
	void (*notify_altered) (CaliforniaComponentInstance* self, gboolean from_full_update);
	void (*update_from_component) (CaliforniaComponentInstance* self, icalcomponent* ical_component, CaliforniaComponentUID* supplied_uid, GError** error);
	CaliforniaComponentInstance* (*clone) (CaliforniaComponentInstance* self, CaliforniaBackingSource* clone_source, GError** error);
	gboolean (*is_valid) (CaliforniaComponentInstance* self, gboolean and_useful);
	gboolean (*equal_to) (CaliforniaComponentInstance* self, CaliforniaComponentInstance* other);
	guint (*hash) (CaliforniaComponentInstance* self);
};

struct _CaliforniaComponentEvent {
	CaliforniaComponentInstance parent_instance;
	CaliforniaComponentEventPrivate * priv;
};

struct _CaliforniaComponentEventClass {
	CaliforniaComponentInstanceClass parent_class;
};

typedef enum  {
	CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE,
	CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED,
	CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED
} CaliforniaComponentEventStatus;

struct _CaliforniaComponentEventPrivate {
	gchar* _summary;
	gchar* _description;
	CaliforniaCalendarExactTimeSpan* _exact_time_span;
	CaliforniaCalendarDateSpan* _date_span;
	gchar* _location;
	CaliforniaComponentEventStatus _status;
};

typedef enum  {
	CALIFORNIA_COMPONENT_ERROR_INVALID,
	CALIFORNIA_COMPONENT_ERROR_MISMATCH,
	CALIFORNIA_COMPONENT_ERROR_UNAVAILABLE
} CaliforniaComponentError;
#define CALIFORNIA_COMPONENT_ERROR california_component_error_quark ()
typedef enum  {
	CALIFORNIA_CALENDAR_ERROR_INVALID
} CaliforniaCalendarError;
#define CALIFORNIA_CALENDAR_ERROR california_calendar_error_quark ()
typedef enum  {
	CALIFORNIA_BACKING_ERROR_INVALID,
	CALIFORNIA_BACKING_ERROR_MISMATCH,
	CALIFORNIA_BACKING_ERROR_UNAVAILABLE,
	CALIFORNIA_BACKING_ERROR_UNKNOWN
} CaliforniaBackingError;
#define CALIFORNIA_BACKING_ERROR california_backing_error_quark ()
typedef enum  {
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NONE = 0,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_ABBREV = 1 << 0,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_COMPACT = 1 << 1,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR = 1 << 2,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_OTHER_YEAR = 1 << 3,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_TODAY = 1 << 4,
	CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_NO_DAY_OF_WEEK = 1 << 5
} CaliforniaCalendarDatePrettyFlag;

typedef enum  {
	CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_PRETTY_FLAG_NONE = 0,
	CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_PRETTY_FLAG_ALLOW_MULTILINE = 1 << 0,
	CALIFORNIA_CALENDAR_EXACT_TIME_SPAN_PRETTY_FLAG_INCLUDE_TIMEZONE = 1 << 1
} CaliforniaCalendarExactTimeSpanPrettyFlag;


static gpointer california_component_event_parent_class = NULL;
static GeeComparableIface* california_component_event_gee_comparable_parent_iface = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_component_instance_get_type (void) G_GNUC_CONST;
GType california_component_uid_get_type (void) G_GNUC_CONST;
GType california_backing_source_get_type (void) G_GNUC_CONST;
GType california_component_event_get_type (void) G_GNUC_CONST;
GType california_calendar_exact_time_span_get_type (void) G_GNUC_CONST;
GType california_calendar_span_get_type (void) G_GNUC_CONST;
GType california_calendar_unit_span_get_type (void) G_GNUC_CONST;
GType california_calendar_date_span_get_type (void) G_GNUC_CONST;
GType california_component_event_status_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_COMPONENT_EVENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEventPrivate))
enum  {
	CALIFORNIA_COMPONENT_EVENT_DUMMY_PROPERTY,
	CALIFORNIA_COMPONENT_EVENT_SUMMARY,
	CALIFORNIA_COMPONENT_EVENT_DESCRIPTION,
	CALIFORNIA_COMPONENT_EVENT_EXACT_TIME_SPAN,
	CALIFORNIA_COMPONENT_EVENT_DATE_SPAN,
	CALIFORNIA_COMPONENT_EVENT_IS_ALL_DAY,
	CALIFORNIA_COMPONENT_EVENT_IS_DAY_SPANNING,
	CALIFORNIA_COMPONENT_EVENT_LOCATION,
	CALIFORNIA_COMPONENT_EVENT_STATUS
};
#define CALIFORNIA_COMPONENT_EVENT_PROP_SUMMARY "summary"
#define CALIFORNIA_COMPONENT_EVENT_PROP_DESCRIPTION "description"
#define CALIFORNIA_COMPONENT_EVENT_PROP_EXACT_TIME_SPAN "exact-time-span"
#define CALIFORNIA_COMPONENT_EVENT_PROP_DATE_SPAN "date-span"
#define CALIFORNIA_COMPONENT_EVENT_PROP_IS_ALL_DAY "is-all-day"
#define CALIFORNIA_COMPONENT_EVENT_PROP_LOCATION "location"
#define CALIFORNIA_COMPONENT_EVENT_PROP_STATUS "status"
GType california_backing_calendar_source_get_type (void) G_GNUC_CONST;
CaliforniaComponentEvent* california_component_event_new (CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error);
CaliforniaComponentEvent* california_component_event_construct (GType object_type, CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error);
CaliforniaComponentInstance* california_component_instance_construct (GType object_type, CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, icalcomponent_kind kind, GError** error);
static void california_component_event_on_notify (CaliforniaComponentEvent* self, GParamSpec* pspec);
static void _california_component_event_on_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
CaliforniaComponentEvent* california_component_event_new_blank (CaliforniaBackingCalendarSource* calendar_source);
CaliforniaComponentEvent* california_component_event_construct_blank (GType object_type, CaliforniaBackingCalendarSource* calendar_source);
CaliforniaComponentInstance* california_component_instance_construct_blank (GType object_type, icalcomponent_kind kind, CaliforniaBackingCalendarSource* calendar_source);
static void california_component_event_real_update_from_component (CaliforniaComponentInstance* base, icalcomponent* ical_component, CaliforniaComponentUID* supplied_uid, GError** error);
void california_component_instance_update_from_component (CaliforniaComponentInstance* self, icalcomponent* ical_component, CaliforniaComponentUID* supplied_uid, GError** error);
void california_component_event_set_summary (CaliforniaComponentEvent* self, const gchar* value);
void california_component_event_set_description (CaliforniaComponentEvent* self, const gchar* value);
GType california_component_date_time_get_type (void) G_GNUC_CONST;
GQuark california_component_error_quark (void);
CaliforniaComponentDateTime* california_component_date_time_new (icalcomponent* ical_component, icalproperty_kind ical_prop_kind, GError** error);
CaliforniaComponentDateTime* california_component_date_time_construct (GType object_type, icalcomponent* ical_component, icalproperty_kind ical_prop_kind, GError** error);
CaliforniaComponentDateTime* california_component_date_time_adjust_duration (CaliforniaComponentDateTime* self, icalcomponent* ical_component, icalproperty_kind new_kind, GError** error);
GQuark california_calendar_error_quark (void);
void california_component_date_time_to_span (CaliforniaComponentDateTime* dt_start, CaliforniaComponentDateTime* dt_end, gboolean dtend_inclusive, CaliforniaCalendarDateSpan** date_span, CaliforniaCalendarExactTimeSpan** exact_time_span, GError** error);
void california_component_event_set_event_exact_time_span (CaliforniaComponentEvent* self, CaliforniaCalendarExactTimeSpan* exact_time_span);
void california_component_event_set_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* date_span);
void california_component_event_set_location (CaliforniaComponentEvent* self, const gchar* value);
void california_component_event_set_status (CaliforniaComponentEvent* self, CaliforniaComponentEventStatus value);
gboolean california_component_instance_get_in_full_update (CaliforniaComponentInstance* self);
gint california_component_instance_remove_all_properties (CaliforniaComponentInstance* self, icalproperty_kind kind);
icalcomponent* california_component_instance_get_ical_component (CaliforniaComponentInstance* self);
const gchar* california_component_event_get_summary (CaliforniaComponentEvent* self);
const gchar* california_component_event_get_description (CaliforniaComponentEvent* self);
CaliforniaCalendarDateSpan* california_component_event_get_date_span (CaliforniaComponentEvent* self);
CaliforniaCalendarExactTimeSpan* california_component_event_get_exact_time_span (CaliforniaComponentEvent* self);
void california_component_instance_exact_time_span_to_ical (CaliforniaCalendarExactTimeSpan* exact_time_span, icaltimetype* ical_dtstart, icaltimetype* ical_dtend);
void california_component_instance_date_span_to_ical (CaliforniaCalendarDateSpan* date_span, gboolean dtend_inclusive, icaltimetype* ical_dtstart, icaltimetype* ical_dtend);
const gchar* california_component_event_get_location (CaliforniaComponentEvent* self);
CaliforniaComponentEventStatus california_component_event_get_status (CaliforniaComponentEvent* self);
void california_component_instance_notify_altered (CaliforniaComponentInstance* self, gboolean from_full_update);
static CaliforniaComponentInstance* california_component_event_real_clone (CaliforniaComponentInstance* base, CaliforniaBackingSource* clone_source, GError** error);
GQuark california_backing_error_quark (void);
CaliforniaBackingCalendarSource* california_component_instance_get_calendar_source (CaliforniaComponentInstance* self);
CaliforniaComponentInstance* california_component_instance_get_master (CaliforniaComponentInstance* self);
void california_component_instance_set_master (CaliforniaComponentInstance* self, CaliforniaComponentInstance* value);
GType california_calendar_timezone_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDateSpan* california_component_event_get_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarTimezone* tz);
CaliforniaCalendarExactTimeSpan* california_calendar_exact_time_span_to_timezone (CaliforniaCalendarExactTimeSpan* self, CaliforniaCalendarTimezone* new_tz);
CaliforniaCalendarDateSpan* california_calendar_date_span_new_from_exact_time_span (CaliforniaCalendarExactTimeSpan* exact_time_span);
CaliforniaCalendarDateSpan* california_calendar_date_span_construct_from_exact_time_span (GType object_type, CaliforniaCalendarExactTimeSpan* exact_time_span);
static void california_component_event_set_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* value);
static void california_component_event_set_exact_time_span (CaliforniaComponentEvent* self, CaliforniaCalendarExactTimeSpan* value);
GType california_calendar_unit_get_type (void) G_GNUC_CONST;
GType california_calendar_date_get_type (void) G_GNUC_CONST;
void california_component_event_adjust_start_date (CaliforniaComponentEvent* self, CaliforniaCalendarDate* new_start_date);
CaliforniaCalendarDate* california_calendar_span_get_start_date (CaliforniaCalendarSpan* self);
gint california_calendar_unit_difference (CaliforniaCalendarUnit* self, gconstpointer other);
CaliforniaCalendarDate* california_calendar_span_get_end_date (CaliforniaCalendarSpan* self);
gpointer california_calendar_unit_adjust (CaliforniaCalendarUnit* self, gint quantity);
gboolean california_component_event_get_is_all_day (CaliforniaComponentEvent* self);
CaliforniaCalendarDateSpan* california_calendar_date_span_new (CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
CaliforniaCalendarDateSpan* california_calendar_date_span_construct (GType object_type, CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
GType california_calendar_exact_time_get_type (void) G_GNUC_CONST;
CaliforniaCalendarExactTime* california_calendar_exact_time_span_get_start_exact_time (CaliforniaCalendarExactTimeSpan* self);
CaliforniaCalendarTimezone* california_calendar_exact_time_get_tz (CaliforniaCalendarExactTime* self);
GType california_calendar_wall_time_get_type (void) G_GNUC_CONST;
CaliforniaCalendarWallTime* california_calendar_exact_time_to_wall_time (CaliforniaCalendarExactTime* self);
CaliforniaCalendarExactTime* california_calendar_exact_time_new (CaliforniaCalendarTimezone* tz, CaliforniaCalendarDate* date, CaliforniaCalendarWallTime* time);
CaliforniaCalendarExactTime* california_calendar_exact_time_construct (GType object_type, CaliforniaCalendarTimezone* tz, CaliforniaCalendarDate* date, CaliforniaCalendarWallTime* time);
CaliforniaCalendarExactTime* california_calendar_exact_time_span_get_end_exact_time (CaliforniaCalendarExactTimeSpan* self);
CaliforniaCalendarExactTimeSpan* california_calendar_exact_time_span_new (CaliforniaCalendarExactTime* start_exact_time, CaliforniaCalendarExactTime* end_exact_time);
CaliforniaCalendarExactTimeSpan* california_calendar_exact_time_span_construct (GType object_type, CaliforniaCalendarExactTime* start_exact_time, CaliforniaCalendarExactTime* end_exact_time);
void california_component_event_all_day_to_timed_event (CaliforniaComponentEvent* self, CaliforniaCalendarWallTime* start_time, CaliforniaCalendarWallTime* end_time, CaliforniaCalendarTimezone* timezone);
void california_component_event_timed_to_all_day_event (CaliforniaComponentEvent* self);
GType california_calendar_date_pretty_flag_get_type (void) G_GNUC_CONST;
GType california_calendar_exact_time_span_pretty_flag_get_type (void) G_GNUC_CONST;
gchar* california_component_event_get_event_time_pretty_string (CaliforniaComponentEvent* self, CaliforniaCalendarDatePrettyFlag date_flags, CaliforniaCalendarExactTimeSpanPrettyFlag time_flags, CaliforniaCalendarTimezone* timezone);
GType california_calendar_year_get_type (void) G_GNUC_CONST;
CaliforniaCalendarYear* california_calendar_date_get_year (CaliforniaCalendarDate* self);
CaliforniaCalendarDate* california_calendar_system_get_today (void);
gchar* california_calendar_date_span_to_pretty_string (CaliforniaCalendarDateSpan* self, CaliforniaCalendarDatePrettyFlag date_flags);
gchar* california_calendar_exact_time_span_to_pretty_string (CaliforniaCalendarExactTimeSpan* self, CaliforniaCalendarDatePrettyFlag date_flags, CaliforniaCalendarExactTimeSpanPrettyFlag time_flags);
static gboolean california_component_event_real_is_valid (CaliforniaComponentInstance* base, gboolean and_useful);
gboolean california_string_is_empty (const gchar* str);
gboolean california_component_instance_is_valid (CaliforniaComponentInstance* self, gboolean and_useful);
static gint california_component_event_real_compare_to (GeeComparable* base, CaliforniaComponentEvent* other);
CaliforniaComponentDateTime* california_component_instance_get_rid (CaliforniaComponentInstance* self);
CaliforniaCalendarExactTime* california_component_instance_get_dtstamp (CaliforniaComponentInstance* self);
gint california_component_instance_get_sequence (CaliforniaComponentInstance* self);
gint california_backing_source_compare_to (CaliforniaBackingSource* self, CaliforniaBackingSource* other);
CaliforniaComponentUID* california_component_instance_get_uid (CaliforniaComponentInstance* self);
static gchar* california_component_event_real_to_string (CaliforniaBaseObject* base);
gchar* california_base_object_to_string (CaliforniaBaseObject* self);
gboolean california_component_event_get_is_day_spanning (CaliforniaComponentEvent* self);
GType california_calendar_duration_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDuration* california_calendar_exact_time_span_get_duration (CaliforniaCalendarExactTimeSpan* self);
guint64 california_calendar_duration_get_days (CaliforniaCalendarDuration* self);
static void california_component_event_finalize (GObject* obj);
static void _vala_california_component_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_component_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType california_component_event_status_get_type (void) {
	static volatile gsize california_component_event_status_type_id__volatile = 0;
	if (g_once_init_enter (&california_component_event_status_type_id__volatile)) {
		static const GEnumValue values[] = {{CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE, "CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE", "tentative"}, {CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED, "CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED", "confirmed"}, {CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED, "CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED", "cancelled"}, {0, NULL, NULL}};
		GType california_component_event_status_type_id;
		california_component_event_status_type_id = g_enum_register_static ("CaliforniaComponentEventStatus", values);
		g_once_init_leave (&california_component_event_status_type_id__volatile, california_component_event_status_type_id);
	}
	return california_component_event_status_type_id__volatile;
}


/**
     * Create an {@link Event} {@link Component} from an EDS CalComponent object.
     *
     * Throws a BackingError if the E.CalComponent's VTYPE is not VEVENT.
     */
static void _california_component_event_on_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 99 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_on_notify ((CaliforniaComponentEvent*) self, pspec);
#line 448 "component-event.c"
}


CaliforniaComponentEvent* california_component_event_construct (GType object_type, CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error) {
	CaliforniaComponentEvent * self = NULL;
	CaliforniaBackingCalendarSource* _tmp0_ = NULL;
	icalcomponent* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 93 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail ((calendar_source == NULL) || CALIFORNIA_BACKING_IS_CALENDAR_SOURCE (calendar_source), NULL);
#line 93 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (ical_component != NULL, NULL);
#line 94 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = calendar_source;
#line 94 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = ical_component;
#line 94 "/home/jim/git/california/src/component/component-event.vala"
	self = (CaliforniaComponentEvent*) california_component_instance_construct (object_type, _tmp0_, _tmp1_, ICAL_VEVENT_COMPONENT, &_inner_error_);
#line 94 "/home/jim/git/california/src/component/component-event.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 94 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 94 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (self);
#line 94 "/home/jim/git/california/src/component/component-event.vala"
		return NULL;
#line 475 "component-event.c"
	}
#line 99 "/home/jim/git/california/src/component/component-event.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify", (GCallback) _california_component_event_on_notify_g_object_notify, self, 0);
#line 93 "/home/jim/git/california/src/component/component-event.vala"
	return self;
#line 481 "component-event.c"
}


CaliforniaComponentEvent* california_component_event_new (CaliforniaBackingCalendarSource* calendar_source, icalcomponent* ical_component, GError** error) {
#line 93 "/home/jim/git/california/src/component/component-event.vala"
	return california_component_event_construct (CALIFORNIA_COMPONENT_TYPE_EVENT, calendar_source, ical_component, error);
#line 488 "component-event.c"
}


/**
     * Creates a "blank" {@link Event} with a generated {@link uid}.
     *
     * A {@link Calendar.DateSpan} or a {@link Calendar.ExactTimeSpan} must be specified in order
     * to generate a minimally-valid Event.
     */
CaliforniaComponentEvent* california_component_event_construct_blank (GType object_type, CaliforniaBackingCalendarSource* calendar_source) {
	CaliforniaComponentEvent * self = NULL;
	CaliforniaBackingCalendarSource* _tmp0_ = NULL;
#line 108 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail ((calendar_source == NULL) || CALIFORNIA_BACKING_IS_CALENDAR_SOURCE (calendar_source), NULL);
#line 109 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = calendar_source;
#line 109 "/home/jim/git/california/src/component/component-event.vala"
	self = (CaliforniaComponentEvent*) california_component_instance_construct_blank (object_type, ICAL_VEVENT_COMPONENT, _tmp0_);
#line 111 "/home/jim/git/california/src/component/component-event.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify", (GCallback) _california_component_event_on_notify_g_object_notify, self, 0);
#line 108 "/home/jim/git/california/src/component/component-event.vala"
	return self;
#line 511 "component-event.c"
}


CaliforniaComponentEvent* california_component_event_new_blank (CaliforniaBackingCalendarSource* calendar_source) {
#line 108 "/home/jim/git/california/src/component/component-event.vala"
	return california_component_event_construct_blank (CALIFORNIA_COMPONENT_TYPE_EVENT, calendar_source);
#line 518 "component-event.c"
}


/**
     * @inheritDoc
     */
static gpointer _g_error_copy0 (gpointer self) {
#line 135 "/home/jim/git/california/src/component/component-event.vala"
	return self ? g_error_copy (self) : NULL;
#line 528 "component-event.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 152 "/home/jim/git/california/src/component/component-event.vala"
	return self ? g_object_ref (self) : NULL;
#line 535 "component-event.c"
}


static void california_component_event_real_update_from_component (CaliforniaComponentInstance* base, icalcomponent* ical_component, CaliforniaComponentUID* supplied_uid, GError** error) {
	CaliforniaComponentEvent * self;
	icalcomponent* _tmp0_ = NULL;
	CaliforniaComponentUID* _tmp1_ = NULL;
	icalcomponent* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	icalcomponent* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	CaliforniaComponentDateTime* dt_start = NULL;
	icalcomponent* _tmp6_ = NULL;
	CaliforniaComponentDateTime* _tmp7_ = NULL;
	CaliforniaComponentDateTime* dt_end = NULL;
	CaliforniaComponentDateTime* _tmp15_ = NULL;
	gboolean dtend_inclusive = FALSE;
	CaliforniaComponentDateTime* _tmp21_ = NULL;
	CaliforniaCalendarDateSpan* date_span = NULL;
	CaliforniaCalendarExactTimeSpan* exact_time_span = NULL;
	CaliforniaComponentDateTime* _tmp24_ = NULL;
	CaliforniaComponentDateTime* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	CaliforniaCalendarDateSpan* _tmp27_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp28_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp29_ = NULL;
	icalcomponent* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	icalcomponent* _tmp35_ = NULL;
	icalproperty_status _tmp36_ = 0;
	GError * _inner_error_ = NULL;
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (ical_component != NULL);
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail ((supplied_uid == NULL) || CALIFORNIA_COMPONENT_IS_UID (supplied_uid));
#line 119 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = ical_component;
#line 119 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = supplied_uid;
#line 119 "/home/jim/git/california/src/component/component-event.vala"
	CALIFORNIA_COMPONENT_INSTANCE_CLASS (california_component_event_parent_class)->update_from_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), _tmp0_, _tmp1_, &_inner_error_);
#line 119 "/home/jim/git/california/src/component/component-event.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 119 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 119 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 585 "component-event.c"
	}
#line 121 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = ical_component;
#line 121 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = icalcomponent_get_summary (_tmp2_);
#line 121 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_summary (self, _tmp3_);
#line 122 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = ical_component;
#line 122 "/home/jim/git/california/src/component/component-event.vala"
	_tmp5_ = icalcomponent_get_description (_tmp4_);
#line 122 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_description (self, _tmp5_);
#line 124 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = ical_component;
#line 124 "/home/jim/git/california/src/component/component-event.vala"
	_tmp7_ = california_component_date_time_new (_tmp6_, ICAL_DTSTART_PROPERTY, &_inner_error_);
#line 124 "/home/jim/git/california/src/component/component-event.vala"
	dt_start = _tmp7_;
#line 124 "/home/jim/git/california/src/component/component-event.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 124 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 124 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 611 "component-event.c"
	}
#line 129 "/home/jim/git/california/src/component/component-event.vala"
	dt_end = NULL;
#line 615 "component-event.c"
	{
		CaliforniaComponentDateTime* _tmp8_ = NULL;
		icalcomponent* _tmp9_ = NULL;
		CaliforniaComponentDateTime* _tmp10_ = NULL;
		CaliforniaComponentDateTime* _tmp11_ = NULL;
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		_tmp9_ = ical_component;
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		_tmp10_ = california_component_date_time_new (_tmp9_, ICAL_DTEND_PROPERTY, &_inner_error_);
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = _tmp10_;
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 131 "/home/jim/git/california/src/component/component-event.vala"
			if (_inner_error_->domain == CALIFORNIA_COMPONENT_ERROR) {
#line 631 "component-event.c"
				goto __catch42_california_component_error;
			}
#line 131 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (dt_end);
#line 131 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (dt_start);
#line 131 "/home/jim/git/california/src/component/component-event.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 131 "/home/jim/git/california/src/component/component-event.vala"
			g_clear_error (&_inner_error_);
#line 131 "/home/jim/git/california/src/component/component-event.vala"
			return;
#line 644 "component-event.c"
		}
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		_tmp11_ = _tmp8_;
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = NULL;
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_end);
#line 131 "/home/jim/git/california/src/component/component-event.vala"
		dt_end = _tmp11_;
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp8_);
#line 656 "component-event.c"
	}
	goto __finally42;
	__catch42_california_component_error:
	{
		GError* comperr = NULL;
		GError* _tmp12_ = NULL;
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		comperr = _inner_error_;
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		_inner_error_ = NULL;
#line 134 "/home/jim/git/california/src/component/component-event.vala"
		_tmp12_ = comperr;
#line 134 "/home/jim/git/california/src/component/component-event.vala"
		if (!g_error_matches (_tmp12_, CALIFORNIA_COMPONENT_ERROR, CALIFORNIA_COMPONENT_ERROR_UNAVAILABLE)) {
#line 671 "component-event.c"
			GError* _tmp13_ = NULL;
			GError* _tmp14_ = NULL;
#line 135 "/home/jim/git/california/src/component/component-event.vala"
			_tmp13_ = comperr;
#line 135 "/home/jim/git/california/src/component/component-event.vala"
			_tmp14_ = _g_error_copy0 (_tmp13_);
#line 135 "/home/jim/git/california/src/component/component-event.vala"
			_inner_error_ = _tmp14_;
#line 135 "/home/jim/git/california/src/component/component-event.vala"
			_g_error_free0 (comperr);
#line 682 "component-event.c"
			goto __finally42;
		}
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		_g_error_free0 (comperr);
#line 687 "component-event.c"
	}
	__finally42:
#line 130 "/home/jim/git/california/src/component/component-event.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_end);
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_start);
#line 130 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 700 "component-event.c"
	}
#line 139 "/home/jim/git/california/src/component/component-event.vala"
	_tmp15_ = dt_end;
#line 139 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp15_ == NULL) {
#line 706 "component-event.c"
		{
			CaliforniaComponentDateTime* _tmp16_ = NULL;
			CaliforniaComponentDateTime* _tmp17_ = NULL;
			icalcomponent* _tmp18_ = NULL;
			CaliforniaComponentDateTime* _tmp19_ = NULL;
			CaliforniaComponentDateTime* _tmp20_ = NULL;
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			_tmp17_ = dt_start;
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			_tmp18_ = ical_component;
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			_tmp19_ = california_component_date_time_adjust_duration (_tmp17_, _tmp18_, ICAL_DTEND_PROPERTY, &_inner_error_);
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			_tmp16_ = _tmp19_;
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 141 "/home/jim/git/california/src/component/component-event.vala"
				if (_inner_error_->domain == CALIFORNIA_COMPONENT_ERROR) {
#line 725 "component-event.c"
					goto __catch43_california_component_error;
				}
#line 141 "/home/jim/git/california/src/component/component-event.vala"
				_g_object_unref0 (dt_end);
#line 141 "/home/jim/git/california/src/component/component-event.vala"
				_g_object_unref0 (dt_start);
#line 141 "/home/jim/git/california/src/component/component-event.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 141 "/home/jim/git/california/src/component/component-event.vala"
				g_clear_error (&_inner_error_);
#line 141 "/home/jim/git/california/src/component/component-event.vala"
				return;
#line 738 "component-event.c"
			}
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			_tmp20_ = _tmp16_;
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			_tmp16_ = NULL;
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (dt_end);
#line 141 "/home/jim/git/california/src/component/component-event.vala"
			dt_end = _tmp20_;
#line 140 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (_tmp16_);
#line 750 "component-event.c"
		}
		goto __finally43;
		__catch43_california_component_error:
		{
			GError* comperr = NULL;
#line 140 "/home/jim/git/california/src/component/component-event.vala"
			comperr = _inner_error_;
#line 140 "/home/jim/git/california/src/component/component-event.vala"
			_inner_error_ = NULL;
#line 140 "/home/jim/git/california/src/component/component-event.vala"
			_g_error_free0 (comperr);
#line 762 "component-event.c"
		}
		__finally43:
#line 140 "/home/jim/git/california/src/component/component-event.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 140 "/home/jim/git/california/src/component/component-event.vala"
			g_propagate_error (error, _inner_error_);
#line 140 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (dt_end);
#line 140 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (dt_start);
#line 140 "/home/jim/git/california/src/component/component-event.vala"
			return;
#line 775 "component-event.c"
		}
	}
#line 147 "/home/jim/git/california/src/component/component-event.vala"
	dtend_inclusive = FALSE;
#line 148 "/home/jim/git/california/src/component/component-event.vala"
	_tmp21_ = dt_end;
#line 148 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp21_ == NULL) {
#line 784 "component-event.c"
		CaliforniaComponentDateTime* _tmp22_ = NULL;
		CaliforniaComponentDateTime* _tmp23_ = NULL;
#line 152 "/home/jim/git/california/src/component/component-event.vala"
		_tmp22_ = dt_start;
#line 152 "/home/jim/git/california/src/component/component-event.vala"
		_tmp23_ = _g_object_ref0 (_tmp22_);
#line 152 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_end);
#line 152 "/home/jim/git/california/src/component/component-event.vala"
		dt_end = _tmp23_;
#line 153 "/home/jim/git/california/src/component/component-event.vala"
		dtend_inclusive = TRUE;
#line 797 "component-event.c"
	}
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	_tmp24_ = dt_start;
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	_tmp25_ = dt_end;
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	_tmp26_ = dtend_inclusive;
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	california_component_date_time_to_span (_tmp24_, _tmp25_, _tmp26_, &_tmp27_, &_tmp28_, &_inner_error_);
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (date_span);
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	date_span = _tmp27_;
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (exact_time_span);
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	exact_time_span = _tmp28_;
#line 160 "/home/jim/git/california/src/component/component-event.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 160 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 160 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (exact_time_span);
#line 160 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (date_span);
#line 160 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_end);
#line 160 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (dt_start);
#line 160 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 829 "component-event.c"
	}
#line 161 "/home/jim/git/california/src/component/component-event.vala"
	_tmp29_ = exact_time_span;
#line 161 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp29_ != NULL) {
#line 835 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp30_ = NULL;
#line 162 "/home/jim/git/california/src/component/component-event.vala"
		_tmp30_ = exact_time_span;
#line 162 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_event_exact_time_span (self, _tmp30_);
#line 841 "component-event.c"
	} else {
		CaliforniaCalendarDateSpan* _tmp31_ = NULL;
		CaliforniaCalendarDateSpan* _tmp32_ = NULL;
#line 164 "/home/jim/git/california/src/component/component-event.vala"
		_tmp31_ = date_span;
#line 164 "/home/jim/git/california/src/component/component-event.vala"
		_vala_assert (_tmp31_ != NULL, "date_span != null");
#line 165 "/home/jim/git/california/src/component/component-event.vala"
		_tmp32_ = date_span;
#line 165 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_event_date_span (self, _tmp32_);
#line 853 "component-event.c"
	}
#line 168 "/home/jim/git/california/src/component/component-event.vala"
	_tmp33_ = ical_component;
#line 168 "/home/jim/git/california/src/component/component-event.vala"
	_tmp34_ = icalcomponent_get_location (_tmp33_);
#line 168 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_location (self, _tmp34_);
#line 170 "/home/jim/git/california/src/component/component-event.vala"
	_tmp35_ = ical_component;
#line 170 "/home/jim/git/california/src/component/component-event.vala"
	_tmp36_ = icalcomponent_get_status (_tmp35_);
#line 170 "/home/jim/git/california/src/component/component-event.vala"
	switch (_tmp36_) {
#line 170 "/home/jim/git/california/src/component/component-event.vala"
		case ICAL_STATUS_TENTATIVE:
#line 869 "component-event.c"
		{
#line 172 "/home/jim/git/california/src/component/component-event.vala"
			california_component_event_set_status (self, CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE);
#line 173 "/home/jim/git/california/src/component/component-event.vala"
			break;
#line 875 "component-event.c"
		}
#line 170 "/home/jim/git/california/src/component/component-event.vala"
		case ICAL_STATUS_CANCELLED:
#line 879 "component-event.c"
		{
#line 176 "/home/jim/git/california/src/component/component-event.vala"
			california_component_event_set_status (self, CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED);
#line 177 "/home/jim/git/california/src/component/component-event.vala"
			break;
#line 885 "component-event.c"
		}
		default:
#line 170 "/home/jim/git/california/src/component/component-event.vala"
		case ICAL_STATUS_CONFIRMED:
#line 890 "component-event.c"
		{
#line 181 "/home/jim/git/california/src/component/component-event.vala"
			california_component_event_set_status (self, CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED);
#line 182 "/home/jim/git/california/src/component/component-event.vala"
			break;
#line 896 "component-event.c"
		}
	}
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (exact_time_span);
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (date_span);
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (dt_end);
#line 117 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (dt_start);
#line 907 "component-event.c"
}


static void california_component_event_on_notify (CaliforniaComponentEvent* self, GParamSpec* pspec) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean altered = FALSE;
	GParamSpec* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
	gboolean _tmp41_ = FALSE;
#line 186 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 186 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (G_IS_PARAM_SPEC (pspec));
#line 188 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = california_component_instance_get_in_full_update (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 188 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _tmp0_;
#line 188 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_) {
#line 189 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 932 "component-event.c"
	}
#line 191 "/home/jim/git/california/src/component/component-event.vala"
	altered = TRUE;
#line 192 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = pspec;
#line 192 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = _tmp2_->name;
#line 192 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = _tmp3_;
#line 192 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 192 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_SUMMARY)) {
#line 192 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 948 "component-event.c"
			default:
			{
				icalcomponent* _tmp7_ = NULL;
				icalcomponent* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
#line 194 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_SUMMARY_PROPERTY);
#line 195 "/home/jim/git/california/src/component/component-event.vala"
				_tmp7_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 195 "/home/jim/git/california/src/component/component-event.vala"
				_tmp8_ = _tmp7_;
#line 195 "/home/jim/git/california/src/component/component-event.vala"
				_tmp9_ = self->priv->_summary;
#line 195 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_summary (_tmp8_, _tmp9_);
#line 196 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 966 "component-event.c"
			}
		}
	} else if (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_DESCRIPTION)) {
#line 192 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 972 "component-event.c"
			default:
			{
				icalcomponent* _tmp10_ = NULL;
				icalcomponent* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
#line 199 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_DESCRIPTION_PROPERTY);
#line 200 "/home/jim/git/california/src/component/component-event.vala"
				_tmp10_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 200 "/home/jim/git/california/src/component/component-event.vala"
				_tmp11_ = _tmp10_;
#line 200 "/home/jim/git/california/src/component/component-event.vala"
				_tmp12_ = self->priv->_description;
#line 200 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_description (_tmp11_, _tmp12_);
#line 201 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 990 "component-event.c"
			}
		}
	} else if ((_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_EXACT_TIME_SPAN)) || (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_DATE_SPAN))) {
#line 192 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 996 "component-event.c"
			default:
			{
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				CaliforniaCalendarDateSpan* _tmp15_ = NULL;
				icaltimetype ical_dtstart = {0};
				icaltimetype _tmp20_ = {0};
				icaltimetype ical_dtend = {0};
				icaltimetype _tmp21_ = {0};
				CaliforniaCalendarExactTimeSpan* _tmp22_ = NULL;
				icalcomponent* _tmp25_ = NULL;
				icalcomponent* _tmp26_ = NULL;
				icaltimetype _tmp27_ = {0};
				icalcomponent* _tmp28_ = NULL;
				icalcomponent* _tmp29_ = NULL;
				icaltimetype _tmp30_ = {0};
#line 208 "/home/jim/git/california/src/component/component-event.vala"
				_tmp15_ = self->priv->_date_span;
#line 208 "/home/jim/git/california/src/component/component-event.vala"
				if (_tmp15_ == NULL) {
#line 1017 "component-event.c"
					CaliforniaCalendarExactTimeSpan* _tmp16_ = NULL;
#line 208 "/home/jim/git/california/src/component/component-event.vala"
					_tmp16_ = self->priv->_exact_time_span;
#line 208 "/home/jim/git/california/src/component/component-event.vala"
					_tmp14_ = _tmp16_ == NULL;
#line 1023 "component-event.c"
				} else {
#line 208 "/home/jim/git/california/src/component/component-event.vala"
					_tmp14_ = FALSE;
#line 1027 "component-event.c"
				}
#line 208 "/home/jim/git/california/src/component/component-event.vala"
				if (_tmp14_) {
#line 208 "/home/jim/git/california/src/component/component-event.vala"
					_tmp13_ = TRUE;
#line 1033 "component-event.c"
				} else {
					gboolean _tmp17_ = FALSE;
					CaliforniaCalendarDateSpan* _tmp18_ = NULL;
#line 209 "/home/jim/git/california/src/component/component-event.vala"
					_tmp18_ = self->priv->_date_span;
#line 209 "/home/jim/git/california/src/component/component-event.vala"
					if (_tmp18_ != NULL) {
#line 1041 "component-event.c"
						CaliforniaCalendarExactTimeSpan* _tmp19_ = NULL;
#line 209 "/home/jim/git/california/src/component/component-event.vala"
						_tmp19_ = self->priv->_exact_time_span;
#line 209 "/home/jim/git/california/src/component/component-event.vala"
						_tmp17_ = _tmp19_ != NULL;
#line 1047 "component-event.c"
					} else {
#line 209 "/home/jim/git/california/src/component/component-event.vala"
						_tmp17_ = FALSE;
#line 1051 "component-event.c"
					}
#line 209 "/home/jim/git/california/src/component/component-event.vala"
					_tmp13_ = _tmp17_;
#line 1055 "component-event.c"
				}
#line 208 "/home/jim/git/california/src/component/component-event.vala"
				if (_tmp13_) {
#line 210 "/home/jim/git/california/src/component/component-event.vala"
					return;
#line 1061 "component-event.c"
				}
#line 215 "/home/jim/git/california/src/component/component-event.vala"
				ical_dtstart = _tmp20_;
#line 216 "/home/jim/git/california/src/component/component-event.vala"
				ical_dtend = _tmp21_;
#line 217 "/home/jim/git/california/src/component/component-event.vala"
				_tmp22_ = self->priv->_exact_time_span;
#line 217 "/home/jim/git/california/src/component/component-event.vala"
				if (_tmp22_ != NULL) {
#line 1071 "component-event.c"
					CaliforniaCalendarExactTimeSpan* _tmp23_ = NULL;
#line 218 "/home/jim/git/california/src/component/component-event.vala"
					_tmp23_ = self->priv->_exact_time_span;
#line 218 "/home/jim/git/california/src/component/component-event.vala"
					california_component_instance_exact_time_span_to_ical (_tmp23_, &ical_dtstart, &ical_dtend);
#line 1077 "component-event.c"
				} else {
					CaliforniaCalendarDateSpan* _tmp24_ = NULL;
#line 220 "/home/jim/git/california/src/component/component-event.vala"
					_tmp24_ = self->priv->_date_span;
#line 220 "/home/jim/git/california/src/component/component-event.vala"
					california_component_instance_date_span_to_ical (_tmp24_, FALSE, &ical_dtstart, &ical_dtend);
#line 1084 "component-event.c"
				}
#line 222 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_DTSTART_PROPERTY);
#line 223 "/home/jim/git/california/src/component/component-event.vala"
				_tmp25_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 223 "/home/jim/git/california/src/component/component-event.vala"
				_tmp26_ = _tmp25_;
#line 223 "/home/jim/git/california/src/component/component-event.vala"
				_tmp27_ = ical_dtstart;
#line 223 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_dtstart (_tmp26_, _tmp27_);
#line 225 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_DTEND_PROPERTY);
#line 226 "/home/jim/git/california/src/component/component-event.vala"
				_tmp28_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 226 "/home/jim/git/california/src/component/component-event.vala"
				_tmp29_ = _tmp28_;
#line 226 "/home/jim/git/california/src/component/component-event.vala"
				_tmp30_ = ical_dtend;
#line 226 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_dtend (_tmp29_, _tmp30_);
#line 227 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 1108 "component-event.c"
			}
		}
	} else if (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_LOCATION)) {
#line 192 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 1114 "component-event.c"
			default:
			{
				icalcomponent* _tmp31_ = NULL;
				icalcomponent* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
#line 230 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_LOCATION_PROPERTY);
#line 231 "/home/jim/git/california/src/component/component-event.vala"
				_tmp31_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 231 "/home/jim/git/california/src/component/component-event.vala"
				_tmp32_ = _tmp31_;
#line 231 "/home/jim/git/california/src/component/component-event.vala"
				_tmp33_ = self->priv->_location;
#line 231 "/home/jim/git/california/src/component/component-event.vala"
				icalcomponent_set_location (_tmp32_, _tmp33_);
#line 232 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 1132 "component-event.c"
			}
		}
	} else if (_tmp6_ == g_quark_from_string (CALIFORNIA_COMPONENT_EVENT_PROP_STATUS)) {
#line 192 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 1138 "component-event.c"
			default:
			{
				CaliforniaComponentEventStatus _tmp34_ = 0;
#line 235 "/home/jim/git/california/src/component/component-event.vala"
				california_component_instance_remove_all_properties (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), ICAL_STATUS_PROPERTY);
#line 236 "/home/jim/git/california/src/component/component-event.vala"
				_tmp34_ = self->priv->_status;
#line 236 "/home/jim/git/california/src/component/component-event.vala"
				switch (_tmp34_) {
#line 236 "/home/jim/git/california/src/component/component-event.vala"
					case CALIFORNIA_COMPONENT_EVENT_STATUS_TENTATIVE:
#line 1150 "component-event.c"
					{
						icalcomponent* _tmp35_ = NULL;
						icalcomponent* _tmp36_ = NULL;
#line 238 "/home/jim/git/california/src/component/component-event.vala"
						_tmp35_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 238 "/home/jim/git/california/src/component/component-event.vala"
						_tmp36_ = _tmp35_;
#line 238 "/home/jim/git/california/src/component/component-event.vala"
						icalcomponent_set_status (_tmp36_, ICAL_STATUS_TENTATIVE);
#line 239 "/home/jim/git/california/src/component/component-event.vala"
						break;
#line 1162 "component-event.c"
					}
#line 236 "/home/jim/git/california/src/component/component-event.vala"
					case CALIFORNIA_COMPONENT_EVENT_STATUS_CANCELLED:
#line 1166 "component-event.c"
					{
						icalcomponent* _tmp37_ = NULL;
						icalcomponent* _tmp38_ = NULL;
#line 242 "/home/jim/git/california/src/component/component-event.vala"
						_tmp37_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 242 "/home/jim/git/california/src/component/component-event.vala"
						_tmp38_ = _tmp37_;
#line 242 "/home/jim/git/california/src/component/component-event.vala"
						icalcomponent_set_status (_tmp38_, ICAL_STATUS_CANCELLED);
#line 243 "/home/jim/git/california/src/component/component-event.vala"
						break;
#line 1178 "component-event.c"
					}
					default:
#line 236 "/home/jim/git/california/src/component/component-event.vala"
					case CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED:
#line 1183 "component-event.c"
					{
						icalcomponent* _tmp39_ = NULL;
						icalcomponent* _tmp40_ = NULL;
#line 247 "/home/jim/git/california/src/component/component-event.vala"
						_tmp39_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 247 "/home/jim/git/california/src/component/component-event.vala"
						_tmp40_ = _tmp39_;
#line 247 "/home/jim/git/california/src/component/component-event.vala"
						icalcomponent_set_status (_tmp40_, ICAL_STATUS_CONFIRMED);
#line 248 "/home/jim/git/california/src/component/component-event.vala"
						break;
#line 1195 "component-event.c"
					}
				}
#line 250 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 1200 "component-event.c"
			}
		}
	} else {
#line 192 "/home/jim/git/california/src/component/component-event.vala"
		switch (0) {
#line 1206 "component-event.c"
			default:
			{
#line 253 "/home/jim/git/california/src/component/component-event.vala"
				altered = FALSE;
#line 254 "/home/jim/git/california/src/component/component-event.vala"
				break;
#line 1213 "component-event.c"
			}
		}
	}
#line 257 "/home/jim/git/california/src/component/component-event.vala"
	_tmp41_ = altered;
#line 257 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp41_) {
#line 258 "/home/jim/git/california/src/component/component-event.vala"
		california_component_instance_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), FALSE);
#line 1223 "component-event.c"
	}
}


/**
     * @inheritDoc
     */
static CaliforniaComponentInstance* california_component_event_real_clone (CaliforniaComponentInstance* base, CaliforniaBackingSource* clone_source, GError** error) {
	CaliforniaComponentEvent * self;
	CaliforniaComponentInstance* result = NULL;
	CaliforniaBackingCalendarSource* clone_calendar_source = NULL;
	CaliforniaBackingSource* _tmp0_ = NULL;
	CaliforniaComponentEvent* cloned_event = NULL;
	CaliforniaBackingCalendarSource* _tmp8_ = NULL;
	icalcomponent* _tmp9_ = NULL;
	icalcomponent* _tmp10_ = NULL;
	CaliforniaComponentEvent* _tmp11_ = NULL;
	CaliforniaComponentInstance* _tmp12_ = NULL;
	CaliforniaComponentInstance* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 264 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 264 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail ((clone_source == NULL) || CALIFORNIA_BACKING_IS_SOURCE (clone_source), NULL);
#line 265 "/home/jim/git/california/src/component/component-event.vala"
	clone_calendar_source = NULL;
#line 266 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = clone_source;
#line 266 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp0_ != NULL) {
#line 1254 "component-event.c"
		CaliforniaBackingSource* _tmp1_ = NULL;
		CaliforniaBackingCalendarSource* _tmp2_ = NULL;
		CaliforniaBackingCalendarSource* _tmp3_ = NULL;
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_tmp1_ = clone_source;
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, CALIFORNIA_BACKING_TYPE_CALENDAR_SOURCE) ? ((CaliforniaBackingCalendarSource*) _tmp1_) : NULL);
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (clone_calendar_source);
#line 267 "/home/jim/git/california/src/component/component-event.vala"
		clone_calendar_source = _tmp2_;
#line 268 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = clone_calendar_source;
#line 268 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp3_ == NULL) {
#line 1270 "component-event.c"
			GError* _tmp4_ = NULL;
#line 269 "/home/jim/git/california/src/component/component-event.vala"
			_tmp4_ = g_error_new_literal (CALIFORNIA_BACKING_ERROR, CALIFORNIA_BACKING_ERROR_INVALID, "Supplied backing source for clone not a CalendarSource");
#line 269 "/home/jim/git/california/src/component/component-event.vala"
			_inner_error_ = _tmp4_;
#line 269 "/home/jim/git/california/src/component/component-event.vala"
			g_propagate_error (error, _inner_error_);
#line 269 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (clone_calendar_source);
#line 269 "/home/jim/git/california/src/component/component-event.vala"
			return NULL;
#line 1282 "component-event.c"
		}
	} else {
		CaliforniaBackingCalendarSource* _tmp5_ = NULL;
		CaliforniaBackingCalendarSource* _tmp6_ = NULL;
		CaliforniaBackingCalendarSource* _tmp7_ = NULL;
#line 271 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = california_component_instance_get_calendar_source (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 271 "/home/jim/git/california/src/component/component-event.vala"
		_tmp6_ = _tmp5_;
#line 271 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 271 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (clone_calendar_source);
#line 271 "/home/jim/git/california/src/component/component-event.vala"
		clone_calendar_source = _tmp7_;
#line 1298 "component-event.c"
	}
#line 274 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = clone_calendar_source;
#line 274 "/home/jim/git/california/src/component/component-event.vala"
	_tmp9_ = california_component_instance_get_ical_component (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 274 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = _tmp9_;
#line 274 "/home/jim/git/california/src/component/component-event.vala"
	_tmp11_ = california_component_event_new (_tmp8_, _tmp10_, &_inner_error_);
#line 274 "/home/jim/git/california/src/component/component-event.vala"
	cloned_event = _tmp11_;
#line 274 "/home/jim/git/california/src/component/component-event.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 274 "/home/jim/git/california/src/component/component-event.vala"
		g_propagate_error (error, _inner_error_);
#line 274 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (clone_calendar_source);
#line 274 "/home/jim/git/california/src/component/component-event.vala"
		return NULL;
#line 1318 "component-event.c"
	}
#line 275 "/home/jim/git/california/src/component/component-event.vala"
	_tmp12_ = california_component_instance_get_master (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 275 "/home/jim/git/california/src/component/component-event.vala"
	_tmp13_ = _tmp12_;
#line 275 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp13_ != NULL) {
#line 1326 "component-event.c"
		CaliforniaComponentEvent* _tmp14_ = NULL;
		CaliforniaBackingCalendarSource* _tmp15_ = NULL;
		CaliforniaComponentInstance* _tmp16_ = NULL;
		CaliforniaComponentInstance* _tmp17_ = NULL;
		icalcomponent* _tmp18_ = NULL;
		icalcomponent* _tmp19_ = NULL;
		CaliforniaComponentEvent* _tmp20_ = NULL;
		CaliforniaComponentEvent* _tmp21_ = NULL;
#line 276 "/home/jim/git/california/src/component/component-event.vala"
		_tmp15_ = clone_calendar_source;
#line 276 "/home/jim/git/california/src/component/component-event.vala"
		_tmp16_ = california_component_instance_get_master (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 276 "/home/jim/git/california/src/component/component-event.vala"
		_tmp17_ = _tmp16_;
#line 276 "/home/jim/git/california/src/component/component-event.vala"
		_tmp18_ = california_component_instance_get_ical_component (_tmp17_);
#line 276 "/home/jim/git/california/src/component/component-event.vala"
		_tmp19_ = _tmp18_;
#line 276 "/home/jim/git/california/src/component/component-event.vala"
		_tmp20_ = california_component_event_new (_tmp15_, _tmp19_, &_inner_error_);
#line 276 "/home/jim/git/california/src/component/component-event.vala"
		_tmp14_ = _tmp20_;
#line 276 "/home/jim/git/california/src/component/component-event.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 276 "/home/jim/git/california/src/component/component-event.vala"
			g_propagate_error (error, _inner_error_);
#line 276 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (cloned_event);
#line 276 "/home/jim/git/california/src/component/component-event.vala"
			_g_object_unref0 (clone_calendar_source);
#line 276 "/home/jim/git/california/src/component/component-event.vala"
			return NULL;
#line 1359 "component-event.c"
		}
#line 276 "/home/jim/git/california/src/component/component-event.vala"
		_tmp21_ = cloned_event;
#line 276 "/home/jim/git/california/src/component/component-event.vala"
		california_component_instance_set_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 275 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp14_);
#line 1367 "component-event.c"
	}
#line 278 "/home/jim/git/california/src/component/component-event.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (cloned_event, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance);
#line 278 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (clone_calendar_source);
#line 278 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1375 "component-event.c"
}


/**
     * Returns a {@link Calendar.DateSpan} for the {@link Event}.
     *
     * This will return a DateSpan whether the Event is a DATE or DATE-TIME VEVENT.
     */
CaliforniaCalendarDateSpan* california_component_event_get_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarTimezone* tz) {
	CaliforniaCalendarDateSpan* result = NULL;
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp3_ = NULL;
	CaliforniaCalendarTimezone* _tmp4_ = NULL;
	CaliforniaCalendarDateSpan* _tmp10_ = NULL;
#line 286 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 286 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail ((tz == NULL) || CALIFORNIA_CALENDAR_IS_TIMEZONE (tz), NULL);
#line 287 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_date_span;
#line 287 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp0_ != NULL) {
#line 1398 "component-event.c"
		CaliforniaCalendarDateSpan* _tmp1_ = NULL;
		CaliforniaCalendarDateSpan* _tmp2_ = NULL;
#line 288 "/home/jim/git/california/src/component/component-event.vala"
		_tmp1_ = self->priv->_date_span;
#line 288 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 288 "/home/jim/git/california/src/component/component-event.vala"
		result = _tmp2_;
#line 288 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1409 "component-event.c"
	}
#line 291 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = tz;
#line 291 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp4_ != NULL) {
#line 1415 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp5_ = NULL;
		CaliforniaCalendarTimezone* _tmp6_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp7_ = NULL;
#line 291 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = self->priv->_exact_time_span;
#line 291 "/home/jim/git/california/src/component/component-event.vala"
		_tmp6_ = tz;
#line 291 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = california_calendar_exact_time_span_to_timezone (_tmp5_, _tmp6_);
#line 291 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp3_);
#line 291 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = _tmp7_;
#line 1429 "component-event.c"
	} else {
		CaliforniaCalendarExactTimeSpan* _tmp8_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp9_ = NULL;
#line 291 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = self->priv->_exact_time_span;
#line 291 "/home/jim/git/california/src/component/component-event.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 291 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp3_);
#line 291 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = _tmp9_;
#line 1441 "component-event.c"
	}
#line 290 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = california_calendar_date_span_new_from_exact_time_span (_tmp3_);
#line 290 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp10_;
#line 290 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp3_);
#line 290 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 1451 "component-event.c"
}


/**
     * Sets the {@link Event} as a DATE VEVENT.
     *
     * {@link date_span} will be set and {@link exact_time_span} will be unset.
     *
     * @see set_event_exact_time_span
     */
void california_component_event_set_event_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* date_span) {
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
#line 301 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 301 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE_SPAN (date_span));
#line 302 "/home/jim/git/california/src/component/component-event.vala"
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 304 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = date_span;
#line 304 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_date_span (self, _tmp0_);
#line 305 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_exact_time_span (self, NULL);
#line 307 "/home/jim/git/california/src/component/component-event.vala"
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 1478 "component-event.c"
}


/**
     * Sets the {@link Event} as a DATE-TIME VEVENT.
     *
     * {@link exact_time_span} will be set and {@link date_span} will be unset.
     *
     * @see set_event_date_span
     */
void california_component_event_set_event_exact_time_span (CaliforniaComponentEvent* self, CaliforniaCalendarExactTimeSpan* exact_time_span) {
	CaliforniaCalendarExactTimeSpan* _tmp0_ = NULL;
#line 317 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 317 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_EXACT_TIME_SPAN (exact_time_span));
#line 318 "/home/jim/git/california/src/component/component-event.vala"
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 320 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = exact_time_span;
#line 320 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_exact_time_span (self, _tmp0_);
#line 321 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_date_span (self, NULL);
#line 323 "/home/jim/git/california/src/component/component-event.vala"
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 1505 "component-event.c"
}


/**
     * Adjusts the dates of an {@link Event} while preserving {@link WallTime}, if present.
     *
     * This will preserve the DATE/DATE-TIME aspect of an Event while adjusting the start and
     * end {@link Calendar.Date}s.  If a DATE Event, then this is functionally equivalent to
     * {@link set_event_date_span}.  If a DATE-TIME event, then this is like
     * {@link set_event_exact_time_span} but without the hassle of preserving start and end times
     * while changing the dates.
     */
void california_component_event_adjust_start_date (CaliforniaComponentEvent* self, CaliforniaCalendarDate* new_start_date) {
	CaliforniaCalendarDateSpan* orig_dates = NULL;
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
	gint diff = 0;
	CaliforniaCalendarDateSpan* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	CaliforniaCalendarDate* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	CaliforniaCalendarDate* new_end_date = NULL;
	CaliforniaCalendarDateSpan* _tmp7_ = NULL;
	CaliforniaCalendarDate* _tmp8_ = NULL;
	CaliforniaCalendarDate* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gpointer _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	CaliforniaCalendarExactTime* new_start_time = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp18_ = NULL;
	CaliforniaCalendarExactTime* _tmp19_ = NULL;
	CaliforniaCalendarExactTime* _tmp20_ = NULL;
	CaliforniaCalendarTimezone* _tmp21_ = NULL;
	CaliforniaCalendarTimezone* _tmp22_ = NULL;
	CaliforniaCalendarDate* _tmp23_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp24_ = NULL;
	CaliforniaCalendarExactTime* _tmp25_ = NULL;
	CaliforniaCalendarExactTime* _tmp26_ = NULL;
	CaliforniaCalendarWallTime* _tmp27_ = NULL;
	CaliforniaCalendarWallTime* _tmp28_ = NULL;
	CaliforniaCalendarExactTime* _tmp29_ = NULL;
	CaliforniaCalendarExactTime* _tmp30_ = NULL;
	CaliforniaCalendarExactTime* new_end_time = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp31_ = NULL;
	CaliforniaCalendarExactTime* _tmp32_ = NULL;
	CaliforniaCalendarExactTime* _tmp33_ = NULL;
	CaliforniaCalendarTimezone* _tmp34_ = NULL;
	CaliforniaCalendarTimezone* _tmp35_ = NULL;
	CaliforniaCalendarDate* _tmp36_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp37_ = NULL;
	CaliforniaCalendarExactTime* _tmp38_ = NULL;
	CaliforniaCalendarExactTime* _tmp39_ = NULL;
	CaliforniaCalendarWallTime* _tmp40_ = NULL;
	CaliforniaCalendarWallTime* _tmp41_ = NULL;
	CaliforniaCalendarExactTime* _tmp42_ = NULL;
	CaliforniaCalendarExactTime* _tmp43_ = NULL;
	CaliforniaCalendarExactTime* _tmp44_ = NULL;
	CaliforniaCalendarExactTime* _tmp45_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp46_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp47_ = NULL;
#line 335 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 335 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_DATE (new_start_date));
#line 338 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = california_component_event_get_event_date_span (self, NULL);
#line 338 "/home/jim/git/california/src/component/component-event.vala"
	orig_dates = _tmp0_;
#line 339 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = orig_dates;
#line 339 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 339 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = _tmp2_;
#line 339 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = new_start_date;
#line 339 "/home/jim/git/california/src/component/component-event.vala"
	_tmp5_ = california_calendar_unit_difference (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit), _tmp4_);
#line 339 "/home/jim/git/california/src/component/component-event.vala"
	diff = _tmp5_;
#line 340 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = diff;
#line 340 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp6_ == 0) {
#line 341 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (orig_dates);
#line 341 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 1596 "component-event.c"
	}
#line 343 "/home/jim/git/california/src/component/component-event.vala"
	_tmp7_ = orig_dates;
#line 343 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 343 "/home/jim/git/california/src/component/component-event.vala"
	_tmp9_ = _tmp8_;
#line 343 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = diff;
#line 343 "/home/jim/git/california/src/component/component-event.vala"
	_tmp11_ = california_calendar_unit_adjust (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit), _tmp10_);
#line 343 "/home/jim/git/california/src/component/component-event.vala"
	new_end_date = (CaliforniaCalendarDate*) _tmp11_;
#line 345 "/home/jim/git/california/src/component/component-event.vala"
	_tmp12_ = california_component_event_get_is_all_day (self);
#line 345 "/home/jim/git/california/src/component/component-event.vala"
	_tmp13_ = _tmp12_;
#line 345 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp13_) {
#line 1616 "component-event.c"
		CaliforniaCalendarDate* _tmp14_ = NULL;
		CaliforniaCalendarDate* _tmp15_ = NULL;
		CaliforniaCalendarDateSpan* _tmp16_ = NULL;
		CaliforniaCalendarDateSpan* _tmp17_ = NULL;
#line 346 "/home/jim/git/california/src/component/component-event.vala"
		_tmp14_ = new_start_date;
#line 346 "/home/jim/git/california/src/component/component-event.vala"
		_tmp15_ = new_end_date;
#line 346 "/home/jim/git/california/src/component/component-event.vala"
		_tmp16_ = california_calendar_date_span_new (_tmp14_, _tmp15_);
#line 346 "/home/jim/git/california/src/component/component-event.vala"
		_tmp17_ = _tmp16_;
#line 346 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_event_date_span (self, _tmp17_);
#line 346 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp17_);
#line 348 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (new_end_date);
#line 348 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (orig_dates);
#line 348 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 1639 "component-event.c"
	}
#line 351 "/home/jim/git/california/src/component/component-event.vala"
	_tmp18_ = self->priv->_exact_time_span;
#line 351 "/home/jim/git/california/src/component/component-event.vala"
	_tmp19_ = california_calendar_exact_time_span_get_start_exact_time (_tmp18_);
#line 351 "/home/jim/git/california/src/component/component-event.vala"
	_tmp20_ = _tmp19_;
#line 351 "/home/jim/git/california/src/component/component-event.vala"
	_tmp21_ = california_calendar_exact_time_get_tz (_tmp20_);
#line 351 "/home/jim/git/california/src/component/component-event.vala"
	_tmp22_ = _tmp21_;
#line 351 "/home/jim/git/california/src/component/component-event.vala"
	_tmp23_ = new_start_date;
#line 351 "/home/jim/git/california/src/component/component-event.vala"
	_tmp24_ = self->priv->_exact_time_span;
#line 351 "/home/jim/git/california/src/component/component-event.vala"
	_tmp25_ = california_calendar_exact_time_span_get_start_exact_time (_tmp24_);
#line 351 "/home/jim/git/california/src/component/component-event.vala"
	_tmp26_ = _tmp25_;
#line 351 "/home/jim/git/california/src/component/component-event.vala"
	_tmp27_ = california_calendar_exact_time_to_wall_time (_tmp26_);
#line 351 "/home/jim/git/california/src/component/component-event.vala"
	_tmp28_ = _tmp27_;
#line 351 "/home/jim/git/california/src/component/component-event.vala"
	_tmp29_ = california_calendar_exact_time_new (_tmp22_, _tmp23_, _tmp28_);
#line 351 "/home/jim/git/california/src/component/component-event.vala"
	_tmp30_ = _tmp29_;
#line 351 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp28_);
#line 351 "/home/jim/git/california/src/component/component-event.vala"
	new_start_time = _tmp30_;
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp31_ = self->priv->_exact_time_span;
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp32_ = california_calendar_exact_time_span_get_end_exact_time (_tmp31_);
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp33_ = _tmp32_;
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp34_ = california_calendar_exact_time_get_tz (_tmp33_);
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp35_ = _tmp34_;
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp36_ = new_end_date;
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp37_ = self->priv->_exact_time_span;
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp38_ = california_calendar_exact_time_span_get_end_exact_time (_tmp37_);
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp39_ = _tmp38_;
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp40_ = california_calendar_exact_time_to_wall_time (_tmp39_);
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp41_ = _tmp40_;
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp42_ = california_calendar_exact_time_new (_tmp35_, _tmp36_, _tmp41_);
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_tmp43_ = _tmp42_;
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp41_);
#line 357 "/home/jim/git/california/src/component/component-event.vala"
	new_end_time = _tmp43_;
#line 363 "/home/jim/git/california/src/component/component-event.vala"
	_tmp44_ = new_start_time;
#line 363 "/home/jim/git/california/src/component/component-event.vala"
	_tmp45_ = new_end_time;
#line 363 "/home/jim/git/california/src/component/component-event.vala"
	_tmp46_ = california_calendar_exact_time_span_new (_tmp44_, _tmp45_);
#line 363 "/home/jim/git/california/src/component/component-event.vala"
	_tmp47_ = _tmp46_;
#line 363 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_event_exact_time_span (self, _tmp47_);
#line 363 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp47_);
#line 335 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (new_end_time);
#line 335 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (new_start_time);
#line 335 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (new_end_date);
#line 335 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (orig_dates);
#line 1721 "component-event.c"
}


/**
     * Convert an {@link Event} from an all-day to a timed event by only adding the time.
     *
     * Returns with no changes if {@link is_all_day} is false.
     */
void california_component_event_all_day_to_timed_event (CaliforniaComponentEvent* self, CaliforniaCalendarWallTime* start_time, CaliforniaCalendarWallTime* end_time, CaliforniaCalendarTimezone* timezone) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CaliforniaCalendarTimezone* _tmp2_ = NULL;
	CaliforniaCalendarDateSpan* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	CaliforniaCalendarWallTime* _tmp6_ = NULL;
	CaliforniaCalendarExactTime* _tmp7_ = NULL;
	CaliforniaCalendarExactTime* _tmp8_ = NULL;
	CaliforniaCalendarTimezone* _tmp9_ = NULL;
	CaliforniaCalendarDateSpan* _tmp10_ = NULL;
	CaliforniaCalendarDate* _tmp11_ = NULL;
	CaliforniaCalendarDate* _tmp12_ = NULL;
	CaliforniaCalendarWallTime* _tmp13_ = NULL;
	CaliforniaCalendarExactTime* _tmp14_ = NULL;
	CaliforniaCalendarExactTime* _tmp15_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp16_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp17_ = NULL;
#line 371 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 371 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (start_time));
#line 371 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (end_time));
#line 371 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_TIMEZONE (timezone));
#line 373 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = california_component_event_get_is_all_day (self);
#line 373 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _tmp0_;
#line 373 "/home/jim/git/california/src/component/component-event.vala"
	if (!_tmp1_) {
#line 374 "/home/jim/git/california/src/component/component-event.vala"
		return;
#line 1765 "component-event.c"
	}
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = timezone;
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = self->priv->_date_span;
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_tmp5_ = _tmp4_;
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = start_time;
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_tmp7_ = california_calendar_exact_time_new (_tmp2_, _tmp5_, _tmp6_);
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = _tmp7_;
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_tmp9_ = timezone;
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = self->priv->_date_span;
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_tmp11_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_tmp12_ = _tmp11_;
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_tmp13_ = end_time;
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_tmp14_ = california_calendar_exact_time_new (_tmp9_, _tmp12_, _tmp13_);
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_tmp15_ = _tmp14_;
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_tmp16_ = california_calendar_exact_time_span_new (_tmp8_, _tmp15_);
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_tmp17_ = _tmp16_;
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_set_event_exact_time_span (self, _tmp17_);
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp17_);
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp15_);
#line 377 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp8_);
#line 1807 "component-event.c"
}


/**
     * Convert an {@link Event} from a timed event to an all-day event by removing the time.
     *
     * Returns with no changes if {@link is_all_day} is true.
     */
void california_component_event_timed_to_all_day_event (CaliforniaComponentEvent* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 390 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 391 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = california_component_event_get_is_all_day (self);
#line 391 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _tmp0_;
#line 391 "/home/jim/git/california/src/component/component-event.vala"
	if (!_tmp1_) {
#line 1827 "component-event.c"
		CaliforniaCalendarDateSpan* _tmp2_ = NULL;
		CaliforniaCalendarDateSpan* _tmp3_ = NULL;
#line 392 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = california_component_event_get_event_date_span (self, NULL);
#line 392 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = _tmp2_;
#line 392 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_event_date_span (self, _tmp3_);
#line 392 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp3_);
#line 1838 "component-event.c"
	}
}


/**
     * Returns a prettified string describing the {@link Event}'s time span in as concise and
     * economical manner possible.
     *
     * @return null if no time/date information is specified
     */
gchar* california_component_event_get_event_time_pretty_string (CaliforniaComponentEvent* self, CaliforniaCalendarDatePrettyFlag date_flags, CaliforniaCalendarExactTimeSpanPrettyFlag time_flags, CaliforniaCalendarTimezone* timezone) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	CaliforniaCalendarDateSpan* _tmp1_ = NULL;
	CaliforniaCalendarDateSpan* date_span = NULL;
	CaliforniaCalendarTimezone* _tmp3_ = NULL;
	CaliforniaCalendarDateSpan* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	CaliforniaCalendarDateSpan* _tmp6_ = NULL;
	CaliforniaCalendarDate* _tmp7_ = NULL;
	CaliforniaCalendarDate* _tmp8_ = NULL;
	CaliforniaCalendarYear* _tmp9_ = NULL;
	CaliforniaCalendarYear* _tmp10_ = NULL;
	CaliforniaCalendarDate* _tmp11_ = NULL;
	CaliforniaCalendarDate* _tmp12_ = NULL;
	CaliforniaCalendarYear* _tmp13_ = NULL;
	CaliforniaCalendarYear* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	CaliforniaCalendarExactTimeSpan* _tmp32_ = NULL;
	CaliforniaCalendarTimezone* _tmp33_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp34_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp35_ = NULL;
	CaliforniaCalendarDatePrettyFlag _tmp36_ = 0;
	CaliforniaCalendarExactTimeSpanPrettyFlag _tmp37_ = 0;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
#line 401 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 401 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_TIMEZONE (timezone), NULL);
#line 403 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = self->priv->_date_span;
#line 403 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_ == NULL) {
#line 1885 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp2_ = NULL;
#line 403 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = self->priv->_exact_time_span;
#line 403 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 1891 "component-event.c"
	} else {
#line 403 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = FALSE;
#line 1895 "component-event.c"
	}
#line 403 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp0_) {
#line 404 "/home/jim/git/california/src/component/component-event.vala"
		result = NULL;
#line 404 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 1903 "component-event.c"
	}
#line 407 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = timezone;
#line 407 "/home/jim/git/california/src/component/component-event.vala"
	_tmp4_ = california_component_event_get_event_date_span (self, _tmp3_);
#line 407 "/home/jim/git/california/src/component/component-event.vala"
	date_span = _tmp4_;
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = date_span;
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp7_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = _tmp7_;
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp9_ = california_calendar_date_get_year (_tmp8_);
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp10_ = _tmp9_;
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp11_ = california_calendar_system_get_today ();
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp12_ = _tmp11_;
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp13_ = california_calendar_date_get_year (_tmp12_);
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp14_ = _tmp13_;
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	_tmp15_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_HASHABLE, GeeHashable), _tmp14_);
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	if (!_tmp15_) {
#line 408 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = TRUE;
#line 1935 "component-event.c"
	} else {
		CaliforniaCalendarDateSpan* _tmp16_ = NULL;
		CaliforniaCalendarDate* _tmp17_ = NULL;
		CaliforniaCalendarDate* _tmp18_ = NULL;
		CaliforniaCalendarYear* _tmp19_ = NULL;
		CaliforniaCalendarYear* _tmp20_ = NULL;
		CaliforniaCalendarDate* _tmp21_ = NULL;
		CaliforniaCalendarDate* _tmp22_ = NULL;
		CaliforniaCalendarYear* _tmp23_ = NULL;
		CaliforniaCalendarYear* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
#line 409 "/home/jim/git/california/src/component/component-event.vala"
		_tmp16_ = date_span;
#line 409 "/home/jim/git/california/src/component/component-event.vala"
		_tmp17_ = california_calendar_span_get_end_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 409 "/home/jim/git/california/src/component/component-event.vala"
		_tmp18_ = _tmp17_;
#line 409 "/home/jim/git/california/src/component/component-event.vala"
		_tmp19_ = california_calendar_date_get_year (_tmp18_);
#line 409 "/home/jim/git/california/src/component/component-event.vala"
		_tmp20_ = _tmp19_;
#line 409 "/home/jim/git/california/src/component/component-event.vala"
		_tmp21_ = california_calendar_system_get_today ();
#line 409 "/home/jim/git/california/src/component/component-event.vala"
		_tmp22_ = _tmp21_;
#line 409 "/home/jim/git/california/src/component/component-event.vala"
		_tmp23_ = california_calendar_date_get_year (_tmp22_);
#line 409 "/home/jim/git/california/src/component/component-event.vala"
		_tmp24_ = _tmp23_;
#line 409 "/home/jim/git/california/src/component/component-event.vala"
		_tmp25_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_HASHABLE, GeeHashable), _tmp24_);
#line 409 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = !_tmp25_;
#line 1969 "component-event.c"
	}
#line 408 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp5_) {
#line 1973 "component-event.c"
		CaliforniaCalendarDatePrettyFlag _tmp26_ = 0;
#line 410 "/home/jim/git/california/src/component/component-event.vala"
		_tmp26_ = date_flags;
#line 410 "/home/jim/git/california/src/component/component-event.vala"
		date_flags = _tmp26_ | CALIFORNIA_CALENDAR_DATE_PRETTY_FLAG_INCLUDE_YEAR;
#line 1979 "component-event.c"
	}
#line 414 "/home/jim/git/california/src/component/component-event.vala"
	_tmp27_ = california_component_event_get_is_all_day (self);
#line 414 "/home/jim/git/california/src/component/component-event.vala"
	_tmp28_ = _tmp27_;
#line 414 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp28_) {
#line 1987 "component-event.c"
		CaliforniaCalendarDateSpan* _tmp29_ = NULL;
		CaliforniaCalendarDatePrettyFlag _tmp30_ = 0;
		gchar* _tmp31_ = NULL;
#line 415 "/home/jim/git/california/src/component/component-event.vala"
		_tmp29_ = date_span;
#line 415 "/home/jim/git/california/src/component/component-event.vala"
		_tmp30_ = date_flags;
#line 415 "/home/jim/git/california/src/component/component-event.vala"
		_tmp31_ = california_calendar_date_span_to_pretty_string (_tmp29_, _tmp30_);
#line 415 "/home/jim/git/california/src/component/component-event.vala"
		result = _tmp31_;
#line 415 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (date_span);
#line 415 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2003 "component-event.c"
	}
#line 417 "/home/jim/git/california/src/component/component-event.vala"
	_tmp32_ = self->priv->_exact_time_span;
#line 417 "/home/jim/git/california/src/component/component-event.vala"
	_tmp33_ = timezone;
#line 417 "/home/jim/git/california/src/component/component-event.vala"
	_tmp34_ = california_calendar_exact_time_span_to_timezone (_tmp32_, _tmp33_);
#line 417 "/home/jim/git/california/src/component/component-event.vala"
	_tmp35_ = _tmp34_;
#line 417 "/home/jim/git/california/src/component/component-event.vala"
	_tmp36_ = date_flags;
#line 417 "/home/jim/git/california/src/component/component-event.vala"
	_tmp37_ = time_flags;
#line 417 "/home/jim/git/california/src/component/component-event.vala"
	_tmp38_ = california_calendar_exact_time_span_to_pretty_string (_tmp35_, _tmp36_, _tmp37_);
#line 417 "/home/jim/git/california/src/component/component-event.vala"
	_tmp39_ = _tmp38_;
#line 417 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (_tmp35_);
#line 417 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp39_;
#line 417 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (date_span);
#line 417 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2029 "component-event.c"
}


/**
     * @inheritDoc
     */
static gboolean california_component_event_real_is_valid (CaliforniaComponentInstance* base, gboolean and_useful) {
	CaliforniaComponentEvent * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
#line 423 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 424 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = and_useful;
#line 424 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_) {
#line 2050 "component-event.c"
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 424 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = self->priv->_summary;
#line 424 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = california_string_is_empty (_tmp2_);
#line 424 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp3_;
#line 2059 "component-event.c"
	} else {
#line 424 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = FALSE;
#line 2063 "component-event.c"
	}
#line 424 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp0_) {
#line 425 "/home/jim/git/california/src/component/component-event.vala"
		result = FALSE;
#line 425 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2071 "component-event.c"
	}
#line 427 "/home/jim/git/california/src/component/component-event.vala"
	_tmp5_ = and_useful;
#line 427 "/home/jim/git/california/src/component/component-event.vala"
	_tmp6_ = CALIFORNIA_COMPONENT_INSTANCE_CLASS (california_component_event_parent_class)->is_valid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance), _tmp5_);
#line 427 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp6_) {
#line 2079 "component-event.c"
		gboolean _tmp7_ = FALSE;
		CaliforniaCalendarDateSpan* _tmp8_ = NULL;
#line 427 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = self->priv->_date_span;
#line 427 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp8_ != NULL) {
#line 427 "/home/jim/git/california/src/component/component-event.vala"
			_tmp7_ = TRUE;
#line 2088 "component-event.c"
		} else {
			CaliforniaCalendarExactTimeSpan* _tmp9_ = NULL;
#line 427 "/home/jim/git/california/src/component/component-event.vala"
			_tmp9_ = self->priv->_exact_time_span;
#line 427 "/home/jim/git/california/src/component/component-event.vala"
			_tmp7_ = _tmp9_ != NULL;
#line 2095 "component-event.c"
		}
#line 427 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = _tmp7_;
#line 2099 "component-event.c"
	} else {
#line 427 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = FALSE;
#line 2103 "component-event.c"
	}
#line 427 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp4_;
#line 427 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2109 "component-event.c"
}


/**
     * Compares an {@link Event} to another and returns which is chronologically first.
     *
     * The method attempts to compare DATE-TIMEs first, then DATEs, coercing a DATE-TIME into a DATE
     * if necessary.
     *
     * If both events have the same chronological time, they're sorted by summary in lexographical
     * order.
     *
     * {@link dtstamp} is the third comparison attempted.  In general, dtstamp is the time the
     * {@link Component} was created.
     *
     * Finally, UIDs are used to stabilize the sort.
     *
     * @inheritDoc
     */
static gint california_component_event_real_compare_to (GeeComparable* base, CaliforniaComponentEvent* other) {
	CaliforniaComponentEvent * self;
	gint result = 0;
	CaliforniaComponentEvent* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gint compare = 0;
	gboolean _tmp13_ = FALSE;
	CaliforniaCalendarExactTimeSpan* _tmp14_ = NULL;
	gint _tmp42_ = 0;
	gboolean _tmp43_ = FALSE;
	CaliforniaComponentDateTime* _tmp44_ = NULL;
	CaliforniaComponentDateTime* _tmp45_ = NULL;
	GCompareFunc _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	CaliforniaComponentEvent* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	CaliforniaCalendarExactTime* _tmp62_ = NULL;
	CaliforniaCalendarExactTime* _tmp63_ = NULL;
	CaliforniaComponentEvent* _tmp64_ = NULL;
	CaliforniaCalendarExactTime* _tmp65_ = NULL;
	CaliforniaCalendarExactTime* _tmp66_ = NULL;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	gint _tmp69_ = 0;
	gint _tmp70_ = 0;
	CaliforniaComponentEvent* _tmp71_ = NULL;
	gint _tmp72_ = 0;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	gboolean _tmp75_ = FALSE;
	CaliforniaBackingCalendarSource* _tmp76_ = NULL;
	CaliforniaBackingCalendarSource* _tmp77_ = NULL;
	CaliforniaComponentUID* _tmp88_ = NULL;
	CaliforniaComponentUID* _tmp89_ = NULL;
	CaliforniaComponentEvent* _tmp90_ = NULL;
	CaliforniaComponentUID* _tmp91_ = NULL;
	CaliforniaComponentUID* _tmp92_ = NULL;
	gint _tmp93_ = 0;
#line 446 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 446 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (other), 0);
#line 447 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = other;
#line 447 "/home/jim/git/california/src/component/component-event.vala"
	if (self == _tmp0_) {
#line 448 "/home/jim/git/california/src/component/component-event.vala"
		result = 0;
#line 448 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2186 "component-event.c"
	}
#line 451 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = california_component_event_get_is_all_day (self);
#line 451 "/home/jim/git/california/src/component/component-event.vala"
	_tmp3_ = _tmp2_;
#line 451 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp3_) {
#line 2194 "component-event.c"
		CaliforniaComponentEvent* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 451 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = other;
#line 451 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = california_component_event_get_is_all_day (_tmp4_);
#line 451 "/home/jim/git/california/src/component/component-event.vala"
		_tmp6_ = _tmp5_;
#line 451 "/home/jim/git/california/src/component/component-event.vala"
		_tmp1_ = !_tmp6_;
#line 2206 "component-event.c"
	} else {
#line 451 "/home/jim/git/california/src/component/component-event.vala"
		_tmp1_ = FALSE;
#line 2210 "component-event.c"
	}
#line 451 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_) {
#line 452 "/home/jim/git/california/src/component/component-event.vala"
		result = -1;
#line 452 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2218 "component-event.c"
	}
#line 454 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = california_component_event_get_is_all_day (self);
#line 454 "/home/jim/git/california/src/component/component-event.vala"
	_tmp9_ = _tmp8_;
#line 454 "/home/jim/git/california/src/component/component-event.vala"
	if (!_tmp9_) {
#line 2226 "component-event.c"
		CaliforniaComponentEvent* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
#line 454 "/home/jim/git/california/src/component/component-event.vala"
		_tmp10_ = other;
#line 454 "/home/jim/git/california/src/component/component-event.vala"
		_tmp11_ = california_component_event_get_is_all_day (_tmp10_);
#line 454 "/home/jim/git/california/src/component/component-event.vala"
		_tmp12_ = _tmp11_;
#line 454 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = _tmp12_;
#line 2238 "component-event.c"
	} else {
#line 454 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = FALSE;
#line 2242 "component-event.c"
	}
#line 454 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp7_) {
#line 455 "/home/jim/git/california/src/component/component-event.vala"
		result = 1;
#line 455 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2250 "component-event.c"
	}
#line 459 "/home/jim/git/california/src/component/component-event.vala"
	_tmp14_ = self->priv->_exact_time_span;
#line 459 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp14_ != NULL) {
#line 2256 "component-event.c"
		CaliforniaComponentEvent* _tmp15_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp16_ = NULL;
#line 459 "/home/jim/git/california/src/component/component-event.vala"
		_tmp15_ = other;
#line 459 "/home/jim/git/california/src/component/component-event.vala"
		_tmp16_ = _tmp15_->priv->_exact_time_span;
#line 459 "/home/jim/git/california/src/component/component-event.vala"
		_tmp13_ = _tmp16_ != NULL;
#line 2265 "component-event.c"
	} else {
#line 459 "/home/jim/git/california/src/component/component-event.vala"
		_tmp13_ = FALSE;
#line 2269 "component-event.c"
	}
#line 459 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp13_) {
#line 2273 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp17_ = NULL;
		CaliforniaComponentEvent* _tmp18_ = NULL;
		CaliforniaCalendarExactTimeSpan* _tmp19_ = NULL;
		gint _tmp20_ = 0;
#line 460 "/home/jim/git/california/src/component/component-event.vala"
		_tmp17_ = self->priv->_exact_time_span;
#line 460 "/home/jim/git/california/src/component/component-event.vala"
		_tmp18_ = other;
#line 460 "/home/jim/git/california/src/component/component-event.vala"
		_tmp19_ = _tmp18_->priv->_exact_time_span;
#line 460 "/home/jim/git/california/src/component/component-event.vala"
		_tmp20_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp19_);
#line 460 "/home/jim/git/california/src/component/component-event.vala"
		compare = _tmp20_;
#line 2288 "component-event.c"
	} else {
		gboolean _tmp21_ = FALSE;
		CaliforniaCalendarDateSpan* _tmp22_ = NULL;
#line 461 "/home/jim/git/california/src/component/component-event.vala"
		_tmp22_ = self->priv->_date_span;
#line 461 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp22_ != NULL) {
#line 2296 "component-event.c"
			CaliforniaComponentEvent* _tmp23_ = NULL;
			CaliforniaCalendarDateSpan* _tmp24_ = NULL;
#line 461 "/home/jim/git/california/src/component/component-event.vala"
			_tmp23_ = other;
#line 461 "/home/jim/git/california/src/component/component-event.vala"
			_tmp24_ = _tmp23_->priv->_date_span;
#line 461 "/home/jim/git/california/src/component/component-event.vala"
			_tmp21_ = _tmp24_ != NULL;
#line 2305 "component-event.c"
		} else {
#line 461 "/home/jim/git/california/src/component/component-event.vala"
			_tmp21_ = FALSE;
#line 2309 "component-event.c"
		}
#line 461 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp21_) {
#line 2313 "component-event.c"
			CaliforniaCalendarDateSpan* _tmp25_ = NULL;
			CaliforniaComponentEvent* _tmp26_ = NULL;
			CaliforniaCalendarDateSpan* _tmp27_ = NULL;
			gint _tmp28_ = 0;
#line 462 "/home/jim/git/california/src/component/component-event.vala"
			_tmp25_ = self->priv->_date_span;
#line 462 "/home/jim/git/california/src/component/component-event.vala"
			_tmp26_ = other;
#line 462 "/home/jim/git/california/src/component/component-event.vala"
			_tmp27_ = _tmp26_->priv->_date_span;
#line 462 "/home/jim/git/california/src/component/component-event.vala"
			_tmp28_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COMPARABLE, GeeComparable), G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan));
#line 462 "/home/jim/git/california/src/component/component-event.vala"
			compare = _tmp28_;
#line 2328 "component-event.c"
		} else {
			CaliforniaCalendarExactTimeSpan* _tmp29_ = NULL;
#line 463 "/home/jim/git/california/src/component/component-event.vala"
			_tmp29_ = self->priv->_exact_time_span;
#line 463 "/home/jim/git/california/src/component/component-event.vala"
			if (_tmp29_ != NULL) {
#line 2335 "component-event.c"
				CaliforniaCalendarExactTimeSpan* _tmp30_ = NULL;
				CaliforniaCalendarDateSpan* _tmp31_ = NULL;
				CaliforniaCalendarDateSpan* _tmp32_ = NULL;
				CaliforniaComponentEvent* _tmp33_ = NULL;
				CaliforniaCalendarDateSpan* _tmp34_ = NULL;
				gint _tmp35_ = 0;
#line 464 "/home/jim/git/california/src/component/component-event.vala"
				_tmp30_ = self->priv->_exact_time_span;
#line 464 "/home/jim/git/california/src/component/component-event.vala"
				_tmp31_ = california_calendar_date_span_new_from_exact_time_span (_tmp30_);
#line 464 "/home/jim/git/california/src/component/component-event.vala"
				_tmp32_ = _tmp31_;
#line 464 "/home/jim/git/california/src/component/component-event.vala"
				_tmp33_ = other;
#line 464 "/home/jim/git/california/src/component/component-event.vala"
				_tmp34_ = _tmp33_->priv->_date_span;
#line 464 "/home/jim/git/california/src/component/component-event.vala"
				_tmp35_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_COMPARABLE, GeeComparable), G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan));
#line 464 "/home/jim/git/california/src/component/component-event.vala"
				compare = _tmp35_;
#line 464 "/home/jim/git/california/src/component/component-event.vala"
				_g_object_unref0 (_tmp32_);
#line 2358 "component-event.c"
			} else {
				CaliforniaCalendarDateSpan* _tmp36_ = NULL;
				CaliforniaComponentEvent* _tmp37_ = NULL;
				CaliforniaCalendarExactTimeSpan* _tmp38_ = NULL;
				CaliforniaCalendarDateSpan* _tmp39_ = NULL;
				CaliforniaCalendarDateSpan* _tmp40_ = NULL;
				gint _tmp41_ = 0;
#line 466 "/home/jim/git/california/src/component/component-event.vala"
				_tmp36_ = self->priv->_date_span;
#line 466 "/home/jim/git/california/src/component/component-event.vala"
				_tmp37_ = other;
#line 466 "/home/jim/git/california/src/component/component-event.vala"
				_tmp38_ = _tmp37_->priv->_exact_time_span;
#line 466 "/home/jim/git/california/src/component/component-event.vala"
				_tmp39_ = california_calendar_date_span_new_from_exact_time_span (_tmp38_);
#line 466 "/home/jim/git/california/src/component/component-event.vala"
				_tmp40_ = _tmp39_;
#line 466 "/home/jim/git/california/src/component/component-event.vala"
				_tmp41_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_COMPARABLE, GeeComparable), G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, CALIFORNIA_CALENDAR_TYPE_UNIT_SPAN, CaliforniaCalendarUnitSpan));
#line 466 "/home/jim/git/california/src/component/component-event.vala"
				compare = _tmp41_;
#line 466 "/home/jim/git/california/src/component/component-event.vala"
				_g_object_unref0 (_tmp40_);
#line 2382 "component-event.c"
			}
		}
	}
#line 468 "/home/jim/git/california/src/component/component-event.vala"
	_tmp42_ = compare;
#line 468 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp42_ != 0) {
#line 469 "/home/jim/git/california/src/component/component-event.vala"
		result = compare;
#line 469 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2394 "component-event.c"
	}
#line 472 "/home/jim/git/california/src/component/component-event.vala"
	_tmp44_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 472 "/home/jim/git/california/src/component/component-event.vala"
	_tmp45_ = _tmp44_;
#line 472 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp45_ != NULL) {
#line 2402 "component-event.c"
		CaliforniaComponentEvent* _tmp46_ = NULL;
		CaliforniaComponentDateTime* _tmp47_ = NULL;
		CaliforniaComponentDateTime* _tmp48_ = NULL;
#line 472 "/home/jim/git/california/src/component/component-event.vala"
		_tmp46_ = other;
#line 472 "/home/jim/git/california/src/component/component-event.vala"
		_tmp47_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 472 "/home/jim/git/california/src/component/component-event.vala"
		_tmp48_ = _tmp47_;
#line 472 "/home/jim/git/california/src/component/component-event.vala"
		_tmp43_ = _tmp48_ != NULL;
#line 2414 "component-event.c"
	} else {
#line 472 "/home/jim/git/california/src/component/component-event.vala"
		_tmp43_ = FALSE;
#line 2418 "component-event.c"
	}
#line 472 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp43_) {
#line 2422 "component-event.c"
		CaliforniaComponentDateTime* _tmp49_ = NULL;
		CaliforniaComponentDateTime* _tmp50_ = NULL;
		CaliforniaComponentEvent* _tmp51_ = NULL;
		CaliforniaComponentDateTime* _tmp52_ = NULL;
		CaliforniaComponentDateTime* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
#line 473 "/home/jim/git/california/src/component/component-event.vala"
		_tmp49_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 473 "/home/jim/git/california/src/component/component-event.vala"
		_tmp50_ = _tmp49_;
#line 473 "/home/jim/git/california/src/component/component-event.vala"
		_tmp51_ = other;
#line 473 "/home/jim/git/california/src/component/component-event.vala"
		_tmp52_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 473 "/home/jim/git/california/src/component/component-event.vala"
		_tmp53_ = _tmp52_;
#line 473 "/home/jim/git/california/src/component/component-event.vala"
		_tmp54_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp53_);
#line 473 "/home/jim/git/california/src/component/component-event.vala"
		compare = _tmp54_;
#line 474 "/home/jim/git/california/src/component/component-event.vala"
		_tmp55_ = compare;
#line 474 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp55_ != 0) {
#line 475 "/home/jim/git/california/src/component/component-event.vala"
			result = compare;
#line 475 "/home/jim/git/california/src/component/component-event.vala"
			return result;
#line 2452 "component-event.c"
		}
	}
#line 479 "/home/jim/git/california/src/component/component-event.vala"
	_tmp56_ = g_strcmp0;
#line 479 "/home/jim/git/california/src/component/component-event.vala"
	_tmp57_ = self->priv->_summary;
#line 479 "/home/jim/git/california/src/component/component-event.vala"
	_tmp58_ = other;
#line 479 "/home/jim/git/california/src/component/component-event.vala"
	_tmp59_ = _tmp58_->priv->_summary;
#line 479 "/home/jim/git/california/src/component/component-event.vala"
	_tmp60_ = _tmp56_ (_tmp57_, _tmp59_);
#line 479 "/home/jim/git/california/src/component/component-event.vala"
	compare = _tmp60_;
#line 480 "/home/jim/git/california/src/component/component-event.vala"
	_tmp61_ = compare;
#line 480 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp61_ != 0) {
#line 481 "/home/jim/git/california/src/component/component-event.vala"
		result = compare;
#line 481 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2475 "component-event.c"
	}
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_tmp62_ = california_component_instance_get_dtstamp (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_tmp63_ = _tmp62_;
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_tmp64_ = other;
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_tmp65_ = california_component_instance_get_dtstamp (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_tmp66_ = _tmp65_;
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	_tmp67_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp66_);
#line 484 "/home/jim/git/california/src/component/component-event.vala"
	compare = _tmp67_;
#line 485 "/home/jim/git/california/src/component/component-event.vala"
	_tmp68_ = compare;
#line 485 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp68_ != 0) {
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		result = compare;
#line 486 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2499 "component-event.c"
	}
#line 489 "/home/jim/git/california/src/component/component-event.vala"
	_tmp69_ = california_component_instance_get_sequence (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 489 "/home/jim/git/california/src/component/component-event.vala"
	_tmp70_ = _tmp69_;
#line 489 "/home/jim/git/california/src/component/component-event.vala"
	_tmp71_ = other;
#line 489 "/home/jim/git/california/src/component/component-event.vala"
	_tmp72_ = california_component_instance_get_sequence (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 489 "/home/jim/git/california/src/component/component-event.vala"
	_tmp73_ = _tmp72_;
#line 489 "/home/jim/git/california/src/component/component-event.vala"
	compare = _tmp70_ - _tmp73_;
#line 490 "/home/jim/git/california/src/component/component-event.vala"
	_tmp74_ = compare;
#line 490 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp74_ != 0) {
#line 491 "/home/jim/git/california/src/component/component-event.vala"
		result = compare;
#line 491 "/home/jim/git/california/src/component/component-event.vala"
		return result;
#line 2521 "component-event.c"
	}
#line 494 "/home/jim/git/california/src/component/component-event.vala"
	_tmp76_ = california_component_instance_get_calendar_source (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 494 "/home/jim/git/california/src/component/component-event.vala"
	_tmp77_ = _tmp76_;
#line 494 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp77_ != NULL) {
#line 2529 "component-event.c"
		CaliforniaComponentEvent* _tmp78_ = NULL;
		CaliforniaBackingCalendarSource* _tmp79_ = NULL;
		CaliforniaBackingCalendarSource* _tmp80_ = NULL;
#line 494 "/home/jim/git/california/src/component/component-event.vala"
		_tmp78_ = other;
#line 494 "/home/jim/git/california/src/component/component-event.vala"
		_tmp79_ = california_component_instance_get_calendar_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 494 "/home/jim/git/california/src/component/component-event.vala"
		_tmp80_ = _tmp79_;
#line 494 "/home/jim/git/california/src/component/component-event.vala"
		_tmp75_ = _tmp80_ != NULL;
#line 2541 "component-event.c"
	} else {
#line 494 "/home/jim/git/california/src/component/component-event.vala"
		_tmp75_ = FALSE;
#line 2545 "component-event.c"
	}
#line 494 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp75_) {
#line 2549 "component-event.c"
		CaliforniaBackingCalendarSource* _tmp81_ = NULL;
		CaliforniaBackingCalendarSource* _tmp82_ = NULL;
		CaliforniaComponentEvent* _tmp83_ = NULL;
		CaliforniaBackingCalendarSource* _tmp84_ = NULL;
		CaliforniaBackingCalendarSource* _tmp85_ = NULL;
		gint _tmp86_ = 0;
		gint _tmp87_ = 0;
#line 495 "/home/jim/git/california/src/component/component-event.vala"
		_tmp81_ = california_component_instance_get_calendar_source (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 495 "/home/jim/git/california/src/component/component-event.vala"
		_tmp82_ = _tmp81_;
#line 495 "/home/jim/git/california/src/component/component-event.vala"
		_tmp83_ = other;
#line 495 "/home/jim/git/california/src/component/component-event.vala"
		_tmp84_ = california_component_instance_get_calendar_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 495 "/home/jim/git/california/src/component/component-event.vala"
		_tmp85_ = _tmp84_;
#line 495 "/home/jim/git/california/src/component/component-event.vala"
		_tmp86_ = california_backing_source_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, CALIFORNIA_BACKING_TYPE_SOURCE, CaliforniaBackingSource));
#line 495 "/home/jim/git/california/src/component/component-event.vala"
		compare = _tmp86_;
#line 496 "/home/jim/git/california/src/component/component-event.vala"
		_tmp87_ = compare;
#line 496 "/home/jim/git/california/src/component/component-event.vala"
		if (_tmp87_ != 0) {
#line 497 "/home/jim/git/california/src/component/component-event.vala"
			result = compare;
#line 497 "/home/jim/git/california/src/component/component-event.vala"
			return result;
#line 2579 "component-event.c"
		}
	}
#line 501 "/home/jim/git/california/src/component/component-event.vala"
	_tmp88_ = california_component_instance_get_uid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 501 "/home/jim/git/california/src/component/component-event.vala"
	_tmp89_ = _tmp88_;
#line 501 "/home/jim/git/california/src/component/component-event.vala"
	_tmp90_ = other;
#line 501 "/home/jim/git/california/src/component/component-event.vala"
	_tmp91_ = california_component_instance_get_uid (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 501 "/home/jim/git/california/src/component/component-event.vala"
	_tmp92_ = _tmp91_;
#line 501 "/home/jim/git/california/src/component/component-event.vala"
	_tmp93_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp92_);
#line 501 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp93_;
#line 501 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2598 "component-event.c"
}


static gchar* california_component_event_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaComponentEvent * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CaliforniaComponentDateTime* _tmp1_ = NULL;
	CaliforniaComponentDateTime* _tmp2_ = NULL;
	gchar* _tmp7_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp8_ = NULL;
	CaliforniaComponentUID* _tmp13_ = NULL;
	CaliforniaComponentUID* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
#line 504 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 507 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 507 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = _tmp1_;
#line 507 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp2_ != NULL) {
#line 2627 "component-event.c"
		CaliforniaComponentDateTime* _tmp3_ = NULL;
		CaliforniaComponentDateTime* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 507 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = california_component_instance_get_rid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 507 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = _tmp3_;
#line 507 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 507 "/home/jim/git/california/src/component/component-event.vala"
		_g_free0 (_tmp0_);
#line 507 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp5_;
#line 2641 "component-event.c"
	} else {
		gchar* _tmp6_ = NULL;
#line 507 "/home/jim/git/california/src/component/component-event.vala"
		_tmp6_ = g_strdup ("(no-recurring)");
#line 507 "/home/jim/git/california/src/component/component-event.vala"
		_g_free0 (_tmp0_);
#line 507 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp6_;
#line 2650 "component-event.c"
	}
#line 510 "/home/jim/git/california/src/component/component-event.vala"
	_tmp8_ = self->priv->_exact_time_span;
#line 510 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp8_ != NULL) {
#line 2656 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 510 "/home/jim/git/california/src/component/component-event.vala"
		_tmp9_ = self->priv->_exact_time_span;
#line 510 "/home/jim/git/california/src/component/component-event.vala"
		_tmp10_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 510 "/home/jim/git/california/src/component/component-event.vala"
		_g_free0 (_tmp7_);
#line 510 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = _tmp10_;
#line 2667 "component-event.c"
	} else {
		CaliforniaCalendarDateSpan* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 510 "/home/jim/git/california/src/component/component-event.vala"
		_tmp11_ = self->priv->_date_span;
#line 510 "/home/jim/git/california/src/component/component-event.vala"
		_tmp12_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 510 "/home/jim/git/california/src/component/component-event.vala"
		_g_free0 (_tmp7_);
#line 510 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = _tmp12_;
#line 2679 "component-event.c"
	}
#line 505 "/home/jim/git/california/src/component/component-event.vala"
	_tmp13_ = california_component_instance_get_uid (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 505 "/home/jim/git/california/src/component/component-event.vala"
	_tmp14_ = _tmp13_;
#line 505 "/home/jim/git/california/src/component/component-event.vala"
	_tmp15_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 505 "/home/jim/git/california/src/component/component-event.vala"
	_tmp16_ = _tmp15_;
#line 505 "/home/jim/git/california/src/component/component-event.vala"
	_tmp17_ = california_component_instance_get_sequence (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_COMPONENT_TYPE_INSTANCE, CaliforniaComponentInstance));
#line 505 "/home/jim/git/california/src/component/component-event.vala"
	_tmp18_ = _tmp17_;
#line 505 "/home/jim/git/california/src/component/component-event.vala"
	_tmp19_ = self->priv->_summary;
#line 505 "/home/jim/git/california/src/component/component-event.vala"
	_tmp20_ = g_strdup_printf ("Event %s/rid=%s/%d \"%s\" (%s)", _tmp16_, _tmp0_, _tmp18_, _tmp19_, _tmp7_);
#line 505 "/home/jim/git/california/src/component/component-event.vala"
	_tmp21_ = _tmp20_;
#line 505 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (_tmp16_);
#line 505 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp21_;
#line 505 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (_tmp7_);
#line 505 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (_tmp0_);
#line 505 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2709 "component-event.c"
}


const gchar* california_component_event_get_summary (CaliforniaComponentEvent* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_summary;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2724 "component-event.c"
}


void california_component_event_set_summary (CaliforniaComponentEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_summary);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_summary = _tmp1_;
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "summary");
#line 2743 "component-event.c"
}


const gchar* california_component_event_get_description (CaliforniaComponentEvent* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_description;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2758 "component-event.c"
}


void california_component_event_set_description (CaliforniaComponentEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_description);
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_description = _tmp1_;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "description");
#line 2777 "component-event.c"
}


CaliforniaCalendarExactTimeSpan* california_component_event_get_exact_time_span (CaliforniaComponentEvent* self) {
	CaliforniaCalendarExactTimeSpan* result;
	CaliforniaCalendarExactTimeSpan* _tmp0_ = NULL;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_exact_time_span;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2792 "component-event.c"
}


static void california_component_event_set_exact_time_span (CaliforniaComponentEvent* self, CaliforniaCalendarExactTimeSpan* value) {
	CaliforniaCalendarExactTimeSpan* _tmp0_ = NULL;
	CaliforniaCalendarExactTimeSpan* _tmp1_ = NULL;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (self->priv->_exact_time_span);
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_exact_time_span = _tmp1_;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "exact-time-span");
#line 2811 "component-event.c"
}


CaliforniaCalendarDateSpan* california_component_event_get_date_span (CaliforniaComponentEvent* self) {
	CaliforniaCalendarDateSpan* result;
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_date_span;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2826 "component-event.c"
}


static void california_component_event_set_date_span (CaliforniaComponentEvent* self, CaliforniaCalendarDateSpan* value) {
	CaliforniaCalendarDateSpan* _tmp0_ = NULL;
	CaliforniaCalendarDateSpan* _tmp1_ = NULL;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (self->priv->_date_span);
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_date_span = _tmp1_;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "date-span");
#line 2845 "component-event.c"
}


gboolean california_component_event_get_is_all_day (CaliforniaComponentEvent* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	CaliforniaCalendarDateSpan* _tmp1_ = NULL;
#line 64 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), FALSE);
#line 65 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = self->priv->_date_span;
#line 65 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp1_ != NULL) {
#line 2859 "component-event.c"
		CaliforniaCalendarExactTimeSpan* _tmp2_ = NULL;
#line 65 "/home/jim/git/california/src/component/component-event.vala"
		_tmp2_ = self->priv->_exact_time_span;
#line 65 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 2865 "component-event.c"
	} else {
#line 65 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = FALSE;
#line 2869 "component-event.c"
	}
#line 65 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 65 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2875 "component-event.c"
}


gboolean california_component_event_get_is_day_spanning (CaliforniaComponentEvent* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 73 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), FALSE);
#line 74 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = california_component_event_get_is_all_day (self);
#line 74 "/home/jim/git/california/src/component/component-event.vala"
	_tmp2_ = _tmp1_;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
	if (_tmp2_) {
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = TRUE;
#line 2894 "component-event.c"
	} else {
		CaliforniaCalendarExactTimeSpan* _tmp3_ = NULL;
		CaliforniaCalendarDuration* _tmp4_ = NULL;
		CaliforniaCalendarDuration* _tmp5_ = NULL;
		CaliforniaCalendarDuration* _tmp6_ = NULL;
		guint64 _tmp7_ = 0ULL;
		guint64 _tmp8_ = 0ULL;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp3_ = self->priv->_exact_time_span;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp4_ = california_calendar_exact_time_span_get_duration (_tmp3_);
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp5_ = _tmp4_;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp6_ = _tmp5_;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp7_ = california_calendar_duration_get_days (_tmp6_);
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp8_ = _tmp7_;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_tmp0_ = _tmp8_ >= ((guint64) 1);
#line 74 "/home/jim/git/california/src/component/component-event.vala"
		_g_object_unref0 (_tmp6_);
#line 2918 "component-event.c"
	}
#line 74 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 74 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2924 "component-event.c"
}


const gchar* california_component_event_get_location (CaliforniaComponentEvent* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), NULL);
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_location;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2939 "component-event.c"
}


void california_component_event_set_location (CaliforniaComponentEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_location);
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_location = _tmp1_;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "location");
#line 2958 "component-event.c"
}


CaliforniaComponentEventStatus california_component_event_get_status (CaliforniaComponentEvent* self) {
	CaliforniaComponentEventStatus result;
	CaliforniaComponentEventStatus _tmp0_ = 0;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	g_return_val_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self), 0);
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = self->priv->_status;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	result = _tmp0_;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	return result;
#line 2973 "component-event.c"
}


void california_component_event_set_status (CaliforniaComponentEvent* self, CaliforniaComponentEventStatus value) {
	CaliforniaComponentEventStatus _tmp0_ = 0;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	g_return_if_fail (CALIFORNIA_COMPONENT_IS_EVENT (self));
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	_tmp0_ = value;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_status = _tmp0_;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	g_object_notify ((GObject *) self, "status");
#line 2987 "component-event.c"
}


static void california_component_event_class_init (CaliforniaComponentEventClass * klass) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_parent_class = g_type_class_peek_parent (klass);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaComponentEventPrivate));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	((CaliforniaComponentInstanceClass *) klass)->update_from_component = california_component_event_real_update_from_component;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	((CaliforniaComponentInstanceClass *) klass)->clone = california_component_event_real_clone;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	((CaliforniaComponentInstanceClass *) klass)->is_valid = california_component_event_real_is_valid;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	((CaliforniaBaseObjectClass *) klass)->to_string = california_component_event_real_to_string;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_component_event_get_property;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_component_event_set_property;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	G_OBJECT_CLASS (klass)->finalize = california_component_event_finalize;
#line 3010 "component-event.c"
	/**
	     * Summary (title) of {@link Event}.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_SUMMARY, g_param_spec_string ("summary", "summary", "summary", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3016 "component-event.c"
	/**
	     * Description of {@link Event}.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3022 "component-event.c"
	/**
	     * {@link Calendar.ExactTimeSpan} of the {@link Event}'s dtstart and dtend.
	     *
	     * This is only non-null if the VEVENT specifies a DATE-TIME for both properties, otherwise
	     * {@link date_span} will be specified.
	     *
	     * @see set_exact_time_span
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_EXACT_TIME_SPAN, g_param_spec_object ("exact-time-span", "exact-time-span", "exact-time-span", CALIFORNIA_CALENDAR_TYPE_EXACT_TIME_SPAN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 3033 "component-event.c"
	/**
	     * {@link Calendar.DateSpan} of the {@link Event}'s dtstart and dtend.
	     *
	     * This is only non-null if the VEVENT defines a DATE for one or both properties.  Generally
	     * this indicates an "all day" or multi-day event.
	     *
	     * @see set_date_span
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_DATE_SPAN, g_param_spec_object ("date-span", "date-span", "date-span", CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 3044 "component-event.c"
	/**
	     * Convenience property for determining if an all-day event or not.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_IS_ALL_DAY, g_param_spec_boolean ("is-all-day", "is-all-day", "is-all-day", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 3050 "component-event.c"
	/**
	     * Convenience property for determining if {@link Event} spans one or more full days.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_IS_DAY_SPANNING, g_param_spec_boolean ("is-day-spanning", "is-day-spanning", "is-day-spanning", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 3056 "component-event.c"
	/**
	     * Location of an {@link Event}.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_LOCATION, g_param_spec_string ("location", "location", "location", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3062 "component-event.c"
	/**
	     * Status (confirmation) of an {@link Event}.
	     */
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_COMPONENT_EVENT_STATUS, g_param_spec_enum ("status", "status", "status", CALIFORNIA_COMPONENT_EVENT_TYPE_STATUS, CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3068 "component-event.c"
}


static void california_component_event_gee_comparable_interface_init (GeeComparableIface * iface) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	california_component_event_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) california_component_event_real_compare_to;
#line 3077 "component-event.c"
}


static void california_component_event_instance_init (CaliforniaComponentEvent * self) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	self->priv = CALIFORNIA_COMPONENT_EVENT_GET_PRIVATE (self);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_summary = NULL;
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_description = NULL;
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_exact_time_span = NULL;
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_date_span = NULL;
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_location = NULL;
#line 86 "/home/jim/git/california/src/component/component-event.vala"
	self->priv->_status = CALIFORNIA_COMPONENT_EVENT_STATUS_CONFIRMED;
#line 3096 "component-event.c"
}


static void california_component_event_finalize (GObject* obj) {
	CaliforniaComponentEvent * self;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 33 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_summary);
#line 38 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_description);
#line 48 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (self->priv->_exact_time_span);
#line 58 "/home/jim/git/california/src/component/component-event.vala"
	_g_object_unref0 (self->priv->_date_span);
#line 81 "/home/jim/git/california/src/component/component-event.vala"
	_g_free0 (self->priv->_location);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	G_OBJECT_CLASS (california_component_event_parent_class)->finalize (obj);
#line 3116 "component-event.c"
}


/**
 * A mutable representation of an iCalendar Event.
 *
 * See [[https://tools.ietf.org/html/rfc5545#section-3.6.1]]
 */
GType california_component_event_get_type (void) {
	static volatile gsize california_component_event_type_id__volatile = 0;
	if (g_once_init_enter (&california_component_event_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaComponentEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_component_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaComponentEvent), 0, (GInstanceInitFunc) california_component_event_instance_init, NULL };
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) california_component_event_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_component_event_type_id;
		california_component_event_type_id = g_type_register_static (CALIFORNIA_COMPONENT_TYPE_INSTANCE, "CaliforniaComponentEvent", &g_define_type_info, 0);
		g_type_add_interface_static (california_component_event_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_once_init_leave (&california_component_event_type_id__volatile, california_component_event_type_id);
	}
	return california_component_event_type_id__volatile;
}


static void _vala_california_component_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaComponentEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	switch (property_id) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_SUMMARY:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_string (value, california_component_event_get_summary (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_DESCRIPTION:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_string (value, california_component_event_get_description (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_EXACT_TIME_SPAN:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_object (value, california_component_event_get_exact_time_span (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_DATE_SPAN:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_object (value, california_component_event_get_date_span (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_IS_ALL_DAY:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_boolean (value, california_component_event_get_is_all_day (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_IS_DAY_SPANNING:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_boolean (value, california_component_event_get_is_day_spanning (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_LOCATION:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_string (value, california_component_event_get_location (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_STATUS:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		g_value_set_enum (value, california_component_event_get_status (self));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 3192 "component-event.c"
		default:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 3198 "component-event.c"
	}
}


static void _vala_california_component_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaComponentEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_COMPONENT_TYPE_EVENT, CaliforniaComponentEvent);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
	switch (property_id) {
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_SUMMARY:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_summary (self, g_value_get_string (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_DESCRIPTION:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_description (self, g_value_get_string (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_EXACT_TIME_SPAN:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_exact_time_span (self, g_value_get_object (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_DATE_SPAN:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_date_span (self, g_value_get_object (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_LOCATION:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_location (self, g_value_get_string (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		case CALIFORNIA_COMPONENT_EVENT_STATUS:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		california_component_event_set_status (self, g_value_get_enum (value));
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 3244 "component-event.c"
		default:
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 15 "/home/jim/git/california/src/component/component-event.vala"
		break;
#line 3250 "component-event.c"
	}
}



