// Generated by Bisonc++ V6.00.00 on Sun, 14 May 2017 16:12:45 +0200

// hdr/includes
#ifndef ParserBase_h_included
#define ParserBase_h_included

#include <exception>
#include <vector>
#include <iostream>

// hdr/baseclass

namespace // anonymous
{
    struct PI_;
}



class ParserBase
{
    public:
        enum DebugMode_
        {
            OFF           = 0,
            ON            = 1 << 0,
            ACTIONCASES   = 1 << 1
        };

// $insert tokens

    // Symbolic tokens:
    enum Tokens_
    {
        NUMBER = 257,
        EOLN,
        UNARY,
    };

// $insert STYPE
typedef int STYPE_;

    private:
                        // state  semval
        typedef std::pair<size_t, STYPE_> StatePair;
                       // token   semval
        typedef std::pair<int,    STYPE_> TokenPair;

        int d_stackIdx = -1;
        std::vector<StatePair> d_stateStack;


    protected:
        enum Return_
        {
            PARSE_ACCEPT_ = 0,   // values used as parse()'s return values
            PARSE_ABORT_  = 1
        };
        enum ErrorRecovery_
        {
            DEFAULT_RECOVERY_MODE_,
            UNEXPECTED_TOKEN_,
        };

        bool        d_actionCases_ = false;    // set by options/directives
        bool        d_debug_ = true;
        size_t      d_requiredTokens_;

        size_t      d_nErrors_;                // initialized by clearin()
        size_t      d_acceptedTokens_;
        int         d_token_;
        size_t      d_state_;

        StatePair *d_vsp_;           // points to the topmost value stack

        STYPE_     d_val_;

        TokenPair   d_next_;

        bool        d_terminalToken_;
        bool        d_recovery_;


        ParserBase();

        void ABORT() const;
        void ACCEPT() const;
        void ERROR() const;
        bool debug() const;

        void clearin_();
        int  lookup_() const;
        void pop_(size_t count = 1);
        void push_(size_t nextState);
        void popToken_();
        void pushToken_(int token);
        void redoToken_();
        void reduce_(int rule);
        void shift_(int state);
        void errorVerbose_();
        size_t top_() const;
        STYPE_ &vs_(int idx);             // value stack element idx 

    public:
        void setDebug(bool mode);
        void setDebug(DebugMode_ mode);
}; 

// hdr/abort
inline void ParserBase::ABORT() const
{
    throw PARSE_ABORT_;
}

// hdr/accept
inline void ParserBase::ACCEPT() const
{
    throw PARSE_ACCEPT_;
}


// hdr/debug
inline bool ParserBase::debug() const
{
    return d_debug_;
}

// hdr/error
inline void ParserBase::ERROR() const
{
    throw UNEXPECTED_TOKEN_;
}

// hdr/opbitand
inline ParserBase::DebugMode_ operator&(ParserBase::DebugMode_ lhs,
                                     ParserBase::DebugMode_ rhs)
{
    return static_cast<ParserBase::DebugMode_>(
            static_cast<int>(lhs) & rhs);
}

// hdr/opbitor
inline ParserBase::DebugMode_ operator|(ParserBase::DebugMode_ lhs, 
                                     ParserBase::DebugMode_ rhs)
{
    return static_cast<ParserBase::DebugMode_>(static_cast<int>(lhs) | rhs);
};

// hdr/vs
inline ParserBase::STYPE_ &ParserBase::vs_(int idx) 
{
    return (d_vsp_ + idx)->second;
}

// hdr/tail
// For convenience, when including ParserBase.h its symbols are available as
// symbols in the class Parser, too.
#define Parser ParserBase


#endif



