# Copyright 2004,2005 Pierre Martineau <pmartino@users.sourceforge.net>
# This file is part of Bibus, a bibliographic database that can
# work together with OpenOffice.org to generate bibliographic indexes.
#
# Bibus is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Bibus is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Bibus; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
#
# -*- coding: ISO-8859-1 -*-
# generated by wxGlade 0.3.4 on Sat Dec  3 16:25:38 2005

import wx
import BIB

class RefDisplayBase(wx.Panel):
	def __init__(self, *args, **kwds):
		# begin wxGlade: RefDisplayBase.__init__
		kwds["style"] = wx.TAB_TRAVERSAL
		wx.Panel.__init__(self, *args, **kwds)
		self.RefDisplay = wx.TextCtrl(self, -1, "", style=wx.TE_MULTILINE|wx.TE_READONLY|wx.TE_RICH)

		self.__set_properties()
		self.__do_layout()
		# end wxGlade

	def __set_properties(self):
		# begin wxGlade: RefDisplayBase.__set_properties
		pass
		# end wxGlade

	def __do_layout(self):
		# begin wxGlade: RefDisplayBase.__do_layout
		sizer_1 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_1.Add(self.RefDisplay, 1, wx.EXPAND, 0)
		self.SetAutoLayout(1)
		self.SetSizer(sizer_1)
		sizer_1.Fit(self)
		sizer_1.SetSizeHints(self)
		# end wxGlade

# end of class RefDisplayBase


class RefDisplay(RefDisplayBase):
	def Clear(self):
		self.RefDisplay.Clear()
		
	def resetFormat(self,format):
		return

	def display(self,ref):
		"""Display the reference ref
		If ref = '' => clear the display
		"""
		self.Clear()
		if ref:
			displayedFields = BIB.EDIT[BIB.BIB_TYPE[int(ref[2])]][0]+("Abstract",)
			for i in displayedFields:
				self.RefDisplay.SetDefaultStyle(wx.TextAttr(BIB.KEY_COLOR))
				self.RefDisplay.AppendText("""%s: """ %BIB.NAME_FIELD[i])
				self.RefDisplay.SetDefaultStyle(wx.TextAttr(BIB.TEXT_COLOR))
				self.RefDisplay.AppendText("""%s\n""" % (ref[BIB.BIBLIOGRAPHIC_FIELDS[i]]))
			self.RefDisplay.ShowPosition(0)

