/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Attribute;
import net.sf.saxon.instruct.FixedAttribute;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLStringConstructor;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.StringValue;

public final class XSLAttribute
extends XSLStringConstructor {
    private Expression attributeName;
    private Expression separator;
    private Expression namespace = null;
    private int validationAction = 3;
    private SimpleType schemaType;

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string7 = this.getNamePool().getClarkName(n2);
            if (string7 == "name") {
                string = attributeCollection.getValue(n).trim();
            } else if (string7 == "namespace") {
                string2 = attributeCollection.getValue(n).trim();
            } else if (string7 == "select") {
                string3 = attributeCollection.getValue(n).trim();
            } else if (string7 == "separator") {
                string4 = attributeCollection.getValue(n).trim();
            } else if (string7 == "validation") {
                string5 = attributeCollection.getValue(n).trim();
            } else if (string7 == "type") {
                string6 = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        this.attributeName = this.makeAttributeValueTemplate(string);
        if (this.attributeName instanceof StringValue && !Name.isQName(string)) {
            this.compileError("Attribute name is not a valid QName");
            this.attributeName = new StringValue("saxon-error-attribute");
        }
        if (string2 != null) {
            this.namespace = this.makeAttributeValueTemplate(string2);
        }
        if (string3 != null) {
            this.select = this.makeExpression(string3);
        }
        this.separator = string4 == null ? (string3 == null ? StringValue.EMPTY_STRING : new StringValue(" ")) : this.makeAttributeValueTemplate(string4);
        if (string5 != null) {
            if (this.validationAction != 4 && !this.getConfiguration().isSchemaAware()) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed");
            }
            this.validationAction = Validation.getCode(string5);
            if (this.validationAction == -1) {
                this.compileError("Invalid value of \u00abvalidation\u00bb attribute");
            }
        }
        if (string6 != null) {
            if (!this.getConfiguration().isSchemaAware()) {
                this.compileError("The \u00abtype\u00bb attribute is available only with a schema-aware XSLT processor");
            }
            this.schemaType = (SimpleType)this.getSchemaType(string6);
            if (!(this.schemaType instanceof SimpleType)) {
                this.compileError("Type annotation for attributes must be a simple type");
            }
        }
        if (string6 != null && string5 != null) {
            this.compileError("The validation and type attributes are mutually exclusive");
        }
    }

    public void validate() throws TransformerConfigurationException {
        if (!(this.getParentNode() instanceof XSLAttributeSet)) {
            this.checkWithinTemplate();
        }
        this.attributeName = this.typeCheck("name", this.attributeName);
        this.namespace = this.typeCheck("namespace", this.namespace);
        this.select = this.typeCheck("select", this.select);
        this.separator = this.typeCheck("separator", this.separator);
        super.validate();
    }

    public Instruction compile() throws TransformerConfigurationException {
        Object object;
        NamespaceContext namespaceContext = null;
        int n = this.getTypeAnnotation(this.schemaType);
        if (this.attributeName instanceof StringValue) {
            String[] stringArray;
            object = ((StringValue)this.attributeName).getStringValue().trim();
            try {
                stringArray = Name.getQNameParts((String)object);
            }
            catch (QNameException qNameException) {
                this.compileError("Invalid attribute name: " + (String)object);
                return null;
            }
            if (((String)object).equals("xmlns") && this.namespace == null) {
                this.compileError("Invalid attribute name: " + (String)object);
                return null;
            }
            if (stringArray[0].equals("xmlns")) {
                if (this.namespace == null) {
                    this.compileError("Invalid attribute name: " + (String)object);
                    return null;
                }
                stringArray[0] = "";
            }
            if (this.namespace == null) {
                String string = "";
                if (!stringArray[0].equals("")) {
                    try {
                        string = this.getURIForPrefix(stringArray[0], false);
                    }
                    catch (NamespaceException namespaceException) {
                        this.compileError(namespaceException.getMessage());
                        return null;
                    }
                }
                int n2 = this.getTargetNamePool().allocate(stringArray[0], string, stringArray[1]);
                FixedAttribute fixedAttribute = new FixedAttribute(n2, this.validationAction, this.schemaType, n);
                this.compileContent(fixedAttribute);
                fixedAttribute.setSeparator(this.separator);
                return fixedAttribute;
            }
            if (this.namespace instanceof StringValue) {
                Object object2;
                String string = ((StringValue)this.namespace).getStringValue();
                if (string.equals("")) {
                    stringArray[0] = "";
                } else if (stringArray[0].equals("")) {
                    AxisIterator axisIterator = this.iterateAxis((byte)8);
                    while ((object2 = (NodeInfo)axisIterator.next()) != null) {
                        if (!object2.getStringValue().equals(string)) continue;
                        stringArray[0] = object2.getLocalPart();
                        break;
                    }
                    if (stringArray[0].equals("") && (object2 = this.getTargetNamePool().suggestPrefixForURI(((StringValue)this.namespace).getStringValue())) != null) {
                        stringArray[0] = object2;
                    }
                    if (stringArray[0].equals("")) {
                        stringArray[0] = "ns0";
                    }
                }
                int n3 = this.getTargetNamePool().allocate(stringArray[0], string, stringArray[1]);
                object2 = new FixedAttribute(n3, this.validationAction, this.schemaType, n);
                this.compileContent((SimpleNodeConstructor)object2);
                ((SimpleNodeConstructor)object2).setSeparator(this.separator);
                return object2;
            }
        } else if (this.namespace == null) {
            namespaceContext = this.makeNamespaceContext();
        }
        object = new Attribute(this.attributeName, this.namespace, namespaceContext, this.validationAction, this.schemaType, n);
        this.compileContent((SimpleNodeConstructor)object);
        return object;
    }
}

