# FindPhtread search and find the libphtread library path and header path
#
# The following variables are set:
# CMAKE_C_FLAGS - flags to add to the C compiler for build arpon
# CMAKE_INCLUDE - include path Cflag
# CMAKE_LIBS    - library path Cflag
#
# Copyright 2010 <Giuseppe Marco Randazzo> zeld@freaknet.org
#
# Redistribution AND use is allowed according to the terms of the New
# BSD license.

find_path(PTHREAD_INCLUDE_DIR ${libpthread_h} ${CMAKE_INCLUDE_PATH})

find_path(PTHREAD_LIB_DIR ${libpthread} ${CMAKE_LIBRARY_PATH})

find_library(PTHREAD_LIBRARY NAMES ${libpthread} PATH ${CMAKE_LIBRARY_PATH})

if(PTHREAD_INCLUDE_DIR AND PTHREAD_LIB_DIR AND PTHREAD_LIBRARY )
  message(STATUS "Found Libphtread.")

  if(NOT ${INCLUDE_DIR} MATCHES ${PTHREAD_INCLUDE_DIR})
    include_directories(${PTHREAD_INCLUDE_DIR})
    set(INCLUDE_DIR "${INCLUDE_DIR} ${PTHREAD_INCLUDE_DIR}")
  endif(NOT ${INCLUDE_DIR} MATCHES ${PTHREAD_INCLUDE_DIR})

  if(NOT ${LIB_DIR} MATCHES ${PTHREAD_LIB_DIR})
    link_directories(${PTHREAD_LIB_DIR})
    set(LIB_DIR "${LIB_DIR} ${PTHREAD_LIB_DIR}")
  endif(NOT ${LIB_DIR} MATCHES ${PTHREAD_LIB_DIR})

else(NOT PTHREAD_INCLUDE_DIR OR NOT PTHREAD_LIB_DIR OR NOT PTHREAD_LIBRARY)
  message(FATAL_ERROR " Libpthread not found! \n Please visit  http://www.gnu.org/software/libc/libc.html or see in the arpon 'INSTALL' file.")
endif(PTHREAD_INCLUDE_DIR AND PTHREAD_LIB_DIR AND PTHREAD_LIBRARY)
