/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;

public class IntrospectionHelper
implements BuildListener {
    private Hashtable attributeTypes = new Hashtable();
    private Hashtable attributeSetters = new Hashtable();
    private Hashtable nestedTypes = new Hashtable();
    private Hashtable nestedCreators = new Hashtable();
    private Hashtable nestedStorers = new Hashtable();
    private Method addText = null;
    private Class bean;
    private static Hashtable helpers = new Hashtable();
    private static final Hashtable PRIMITIVE_TYPE_MAP = new Hashtable(8);
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$apache$tools$ant$Task;
    static /* synthetic */ Class class$org$apache$tools$ant$TaskContainer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$tools$ant$Location;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$org$apache$tools$ant$types$Path;
    static /* synthetic */ Class class$org$apache$tools$ant$types$EnumeratedAttribute;

    private IntrospectionHelper(Class bean) {
        this.bean = bean;
        Method[] methods = bean.getMethods();
        int i = 0;
        while (i < methods.length) {
            final Method m = methods[i];
            String name = m.getName();
            Class<?> returnType = m.getReturnType();
            Class<?>[] args = m.getParameterTypes();
            if (!((class$org$apache$tools$ant$Task == null ? IntrospectionHelper.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task).isAssignableFrom(bean) && args.length == 1 && this.isHiddenSetMethod(name, args[0]) || (class$org$apache$tools$ant$TaskContainer == null ? IntrospectionHelper.class$("org.apache.tools.ant.TaskContainer") : class$org$apache$tools$ant$TaskContainer).isAssignableFrom(bean) && args.length == 1 && "addTask".equals(name) && (class$org$apache$tools$ant$Task == null ? IntrospectionHelper.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task).equals(args[0]))) {
                String propName;
                Constructor<?> c;
                String propName2;
                if ("addText".equals(name) && Void.TYPE.equals(returnType) && args.length == 1 && (class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(args[0])) {
                    this.addText = methods[i];
                } else if (name.startsWith("set") && Void.TYPE.equals(returnType) && args.length == 1 && !args[0].isArray()) {
                    AttributeSetter as;
                    propName2 = this.getPropertyName(name, "set");
                    if (!(this.attributeSetters.get(propName2) != null && (class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(args[0]) || (as = this.createAttributeSetter(m, args[0])) == null)) {
                        this.attributeTypes.put(propName2, args[0]);
                        this.attributeSetters.put(propName2, as);
                    }
                } else if (name.startsWith("create") && !returnType.isArray() && !returnType.isPrimitive() && args.length == 0) {
                    propName2 = this.getPropertyName(name, "create");
                    this.nestedTypes.put(propName2, returnType);
                    this.nestedCreators.put(propName2, new NestedCreator(){

                        public Object create(Object parent) throws InvocationTargetException, IllegalAccessException {
                            return m.invoke(parent, new Object[0]);
                        }
                    });
                    this.nestedStorers.remove(propName2);
                } else if (name.startsWith("addConfigured") && Void.TYPE.equals(returnType) && args.length == 1 && !(class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(args[0]) && !args[0].isArray() && !args[0].isPrimitive()) {
                    try {
                        c = args[0].getConstructor(new Class[0]);
                        propName = this.getPropertyName(name, "addConfigured");
                        this.nestedTypes.put(propName, args[0]);
                        this.nestedCreators.put(propName, new NestedCreator(){

                            public Object create(Object parent) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                                Object o = c.newInstance(new Object[0]);
                                return o;
                            }
                        });
                        this.nestedStorers.put(propName, new NestedStorer(){

                            public void store(Object parent, Object child) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                                m.invoke(parent, child);
                            }
                        });
                    }
                    catch (NoSuchMethodException nse) {}
                } else if (name.startsWith("add") && Void.TYPE.equals(returnType) && args.length == 1 && !(class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(args[0]) && !args[0].isArray() && !args[0].isPrimitive()) {
                    try {
                        c = args[0].getConstructor(new Class[0]);
                        propName = this.getPropertyName(name, "add");
                        this.nestedTypes.put(propName, args[0]);
                        this.nestedCreators.put(propName, new NestedCreator(){

                            public Object create(Object parent) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                                Object o = c.newInstance(new Object[0]);
                                m.invoke(parent, o);
                                return o;
                            }
                        });
                        this.nestedStorers.remove(name);
                    }
                    catch (NoSuchMethodException nse) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
    }

    private boolean isHiddenSetMethod(String name, Class type) {
        if ("setLocation".equals(name) && (class$org$apache$tools$ant$Location == null ? (class$org$apache$tools$ant$Location = IntrospectionHelper.class$("org.apache.tools.ant.Location")) : class$org$apache$tools$ant$Location).equals(type)) {
            return true;
        }
        return "setTaskType".equals(name) && (class$java$lang$String == null ? (class$java$lang$String = IntrospectionHelper.class$("java.lang.String")) : class$java$lang$String).equals(type);
    }

    public static synchronized IntrospectionHelper getHelper(Class c) {
        IntrospectionHelper ih = (IntrospectionHelper)helpers.get(c);
        if (ih == null) {
            ih = new IntrospectionHelper(c);
            helpers.put(c, ih);
        }
        return ih;
    }

    public void setAttribute(Project p, Object element, String attributeName, String value) throws BuildException {
        AttributeSetter as = (AttributeSetter)this.attributeSetters.get(attributeName);
        if (as == null) {
            if (element instanceof DynamicConfigurator) {
                DynamicConfigurator dc = (DynamicConfigurator)element;
                dc.setDynamicAttribute(attributeName, value);
                return;
            }
            String msg = this.getElementName(p, element) + " doesn't support the \"" + attributeName + "\" attribute.";
            throw new BuildException(msg);
        }
        try {
            as.set(p, element, value);
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public void addText(Project project, Object element, String text) throws BuildException {
        if (this.addText == null) {
            if (text.trim().length() == 0) {
                return;
            }
            String msg = project.getElementName(element) + " doesn't support nested text data.";
            throw new BuildException(msg);
        }
        try {
            this.addText.invoke(element, (Object[])new String[]{text});
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public Object createElement(Project project, Object parent, String elementName) throws BuildException {
        DynamicConfigurator dc;
        Object nestedElement;
        NestedCreator nc = (NestedCreator)this.nestedCreators.get(elementName);
        if (nc == null && parent instanceof DynamicConfigurator && (nestedElement = (dc = (DynamicConfigurator)parent).createDynamicElement(elementName)) != null) {
            if (nestedElement instanceof ProjectComponent) {
                ((ProjectComponent)nestedElement).setProject(project);
            }
            return nestedElement;
        }
        if (nc == null) {
            String msg = project.getElementName(parent) + " doesn't support the nested \"" + elementName + "\" element.";
            throw new BuildException(msg);
        }
        try {
            Object nestedElement2 = nc.create(parent);
            if (nestedElement2 instanceof ProjectComponent) {
                ((ProjectComponent)nestedElement2).setProject(project);
            }
            return nestedElement2;
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InstantiationException ine) {
            throw new BuildException(ine);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public void storeElement(Project project, Object parent, Object child, String elementName) throws BuildException {
        if (elementName == null) {
            return;
        }
        NestedStorer ns = (NestedStorer)this.nestedStorers.get(elementName);
        if (ns == null) {
            return;
        }
        try {
            ns.store(parent, child);
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InstantiationException ine) {
            throw new BuildException(ine);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public Class getElementType(String elementName) throws BuildException {
        Class nt = (Class)this.nestedTypes.get(elementName);
        if (nt == null) {
            String msg = "Class " + this.bean.getName() + " doesn't support the nested \"" + elementName + "\" element.";
            throw new BuildException(msg);
        }
        return nt;
    }

    public Class getAttributeType(String attributeName) throws BuildException {
        Class at = (Class)this.attributeTypes.get(attributeName);
        if (at == null) {
            String msg = "Class " + this.bean.getName() + " doesn't support the \"" + attributeName + "\" attribute.";
            throw new BuildException(msg);
        }
        return at;
    }

    public boolean supportsCharacters() {
        return this.addText != null;
    }

    public Enumeration getAttributes() {
        return this.attributeSetters.keys();
    }

    public Enumeration getNestedElements() {
        return this.nestedTypes.keys();
    }

    private AttributeSetter createAttributeSetter(final Method m, Class arg) {
        Class reflectedArg;
        if ((class$java$lang$String == null ? (class$java$lang$String = IntrospectionHelper.class$("java.lang.String")) : class$java$lang$String).equals(reflectedArg = PRIMITIVE_TYPE_MAP.containsKey(arg) ? (Class)PRIMITIVE_TYPE_MAP.get(arg) : arg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new String[]{value});
                }
            };
        }
        if ((class$java$lang$Character == null ? (class$java$lang$Character = IntrospectionHelper.class$("java.lang.Character")) : class$java$lang$Character).equals(reflectedArg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new Character[]{new Character(value.charAt(0))});
                }
            };
        }
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = IntrospectionHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(reflectedArg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new Boolean[]{new Boolean(Project.toBoolean(value))});
                }
            };
        }
        if ((class$java$lang$Class == null ? (class$java$lang$Class = IntrospectionHelper.class$("java.lang.Class")) : class$java$lang$Class).equals(reflectedArg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        m.invoke(parent, (Object[])new Class[]{Class.forName(value)});
                    }
                    catch (ClassNotFoundException ce) {
                        throw new BuildException(ce);
                    }
                }
            };
        }
        if ((class$java$io$File == null ? (class$java$io$File = IntrospectionHelper.class$("java.io.File")) : class$java$io$File).equals(reflectedArg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new File[]{p.resolveFile(value)});
                }
            };
        }
        if ((class$org$apache$tools$ant$types$Path == null ? (class$org$apache$tools$ant$types$Path = IntrospectionHelper.class$("org.apache.tools.ant.types.Path")) : class$org$apache$tools$ant$types$Path).equals(reflectedArg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new Path[]{new Path(p, value)});
                }
            };
        }
        if ((class$org$apache$tools$ant$types$EnumeratedAttribute == null ? (class$org$apache$tools$ant$types$EnumeratedAttribute = IntrospectionHelper.class$("org.apache.tools.ant.types.EnumeratedAttribute")) : class$org$apache$tools$ant$types$EnumeratedAttribute).isAssignableFrom(reflectedArg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        EnumeratedAttribute ea = (EnumeratedAttribute)reflectedArg.newInstance();
                        ea.setValue(value);
                        m.invoke(parent, (Object[])new EnumeratedAttribute[]{ea});
                    }
                    catch (InstantiationException ie) {
                        throw new BuildException(ie);
                    }
                }
            };
        }
        try {
            final Constructor c = reflectedArg.getConstructor(class$java$lang$String == null ? (class$java$lang$String = IntrospectionHelper.class$("java.lang.String")) : class$java$lang$String);
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        Object attribute = c.newInstance(value);
                        if (attribute instanceof ProjectComponent) {
                            ((ProjectComponent)attribute).setProject(p);
                        }
                        m.invoke(parent, attribute);
                    }
                    catch (InstantiationException ie) {
                        throw new BuildException(ie);
                    }
                }
            };
        }
        catch (NoSuchMethodException nme) {
            return null;
        }
    }

    protected String getElementName(Project project, Object element) {
        return project.getElementName(element);
    }

    private String getPropertyName(String methodName, String prefix) {
        int start = prefix.length();
        return methodName.substring(start).toLowerCase(Locale.US);
    }

    public void buildFinished(BuildEvent event) {
        this.attributeTypes.clear();
        this.attributeSetters.clear();
        this.nestedTypes.clear();
        this.nestedCreators.clear();
        this.addText = null;
        helpers.clear();
    }

    public void buildStarted(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        Class[] wrappers = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = IntrospectionHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Byte == null ? (class$java$lang$Byte = IntrospectionHelper.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Character == null ? (class$java$lang$Character = IntrospectionHelper.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Short == null ? (class$java$lang$Short = IntrospectionHelper.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = IntrospectionHelper.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = IntrospectionHelper.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = IntrospectionHelper.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Double == null ? (class$java$lang$Double = IntrospectionHelper.class$("java.lang.Double")) : class$java$lang$Double};
        int i = 0;
        while (i < primitives.length) {
            PRIMITIVE_TYPE_MAP.put(primitives[i], wrappers[i]);
            ++i;
        }
    }

    private static interface AttributeSetter {
        public void set(Project var1, Object var2, String var3) throws InvocationTargetException, IllegalAccessException, BuildException;
    }

    private static interface NestedStorer {
        public void store(Object var1, Object var2) throws InvocationTargetException, IllegalAccessException, InstantiationException;
    }

    private static interface NestedCreator {
        public Object create(Object var1) throws InvocationTargetException, IllegalAccessException, InstantiationException;
    }
}

