!{\src2tex{textfont=tt}}
!!****f* ABINIT/write_deltaI
!! NAME
!!  write_deltaI
!!
!! FUNCTION
!!  Writes the incompleteness matrix
!!
!! COPYRIGHT
!!  Copyright (C) 2011-2014 ABINIT group (GKA)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  unt=The unit number of the file to be written (supposed to be already open)
!!  deltaI(npwe,npwe,1)=The matrix to be written, for a single q-point.
!!
!! OUTPUT
!!  (only writing on file)
!!
!! PARENTS
!!      screening
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


subroutine write_deltaI(unt,iqibz,deltaI,npwe)
    
 use defs_basis
 use m_profiling

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'write_deltaI'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer , intent(in)  :: unt,npwe,iqibz
!arrays
 complex(gwpc),intent(in) :: deltaI(npwe,npwe,1)

!Local variables-------------------------------
 integer :: ipwe,jpwe
 
! *************************************************************************

 write(unt,'(2a,i3,1x,2a)')ch10,'# Incompleteness matrix for q-point',iqibz,ch10,'# ig1, ig2    Re     Im '
 do ipwe=1,npwe
   do jpwe=1,npwe
     write(unt,'(i4,1x,i4,1x,2(f8.4))' ) ipwe,jpwe,deltaI(ipwe,jpwe,1)
   end do
   write(unt,'(1x)' )
 end do

end subroutine write_deltaI
!!***
