/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class LabeledTextChunk
extends Chunk {
    public LabeledTextChunk(ModuleBase moduleBase, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(moduleBase, chunkHeader, dataInputStream);
    }

    @Override
    public boolean readChunk(RepInfo repInfo) throws IOException {
        WaveModule waveModule = (WaveModule)this._module;
        long l = waveModule.readUnsignedInt(this._dstream);
        long l2 = waveModule.readUnsignedInt(this._dstream);
        long l3 = waveModule.readUnsignedInt(this._dstream);
        int n = waveModule.readUnsignedShort(this._dstream);
        int n2 = waveModule.readUnsignedShort(this._dstream);
        int n3 = waveModule.readUnsignedShort(this._dstream);
        int n4 = waveModule.readUnsignedShort(this._dstream);
        byte[] byArray = new byte[(int)(this.bytesLeft - 20L)];
        ModuleBase.readByteBuf(this._dstream, byArray, waveModule);
        String string = new String(byArray).trim();
        ArrayList<Property> arrayList = new ArrayList<Property>(10);
        arrayList.add(new Property("CuePointID", PropertyType.LONG, new Long(l)));
        arrayList.add(new Property("SampleLength", PropertyType.LONG, new Long(l2)));
        arrayList.add(new Property("PurposeID", PropertyType.LONG, new Long(l3)));
        arrayList.add(new Property("Country", PropertyType.INTEGER, new Integer(n)));
        arrayList.add(new Property("Language", PropertyType.INTEGER, new Integer(n2)));
        arrayList.add(new Property("Dialect", PropertyType.INTEGER, new Integer(n3)));
        arrayList.add(new Property("CodePage", PropertyType.INTEGER, new Integer(n4)));
        arrayList.add(new Property("Text", PropertyType.STRING, string));
        waveModule.addLabeledText(new Property("LabeledTextItem", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        return true;
    }
}

