/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.recalibration.covariates;

import org.broadinstitute.gatk.tools.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.gatk.utils.recalibration.ReadCovariates;
import org.broadinstitute.gatk.utils.recalibration.covariates.RequiredCovariate;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class QualityScoreCovariate
implements RequiredCovariate {
    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
    }

    @Override
    public void recordValues(GATKSAMRecord read, ReadCovariates values) {
        byte[] baseQualities = read.getBaseQualities();
        byte[] baseInsertionQualities = read.getBaseInsertionQualities();
        byte[] baseDeletionQualities = read.getBaseDeletionQualities();
        for (int i = 0; i < baseQualities.length; ++i) {
            values.addCovariate(baseQualities[i], baseInsertionQualities[i], baseDeletionQualities[i], i);
        }
    }

    @Override
    public final Object getValue(String str) {
        return Byte.parseByte(str);
    }

    @Override
    public String formatKey(int key) {
        return String.format("%d", key);
    }

    @Override
    public int keyFromValue(Object value) {
        return value instanceof String ? Byte.parseByte((String)value) : (Byte)value;
    }

    @Override
    public int maximumKeyValue() {
        return 93;
    }
}

