/*
#include <windows.h>
#include <windowsx.h>
#include <winuser.h>
#include <stdio.h>
*/
#include "stdafx.h"
#include "common.h"
#include "resource.h"
#include "musenc.h"

static	HINSTANCE	hModule = NULL;
typedef MERET (*me_init)(void);
typedef MERET (*me_setconf)(MPARAM mode, UPARAM dwPara1, UPARAM dwPara2 );
typedef MERET (*me_getconf)(MPARAM mode, void *para1 );
typedef MERET (*me_detect)();
typedef MERET (*me_procframe)();
typedef MERET (*me_close)();
typedef MERET (*me_end)();
typedef MERET (*me_getver)( unsigned long *vercode,  char *verstring );
typedef MERET (*me_haveunit)( unsigned long *unit );


static	me_init		mpge_init;
static  me_setconf	mpge_setconf;
static	me_getconf	mpge_getconf;
static	me_detect	mpge_detector;
static	me_procframe mpge_processframe;
static	me_close	mpge_close;
static	me_end		mpge_end;
static	me_getver	mpge_getver;
static	me_haveunit mpge_haveunit;


MERET	MPGE_initializeWork()
{
	if( hModule == NULL ){
		hModule = LoadLibrary("gogo.dll");
		if( !hModule ){
			disp_err( 
				"GOGO.DLL̓ǂݍ݂s܂B\n"
				"DLLEXEt@CƓfBNg֕ʂĂ\n" );
			exit( -1 );
		}
		mpge_init = (me_init )GetProcAddress( hModule, "MPGE_initializeWork" );
		mpge_setconf = (me_setconf )GetProcAddress( hModule, "MPGE_setConfigure" );
		mpge_getconf = (me_getconf )GetProcAddress( hModule, "MPGE_getConfigure" );
		mpge_detector = (me_detect )GetProcAddress( hModule, "MPGE_detectConfigure" );
		mpge_processframe = (me_procframe )GetProcAddress( hModule, "MPGE_processFrame" );
		mpge_close   = (me_close )GetProcAddress( hModule, "MPGE_closeCoder" );
		mpge_end	 = (me_end )GetProcAddress( hModule, "MPGE_endCoder" );
		mpge_getver	 = (me_getver )GetProcAddress( hModule, "MPGE_getVersion" );
		mpge_haveunit= (me_haveunit )GetProcAddress( hModule, "MPGE_getUnitStates" );
	}

	if( mpge_init && mpge_setconf && mpge_getconf &&
		mpge_detector && mpge_processframe && mpge_end && mpge_getver && mpge_haveunit)
		return (mpge_init)();

	fprintf( stderr, "DLL̓e𐳂ʂ邱Ƃo܂ł\n");
	FreeLibrary( hModule );
	hModule = NULL;
	exit( -1 );

	return ME_NOERR;
}

MERET	MPGE_setConfigure(MPARAM mode, UPARAM dwPara1, UPARAM dwPara2 )
{
	return (mpge_setconf)( mode, dwPara1, dwPara2 );
}

MERET	MPGE_getConfigure(MPARAM mode, void *para1 )
{
	return (mpge_getconf)( mode, para1 );
}

MERET	MPGE_detectConfigure()
{
	return (mpge_detector)();
}

MERET	MPGE_processFrame()
{
	return (mpge_processframe)();
}

MERET	MPGE_closeCoder()
{
	return (mpge_close)();
}

MERET	MPGE_endCoder()
{
	MERET	val = (mpge_end)();
	if( val == ME_NOERR ){
		FreeLibrary( hModule );		// DLLJ
		hModule = NULL;
	}
	return val;
}

MERET	MPGE_getVersion( unsigned long *vercode,  char *verstring )
{
	MERET	val = (mpge_getver)( vercode, verstring );
	return val;
}

MERET	MPGE_getUnitStates( unsigned long *unit)
{
	MERET	val = (mpge_haveunit)( unit );
	return val;
}

