/* PublishingInterfaces.c generated by valac 0.36.6, the Vala compiler
 * generated from PublishingInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gee.h>


#define SPIT_PUBLISHING_TYPE_PUBLISHER (spit_publishing_publisher_get_type ())
#define SPIT_PUBLISHING_PUBLISHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_PUBLISHING_TYPE_PUBLISHER, SpitPublishingPublisher))
#define SPIT_PUBLISHING_IS_PUBLISHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_PUBLISHING_TYPE_PUBLISHER))
#define SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_PUBLISHING_TYPE_PUBLISHER, SpitPublishingPublisherIface))

typedef struct _SpitPublishingPublisher SpitPublishingPublisher;
typedef struct _SpitPublishingPublisherIface SpitPublishingPublisherIface;

#define SPIT_TYPE_PLUGGABLE (spit_pluggable_get_type ())
#define SPIT_PLUGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_TYPE_PLUGGABLE, SpitPluggable))
#define SPIT_IS_PLUGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_TYPE_PLUGGABLE))
#define SPIT_PLUGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_TYPE_PLUGGABLE, SpitPluggableIface))

typedef struct _SpitPluggable SpitPluggable;
typedef struct _SpitPluggableIface SpitPluggableIface;

#define SPIT_TYPE_PLUGGABLE_INFO (spit_pluggable_info_get_type ())
typedef struct _SpitPluggableInfo SpitPluggableInfo;

#define SPIT_PUBLISHING_TYPE_SERVICE (spit_publishing_service_get_type ())
#define SPIT_PUBLISHING_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_PUBLISHING_TYPE_SERVICE, SpitPublishingService))
#define SPIT_PUBLISHING_IS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_PUBLISHING_TYPE_SERVICE))
#define SPIT_PUBLISHING_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_PUBLISHING_TYPE_SERVICE, SpitPublishingServiceIface))

typedef struct _SpitPublishingService SpitPublishingService;
typedef struct _SpitPublishingServiceIface SpitPublishingServiceIface;

#define SPIT_TYPE_HOST_INTERFACE (spit_host_interface_get_type ())
#define SPIT_HOST_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_TYPE_HOST_INTERFACE, SpitHostInterface))
#define SPIT_IS_HOST_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_TYPE_HOST_INTERFACE))
#define SPIT_HOST_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_TYPE_HOST_INTERFACE, SpitHostInterfaceIface))

typedef struct _SpitHostInterface SpitHostInterface;
typedef struct _SpitHostInterfaceIface SpitHostInterfaceIface;

#define SPIT_PUBLISHING_TYPE_PLUGIN_HOST (spit_publishing_plugin_host_get_type ())
#define SPIT_PUBLISHING_PLUGIN_HOST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_PUBLISHING_TYPE_PLUGIN_HOST, SpitPublishingPluginHost))
#define SPIT_PUBLISHING_IS_PLUGIN_HOST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_PUBLISHING_TYPE_PLUGIN_HOST))
#define SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_PUBLISHING_TYPE_PLUGIN_HOST, SpitPublishingPluginHostIface))

typedef struct _SpitPublishingPluginHost SpitPublishingPluginHost;
typedef struct _SpitPublishingPluginHostIface SpitPublishingPluginHostIface;

#define SPIT_PUBLISHING_TYPE_DIALOG_PANE (spit_publishing_dialog_pane_get_type ())
#define SPIT_PUBLISHING_DIALOG_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_PUBLISHING_TYPE_DIALOG_PANE, SpitPublishingDialogPane))
#define SPIT_PUBLISHING_IS_DIALOG_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_PUBLISHING_TYPE_DIALOG_PANE))
#define SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_PUBLISHING_TYPE_DIALOG_PANE, SpitPublishingDialogPaneIface))

typedef struct _SpitPublishingDialogPane SpitPublishingDialogPane;
typedef struct _SpitPublishingDialogPaneIface SpitPublishingDialogPaneIface;

#define SPIT_PUBLISHING_DIALOG_PANE_TYPE_GEOMETRY_OPTIONS (spit_publishing_dialog_pane_geometry_options_get_type ())

#define SPIT_PUBLISHING_PLUGIN_HOST_TYPE_BUTTON_MODE (spit_publishing_plugin_host_button_mode_get_type ())

#define SPIT_PUBLISHING_TYPE_PUBLISHABLE (spit_publishing_publishable_get_type ())
#define SPIT_PUBLISHING_PUBLISHABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_PUBLISHING_TYPE_PUBLISHABLE, SpitPublishingPublishable))
#define SPIT_PUBLISHING_IS_PUBLISHABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_PUBLISHING_TYPE_PUBLISHABLE))
#define SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_PUBLISHING_TYPE_PUBLISHABLE, SpitPublishingPublishableIface))

typedef struct _SpitPublishingPublishable SpitPublishingPublishable;
typedef struct _SpitPublishingPublishableIface SpitPublishingPublishableIface;

#define SPIT_PUBLISHING_PUBLISHER_TYPE_MEDIA_TYPE (spit_publishing_publisher_media_type_get_type ())

#define SPIT_PUBLISHING_TYPE_AUTHENTICATOR (spit_publishing_authenticator_get_type ())
#define SPIT_PUBLISHING_AUTHENTICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_PUBLISHING_TYPE_AUTHENTICATOR, SpitPublishingAuthenticator))
#define SPIT_PUBLISHING_IS_AUTHENTICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_PUBLISHING_TYPE_AUTHENTICATOR))
#define SPIT_PUBLISHING_AUTHENTICATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_PUBLISHING_TYPE_AUTHENTICATOR, SpitPublishingAuthenticatorIface))

typedef struct _SpitPublishingAuthenticator SpitPublishingAuthenticator;
typedef struct _SpitPublishingAuthenticatorIface SpitPublishingAuthenticatorIface;
enum  {
	SPIT_PUBLISHING_AUTHENTICATOR_AUTHENTICATED_SIGNAL,
	SPIT_PUBLISHING_AUTHENTICATOR_AUTHENTICATION_FAILED_SIGNAL,
	SPIT_PUBLISHING_AUTHENTICATOR_LAST_SIGNAL
};
static guint spit_publishing_authenticator_signals[SPIT_PUBLISHING_AUTHENTICATOR_LAST_SIGNAL] = {0};

#define SPIT_PUBLISHING_TYPE_AUTHENTICATOR_FACTORY (spit_publishing_authenticator_factory_get_type ())
#define SPIT_PUBLISHING_AUTHENTICATOR_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_PUBLISHING_TYPE_AUTHENTICATOR_FACTORY, SpitPublishingAuthenticatorFactory))
#define SPIT_PUBLISHING_IS_AUTHENTICATOR_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_PUBLISHING_TYPE_AUTHENTICATOR_FACTORY))
#define SPIT_PUBLISHING_AUTHENTICATOR_FACTORY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_PUBLISHING_TYPE_AUTHENTICATOR_FACTORY, SpitPublishingAuthenticatorFactoryIface))

typedef struct _SpitPublishingAuthenticatorFactory SpitPublishingAuthenticatorFactory;
typedef struct _SpitPublishingAuthenticatorFactoryIface SpitPublishingAuthenticatorFactoryIface;

/**
 * Defines different kinds of errors that can occur during publishing.
 */
typedef enum  {
	SPIT_PUBLISHING_PUBLISHING_ERROR_NO_ANSWER,
	SPIT_PUBLISHING_PUBLISHING_ERROR_COMMUNICATION_FAILED,
	SPIT_PUBLISHING_PUBLISHING_ERROR_PROTOCOL_ERROR,
	SPIT_PUBLISHING_PUBLISHING_ERROR_SERVICE_ERROR,
	SPIT_PUBLISHING_PUBLISHING_ERROR_MALFORMED_RESPONSE,
	SPIT_PUBLISHING_PUBLISHING_ERROR_LOCAL_FILE_ERROR,
	SPIT_PUBLISHING_PUBLISHING_ERROR_EXPIRED_SESSION,
	SPIT_PUBLISHING_PUBLISHING_ERROR_SSL_FAILED
} SpitPublishingPublishingError;
#define SPIT_PUBLISHING_PUBLISHING_ERROR spit_publishing_publishing_error_quark ()
struct _SpitPluggableInfo {
	gchar* version;
	gchar* brief_description;
	gchar* authors;
	gchar* copyright;
	gchar* license;
	gboolean is_license_wordwrapped;
	gchar* website_url;
	gchar* website_name;
	gchar* translators;
	GdkPixbuf** icons;
	gint icons_length1;
};

struct _SpitPluggableIface {
	GTypeInterface parent_iface;
	gint (*get_pluggable_interface) (SpitPluggable* self, gint min_host_interface, gint max_host_interface);
	const gchar* (*get_id) (SpitPluggable* self);
	const gchar* (*get_pluggable_name) (SpitPluggable* self);
	void (*get_info) (SpitPluggable* self, SpitPluggableInfo* info);
	void (*activation) (SpitPluggable* self, gboolean enabled);
	void (*reserved0) (SpitPluggable* self);
	void (*reserved1) (SpitPluggable* self);
	void (*reserved2) (SpitPluggable* self);
	void (*reserved3) (SpitPluggable* self);
	void (*reserved4) (SpitPluggable* self);
	void (*reserved5) (SpitPluggable* self);
	void (*reserved6) (SpitPluggable* self);
	void (*reserved7) (SpitPluggable* self);
};

struct _SpitHostInterfaceIface {
	GTypeInterface parent_iface;
	GFile* (*get_module_file) (SpitHostInterface* self);
	gboolean (*get_config_bool) (SpitHostInterface* self, const gchar* key, gboolean def);
	void (*set_config_bool) (SpitHostInterface* self, const gchar* key, gboolean val);
	gint (*get_config_int) (SpitHostInterface* self, const gchar* key, gint def);
	void (*set_config_int) (SpitHostInterface* self, const gchar* key, gint val);
	gchar* (*get_config_string) (SpitHostInterface* self, const gchar* key, const gchar* def);
	void (*set_config_string) (SpitHostInterface* self, const gchar* key, const gchar* val);
	gdouble (*get_config_double) (SpitHostInterface* self, const gchar* key, gdouble def);
	void (*set_config_double) (SpitHostInterface* self, const gchar* key, gdouble val);
	void (*unset_config_key) (SpitHostInterface* self, const gchar* key);
	void (*reserved0) (SpitHostInterface* self);
	void (*reserved1) (SpitHostInterface* self);
	void (*reserved2) (SpitHostInterface* self);
	void (*reserved3) (SpitHostInterface* self);
	void (*reserved4) (SpitHostInterface* self);
	void (*reserved5) (SpitHostInterface* self);
	void (*reserved6) (SpitHostInterface* self);
	void (*reserved7) (SpitHostInterface* self);
};

typedef enum  {
	SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_NONE = 0,
	SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_EXTENDED_SIZE = 1 << 0,
	SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_RESIZABLE = 1 << 1,
	SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_COLOSSAL_SIZE = 1 << 2
} SpitPublishingDialogPaneGeometryOptions;

struct _SpitPublishingDialogPaneIface {
	GTypeInterface parent_iface;
	GtkWidget* (*get_widget) (SpitPublishingDialogPane* self);
	SpitPublishingDialogPaneGeometryOptions (*get_preferred_geometry) (SpitPublishingDialogPane* self);
	void (*on_pane_installed) (SpitPublishingDialogPane* self);
	void (*on_pane_uninstalled) (SpitPublishingDialogPane* self);
	void (*reserved0) (SpitPublishingDialogPane* self);
	void (*reserved1) (SpitPublishingDialogPane* self);
	void (*reserved2) (SpitPublishingDialogPane* self);
	void (*reserved3) (SpitPublishingDialogPane* self);
	void (*reserved4) (SpitPublishingDialogPane* self);
	void (*reserved5) (SpitPublishingDialogPane* self);
	void (*reserved6) (SpitPublishingDialogPane* self);
	void (*reserved7) (SpitPublishingDialogPane* self);
};

typedef enum  {
	SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CLOSE = 0,
	SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CANCEL = 1
} SpitPublishingPluginHostButtonMode;

typedef void (*SpitPublishingLoginCallback) (void* user_data);
typedef enum  {
	SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_NONE = 0,
	SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_PHOTO = 1 << 0,
	SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_VIDEO = 1 << 1
} SpitPublishingPublisherMediaType;

struct _SpitPublishingPublishableIface {
	GTypeInterface parent_iface;
	GFile* (*get_serialized_file) (SpitPublishingPublishable* self);
	gchar* (*get_publishing_name) (SpitPublishingPublishable* self);
	gchar* (*get_param_string) (SpitPublishingPublishable* self, const gchar* name);
	gchar** (*get_publishing_keywords) (SpitPublishingPublishable* self, int* result_length1);
	SpitPublishingPublisherMediaType (*get_media_type) (SpitPublishingPublishable* self);
	GDateTime* (*get_exposure_date_time) (SpitPublishingPublishable* self);
	void (*reserved0) (SpitPublishingPublishable* self);
	void (*reserved1) (SpitPublishingPublishable* self);
	void (*reserved2) (SpitPublishingPublishable* self);
	void (*reserved3) (SpitPublishingPublishable* self);
	void (*reserved4) (SpitPublishingPublishable* self);
	void (*reserved5) (SpitPublishingPublishable* self);
	void (*reserved6) (SpitPublishingPublishable* self);
	void (*reserved7) (SpitPublishingPublishable* self);
};

typedef void (*SpitPublishingProgressCallback) (gint file_number, gdouble fraction_complete, void* user_data);
struct _SpitPublishingPluginHostIface {
	GTypeInterface parent_iface;
	void (*post_error) (SpitPublishingPluginHost* self, GError* err);
	void (*stop_publishing) (SpitPublishingPluginHost* self);
	SpitPublishingPublisher* (*get_publisher) (SpitPublishingPluginHost* self);
	void (*install_dialog_pane) (SpitPublishingPluginHost* self, SpitPublishingDialogPane* pane, SpitPublishingPluginHostButtonMode mode);
	void (*install_static_message_pane) (SpitPublishingPluginHost* self, const gchar* message, SpitPublishingPluginHostButtonMode mode);
	void (*install_pango_message_pane) (SpitPublishingPluginHost* self, const gchar* markup, SpitPublishingPluginHostButtonMode mode);
	void (*install_success_pane) (SpitPublishingPluginHost* self);
	void (*install_account_fetch_wait_pane) (SpitPublishingPluginHost* self);
	void (*install_login_wait_pane) (SpitPublishingPluginHost* self);
	void (*install_welcome_pane) (SpitPublishingPluginHost* self, const gchar* welcome_message, SpitPublishingLoginCallback on_login_clicked, void* on_login_clicked_target);
	void (*set_service_locked) (SpitPublishingPluginHost* self, gboolean is_locked);
	void (*set_dialog_default_widget) (SpitPublishingPluginHost* self, GtkWidget* widget);
	SpitPublishingPublishable** (*get_publishables) (SpitPublishingPluginHost* self, int* result_length1);
	SpitPublishingProgressCallback (*serialize_publishables) (SpitPublishingPluginHost* self, gint content_major_axis, gboolean strip_metadata, void** result_target, GDestroyNotify* result_target_destroy_notify);
	SpitPublishingPublisherMediaType (*get_publishable_media_type) (SpitPublishingPluginHost* self);
	void (*reserved0) (SpitPublishingPluginHost* self);
	void (*reserved1) (SpitPublishingPluginHost* self);
	void (*reserved2) (SpitPublishingPluginHost* self);
	void (*reserved3) (SpitPublishingPluginHost* self);
	void (*reserved4) (SpitPublishingPluginHost* self);
	void (*reserved5) (SpitPublishingPluginHost* self);
	void (*reserved6) (SpitPublishingPluginHost* self);
	void (*reserved7) (SpitPublishingPluginHost* self);
};

struct _SpitPublishingServiceIface {
	GTypeInterface parent_iface;
	SpitPublishingPublisher* (*create_publisher) (SpitPublishingService* self, SpitPublishingPluginHost* host);
	SpitPublishingPublisherMediaType (*get_supported_media) (SpitPublishingService* self);
	void (*reserved0) (SpitPublishingService* self);
	void (*reserved1) (SpitPublishingService* self);
	void (*reserved2) (SpitPublishingService* self);
	void (*reserved3) (SpitPublishingService* self);
	void (*reserved4) (SpitPublishingService* self);
	void (*reserved5) (SpitPublishingService* self);
	void (*reserved6) (SpitPublishingService* self);
	void (*reserved7) (SpitPublishingService* self);
};

struct _SpitPublishingPublisherIface {
	GTypeInterface parent_iface;
	SpitPublishingService* (*get_service) (SpitPublishingPublisher* self);
	void (*start) (SpitPublishingPublisher* self);
	gboolean (*is_running) (SpitPublishingPublisher* self);
	void (*stop) (SpitPublishingPublisher* self);
	void (*reserved0) (SpitPublishingPublisher* self);
	void (*reserved1) (SpitPublishingPublisher* self);
	void (*reserved2) (SpitPublishingPublisher* self);
	void (*reserved3) (SpitPublishingPublisher* self);
	void (*reserved4) (SpitPublishingPublisher* self);
	void (*reserved5) (SpitPublishingPublisher* self);
	void (*reserved6) (SpitPublishingPublisher* self);
	void (*reserved7) (SpitPublishingPublisher* self);
};

struct _SpitPublishingAuthenticatorIface {
	GTypeInterface parent_iface;
	void (*authenticate) (SpitPublishingAuthenticator* self);
	gboolean (*can_logout) (SpitPublishingAuthenticator* self);
	void (*logout) (SpitPublishingAuthenticator* self);
	void (*refresh) (SpitPublishingAuthenticator* self);
	GHashTable* (*get_authentication_parameter) (SpitPublishingAuthenticator* self);
};

struct _SpitPublishingAuthenticatorFactoryIface {
	GTypeInterface parent_iface;
	GeeList* (*get_available_authenticators) (SpitPublishingAuthenticatorFactory* self);
	SpitPublishingAuthenticator* (*create) (SpitPublishingAuthenticatorFactory* self, const gchar* provider, SpitPublishingPluginHost* host);
};



#define SPIT_PUBLISHING_CURRENT_INTERFACE 0
GQuark spit_publishing_publishing_error_quark (void);
GType spit_pluggable_info_get_type (void) G_GNUC_CONST;
SpitPluggableInfo* spit_pluggable_info_dup (const SpitPluggableInfo* self);
void spit_pluggable_info_free (SpitPluggableInfo* self);
void spit_pluggable_info_copy (const SpitPluggableInfo* self, SpitPluggableInfo* dest);
void spit_pluggable_info_destroy (SpitPluggableInfo* self);
GType spit_pluggable_get_type (void) G_GNUC_CONST;
GType spit_host_interface_get_type (void) G_GNUC_CONST;
GType spit_publishing_dialog_pane_geometry_options_get_type (void) G_GNUC_CONST;
GType spit_publishing_dialog_pane_get_type (void) G_GNUC_CONST;
GType spit_publishing_plugin_host_button_mode_get_type (void) G_GNUC_CONST;
GType spit_publishing_publisher_media_type_get_type (void) G_GNUC_CONST;
GType spit_publishing_publishable_get_type (void) G_GNUC_CONST;
GType spit_publishing_plugin_host_get_type (void) G_GNUC_CONST;
GType spit_publishing_service_get_type (void) G_GNUC_CONST;
GType spit_publishing_publisher_get_type (void) G_GNUC_CONST;
SpitPublishingService* spit_publishing_publisher_get_service (SpitPublishingPublisher* self);
void spit_publishing_publisher_start (SpitPublishingPublisher* self);
gboolean spit_publishing_publisher_is_running (SpitPublishingPublisher* self);
void spit_publishing_publisher_stop (SpitPublishingPublisher* self);
void spit_publishing_publisher_reserved0 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved0 (SpitPublishingPublisher* self);
void spit_publishing_publisher_reserved1 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved1 (SpitPublishingPublisher* self);
void spit_publishing_publisher_reserved2 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved2 (SpitPublishingPublisher* self);
void spit_publishing_publisher_reserved3 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved3 (SpitPublishingPublisher* self);
void spit_publishing_publisher_reserved4 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved4 (SpitPublishingPublisher* self);
void spit_publishing_publisher_reserved5 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved5 (SpitPublishingPublisher* self);
void spit_publishing_publisher_reserved6 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved6 (SpitPublishingPublisher* self);
void spit_publishing_publisher_reserved7 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved7 (SpitPublishingPublisher* self);
GtkWidget* spit_publishing_dialog_pane_get_widget (SpitPublishingDialogPane* self);
SpitPublishingDialogPaneGeometryOptions spit_publishing_dialog_pane_get_preferred_geometry (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_on_pane_installed (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_on_pane_uninstalled (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_reserved0 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved0 (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_reserved1 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved1 (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_reserved2 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved2 (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_reserved3 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved3 (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_reserved4 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved4 (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_reserved5 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved5 (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_reserved6 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved6 (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_reserved7 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved7 (SpitPublishingDialogPane* self);
void spit_publishing_plugin_host_post_error (SpitPublishingPluginHost* self, GError* err);
void spit_publishing_plugin_host_stop_publishing (SpitPublishingPluginHost* self);
SpitPublishingPublisher* spit_publishing_plugin_host_get_publisher (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_install_dialog_pane (SpitPublishingPluginHost* self, SpitPublishingDialogPane* pane, SpitPublishingPluginHostButtonMode mode);
void spit_publishing_plugin_host_install_static_message_pane (SpitPublishingPluginHost* self, const gchar* message, SpitPublishingPluginHostButtonMode mode);
void spit_publishing_plugin_host_install_pango_message_pane (SpitPublishingPluginHost* self, const gchar* markup, SpitPublishingPluginHostButtonMode mode);
void spit_publishing_plugin_host_install_success_pane (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_install_account_fetch_wait_pane (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_install_login_wait_pane (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_install_welcome_pane (SpitPublishingPluginHost* self, const gchar* welcome_message, SpitPublishingLoginCallback on_login_clicked, void* on_login_clicked_target);
void spit_publishing_plugin_host_set_service_locked (SpitPublishingPluginHost* self, gboolean is_locked);
void spit_publishing_plugin_host_set_dialog_default_widget (SpitPublishingPluginHost* self, GtkWidget* widget);
SpitPublishingPublishable** spit_publishing_plugin_host_get_publishables (SpitPublishingPluginHost* self, int* result_length1);
SpitPublishingProgressCallback spit_publishing_plugin_host_serialize_publishables (SpitPublishingPluginHost* self, gint content_major_axis, gboolean strip_metadata, void** result_target, GDestroyNotify* result_target_destroy_notify);
SpitPublishingPublisherMediaType spit_publishing_plugin_host_get_publishable_media_type (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_reserved0 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved0 (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_reserved1 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved1 (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_reserved2 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved2 (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_reserved3 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved3 (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_reserved4 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved4 (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_reserved5 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved5 (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_reserved6 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved6 (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_reserved7 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved7 (SpitPublishingPluginHost* self);
GFile* spit_publishing_publishable_get_serialized_file (SpitPublishingPublishable* self);
gchar* spit_publishing_publishable_get_publishing_name (SpitPublishingPublishable* self);
gchar* spit_publishing_publishable_get_param_string (SpitPublishingPublishable* self, const gchar* name);
gchar** spit_publishing_publishable_get_publishing_keywords (SpitPublishingPublishable* self, int* result_length1);
SpitPublishingPublisherMediaType spit_publishing_publishable_get_media_type (SpitPublishingPublishable* self);
GDateTime* spit_publishing_publishable_get_exposure_date_time (SpitPublishingPublishable* self);
void spit_publishing_publishable_reserved0 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved0 (SpitPublishingPublishable* self);
void spit_publishing_publishable_reserved1 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved1 (SpitPublishingPublishable* self);
void spit_publishing_publishable_reserved2 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved2 (SpitPublishingPublishable* self);
void spit_publishing_publishable_reserved3 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved3 (SpitPublishingPublishable* self);
void spit_publishing_publishable_reserved4 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved4 (SpitPublishingPublishable* self);
void spit_publishing_publishable_reserved5 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved5 (SpitPublishingPublishable* self);
void spit_publishing_publishable_reserved6 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved6 (SpitPublishingPublishable* self);
void spit_publishing_publishable_reserved7 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved7 (SpitPublishingPublishable* self);
#define SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_BASENAME "basename"
#define SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_TITLE "title"
#define SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_COMMENT "comment"
#define SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_EVENTCOMMENT "eventcomment"
SpitPublishingPublisher* spit_publishing_service_create_publisher (SpitPublishingService* self, SpitPublishingPluginHost* host);
SpitPublishingPublisherMediaType spit_publishing_service_get_supported_media (SpitPublishingService* self);
void spit_publishing_service_reserved0 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved0 (SpitPublishingService* self);
void spit_publishing_service_reserved1 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved1 (SpitPublishingService* self);
void spit_publishing_service_reserved2 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved2 (SpitPublishingService* self);
void spit_publishing_service_reserved3 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved3 (SpitPublishingService* self);
void spit_publishing_service_reserved4 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved4 (SpitPublishingService* self);
void spit_publishing_service_reserved5 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved5 (SpitPublishingService* self);
void spit_publishing_service_reserved6 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved6 (SpitPublishingService* self);
void spit_publishing_service_reserved7 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved7 (SpitPublishingService* self);
GType spit_publishing_authenticator_get_type (void) G_GNUC_CONST;
void spit_publishing_authenticator_authenticate (SpitPublishingAuthenticator* self);
gboolean spit_publishing_authenticator_can_logout (SpitPublishingAuthenticator* self);
void spit_publishing_authenticator_logout (SpitPublishingAuthenticator* self);
void spit_publishing_authenticator_refresh (SpitPublishingAuthenticator* self);
GHashTable* spit_publishing_authenticator_get_authentication_parameter (SpitPublishingAuthenticator* self);
GType spit_publishing_authenticator_factory_get_type (void) G_GNUC_CONST;
GeeList* spit_publishing_authenticator_factory_get_available_authenticators (SpitPublishingAuthenticatorFactory* self);
SpitPublishingAuthenticator* spit_publishing_authenticator_factory_create (SpitPublishingAuthenticatorFactory* self, const gchar* provider, SpitPublishingPluginHost* host);


GQuark spit_publishing_publishing_error_quark (void) {
	return g_quark_from_static_string ("spit_publishing_publishing_error-quark");
}


/**
     * Describes the kinds of media a publishing service supports.
     *
     * Values can be masked together, for example: {{{(MediaType.PHOTO | MediaType.VIDEO)}}}
     * indicates that a publishing service supports the upload of both photos and videos.
     */
GType spit_publishing_publisher_media_type_get_type (void) {
	static volatile gsize spit_publishing_publisher_media_type_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_publisher_media_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_NONE, "SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_NONE", "none"}, {SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_PHOTO, "SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_PHOTO", "photo"}, {SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_VIDEO, "SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_VIDEO", "video"}, {0, NULL, NULL}};
		GType spit_publishing_publisher_media_type_type_id;
		spit_publishing_publisher_media_type_type_id = g_enum_register_static ("SpitPublishingPublisherMediaType", values);
		g_once_init_leave (&spit_publishing_publisher_media_type_type_id__volatile, spit_publishing_publisher_media_type_type_id);
	}
	return spit_publishing_publisher_media_type_type_id__volatile;
}


/**
     * Returns a {@link Service} object describing the service to which this connects.
     */
SpitPublishingService* spit_publishing_publisher_get_service (SpitPublishingPublisher* self) {
#line 121 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self), NULL);
#line 121 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->get_service (self);
#line 479 "PublishingInterfaces.c"
}


/**
     * Makes this publisher enter the running state and endows it with exclusive access
     * to the shared services provided by the {@link PluginHost}. Through the host’s interface,
     * this publisher can install user interface panes and query configuration information.
     * Only running services should perform network operations.
     */
void spit_publishing_publisher_start (SpitPublishingPublisher* self) {
#line 129 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 129 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->start (self);
#line 494 "PublishingInterfaces.c"
}


/**
     * Returns true if this publisher is in the running state; false otherwise.
     */
gboolean spit_publishing_publisher_is_running (SpitPublishingPublisher* self) {
#line 134 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self), FALSE);
#line 134 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->is_running (self);
#line 506 "PublishingInterfaces.c"
}


/**
     * Causes this publisher to enter a non-running state. This publisher should stop all
     * network operations and cease use of the shared services provided by the {@link PluginHost}.
     */
void spit_publishing_publisher_stop (SpitPublishingPublisher* self) {
#line 140 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 140 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->stop (self);
#line 519 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_real_reserved0 (SpitPublishingPublisher* self) {
}


void spit_publishing_publisher_reserved0 (SpitPublishingPublisher* self) {
#line 145 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 145 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->reserved0 (self);
#line 532 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_real_reserved1 (SpitPublishingPublisher* self) {
}


void spit_publishing_publisher_reserved1 (SpitPublishingPublisher* self) {
#line 146 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 146 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->reserved1 (self);
#line 545 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_real_reserved2 (SpitPublishingPublisher* self) {
}


void spit_publishing_publisher_reserved2 (SpitPublishingPublisher* self) {
#line 147 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 147 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->reserved2 (self);
#line 558 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_real_reserved3 (SpitPublishingPublisher* self) {
}


void spit_publishing_publisher_reserved3 (SpitPublishingPublisher* self) {
#line 148 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 148 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->reserved3 (self);
#line 571 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_real_reserved4 (SpitPublishingPublisher* self) {
}


void spit_publishing_publisher_reserved4 (SpitPublishingPublisher* self) {
#line 149 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 149 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->reserved4 (self);
#line 584 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_real_reserved5 (SpitPublishingPublisher* self) {
}


void spit_publishing_publisher_reserved5 (SpitPublishingPublisher* self) {
#line 150 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 150 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->reserved5 (self);
#line 597 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_real_reserved6 (SpitPublishingPublisher* self) {
}


void spit_publishing_publisher_reserved6 (SpitPublishingPublisher* self) {
#line 151 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 151 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->reserved6 (self);
#line 610 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_real_reserved7 (SpitPublishingPublisher* self) {
}


void spit_publishing_publisher_reserved7 (SpitPublishingPublisher* self) {
#line 152 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 152 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->reserved7 (self);
#line 623 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_base_init (SpitPublishingPublisherIface * iface) {
#line 105 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	static gboolean initialized = FALSE;
#line 105 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	if (!initialized) {
#line 105 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		initialized = TRUE;
#line 105 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved0 = spit_publishing_publisher_real_reserved0;
#line 105 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved1 = spit_publishing_publisher_real_reserved1;
#line 105 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved2 = spit_publishing_publisher_real_reserved2;
#line 105 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved3 = spit_publishing_publisher_real_reserved3;
#line 105 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved4 = spit_publishing_publisher_real_reserved4;
#line 105 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved5 = spit_publishing_publisher_real_reserved5;
#line 105 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved6 = spit_publishing_publisher_real_reserved6;
#line 105 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved7 = spit_publishing_publisher_real_reserved7;
#line 650 "PublishingInterfaces.c"
	}
}


/** 
 * Represents a connection to a publishing service.
 *
 * Developers of publishing plugins provide a class that implements this interface. At
 * any given time, only one Publisher can be running. When a publisher is running, it is
 * allowed to access the network and has exclusive use of the shared user-interface and
 * configuration services provided by the {@link PluginHost}. Publishers are created in
 * a non-running state and do not begin running until start( ) is invoked. Publishers
 * run until stop( ) is invoked.
 */
GType spit_publishing_publisher_get_type (void) {
	static volatile gsize spit_publishing_publisher_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_publisher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingPublisherIface), (GBaseInitFunc) spit_publishing_publisher_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_publishing_publisher_type_id;
		spit_publishing_publisher_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingPublisher", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_publishing_publisher_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_publishing_publisher_type_id__volatile, spit_publishing_publisher_type_id);
	}
	return spit_publishing_publisher_type_id__volatile;
}


/**
     * Describes how the on-screen publishing dialog box should look and behave when an associated
     * pane is installed in the on-screen publishing dialog box.
     */
GType spit_publishing_dialog_pane_geometry_options_get_type (void) {
	static volatile gsize spit_publishing_dialog_pane_geometry_options_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_dialog_pane_geometry_options_type_id__volatile)) {
		static const GEnumValue values[] = {{SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_NONE, "SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_NONE", "none"}, {SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_EXTENDED_SIZE, "SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_EXTENDED_SIZE", "extended-size"}, {SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_RESIZABLE, "SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_RESIZABLE", "resizable"}, {SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_COLOSSAL_SIZE, "SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_COLOSSAL_SIZE", "colossal-size"}, {0, NULL, NULL}};
		GType spit_publishing_dialog_pane_geometry_options_type_id;
		spit_publishing_dialog_pane_geometry_options_type_id = g_enum_register_static ("SpitPublishingDialogPaneGeometryOptions", values);
		g_once_init_leave (&spit_publishing_dialog_pane_geometry_options_type_id__volatile, spit_publishing_dialog_pane_geometry_options_type_id);
	}
	return spit_publishing_dialog_pane_geometry_options_type_id__volatile;
}


/**
     * Returns the Gtk.Widget that is this pane's on-screen representation.
     */
GtkWidget* spit_publishing_dialog_pane_get_widget (SpitPublishingDialogPane* self) {
#line 197 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self), NULL);
#line 197 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->get_widget (self);
#line 702 "PublishingInterfaces.c"
}


/**
     * Returns a {@link GeometryOptions} bitfield describing how the on-screen publishing dialog
     * box should look and behave when this pane is installed.
     */
SpitPublishingDialogPaneGeometryOptions spit_publishing_dialog_pane_get_preferred_geometry (SpitPublishingDialogPane* self) {
#line 203 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self), 0);
#line 203 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->get_preferred_geometry (self);
#line 715 "PublishingInterfaces.c"
}


/**
     * Invoked automatically by Shotwell when this pane has been installed into the on-screen
     * publishing dialog box and become visible to the user.
     */
void spit_publishing_dialog_pane_on_pane_installed (SpitPublishingDialogPane* self) {
#line 209 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 209 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->on_pane_installed (self);
#line 728 "PublishingInterfaces.c"
}


/**
     * Invoked automatically by Shotwell when this pane has been removed from the on-screen
     * publishing dialog box and is no longer visible to the user.
     */
void spit_publishing_dialog_pane_on_pane_uninstalled (SpitPublishingDialogPane* self) {
#line 215 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 215 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->on_pane_uninstalled (self);
#line 741 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_real_reserved0 (SpitPublishingDialogPane* self) {
}


void spit_publishing_dialog_pane_reserved0 (SpitPublishingDialogPane* self) {
#line 220 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 220 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->reserved0 (self);
#line 754 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_real_reserved1 (SpitPublishingDialogPane* self) {
}


void spit_publishing_dialog_pane_reserved1 (SpitPublishingDialogPane* self) {
#line 221 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 221 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->reserved1 (self);
#line 767 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_real_reserved2 (SpitPublishingDialogPane* self) {
}


void spit_publishing_dialog_pane_reserved2 (SpitPublishingDialogPane* self) {
#line 222 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 222 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->reserved2 (self);
#line 780 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_real_reserved3 (SpitPublishingDialogPane* self) {
}


void spit_publishing_dialog_pane_reserved3 (SpitPublishingDialogPane* self) {
#line 223 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 223 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->reserved3 (self);
#line 793 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_real_reserved4 (SpitPublishingDialogPane* self) {
}


void spit_publishing_dialog_pane_reserved4 (SpitPublishingDialogPane* self) {
#line 224 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 224 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->reserved4 (self);
#line 806 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_real_reserved5 (SpitPublishingDialogPane* self) {
}


void spit_publishing_dialog_pane_reserved5 (SpitPublishingDialogPane* self) {
#line 225 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 225 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->reserved5 (self);
#line 819 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_real_reserved6 (SpitPublishingDialogPane* self) {
}


void spit_publishing_dialog_pane_reserved6 (SpitPublishingDialogPane* self) {
#line 226 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 226 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->reserved6 (self);
#line 832 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_real_reserved7 (SpitPublishingDialogPane* self) {
}


void spit_publishing_dialog_pane_reserved7 (SpitPublishingDialogPane* self) {
#line 227 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 227 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->reserved7 (self);
#line 845 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_base_init (SpitPublishingDialogPaneIface * iface) {
#line 160 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	static gboolean initialized = FALSE;
#line 160 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	if (!initialized) {
#line 160 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		initialized = TRUE;
#line 160 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved0 = spit_publishing_dialog_pane_real_reserved0;
#line 160 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved1 = spit_publishing_dialog_pane_real_reserved1;
#line 160 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved2 = spit_publishing_dialog_pane_real_reserved2;
#line 160 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved3 = spit_publishing_dialog_pane_real_reserved3;
#line 160 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved4 = spit_publishing_dialog_pane_real_reserved4;
#line 160 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved5 = spit_publishing_dialog_pane_real_reserved5;
#line 160 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved6 = spit_publishing_dialog_pane_real_reserved6;
#line 160 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved7 = spit_publishing_dialog_pane_real_reserved7;
#line 872 "PublishingInterfaces.c"
	}
}


/**
 * Encapsulates a pane that can be installed in the on-screen publishing dialog box to
 * communicate status to and to get information from the user.
 *
 */
GType spit_publishing_dialog_pane_get_type (void) {
	static volatile gsize spit_publishing_dialog_pane_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_dialog_pane_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingDialogPaneIface), (GBaseInitFunc) spit_publishing_dialog_pane_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_publishing_dialog_pane_type_id;
		spit_publishing_dialog_pane_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingDialogPane", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_publishing_dialog_pane_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_publishing_dialog_pane_type_id__volatile, spit_publishing_dialog_pane_type_id);
	}
	return spit_publishing_dialog_pane_type_id__volatile;
}


/**
     * Specifies the label text on the push button control that appears in the
     * lower-right-hand corner of the on-screen publishing dialog box.
     */
GType spit_publishing_plugin_host_button_mode_get_type (void) {
	static volatile gsize spit_publishing_plugin_host_button_mode_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_plugin_host_button_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CLOSE, "SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CLOSE", "close"}, {SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CANCEL, "SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CANCEL", "cancel"}, {0, NULL, NULL}};
		GType spit_publishing_plugin_host_button_mode_type_id;
		spit_publishing_plugin_host_button_mode_type_id = g_enum_register_static ("SpitPublishingPluginHostButtonMode", values);
		g_once_init_leave (&spit_publishing_plugin_host_button_mode_type_id__volatile, spit_publishing_plugin_host_button_mode_type_id);
	}
	return spit_publishing_plugin_host_button_mode_type_id__volatile;
}


/**
     * Notifies the user that an unrecoverable publishing error has occurred and halts
     * the publishing process.
     *
     * @param err An error object that describes the kind of error that occurred.
     */
void spit_publishing_plugin_host_post_error (SpitPublishingPluginHost* self, GError* err) {
#line 277 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 277 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->post_error (self, err);
#line 922 "PublishingInterfaces.c"
}


/**
     * Halts the publishing process.
     *
     * Calling this method stops all network activity and hides the on-screen publishing
     * dialog box.
     */
void spit_publishing_plugin_host_stop_publishing (SpitPublishingPluginHost* self) {
#line 285 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 285 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->stop_publishing (self);
#line 937 "PublishingInterfaces.c"
}


/**
     * Returns a reference to the {@link Publisher} object that this is currently hosting.
     */
SpitPublishingPublisher* spit_publishing_plugin_host_get_publisher (SpitPublishingPluginHost* self) {
#line 290 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self), NULL);
#line 290 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->get_publisher (self);
#line 949 "PublishingInterfaces.c"
}


/**
     * Attempts to install a pane in the on-screen publishing dialog box, making the pane visible
     * and allowing it to interact with the user.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     * 
     * @param pane the pane to install
     *
     * @param mode allows you to set the text displayed on the close/cancel button in the
     * lower-right-hand corner of the on-screen publishing dialog box when pane is installed.
     * If mode is ButtonMode.CLOSE, the button will have the title "Close." If mode is
     * ButtonMode.CANCEL, the button will be titled "Cancel." You should set mode depending on
     * whether a cancellable action is in progress. For example, if your publisher is in the
     * middle of uploading 3 of 8 videos, then mode should be ButtonMode.CANCEL. However, if
     * the publishing operation has completed and the success pane is displayed, then mode
     * should be ButtonMode.CLOSE, because all cancellable publishing actions have already
     * occurred.
     */
void spit_publishing_plugin_host_install_dialog_pane (SpitPublishingPluginHost* self, SpitPublishingDialogPane* pane, SpitPublishingPluginHostButtonMode mode) {
#line 310 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 310 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->install_dialog_pane (self, pane, mode);
#line 976 "PublishingInterfaces.c"
}


/**
     * Attempts to install a pane in the on-screen publishing dialog box that contains
     * static text.
     *
     * The text appears centered in the publishing dialog box and is drawn in
     * the system font. This is a convenience method only; similar results could be
     * achieved by manually constructing a Gtk.Label widget, wrapping it inside a
     * {@link DialogPane}, and installing it manually with a call to
     * install_dialog_pane( ). To provide visual consistency across publishing services,
     * however, always use this convenience method instead of constructing label panes when
     * you need to display static text to the user.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     * 
     * @param message the text to show in the pane
     *
     * @param mode allows you to set the text displayed on the close/cancel button in the
     * lower-right-hand corner of the on-screen publishing dialog box when pane is installed.
     * If mode is ButtonMode.CLOSE, the button will have the title "Close." If mode is
     * ButtonMode.CANCEL, the button will be titled "Cancel." You should set mode depending on
     * whether a cancellable action is in progress. For example, if your publisher is in the
     * middle of uploading 3 of 8 videos, then mode should be ButtonMode.CANCEL. However, if
     * the publishing operation has completed and the success pane is displayed, then mode
     * should be ButtonMode.CLOSE, because all cancellable publishing actions have already
     * occurred.
     */
void spit_publishing_plugin_host_install_static_message_pane (SpitPublishingPluginHost* self, const gchar* message, SpitPublishingPluginHostButtonMode mode) {
#line 339 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 339 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->install_static_message_pane (self, message, mode);
#line 1011 "PublishingInterfaces.c"
}


/**
     * Works just like {@link install_static_message_pane} but allows markup to contain
     * Pango text formatting tags as well as unstyled text.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     * 
     * @param markup the text to show in the pane, marked up with Pango formatting tags.
     *
     * @param mode allows you to set the text displayed on the close/cancel button in the
     * lower-right-hand corner of the on-screen publishing dialog box when pane is installed.
     * If mode is ButtonMode.CLOSE, the button will have the title "Close." If mode is
     * ButtonMode.CANCEL, the button will be titled "Cancel." You should set mode depending on
     * whether a cancellable action is in progress. For example, if your publisher is in the
     * middle of uploading 3 of 8 videos, then mode should be ButtonMode.CANCEL. However, if
     * the publishing operation has completed and the success pane is displayed, then mode
     * should be ButtonMode.CLOSE, because all cancellable publishing actions have already
     * occurred.
     */
void spit_publishing_plugin_host_install_pango_message_pane (SpitPublishingPluginHost* self, const gchar* markup, SpitPublishingPluginHostButtonMode mode) {
#line 360 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 360 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->install_pango_message_pane (self, markup, mode);
#line 1038 "PublishingInterfaces.c"
}


/**
     * Attempts to install a pane in the on-screen publishing dialog box notifying the user
     * that his or her publishing operation completed successfully.
     * 
     * The text displayed depends on the type of media the current publishing service
     * supports. To provide visual consistency across publishing services and to allow
     * Shotwell to handle internationalization, always use this convenience method; don’t
     * contruct and install success panes manually.
     *
     * If an error has posted, the {@link PluginHost} will not honor
     * this request.
     */
void spit_publishing_plugin_host_install_success_pane (SpitPublishingPluginHost* self) {
#line 375 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 375 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->install_success_pane (self);
#line 1059 "PublishingInterfaces.c"
}


/**
     * Attempts to install a pane displaying the static text “Fetching account information...”
     * in the on-screen publishing dialog box, making it visible to the user.
     *
     * This is a convenience method only; similar results could be achieved by calling
     * {@link install_static_message_pane} with an appropriate text argument. To provide
     * visual consistency across publishing services and to allow Shotwell to handle
     * internationalization, however, you should always use this convenience method whenever
     * you need to tell the user that you’re querying account information over the network.
     * Queries such as this are almost always performed immediately after the user has logged
     * in to the remote service.
     * 
     * If an error has posted, the {@link PluginHost} will not honor this request.
     */
void spit_publishing_plugin_host_install_account_fetch_wait_pane (SpitPublishingPluginHost* self) {
#line 391 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 391 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->install_account_fetch_wait_pane (self);
#line 1082 "PublishingInterfaces.c"
}


/**
     * Works just like {@link install_account_fetch_wait_pane} but displays the static text
     * “Logging in...“
     * 
     * As with {@link install_account_fetch_wait_pane}, this is a convenience method, but
     * you should you use it provide to visual consistency and to let Shotwell handle
     * internationalization. See the description of {@link install_account_fetch_wait_pane}
     * for more information.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     */
void spit_publishing_plugin_host_install_login_wait_pane (SpitPublishingPluginHost* self) {
#line 405 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 405 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->install_login_wait_pane (self);
#line 1102 "PublishingInterfaces.c"
}


/**
     * Attempts to install a pane displaying the text 'welcome_message' above a push
     * button labeled “Login” in the on-screen publishing dialog box, making it visible to the
     * user.
     *
     * When the user clicks the “Login” button, you’ll be notified of the user’s action through
     * the callback 'on_login_clicked'. Every Publisher should provide a welcome pane to
     * introduce the service and explain service-specific features or restrictions. To provide
     * visual consistency across publishing services and to allow Shotwell to handle
     * internationalization, always use this convenience method; don’t contruct and install
     * welcome panes manually.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     *
     * @param welcome_message the text to be displayed above a push button labeled “Login”
     * in the on-screen publishing dialog box.
     *
     * @param on_login_clicked specifies the callback that is invoked when the user clicks
     * the “Login” button.
     */
void spit_publishing_plugin_host_install_welcome_pane (SpitPublishingPluginHost* self, const gchar* welcome_message, SpitPublishingLoginCallback on_login_clicked, void* on_login_clicked_target) {
#line 427 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 427 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->install_welcome_pane (self, welcome_message, on_login_clicked, on_login_clicked_target);
#line 1131 "PublishingInterfaces.c"
}


/**
     * Toggles whether the service selector combo box in the upper-right-hand corner of the
     * on-screen publishing dialog box is sensitive to input.
     *
     * Publishers should make the service selector box insensitive to input when they are performing
     * non-interruptible file or network operations, since switching to another publishing
     * service will halt whatever service is currently running. Under certain circumstances,
     * the {@link PluginHost} may not honor this request.
     *
     * @param is_locked when is_locked is true, the service selector combo box is made insensitive.
     * It appears greyed out and the user is prevented from switching to another publishing service.
     * When is_locked is false, the combo box is sensitive, allowing the user to freely switch
     * from the current service to another service. 
     */
void spit_publishing_plugin_host_set_service_locked (SpitPublishingPluginHost* self, gboolean is_locked) {
#line 444 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 444 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->set_service_locked (self, is_locked);
#line 1154 "PublishingInterfaces.c"
}


/**
     * Makes the designated widget the default widget for the publishing dialog.
     *
     * After a call to this method, the designated widget will be activated whenever the user
     * presses the [ENTER] key anywhere in the on-screen publishing dialog box. Under certain
     * circumstances, the {@link PluginHost} may not honor this request.
     *
     * @param widget a reference to the widget to designate as the default widget for the
     *               publishing dialog.
     */
void spit_publishing_plugin_host_set_dialog_default_widget (SpitPublishingPluginHost* self, GtkWidget* widget) {
#line 456 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 456 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->set_dialog_default_widget (self, widget);
#line 1173 "PublishingInterfaces.c"
}


/**
     * Returns an array of the publishable media items that the user has selected for upload to the
     * remote service.
     */
SpitPublishingPublishable** spit_publishing_plugin_host_get_publishables (SpitPublishingPluginHost* self, int* result_length1) {
#line 462 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self), NULL);
#line 462 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->get_publishables (self, result_length1);
#line 1186 "PublishingInterfaces.c"
}


/**
     * Writes all of the publishable media items that the user has selected for upload to the
     * remote service to a temporary directory on a local disk.
     *
     * You should call this method immediately before sending the publishable media items to the
     * remote service over the network. Because serializing several megabytes of data is a
     * potentially lengthy operation, calling this method installs an activity status pane in
     * the on-screen publishing dialog box. The activity status pane displays a progress bar along
     * with a string of informational text.
     *
     * Because sending items over the network to the remote service is also a potentially lengthy
     * operation, you should leave the activity status pane installed in the on-screen publishing
     * dialog box until this task is finished. Periodically during the sending process, you should
     * report to the user on the progress of his or her upload. You can do this by invoking the
     * returned {@link ProgressCallback} delegate.
     *
     * After calling this method, the activity status pane that this method installs remains
     * displayed in the on-screen publishing dialog box until you install a new pane.
     *
     * @param content_major_axis when serializing publishable media items that are photos,
     *                           ensure that neither the width nor the height of the serialized
     *                           photo is greater than content_major_axis pixels. The value of
     *                           this parameter has no effect on video publishables.
     *
     * @param strip_metadata when serializing publishable media items that are photos, if
     *                       strip_metadata is true, all EXIF, IPTC, and XMP metadata will be
     *                       removed from the serialized file. If strip_metadata is false, all
     *                       metadata will be left intact. The value of this parameter has no
     *                       effect on video publishables.
     */
SpitPublishingProgressCallback spit_publishing_plugin_host_serialize_publishables (SpitPublishingPluginHost* self, gint content_major_axis, gboolean strip_metadata, void** result_target, GDestroyNotify* result_target_destroy_notify) {
#line 494 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self), NULL);
#line 494 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->serialize_publishables (self, content_major_axis, strip_metadata, result_target, result_target_destroy_notify);
#line 1225 "PublishingInterfaces.c"
}


/**
     * Returns a {@link Publisher.MediaType} bitfield describing which kinds of media are present
     * in the set of publishable media items that the user has selected for upload to the remote
     * service.
     */
SpitPublishingPublisherMediaType spit_publishing_plugin_host_get_publishable_media_type (SpitPublishingPluginHost* self) {
#line 502 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self), 0);
#line 502 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->get_publishable_media_type (self);
#line 1239 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_real_reserved0 (SpitPublishingPluginHost* self) {
}


void spit_publishing_plugin_host_reserved0 (SpitPublishingPluginHost* self) {
#line 507 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 507 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->reserved0 (self);
#line 1252 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_real_reserved1 (SpitPublishingPluginHost* self) {
}


void spit_publishing_plugin_host_reserved1 (SpitPublishingPluginHost* self) {
#line 508 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 508 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->reserved1 (self);
#line 1265 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_real_reserved2 (SpitPublishingPluginHost* self) {
}


void spit_publishing_plugin_host_reserved2 (SpitPublishingPluginHost* self) {
#line 509 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 509 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->reserved2 (self);
#line 1278 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_real_reserved3 (SpitPublishingPluginHost* self) {
}


void spit_publishing_plugin_host_reserved3 (SpitPublishingPluginHost* self) {
#line 510 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 510 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->reserved3 (self);
#line 1291 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_real_reserved4 (SpitPublishingPluginHost* self) {
}


void spit_publishing_plugin_host_reserved4 (SpitPublishingPluginHost* self) {
#line 511 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 511 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->reserved4 (self);
#line 1304 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_real_reserved5 (SpitPublishingPluginHost* self) {
}


void spit_publishing_plugin_host_reserved5 (SpitPublishingPluginHost* self) {
#line 512 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 512 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->reserved5 (self);
#line 1317 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_real_reserved6 (SpitPublishingPluginHost* self) {
}


void spit_publishing_plugin_host_reserved6 (SpitPublishingPluginHost* self) {
#line 513 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 513 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->reserved6 (self);
#line 1330 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_real_reserved7 (SpitPublishingPluginHost* self) {
}


void spit_publishing_plugin_host_reserved7 (SpitPublishingPluginHost* self) {
#line 514 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 514 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->reserved7 (self);
#line 1343 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_base_init (SpitPublishingPluginHostIface * iface) {
#line 260 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	static gboolean initialized = FALSE;
#line 260 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	if (!initialized) {
#line 260 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		initialized = TRUE;
#line 260 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved0 = spit_publishing_plugin_host_real_reserved0;
#line 260 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved1 = spit_publishing_plugin_host_real_reserved1;
#line 260 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved2 = spit_publishing_plugin_host_real_reserved2;
#line 260 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved3 = spit_publishing_plugin_host_real_reserved3;
#line 260 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved4 = spit_publishing_plugin_host_real_reserved4;
#line 260 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved5 = spit_publishing_plugin_host_real_reserved5;
#line 260 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved6 = spit_publishing_plugin_host_real_reserved6;
#line 260 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved7 = spit_publishing_plugin_host_real_reserved7;
#line 1370 "PublishingInterfaces.c"
	}
}


/**
 * Manages and provides services for publishing plugins.
 *
 * Implemented inside Shotwell, the PluginHost provides an interface through which the
 * developers of publishing plugins can query and make changes to the publishing
 * environment. For example, through the PluginHost, plugins can get a list of the photos
 * and videos to be published, install and remove user-interface panes in the publishing
 * dialog box, and request that the items to be uploaded be serialized to a temporary
 * directory on disk. Plugins can use the services of the PluginHost only when their
 * {@link Publisher} is in the running state. This ensures that non-running publishers
 * don’t destructively interfere with the actively running publisher.
 */
GType spit_publishing_plugin_host_get_type (void) {
	static volatile gsize spit_publishing_plugin_host_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_plugin_host_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingPluginHostIface), (GBaseInitFunc) spit_publishing_plugin_host_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_publishing_plugin_host_type_id;
		spit_publishing_plugin_host_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingPluginHost", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_publishing_plugin_host_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (spit_publishing_plugin_host_type_id, SPIT_TYPE_HOST_INTERFACE);
		g_once_init_leave (&spit_publishing_plugin_host_type_id__volatile, spit_publishing_plugin_host_type_id);
	}
	return spit_publishing_plugin_host_type_id__volatile;
}


/**
     * Returns a handle to the file on disk to which this publishable's data has been
     * serialized.
     *
     * You should use this file handle to read into memory the binary data you will send over
     * the network to the remote publishing service when this publishable is uploaded.
     */
GFile* spit_publishing_publishable_get_serialized_file (SpitPublishingPublishable* self) {
#line 535 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), NULL);
#line 535 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->get_serialized_file (self);
#line 1413 "PublishingInterfaces.c"
}


/**
     * Returns a name that can be used to identify this publishable to the remote service.
     * If the publishing host cannot derive a sensible name, this method will
     * return an empty string. Plugins should be able to handle that situation
     * and provide a fallback value. One possible option for a fallback is:
     * get_param_string(Spit.Publishing.Publishable.PARAM_STRING_BASENAME)
     */
gchar* spit_publishing_publishable_get_publishing_name (SpitPublishingPublishable* self) {
#line 544 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), NULL);
#line 544 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->get_publishing_name (self);
#line 1429 "PublishingInterfaces.c"
}


/**
     * Returns a string value from the publishable corresponding with the parameter name 
     * provided, or null if there is no value for this name.
     */
gchar* spit_publishing_publishable_get_param_string (SpitPublishingPublishable* self, const gchar* name) {
#line 550 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), NULL);
#line 550 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->get_param_string (self, name);
#line 1442 "PublishingInterfaces.c"
}


/**
     * Returns an array of strings that should be used to tag or mark this publishable on the
     * remote service, or null if this publishable has no tags or markings.
     */
gchar** spit_publishing_publishable_get_publishing_keywords (SpitPublishingPublishable* self, int* result_length1) {
#line 556 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), NULL);
#line 556 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->get_publishing_keywords (self, result_length1);
#line 1455 "PublishingInterfaces.c"
}


/**
     * Returns the kind of media item this publishable encapsulates.
     */
SpitPublishingPublisherMediaType spit_publishing_publishable_get_media_type (SpitPublishingPublishable* self) {
#line 561 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), 0);
#line 561 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->get_media_type (self);
#line 1467 "PublishingInterfaces.c"
}


/**
     * Returns the creation timestamp on the file.
     */
GDateTime* spit_publishing_publishable_get_exposure_date_time (SpitPublishingPublishable* self) {
#line 566 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), NULL);
#line 566 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->get_exposure_date_time (self);
#line 1479 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_real_reserved0 (SpitPublishingPublishable* self) {
}


void spit_publishing_publishable_reserved0 (SpitPublishingPublishable* self) {
#line 571 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
#line 571 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->reserved0 (self);
#line 1492 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_real_reserved1 (SpitPublishingPublishable* self) {
}


void spit_publishing_publishable_reserved1 (SpitPublishingPublishable* self) {
#line 572 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
#line 572 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->reserved1 (self);
#line 1505 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_real_reserved2 (SpitPublishingPublishable* self) {
}


void spit_publishing_publishable_reserved2 (SpitPublishingPublishable* self) {
#line 573 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
#line 573 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->reserved2 (self);
#line 1518 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_real_reserved3 (SpitPublishingPublishable* self) {
}


void spit_publishing_publishable_reserved3 (SpitPublishingPublishable* self) {
#line 574 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
#line 574 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->reserved3 (self);
#line 1531 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_real_reserved4 (SpitPublishingPublishable* self) {
}


void spit_publishing_publishable_reserved4 (SpitPublishingPublishable* self) {
#line 575 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
#line 575 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->reserved4 (self);
#line 1544 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_real_reserved5 (SpitPublishingPublishable* self) {
}


void spit_publishing_publishable_reserved5 (SpitPublishingPublishable* self) {
#line 576 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
#line 576 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->reserved5 (self);
#line 1557 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_real_reserved6 (SpitPublishingPublishable* self) {
}


void spit_publishing_publishable_reserved6 (SpitPublishingPublishable* self) {
#line 577 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
#line 577 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->reserved6 (self);
#line 1570 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_real_reserved7 (SpitPublishingPublishable* self) {
}


void spit_publishing_publishable_reserved7 (SpitPublishingPublishable* self) {
#line 578 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
#line 578 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->reserved7 (self);
#line 1583 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_base_init (SpitPublishingPublishableIface * iface) {
#line 521 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	static gboolean initialized = FALSE;
#line 521 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	if (!initialized) {
#line 521 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		initialized = TRUE;
#line 521 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved0 = spit_publishing_publishable_real_reserved0;
#line 521 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved1 = spit_publishing_publishable_real_reserved1;
#line 521 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved2 = spit_publishing_publishable_real_reserved2;
#line 521 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved3 = spit_publishing_publishable_real_reserved3;
#line 521 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved4 = spit_publishing_publishable_real_reserved4;
#line 521 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved5 = spit_publishing_publishable_real_reserved5;
#line 521 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved6 = spit_publishing_publishable_real_reserved6;
#line 521 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved7 = spit_publishing_publishable_real_reserved7;
#line 1610 "PublishingInterfaces.c"
	}
}


/**
 * Describes an underlying media item (such as a photo or a video) that your plugin
 * uploads to a remote publishing service.
 */
GType spit_publishing_publishable_get_type (void) {
	static volatile gsize spit_publishing_publishable_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_publishable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingPublishableIface), (GBaseInitFunc) spit_publishing_publishable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_publishing_publishable_type_id;
		spit_publishing_publishable_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingPublishable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_publishing_publishable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_publishing_publishable_type_id__volatile, spit_publishing_publishable_type_id);
	}
	return spit_publishing_publishable_type_id__volatile;
}


/**
     * A factory method that instantiates and returns a new {@link Publisher} object that
     * encapsulates a connection to the remote publishing service that this Service describes.
     */
SpitPublishingPublisher* spit_publishing_service_create_publisher (SpitPublishingService* self, SpitPublishingPluginHost* host) {
#line 591 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_SERVICE (self), NULL);
#line 591 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->create_publisher (self, host);
#line 1641 "PublishingInterfaces.c"
}


/**
     * Returns the kinds of media that this service can work with.
     */
SpitPublishingPublisherMediaType spit_publishing_service_get_supported_media (SpitPublishingService* self) {
#line 596 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_SERVICE (self), 0);
#line 596 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->get_supported_media (self);
#line 1653 "PublishingInterfaces.c"
}


static void spit_publishing_service_real_reserved0 (SpitPublishingService* self) {
}


void spit_publishing_service_reserved0 (SpitPublishingService* self) {
#line 601 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
#line 601 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->reserved0 (self);
#line 1666 "PublishingInterfaces.c"
}


static void spit_publishing_service_real_reserved1 (SpitPublishingService* self) {
}


void spit_publishing_service_reserved1 (SpitPublishingService* self) {
#line 602 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
#line 602 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->reserved1 (self);
#line 1679 "PublishingInterfaces.c"
}


static void spit_publishing_service_real_reserved2 (SpitPublishingService* self) {
}


void spit_publishing_service_reserved2 (SpitPublishingService* self) {
#line 603 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
#line 603 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->reserved2 (self);
#line 1692 "PublishingInterfaces.c"
}


static void spit_publishing_service_real_reserved3 (SpitPublishingService* self) {
}


void spit_publishing_service_reserved3 (SpitPublishingService* self) {
#line 604 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
#line 604 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->reserved3 (self);
#line 1705 "PublishingInterfaces.c"
}


static void spit_publishing_service_real_reserved4 (SpitPublishingService* self) {
}


void spit_publishing_service_reserved4 (SpitPublishingService* self) {
#line 605 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
#line 605 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->reserved4 (self);
#line 1718 "PublishingInterfaces.c"
}


static void spit_publishing_service_real_reserved5 (SpitPublishingService* self) {
}


void spit_publishing_service_reserved5 (SpitPublishingService* self) {
#line 606 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
#line 606 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->reserved5 (self);
#line 1731 "PublishingInterfaces.c"
}


static void spit_publishing_service_real_reserved6 (SpitPublishingService* self) {
}


void spit_publishing_service_reserved6 (SpitPublishingService* self) {
#line 607 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
#line 607 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->reserved6 (self);
#line 1744 "PublishingInterfaces.c"
}


static void spit_publishing_service_real_reserved7 (SpitPublishingService* self) {
}


void spit_publishing_service_reserved7 (SpitPublishingService* self) {
#line 608 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
#line 608 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->reserved7 (self);
#line 1757 "PublishingInterfaces.c"
}


static void spit_publishing_service_base_init (SpitPublishingServiceIface * iface) {
#line 586 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	static gboolean initialized = FALSE;
#line 586 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	if (!initialized) {
#line 586 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		initialized = TRUE;
#line 586 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved0 = spit_publishing_service_real_reserved0;
#line 586 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved1 = spit_publishing_service_real_reserved1;
#line 586 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved2 = spit_publishing_service_real_reserved2;
#line 586 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved3 = spit_publishing_service_real_reserved3;
#line 586 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved4 = spit_publishing_service_real_reserved4;
#line 586 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved5 = spit_publishing_service_real_reserved5;
#line 586 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved6 = spit_publishing_service_real_reserved6;
#line 586 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved7 = spit_publishing_service_real_reserved7;
#line 1784 "PublishingInterfaces.c"
	}
}


/**
 * Describes the features and capabilities of a remote publishing service.
 *
 * Developers of publishing plugins provide a class that implements this interface.
 */
GType spit_publishing_service_get_type (void) {
	static volatile gsize spit_publishing_service_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingServiceIface), (GBaseInitFunc) spit_publishing_service_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_publishing_service_type_id;
		spit_publishing_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingService", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_publishing_service_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (spit_publishing_service_type_id, SPIT_TYPE_PLUGGABLE);
		g_once_init_leave (&spit_publishing_service_type_id__volatile, spit_publishing_service_type_id);
	}
	return spit_publishing_service_type_id__volatile;
}


void spit_publishing_authenticator_authenticate (SpitPublishingAuthenticator* self) {
#line 615 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_AUTHENTICATOR (self));
#line 615 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_AUTHENTICATOR_GET_INTERFACE (self)->authenticate (self);
#line 1813 "PublishingInterfaces.c"
}


gboolean spit_publishing_authenticator_can_logout (SpitPublishingAuthenticator* self) {
#line 616 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_AUTHENTICATOR (self), FALSE);
#line 616 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_AUTHENTICATOR_GET_INTERFACE (self)->can_logout (self);
#line 1822 "PublishingInterfaces.c"
}


void spit_publishing_authenticator_logout (SpitPublishingAuthenticator* self) {
#line 617 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_AUTHENTICATOR (self));
#line 617 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_AUTHENTICATOR_GET_INTERFACE (self)->logout (self);
#line 1831 "PublishingInterfaces.c"
}


void spit_publishing_authenticator_refresh (SpitPublishingAuthenticator* self) {
#line 618 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_AUTHENTICATOR (self));
#line 618 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_AUTHENTICATOR_GET_INTERFACE (self)->refresh (self);
#line 1840 "PublishingInterfaces.c"
}


GHashTable* spit_publishing_authenticator_get_authentication_parameter (SpitPublishingAuthenticator* self) {
#line 620 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_AUTHENTICATOR (self), NULL);
#line 620 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_AUTHENTICATOR_GET_INTERFACE (self)->get_authentication_parameter (self);
#line 1849 "PublishingInterfaces.c"
}


static void spit_publishing_authenticator_base_init (SpitPublishingAuthenticatorIface * iface) {
#line 611 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	static gboolean initialized = FALSE;
#line 611 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	if (!initialized) {
#line 611 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		initialized = TRUE;
#line 611 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		spit_publishing_authenticator_signals[SPIT_PUBLISHING_AUTHENTICATOR_AUTHENTICATED_SIGNAL] = g_signal_new ("authenticated", SPIT_PUBLISHING_TYPE_AUTHENTICATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 611 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		spit_publishing_authenticator_signals[SPIT_PUBLISHING_AUTHENTICATOR_AUTHENTICATION_FAILED_SIGNAL] = g_signal_new ("authentication-failed", SPIT_PUBLISHING_TYPE_AUTHENTICATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1864 "PublishingInterfaces.c"
	}
}


GType spit_publishing_authenticator_get_type (void) {
	static volatile gsize spit_publishing_authenticator_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_authenticator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingAuthenticatorIface), (GBaseInitFunc) spit_publishing_authenticator_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_publishing_authenticator_type_id;
		spit_publishing_authenticator_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingAuthenticator", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_publishing_authenticator_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_publishing_authenticator_type_id__volatile, spit_publishing_authenticator_type_id);
	}
	return spit_publishing_authenticator_type_id__volatile;
}


GeeList* spit_publishing_authenticator_factory_get_available_authenticators (SpitPublishingAuthenticatorFactory* self) {
#line 628 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_AUTHENTICATOR_FACTORY (self), NULL);
#line 628 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_AUTHENTICATOR_FACTORY_GET_INTERFACE (self)->get_available_authenticators (self);
#line 1887 "PublishingInterfaces.c"
}


SpitPublishingAuthenticator* spit_publishing_authenticator_factory_create (SpitPublishingAuthenticatorFactory* self, const gchar* provider, SpitPublishingPluginHost* host) {
#line 629 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_AUTHENTICATOR_FACTORY (self), NULL);
#line 629 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_AUTHENTICATOR_FACTORY_GET_INTERFACE (self)->create (self, provider, host);
#line 1896 "PublishingInterfaces.c"
}


static void spit_publishing_authenticator_factory_base_init (SpitPublishingAuthenticatorFactoryIface * iface) {
#line 623 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	static gboolean initialized = FALSE;
#line 623 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	if (!initialized) {
#line 623 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		initialized = TRUE;
#line 1907 "PublishingInterfaces.c"
	}
}


GType spit_publishing_authenticator_factory_get_type (void) {
	static volatile gsize spit_publishing_authenticator_factory_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_authenticator_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingAuthenticatorFactoryIface), (GBaseInitFunc) spit_publishing_authenticator_factory_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_publishing_authenticator_factory_type_id;
		spit_publishing_authenticator_factory_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingAuthenticatorFactory", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_publishing_authenticator_factory_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_publishing_authenticator_factory_type_id__volatile, spit_publishing_authenticator_factory_type_id);
	}
	return spit_publishing_authenticator_factory_type_id__volatile;
}



