#!/bin/sh

set -e

newpackage=$1
newversion=$2

export QUILT_PATCHES=debian/patches

# Pop vendor-remove-unused-deps.patch
quilt pop vendor-remove-unused-deps.patch
quilt pop

# Prepare a new patch
quilt new update-$newpackage-$newversion.patch

# Update the dependency in the lockfile
quilt shell cargo update -p $newpackage --precise $newversion --manifest-path rust/Cargo.toml
# Update the vendored dependencies
quilt shell debian/rules vendor-deps

# Record the changes
quilt refresh

# Push the rest of the patches. The new update might conflict with the vendor-remove-unused-deps patch.
quilt push -a
