/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_DEVICE_H
#define VN_PROTOCOL_DRIVER_DEVICE_H

#include "vn_instance.h"
#include "vn_protocol_driver_structs.h"

/*
 * These structs/unions/commands are not included
 *
 *   vkGetDeviceProcAddr
 */

/* struct VkPhysicalDeviceLimits */

static inline size_t
vn_sizeof_VkPhysicalDeviceLimits(const VkPhysicalDeviceLimits *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->maxImageDimension1D);
    size += vn_sizeof_uint32_t(&val->maxImageDimension2D);
    size += vn_sizeof_uint32_t(&val->maxImageDimension3D);
    size += vn_sizeof_uint32_t(&val->maxImageDimensionCube);
    size += vn_sizeof_uint32_t(&val->maxImageArrayLayers);
    size += vn_sizeof_uint32_t(&val->maxTexelBufferElements);
    size += vn_sizeof_uint32_t(&val->maxUniformBufferRange);
    size += vn_sizeof_uint32_t(&val->maxStorageBufferRange);
    size += vn_sizeof_uint32_t(&val->maxPushConstantsSize);
    size += vn_sizeof_uint32_t(&val->maxMemoryAllocationCount);
    size += vn_sizeof_uint32_t(&val->maxSamplerAllocationCount);
    size += vn_sizeof_VkDeviceSize(&val->bufferImageGranularity);
    size += vn_sizeof_VkDeviceSize(&val->sparseAddressSpaceSize);
    size += vn_sizeof_uint32_t(&val->maxBoundDescriptorSets);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorSamplers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUniformBuffers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorStorageBuffers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorSampledImages);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorStorageImages);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorInputAttachments);
    size += vn_sizeof_uint32_t(&val->maxPerStageResources);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetSamplers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUniformBuffers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUniformBuffersDynamic);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetStorageBuffers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetStorageBuffersDynamic);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetSampledImages);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetStorageImages);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetInputAttachments);
    size += vn_sizeof_uint32_t(&val->maxVertexInputAttributes);
    size += vn_sizeof_uint32_t(&val->maxVertexInputBindings);
    size += vn_sizeof_uint32_t(&val->maxVertexInputAttributeOffset);
    size += vn_sizeof_uint32_t(&val->maxVertexInputBindingStride);
    size += vn_sizeof_uint32_t(&val->maxVertexOutputComponents);
    size += vn_sizeof_uint32_t(&val->maxTessellationGenerationLevel);
    size += vn_sizeof_uint32_t(&val->maxTessellationPatchSize);
    size += vn_sizeof_uint32_t(&val->maxTessellationControlPerVertexInputComponents);
    size += vn_sizeof_uint32_t(&val->maxTessellationControlPerVertexOutputComponents);
    size += vn_sizeof_uint32_t(&val->maxTessellationControlPerPatchOutputComponents);
    size += vn_sizeof_uint32_t(&val->maxTessellationControlTotalOutputComponents);
    size += vn_sizeof_uint32_t(&val->maxTessellationEvaluationInputComponents);
    size += vn_sizeof_uint32_t(&val->maxTessellationEvaluationOutputComponents);
    size += vn_sizeof_uint32_t(&val->maxGeometryShaderInvocations);
    size += vn_sizeof_uint32_t(&val->maxGeometryInputComponents);
    size += vn_sizeof_uint32_t(&val->maxGeometryOutputComponents);
    size += vn_sizeof_uint32_t(&val->maxGeometryOutputVertices);
    size += vn_sizeof_uint32_t(&val->maxGeometryTotalOutputComponents);
    size += vn_sizeof_uint32_t(&val->maxFragmentInputComponents);
    size += vn_sizeof_uint32_t(&val->maxFragmentOutputAttachments);
    size += vn_sizeof_uint32_t(&val->maxFragmentDualSrcAttachments);
    size += vn_sizeof_uint32_t(&val->maxFragmentCombinedOutputResources);
    size += vn_sizeof_uint32_t(&val->maxComputeSharedMemorySize);
    size += vn_sizeof_array_size(3);
    size += vn_sizeof_uint32_t_array(val->maxComputeWorkGroupCount, 3);
    size += vn_sizeof_uint32_t(&val->maxComputeWorkGroupInvocations);
    size += vn_sizeof_array_size(3);
    size += vn_sizeof_uint32_t_array(val->maxComputeWorkGroupSize, 3);
    size += vn_sizeof_uint32_t(&val->subPixelPrecisionBits);
    size += vn_sizeof_uint32_t(&val->subTexelPrecisionBits);
    size += vn_sizeof_uint32_t(&val->mipmapPrecisionBits);
    size += vn_sizeof_uint32_t(&val->maxDrawIndexedIndexValue);
    size += vn_sizeof_uint32_t(&val->maxDrawIndirectCount);
    size += vn_sizeof_float(&val->maxSamplerLodBias);
    size += vn_sizeof_float(&val->maxSamplerAnisotropy);
    size += vn_sizeof_uint32_t(&val->maxViewports);
    size += vn_sizeof_array_size(2);
    size += vn_sizeof_uint32_t_array(val->maxViewportDimensions, 2);
    size += vn_sizeof_array_size(2);
    size += vn_sizeof_float_array(val->viewportBoundsRange, 2);
    size += vn_sizeof_uint32_t(&val->viewportSubPixelBits);
    size += vn_sizeof_size_t(&val->minMemoryMapAlignment);
    size += vn_sizeof_VkDeviceSize(&val->minTexelBufferOffsetAlignment);
    size += vn_sizeof_VkDeviceSize(&val->minUniformBufferOffsetAlignment);
    size += vn_sizeof_VkDeviceSize(&val->minStorageBufferOffsetAlignment);
    size += vn_sizeof_int32_t(&val->minTexelOffset);
    size += vn_sizeof_uint32_t(&val->maxTexelOffset);
    size += vn_sizeof_int32_t(&val->minTexelGatherOffset);
    size += vn_sizeof_uint32_t(&val->maxTexelGatherOffset);
    size += vn_sizeof_float(&val->minInterpolationOffset);
    size += vn_sizeof_float(&val->maxInterpolationOffset);
    size += vn_sizeof_uint32_t(&val->subPixelInterpolationOffsetBits);
    size += vn_sizeof_uint32_t(&val->maxFramebufferWidth);
    size += vn_sizeof_uint32_t(&val->maxFramebufferHeight);
    size += vn_sizeof_uint32_t(&val->maxFramebufferLayers);
    size += vn_sizeof_VkFlags(&val->framebufferColorSampleCounts);
    size += vn_sizeof_VkFlags(&val->framebufferDepthSampleCounts);
    size += vn_sizeof_VkFlags(&val->framebufferStencilSampleCounts);
    size += vn_sizeof_VkFlags(&val->framebufferNoAttachmentsSampleCounts);
    size += vn_sizeof_uint32_t(&val->maxColorAttachments);
    size += vn_sizeof_VkFlags(&val->sampledImageColorSampleCounts);
    size += vn_sizeof_VkFlags(&val->sampledImageIntegerSampleCounts);
    size += vn_sizeof_VkFlags(&val->sampledImageDepthSampleCounts);
    size += vn_sizeof_VkFlags(&val->sampledImageStencilSampleCounts);
    size += vn_sizeof_VkFlags(&val->storageImageSampleCounts);
    size += vn_sizeof_uint32_t(&val->maxSampleMaskWords);
    size += vn_sizeof_VkBool32(&val->timestampComputeAndGraphics);
    size += vn_sizeof_float(&val->timestampPeriod);
    size += vn_sizeof_uint32_t(&val->maxClipDistances);
    size += vn_sizeof_uint32_t(&val->maxCullDistances);
    size += vn_sizeof_uint32_t(&val->maxCombinedClipAndCullDistances);
    size += vn_sizeof_uint32_t(&val->discreteQueuePriorities);
    size += vn_sizeof_array_size(2);
    size += vn_sizeof_float_array(val->pointSizeRange, 2);
    size += vn_sizeof_array_size(2);
    size += vn_sizeof_float_array(val->lineWidthRange, 2);
    size += vn_sizeof_float(&val->pointSizeGranularity);
    size += vn_sizeof_float(&val->lineWidthGranularity);
    size += vn_sizeof_VkBool32(&val->strictLines);
    size += vn_sizeof_VkBool32(&val->standardSampleLocations);
    size += vn_sizeof_VkDeviceSize(&val->optimalBufferCopyOffsetAlignment);
    size += vn_sizeof_VkDeviceSize(&val->optimalBufferCopyRowPitchAlignment);
    size += vn_sizeof_VkDeviceSize(&val->nonCoherentAtomSize);
    return size;
}

static inline void
vn_decode_VkPhysicalDeviceLimits(struct vn_cs_decoder *dec, VkPhysicalDeviceLimits *val)
{
    vn_decode_uint32_t(dec, &val->maxImageDimension1D);
    vn_decode_uint32_t(dec, &val->maxImageDimension2D);
    vn_decode_uint32_t(dec, &val->maxImageDimension3D);
    vn_decode_uint32_t(dec, &val->maxImageDimensionCube);
    vn_decode_uint32_t(dec, &val->maxImageArrayLayers);
    vn_decode_uint32_t(dec, &val->maxTexelBufferElements);
    vn_decode_uint32_t(dec, &val->maxUniformBufferRange);
    vn_decode_uint32_t(dec, &val->maxStorageBufferRange);
    vn_decode_uint32_t(dec, &val->maxPushConstantsSize);
    vn_decode_uint32_t(dec, &val->maxMemoryAllocationCount);
    vn_decode_uint32_t(dec, &val->maxSamplerAllocationCount);
    vn_decode_VkDeviceSize(dec, &val->bufferImageGranularity);
    vn_decode_VkDeviceSize(dec, &val->sparseAddressSpaceSize);
    vn_decode_uint32_t(dec, &val->maxBoundDescriptorSets);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorSamplers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUniformBuffers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorStorageBuffers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorSampledImages);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorStorageImages);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorInputAttachments);
    vn_decode_uint32_t(dec, &val->maxPerStageResources);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetSamplers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUniformBuffers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUniformBuffersDynamic);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetStorageBuffers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetStorageBuffersDynamic);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetSampledImages);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetStorageImages);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetInputAttachments);
    vn_decode_uint32_t(dec, &val->maxVertexInputAttributes);
    vn_decode_uint32_t(dec, &val->maxVertexInputBindings);
    vn_decode_uint32_t(dec, &val->maxVertexInputAttributeOffset);
    vn_decode_uint32_t(dec, &val->maxVertexInputBindingStride);
    vn_decode_uint32_t(dec, &val->maxVertexOutputComponents);
    vn_decode_uint32_t(dec, &val->maxTessellationGenerationLevel);
    vn_decode_uint32_t(dec, &val->maxTessellationPatchSize);
    vn_decode_uint32_t(dec, &val->maxTessellationControlPerVertexInputComponents);
    vn_decode_uint32_t(dec, &val->maxTessellationControlPerVertexOutputComponents);
    vn_decode_uint32_t(dec, &val->maxTessellationControlPerPatchOutputComponents);
    vn_decode_uint32_t(dec, &val->maxTessellationControlTotalOutputComponents);
    vn_decode_uint32_t(dec, &val->maxTessellationEvaluationInputComponents);
    vn_decode_uint32_t(dec, &val->maxTessellationEvaluationOutputComponents);
    vn_decode_uint32_t(dec, &val->maxGeometryShaderInvocations);
    vn_decode_uint32_t(dec, &val->maxGeometryInputComponents);
    vn_decode_uint32_t(dec, &val->maxGeometryOutputComponents);
    vn_decode_uint32_t(dec, &val->maxGeometryOutputVertices);
    vn_decode_uint32_t(dec, &val->maxGeometryTotalOutputComponents);
    vn_decode_uint32_t(dec, &val->maxFragmentInputComponents);
    vn_decode_uint32_t(dec, &val->maxFragmentOutputAttachments);
    vn_decode_uint32_t(dec, &val->maxFragmentDualSrcAttachments);
    vn_decode_uint32_t(dec, &val->maxFragmentCombinedOutputResources);
    vn_decode_uint32_t(dec, &val->maxComputeSharedMemorySize);
    {
        const size_t array_size = vn_decode_array_size(dec, 3);
        vn_decode_uint32_t_array(dec, val->maxComputeWorkGroupCount, array_size);
    }
    vn_decode_uint32_t(dec, &val->maxComputeWorkGroupInvocations);
    {
        const size_t array_size = vn_decode_array_size(dec, 3);
        vn_decode_uint32_t_array(dec, val->maxComputeWorkGroupSize, array_size);
    }
    vn_decode_uint32_t(dec, &val->subPixelPrecisionBits);
    vn_decode_uint32_t(dec, &val->subTexelPrecisionBits);
    vn_decode_uint32_t(dec, &val->mipmapPrecisionBits);
    vn_decode_uint32_t(dec, &val->maxDrawIndexedIndexValue);
    vn_decode_uint32_t(dec, &val->maxDrawIndirectCount);
    vn_decode_float(dec, &val->maxSamplerLodBias);
    vn_decode_float(dec, &val->maxSamplerAnisotropy);
    vn_decode_uint32_t(dec, &val->maxViewports);
    {
        const size_t array_size = vn_decode_array_size(dec, 2);
        vn_decode_uint32_t_array(dec, val->maxViewportDimensions, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, 2);
        vn_decode_float_array(dec, val->viewportBoundsRange, array_size);
    }
    vn_decode_uint32_t(dec, &val->viewportSubPixelBits);
    vn_decode_size_t(dec, &val->minMemoryMapAlignment);
    vn_decode_VkDeviceSize(dec, &val->minTexelBufferOffsetAlignment);
    vn_decode_VkDeviceSize(dec, &val->minUniformBufferOffsetAlignment);
    vn_decode_VkDeviceSize(dec, &val->minStorageBufferOffsetAlignment);
    vn_decode_int32_t(dec, &val->minTexelOffset);
    vn_decode_uint32_t(dec, &val->maxTexelOffset);
    vn_decode_int32_t(dec, &val->minTexelGatherOffset);
    vn_decode_uint32_t(dec, &val->maxTexelGatherOffset);
    vn_decode_float(dec, &val->minInterpolationOffset);
    vn_decode_float(dec, &val->maxInterpolationOffset);
    vn_decode_uint32_t(dec, &val->subPixelInterpolationOffsetBits);
    vn_decode_uint32_t(dec, &val->maxFramebufferWidth);
    vn_decode_uint32_t(dec, &val->maxFramebufferHeight);
    vn_decode_uint32_t(dec, &val->maxFramebufferLayers);
    vn_decode_VkFlags(dec, &val->framebufferColorSampleCounts);
    vn_decode_VkFlags(dec, &val->framebufferDepthSampleCounts);
    vn_decode_VkFlags(dec, &val->framebufferStencilSampleCounts);
    vn_decode_VkFlags(dec, &val->framebufferNoAttachmentsSampleCounts);
    vn_decode_uint32_t(dec, &val->maxColorAttachments);
    vn_decode_VkFlags(dec, &val->sampledImageColorSampleCounts);
    vn_decode_VkFlags(dec, &val->sampledImageIntegerSampleCounts);
    vn_decode_VkFlags(dec, &val->sampledImageDepthSampleCounts);
    vn_decode_VkFlags(dec, &val->sampledImageStencilSampleCounts);
    vn_decode_VkFlags(dec, &val->storageImageSampleCounts);
    vn_decode_uint32_t(dec, &val->maxSampleMaskWords);
    vn_decode_VkBool32(dec, &val->timestampComputeAndGraphics);
    vn_decode_float(dec, &val->timestampPeriod);
    vn_decode_uint32_t(dec, &val->maxClipDistances);
    vn_decode_uint32_t(dec, &val->maxCullDistances);
    vn_decode_uint32_t(dec, &val->maxCombinedClipAndCullDistances);
    vn_decode_uint32_t(dec, &val->discreteQueuePriorities);
    {
        const size_t array_size = vn_decode_array_size(dec, 2);
        vn_decode_float_array(dec, val->pointSizeRange, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, 2);
        vn_decode_float_array(dec, val->lineWidthRange, array_size);
    }
    vn_decode_float(dec, &val->pointSizeGranularity);
    vn_decode_float(dec, &val->lineWidthGranularity);
    vn_decode_VkBool32(dec, &val->strictLines);
    vn_decode_VkBool32(dec, &val->standardSampleLocations);
    vn_decode_VkDeviceSize(dec, &val->optimalBufferCopyOffsetAlignment);
    vn_decode_VkDeviceSize(dec, &val->optimalBufferCopyRowPitchAlignment);
    vn_decode_VkDeviceSize(dec, &val->nonCoherentAtomSize);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceLimits_partial(const VkPhysicalDeviceLimits *val)
{
    size_t size = 0;
    /* skip val->maxImageDimension1D */
    /* skip val->maxImageDimension2D */
    /* skip val->maxImageDimension3D */
    /* skip val->maxImageDimensionCube */
    /* skip val->maxImageArrayLayers */
    /* skip val->maxTexelBufferElements */
    /* skip val->maxUniformBufferRange */
    /* skip val->maxStorageBufferRange */
    /* skip val->maxPushConstantsSize */
    /* skip val->maxMemoryAllocationCount */
    /* skip val->maxSamplerAllocationCount */
    /* skip val->bufferImageGranularity */
    /* skip val->sparseAddressSpaceSize */
    /* skip val->maxBoundDescriptorSets */
    /* skip val->maxPerStageDescriptorSamplers */
    /* skip val->maxPerStageDescriptorUniformBuffers */
    /* skip val->maxPerStageDescriptorStorageBuffers */
    /* skip val->maxPerStageDescriptorSampledImages */
    /* skip val->maxPerStageDescriptorStorageImages */
    /* skip val->maxPerStageDescriptorInputAttachments */
    /* skip val->maxPerStageResources */
    /* skip val->maxDescriptorSetSamplers */
    /* skip val->maxDescriptorSetUniformBuffers */
    /* skip val->maxDescriptorSetUniformBuffersDynamic */
    /* skip val->maxDescriptorSetStorageBuffers */
    /* skip val->maxDescriptorSetStorageBuffersDynamic */
    /* skip val->maxDescriptorSetSampledImages */
    /* skip val->maxDescriptorSetStorageImages */
    /* skip val->maxDescriptorSetInputAttachments */
    /* skip val->maxVertexInputAttributes */
    /* skip val->maxVertexInputBindings */
    /* skip val->maxVertexInputAttributeOffset */
    /* skip val->maxVertexInputBindingStride */
    /* skip val->maxVertexOutputComponents */
    /* skip val->maxTessellationGenerationLevel */
    /* skip val->maxTessellationPatchSize */
    /* skip val->maxTessellationControlPerVertexInputComponents */
    /* skip val->maxTessellationControlPerVertexOutputComponents */
    /* skip val->maxTessellationControlPerPatchOutputComponents */
    /* skip val->maxTessellationControlTotalOutputComponents */
    /* skip val->maxTessellationEvaluationInputComponents */
    /* skip val->maxTessellationEvaluationOutputComponents */
    /* skip val->maxGeometryShaderInvocations */
    /* skip val->maxGeometryInputComponents */
    /* skip val->maxGeometryOutputComponents */
    /* skip val->maxGeometryOutputVertices */
    /* skip val->maxGeometryTotalOutputComponents */
    /* skip val->maxFragmentInputComponents */
    /* skip val->maxFragmentOutputAttachments */
    /* skip val->maxFragmentDualSrcAttachments */
    /* skip val->maxFragmentCombinedOutputResources */
    /* skip val->maxComputeSharedMemorySize */
    /* skip val->maxComputeWorkGroupCount */
    /* skip val->maxComputeWorkGroupInvocations */
    /* skip val->maxComputeWorkGroupSize */
    /* skip val->subPixelPrecisionBits */
    /* skip val->subTexelPrecisionBits */
    /* skip val->mipmapPrecisionBits */
    /* skip val->maxDrawIndexedIndexValue */
    /* skip val->maxDrawIndirectCount */
    /* skip val->maxSamplerLodBias */
    /* skip val->maxSamplerAnisotropy */
    /* skip val->maxViewports */
    /* skip val->maxViewportDimensions */
    /* skip val->viewportBoundsRange */
    /* skip val->viewportSubPixelBits */
    /* skip val->minMemoryMapAlignment */
    /* skip val->minTexelBufferOffsetAlignment */
    /* skip val->minUniformBufferOffsetAlignment */
    /* skip val->minStorageBufferOffsetAlignment */
    /* skip val->minTexelOffset */
    /* skip val->maxTexelOffset */
    /* skip val->minTexelGatherOffset */
    /* skip val->maxTexelGatherOffset */
    /* skip val->minInterpolationOffset */
    /* skip val->maxInterpolationOffset */
    /* skip val->subPixelInterpolationOffsetBits */
    /* skip val->maxFramebufferWidth */
    /* skip val->maxFramebufferHeight */
    /* skip val->maxFramebufferLayers */
    /* skip val->framebufferColorSampleCounts */
    /* skip val->framebufferDepthSampleCounts */
    /* skip val->framebufferStencilSampleCounts */
    /* skip val->framebufferNoAttachmentsSampleCounts */
    /* skip val->maxColorAttachments */
    /* skip val->sampledImageColorSampleCounts */
    /* skip val->sampledImageIntegerSampleCounts */
    /* skip val->sampledImageDepthSampleCounts */
    /* skip val->sampledImageStencilSampleCounts */
    /* skip val->storageImageSampleCounts */
    /* skip val->maxSampleMaskWords */
    /* skip val->timestampComputeAndGraphics */
    /* skip val->timestampPeriod */
    /* skip val->maxClipDistances */
    /* skip val->maxCullDistances */
    /* skip val->maxCombinedClipAndCullDistances */
    /* skip val->discreteQueuePriorities */
    /* skip val->pointSizeRange */
    /* skip val->lineWidthRange */
    /* skip val->pointSizeGranularity */
    /* skip val->lineWidthGranularity */
    /* skip val->strictLines */
    /* skip val->standardSampleLocations */
    /* skip val->optimalBufferCopyOffsetAlignment */
    /* skip val->optimalBufferCopyRowPitchAlignment */
    /* skip val->nonCoherentAtomSize */
    return size;
}

static inline void
vn_encode_VkPhysicalDeviceLimits_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceLimits *val)
{
    /* skip val->maxImageDimension1D */
    /* skip val->maxImageDimension2D */
    /* skip val->maxImageDimension3D */
    /* skip val->maxImageDimensionCube */
    /* skip val->maxImageArrayLayers */
    /* skip val->maxTexelBufferElements */
    /* skip val->maxUniformBufferRange */
    /* skip val->maxStorageBufferRange */
    /* skip val->maxPushConstantsSize */
    /* skip val->maxMemoryAllocationCount */
    /* skip val->maxSamplerAllocationCount */
    /* skip val->bufferImageGranularity */
    /* skip val->sparseAddressSpaceSize */
    /* skip val->maxBoundDescriptorSets */
    /* skip val->maxPerStageDescriptorSamplers */
    /* skip val->maxPerStageDescriptorUniformBuffers */
    /* skip val->maxPerStageDescriptorStorageBuffers */
    /* skip val->maxPerStageDescriptorSampledImages */
    /* skip val->maxPerStageDescriptorStorageImages */
    /* skip val->maxPerStageDescriptorInputAttachments */
    /* skip val->maxPerStageResources */
    /* skip val->maxDescriptorSetSamplers */
    /* skip val->maxDescriptorSetUniformBuffers */
    /* skip val->maxDescriptorSetUniformBuffersDynamic */
    /* skip val->maxDescriptorSetStorageBuffers */
    /* skip val->maxDescriptorSetStorageBuffersDynamic */
    /* skip val->maxDescriptorSetSampledImages */
    /* skip val->maxDescriptorSetStorageImages */
    /* skip val->maxDescriptorSetInputAttachments */
    /* skip val->maxVertexInputAttributes */
    /* skip val->maxVertexInputBindings */
    /* skip val->maxVertexInputAttributeOffset */
    /* skip val->maxVertexInputBindingStride */
    /* skip val->maxVertexOutputComponents */
    /* skip val->maxTessellationGenerationLevel */
    /* skip val->maxTessellationPatchSize */
    /* skip val->maxTessellationControlPerVertexInputComponents */
    /* skip val->maxTessellationControlPerVertexOutputComponents */
    /* skip val->maxTessellationControlPerPatchOutputComponents */
    /* skip val->maxTessellationControlTotalOutputComponents */
    /* skip val->maxTessellationEvaluationInputComponents */
    /* skip val->maxTessellationEvaluationOutputComponents */
    /* skip val->maxGeometryShaderInvocations */
    /* skip val->maxGeometryInputComponents */
    /* skip val->maxGeometryOutputComponents */
    /* skip val->maxGeometryOutputVertices */
    /* skip val->maxGeometryTotalOutputComponents */
    /* skip val->maxFragmentInputComponents */
    /* skip val->maxFragmentOutputAttachments */
    /* skip val->maxFragmentDualSrcAttachments */
    /* skip val->maxFragmentCombinedOutputResources */
    /* skip val->maxComputeSharedMemorySize */
    /* skip val->maxComputeWorkGroupCount */
    /* skip val->maxComputeWorkGroupInvocations */
    /* skip val->maxComputeWorkGroupSize */
    /* skip val->subPixelPrecisionBits */
    /* skip val->subTexelPrecisionBits */
    /* skip val->mipmapPrecisionBits */
    /* skip val->maxDrawIndexedIndexValue */
    /* skip val->maxDrawIndirectCount */
    /* skip val->maxSamplerLodBias */
    /* skip val->maxSamplerAnisotropy */
    /* skip val->maxViewports */
    /* skip val->maxViewportDimensions */
    /* skip val->viewportBoundsRange */
    /* skip val->viewportSubPixelBits */
    /* skip val->minMemoryMapAlignment */
    /* skip val->minTexelBufferOffsetAlignment */
    /* skip val->minUniformBufferOffsetAlignment */
    /* skip val->minStorageBufferOffsetAlignment */
    /* skip val->minTexelOffset */
    /* skip val->maxTexelOffset */
    /* skip val->minTexelGatherOffset */
    /* skip val->maxTexelGatherOffset */
    /* skip val->minInterpolationOffset */
    /* skip val->maxInterpolationOffset */
    /* skip val->subPixelInterpolationOffsetBits */
    /* skip val->maxFramebufferWidth */
    /* skip val->maxFramebufferHeight */
    /* skip val->maxFramebufferLayers */
    /* skip val->framebufferColorSampleCounts */
    /* skip val->framebufferDepthSampleCounts */
    /* skip val->framebufferStencilSampleCounts */
    /* skip val->framebufferNoAttachmentsSampleCounts */
    /* skip val->maxColorAttachments */
    /* skip val->sampledImageColorSampleCounts */
    /* skip val->sampledImageIntegerSampleCounts */
    /* skip val->sampledImageDepthSampleCounts */
    /* skip val->sampledImageStencilSampleCounts */
    /* skip val->storageImageSampleCounts */
    /* skip val->maxSampleMaskWords */
    /* skip val->timestampComputeAndGraphics */
    /* skip val->timestampPeriod */
    /* skip val->maxClipDistances */
    /* skip val->maxCullDistances */
    /* skip val->maxCombinedClipAndCullDistances */
    /* skip val->discreteQueuePriorities */
    /* skip val->pointSizeRange */
    /* skip val->lineWidthRange */
    /* skip val->pointSizeGranularity */
    /* skip val->lineWidthGranularity */
    /* skip val->strictLines */
    /* skip val->standardSampleLocations */
    /* skip val->optimalBufferCopyOffsetAlignment */
    /* skip val->optimalBufferCopyRowPitchAlignment */
    /* skip val->nonCoherentAtomSize */
}

/* struct VkPhysicalDeviceSparseProperties */

static inline size_t
vn_sizeof_VkPhysicalDeviceSparseProperties(const VkPhysicalDeviceSparseProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_VkBool32(&val->residencyStandard2DBlockShape);
    size += vn_sizeof_VkBool32(&val->residencyStandard2DMultisampleBlockShape);
    size += vn_sizeof_VkBool32(&val->residencyStandard3DBlockShape);
    size += vn_sizeof_VkBool32(&val->residencyAlignedMipSize);
    size += vn_sizeof_VkBool32(&val->residencyNonResidentStrict);
    return size;
}

static inline void
vn_decode_VkPhysicalDeviceSparseProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceSparseProperties *val)
{
    vn_decode_VkBool32(dec, &val->residencyStandard2DBlockShape);
    vn_decode_VkBool32(dec, &val->residencyStandard2DMultisampleBlockShape);
    vn_decode_VkBool32(dec, &val->residencyStandard3DBlockShape);
    vn_decode_VkBool32(dec, &val->residencyAlignedMipSize);
    vn_decode_VkBool32(dec, &val->residencyNonResidentStrict);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSparseProperties_partial(const VkPhysicalDeviceSparseProperties *val)
{
    size_t size = 0;
    /* skip val->residencyStandard2DBlockShape */
    /* skip val->residencyStandard2DMultisampleBlockShape */
    /* skip val->residencyStandard3DBlockShape */
    /* skip val->residencyAlignedMipSize */
    /* skip val->residencyNonResidentStrict */
    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSparseProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSparseProperties *val)
{
    /* skip val->residencyStandard2DBlockShape */
    /* skip val->residencyStandard2DMultisampleBlockShape */
    /* skip val->residencyStandard3DBlockShape */
    /* skip val->residencyAlignedMipSize */
    /* skip val->residencyNonResidentStrict */
}

/* struct VkPhysicalDeviceProperties */

static inline size_t
vn_sizeof_VkPhysicalDeviceProperties(const VkPhysicalDeviceProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->apiVersion);
    size += vn_sizeof_uint32_t(&val->driverVersion);
    size += vn_sizeof_uint32_t(&val->vendorID);
    size += vn_sizeof_uint32_t(&val->deviceID);
    size += vn_sizeof_VkPhysicalDeviceType(&val->deviceType);
    size += vn_sizeof_array_size(VK_MAX_PHYSICAL_DEVICE_NAME_SIZE);
    size += vn_sizeof_char_array(val->deviceName, VK_MAX_PHYSICAL_DEVICE_NAME_SIZE);
    size += vn_sizeof_array_size(VK_UUID_SIZE);
    size += vn_sizeof_uint8_t_array(val->pipelineCacheUUID, VK_UUID_SIZE);
    size += vn_sizeof_VkPhysicalDeviceLimits(&val->limits);
    size += vn_sizeof_VkPhysicalDeviceSparseProperties(&val->sparseProperties);
    return size;
}

static inline void
vn_decode_VkPhysicalDeviceProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceProperties *val)
{
    vn_decode_uint32_t(dec, &val->apiVersion);
    vn_decode_uint32_t(dec, &val->driverVersion);
    vn_decode_uint32_t(dec, &val->vendorID);
    vn_decode_uint32_t(dec, &val->deviceID);
    vn_decode_VkPhysicalDeviceType(dec, &val->deviceType);
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_PHYSICAL_DEVICE_NAME_SIZE);
        vn_decode_char_array(dec, val->deviceName, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_UUID_SIZE);
        vn_decode_uint8_t_array(dec, val->pipelineCacheUUID, array_size);
    }
    vn_decode_VkPhysicalDeviceLimits(dec, &val->limits);
    vn_decode_VkPhysicalDeviceSparseProperties(dec, &val->sparseProperties);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProperties_partial(const VkPhysicalDeviceProperties *val)
{
    size_t size = 0;
    /* skip val->apiVersion */
    /* skip val->driverVersion */
    /* skip val->vendorID */
    /* skip val->deviceID */
    /* skip val->deviceType */
    /* skip val->deviceName */
    /* skip val->pipelineCacheUUID */
    size += vn_sizeof_VkPhysicalDeviceLimits_partial(&val->limits);
    size += vn_sizeof_VkPhysicalDeviceSparseProperties_partial(&val->sparseProperties);
    return size;
}

static inline void
vn_encode_VkPhysicalDeviceProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProperties *val)
{
    /* skip val->apiVersion */
    /* skip val->driverVersion */
    /* skip val->vendorID */
    /* skip val->deviceID */
    /* skip val->deviceType */
    /* skip val->deviceName */
    /* skip val->pipelineCacheUUID */
    vn_encode_VkPhysicalDeviceLimits_partial(enc, &val->limits);
    vn_encode_VkPhysicalDeviceSparseProperties_partial(enc, &val->sparseProperties);
}

/* struct VkQueueFamilyProperties */

static inline size_t
vn_sizeof_VkQueueFamilyProperties(const VkQueueFamilyProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_VkFlags(&val->queueFlags);
    size += vn_sizeof_uint32_t(&val->queueCount);
    size += vn_sizeof_uint32_t(&val->timestampValidBits);
    size += vn_sizeof_VkExtent3D(&val->minImageTransferGranularity);
    return size;
}

static inline void
vn_decode_VkQueueFamilyProperties(struct vn_cs_decoder *dec, VkQueueFamilyProperties *val)
{
    vn_decode_VkFlags(dec, &val->queueFlags);
    vn_decode_uint32_t(dec, &val->queueCount);
    vn_decode_uint32_t(dec, &val->timestampValidBits);
    vn_decode_VkExtent3D(dec, &val->minImageTransferGranularity);
}

static inline size_t
vn_sizeof_VkQueueFamilyProperties_partial(const VkQueueFamilyProperties *val)
{
    size_t size = 0;
    /* skip val->queueFlags */
    /* skip val->queueCount */
    /* skip val->timestampValidBits */
    size += vn_sizeof_VkExtent3D_partial(&val->minImageTransferGranularity);
    return size;
}

static inline void
vn_encode_VkQueueFamilyProperties_partial(struct vn_cs_encoder *enc, const VkQueueFamilyProperties *val)
{
    /* skip val->queueFlags */
    /* skip val->queueCount */
    /* skip val->timestampValidBits */
    vn_encode_VkExtent3D_partial(enc, &val->minImageTransferGranularity);
}

/* struct VkMemoryType */

static inline size_t
vn_sizeof_VkMemoryType(const VkMemoryType *val)
{
    size_t size = 0;
    size += vn_sizeof_VkFlags(&val->propertyFlags);
    size += vn_sizeof_uint32_t(&val->heapIndex);
    return size;
}

static inline void
vn_decode_VkMemoryType(struct vn_cs_decoder *dec, VkMemoryType *val)
{
    vn_decode_VkFlags(dec, &val->propertyFlags);
    vn_decode_uint32_t(dec, &val->heapIndex);
}

static inline size_t
vn_sizeof_VkMemoryType_partial(const VkMemoryType *val)
{
    size_t size = 0;
    /* skip val->propertyFlags */
    /* skip val->heapIndex */
    return size;
}

static inline void
vn_encode_VkMemoryType_partial(struct vn_cs_encoder *enc, const VkMemoryType *val)
{
    /* skip val->propertyFlags */
    /* skip val->heapIndex */
}

/* struct VkMemoryHeap */

static inline size_t
vn_sizeof_VkMemoryHeap(const VkMemoryHeap *val)
{
    size_t size = 0;
    size += vn_sizeof_VkDeviceSize(&val->size);
    size += vn_sizeof_VkFlags(&val->flags);
    return size;
}

static inline void
vn_decode_VkMemoryHeap(struct vn_cs_decoder *dec, VkMemoryHeap *val)
{
    vn_decode_VkDeviceSize(dec, &val->size);
    vn_decode_VkFlags(dec, &val->flags);
}

static inline size_t
vn_sizeof_VkMemoryHeap_partial(const VkMemoryHeap *val)
{
    size_t size = 0;
    /* skip val->size */
    /* skip val->flags */
    return size;
}

static inline void
vn_encode_VkMemoryHeap_partial(struct vn_cs_encoder *enc, const VkMemoryHeap *val)
{
    /* skip val->size */
    /* skip val->flags */
}

/* struct VkPhysicalDeviceMemoryProperties */

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryProperties(const VkPhysicalDeviceMemoryProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->memoryTypeCount);
    size += vn_sizeof_array_size(VK_MAX_MEMORY_TYPES);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_TYPES; i++)
        size += vn_sizeof_VkMemoryType(&val->memoryTypes[i]);
    size += vn_sizeof_uint32_t(&val->memoryHeapCount);
    size += vn_sizeof_array_size(VK_MAX_MEMORY_HEAPS);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; i++)
        size += vn_sizeof_VkMemoryHeap(&val->memoryHeaps[i]);
    return size;
}

static inline void
vn_decode_VkPhysicalDeviceMemoryProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryProperties *val)
{
    vn_decode_uint32_t(dec, &val->memoryTypeCount);
    {
        const uint32_t iter_count = vn_decode_array_size(dec, VK_MAX_MEMORY_TYPES);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkMemoryType(dec, &val->memoryTypes[i]);
    }
    vn_decode_uint32_t(dec, &val->memoryHeapCount);
    {
        const uint32_t iter_count = vn_decode_array_size(dec, VK_MAX_MEMORY_HEAPS);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkMemoryHeap(dec, &val->memoryHeaps[i]);
    }
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryProperties_partial(const VkPhysicalDeviceMemoryProperties *val)
{
    size_t size = 0;
    /* skip val->memoryTypeCount */
    size += vn_sizeof_array_size(VK_MAX_MEMORY_TYPES);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_TYPES; i++)
        size += vn_sizeof_VkMemoryType_partial(&val->memoryTypes[i]);
    /* skip val->memoryHeapCount */
    size += vn_sizeof_array_size(VK_MAX_MEMORY_HEAPS);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; i++)
        size += vn_sizeof_VkMemoryHeap_partial(&val->memoryHeaps[i]);
    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryProperties *val)
{
    /* skip val->memoryTypeCount */
    vn_encode_array_size(enc, VK_MAX_MEMORY_TYPES);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_TYPES; i++)
        vn_encode_VkMemoryType_partial(enc, &val->memoryTypes[i]);
    /* skip val->memoryHeapCount */
    vn_encode_array_size(enc, VK_MAX_MEMORY_HEAPS);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; i++)
        vn_encode_VkMemoryHeap_partial(enc, &val->memoryHeaps[i]);
}

/* struct VkPhysicalDeviceFeatures */

static inline size_t
vn_sizeof_VkPhysicalDeviceFeatures(const VkPhysicalDeviceFeatures *val)
{
    size_t size = 0;
    size += vn_sizeof_VkBool32(&val->robustBufferAccess);
    size += vn_sizeof_VkBool32(&val->fullDrawIndexUint32);
    size += vn_sizeof_VkBool32(&val->imageCubeArray);
    size += vn_sizeof_VkBool32(&val->independentBlend);
    size += vn_sizeof_VkBool32(&val->geometryShader);
    size += vn_sizeof_VkBool32(&val->tessellationShader);
    size += vn_sizeof_VkBool32(&val->sampleRateShading);
    size += vn_sizeof_VkBool32(&val->dualSrcBlend);
    size += vn_sizeof_VkBool32(&val->logicOp);
    size += vn_sizeof_VkBool32(&val->multiDrawIndirect);
    size += vn_sizeof_VkBool32(&val->drawIndirectFirstInstance);
    size += vn_sizeof_VkBool32(&val->depthClamp);
    size += vn_sizeof_VkBool32(&val->depthBiasClamp);
    size += vn_sizeof_VkBool32(&val->fillModeNonSolid);
    size += vn_sizeof_VkBool32(&val->depthBounds);
    size += vn_sizeof_VkBool32(&val->wideLines);
    size += vn_sizeof_VkBool32(&val->largePoints);
    size += vn_sizeof_VkBool32(&val->alphaToOne);
    size += vn_sizeof_VkBool32(&val->multiViewport);
    size += vn_sizeof_VkBool32(&val->samplerAnisotropy);
    size += vn_sizeof_VkBool32(&val->textureCompressionETC2);
    size += vn_sizeof_VkBool32(&val->textureCompressionASTC_LDR);
    size += vn_sizeof_VkBool32(&val->textureCompressionBC);
    size += vn_sizeof_VkBool32(&val->occlusionQueryPrecise);
    size += vn_sizeof_VkBool32(&val->pipelineStatisticsQuery);
    size += vn_sizeof_VkBool32(&val->vertexPipelineStoresAndAtomics);
    size += vn_sizeof_VkBool32(&val->fragmentStoresAndAtomics);
    size += vn_sizeof_VkBool32(&val->shaderTessellationAndGeometryPointSize);
    size += vn_sizeof_VkBool32(&val->shaderImageGatherExtended);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageExtendedFormats);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageMultisample);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageReadWithoutFormat);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageWriteWithoutFormat);
    size += vn_sizeof_VkBool32(&val->shaderUniformBufferArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderSampledImageArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageBufferArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderClipDistance);
    size += vn_sizeof_VkBool32(&val->shaderCullDistance);
    size += vn_sizeof_VkBool32(&val->shaderFloat64);
    size += vn_sizeof_VkBool32(&val->shaderInt64);
    size += vn_sizeof_VkBool32(&val->shaderInt16);
    size += vn_sizeof_VkBool32(&val->shaderResourceResidency);
    size += vn_sizeof_VkBool32(&val->shaderResourceMinLod);
    size += vn_sizeof_VkBool32(&val->sparseBinding);
    size += vn_sizeof_VkBool32(&val->sparseResidencyBuffer);
    size += vn_sizeof_VkBool32(&val->sparseResidencyImage2D);
    size += vn_sizeof_VkBool32(&val->sparseResidencyImage3D);
    size += vn_sizeof_VkBool32(&val->sparseResidency2Samples);
    size += vn_sizeof_VkBool32(&val->sparseResidency4Samples);
    size += vn_sizeof_VkBool32(&val->sparseResidency8Samples);
    size += vn_sizeof_VkBool32(&val->sparseResidency16Samples);
    size += vn_sizeof_VkBool32(&val->sparseResidencyAliased);
    size += vn_sizeof_VkBool32(&val->variableMultisampleRate);
    size += vn_sizeof_VkBool32(&val->inheritedQueries);
    return size;
}

static inline void
vn_encode_VkPhysicalDeviceFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures *val)
{
    vn_encode_VkBool32(enc, &val->robustBufferAccess);
    vn_encode_VkBool32(enc, &val->fullDrawIndexUint32);
    vn_encode_VkBool32(enc, &val->imageCubeArray);
    vn_encode_VkBool32(enc, &val->independentBlend);
    vn_encode_VkBool32(enc, &val->geometryShader);
    vn_encode_VkBool32(enc, &val->tessellationShader);
    vn_encode_VkBool32(enc, &val->sampleRateShading);
    vn_encode_VkBool32(enc, &val->dualSrcBlend);
    vn_encode_VkBool32(enc, &val->logicOp);
    vn_encode_VkBool32(enc, &val->multiDrawIndirect);
    vn_encode_VkBool32(enc, &val->drawIndirectFirstInstance);
    vn_encode_VkBool32(enc, &val->depthClamp);
    vn_encode_VkBool32(enc, &val->depthBiasClamp);
    vn_encode_VkBool32(enc, &val->fillModeNonSolid);
    vn_encode_VkBool32(enc, &val->depthBounds);
    vn_encode_VkBool32(enc, &val->wideLines);
    vn_encode_VkBool32(enc, &val->largePoints);
    vn_encode_VkBool32(enc, &val->alphaToOne);
    vn_encode_VkBool32(enc, &val->multiViewport);
    vn_encode_VkBool32(enc, &val->samplerAnisotropy);
    vn_encode_VkBool32(enc, &val->textureCompressionETC2);
    vn_encode_VkBool32(enc, &val->textureCompressionASTC_LDR);
    vn_encode_VkBool32(enc, &val->textureCompressionBC);
    vn_encode_VkBool32(enc, &val->occlusionQueryPrecise);
    vn_encode_VkBool32(enc, &val->pipelineStatisticsQuery);
    vn_encode_VkBool32(enc, &val->vertexPipelineStoresAndAtomics);
    vn_encode_VkBool32(enc, &val->fragmentStoresAndAtomics);
    vn_encode_VkBool32(enc, &val->shaderTessellationAndGeometryPointSize);
    vn_encode_VkBool32(enc, &val->shaderImageGatherExtended);
    vn_encode_VkBool32(enc, &val->shaderStorageImageExtendedFormats);
    vn_encode_VkBool32(enc, &val->shaderStorageImageMultisample);
    vn_encode_VkBool32(enc, &val->shaderStorageImageReadWithoutFormat);
    vn_encode_VkBool32(enc, &val->shaderStorageImageWriteWithoutFormat);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderClipDistance);
    vn_encode_VkBool32(enc, &val->shaderCullDistance);
    vn_encode_VkBool32(enc, &val->shaderFloat64);
    vn_encode_VkBool32(enc, &val->shaderInt64);
    vn_encode_VkBool32(enc, &val->shaderInt16);
    vn_encode_VkBool32(enc, &val->shaderResourceResidency);
    vn_encode_VkBool32(enc, &val->shaderResourceMinLod);
    vn_encode_VkBool32(enc, &val->sparseBinding);
    vn_encode_VkBool32(enc, &val->sparseResidencyBuffer);
    vn_encode_VkBool32(enc, &val->sparseResidencyImage2D);
    vn_encode_VkBool32(enc, &val->sparseResidencyImage3D);
    vn_encode_VkBool32(enc, &val->sparseResidency2Samples);
    vn_encode_VkBool32(enc, &val->sparseResidency4Samples);
    vn_encode_VkBool32(enc, &val->sparseResidency8Samples);
    vn_encode_VkBool32(enc, &val->sparseResidency16Samples);
    vn_encode_VkBool32(enc, &val->sparseResidencyAliased);
    vn_encode_VkBool32(enc, &val->variableMultisampleRate);
    vn_encode_VkBool32(enc, &val->inheritedQueries);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures *val)
{
    vn_decode_VkBool32(dec, &val->robustBufferAccess);
    vn_decode_VkBool32(dec, &val->fullDrawIndexUint32);
    vn_decode_VkBool32(dec, &val->imageCubeArray);
    vn_decode_VkBool32(dec, &val->independentBlend);
    vn_decode_VkBool32(dec, &val->geometryShader);
    vn_decode_VkBool32(dec, &val->tessellationShader);
    vn_decode_VkBool32(dec, &val->sampleRateShading);
    vn_decode_VkBool32(dec, &val->dualSrcBlend);
    vn_decode_VkBool32(dec, &val->logicOp);
    vn_decode_VkBool32(dec, &val->multiDrawIndirect);
    vn_decode_VkBool32(dec, &val->drawIndirectFirstInstance);
    vn_decode_VkBool32(dec, &val->depthClamp);
    vn_decode_VkBool32(dec, &val->depthBiasClamp);
    vn_decode_VkBool32(dec, &val->fillModeNonSolid);
    vn_decode_VkBool32(dec, &val->depthBounds);
    vn_decode_VkBool32(dec, &val->wideLines);
    vn_decode_VkBool32(dec, &val->largePoints);
    vn_decode_VkBool32(dec, &val->alphaToOne);
    vn_decode_VkBool32(dec, &val->multiViewport);
    vn_decode_VkBool32(dec, &val->samplerAnisotropy);
    vn_decode_VkBool32(dec, &val->textureCompressionETC2);
    vn_decode_VkBool32(dec, &val->textureCompressionASTC_LDR);
    vn_decode_VkBool32(dec, &val->textureCompressionBC);
    vn_decode_VkBool32(dec, &val->occlusionQueryPrecise);
    vn_decode_VkBool32(dec, &val->pipelineStatisticsQuery);
    vn_decode_VkBool32(dec, &val->vertexPipelineStoresAndAtomics);
    vn_decode_VkBool32(dec, &val->fragmentStoresAndAtomics);
    vn_decode_VkBool32(dec, &val->shaderTessellationAndGeometryPointSize);
    vn_decode_VkBool32(dec, &val->shaderImageGatherExtended);
    vn_decode_VkBool32(dec, &val->shaderStorageImageExtendedFormats);
    vn_decode_VkBool32(dec, &val->shaderStorageImageMultisample);
    vn_decode_VkBool32(dec, &val->shaderStorageImageReadWithoutFormat);
    vn_decode_VkBool32(dec, &val->shaderStorageImageWriteWithoutFormat);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderClipDistance);
    vn_decode_VkBool32(dec, &val->shaderCullDistance);
    vn_decode_VkBool32(dec, &val->shaderFloat64);
    vn_decode_VkBool32(dec, &val->shaderInt64);
    vn_decode_VkBool32(dec, &val->shaderInt16);
    vn_decode_VkBool32(dec, &val->shaderResourceResidency);
    vn_decode_VkBool32(dec, &val->shaderResourceMinLod);
    vn_decode_VkBool32(dec, &val->sparseBinding);
    vn_decode_VkBool32(dec, &val->sparseResidencyBuffer);
    vn_decode_VkBool32(dec, &val->sparseResidencyImage2D);
    vn_decode_VkBool32(dec, &val->sparseResidencyImage3D);
    vn_decode_VkBool32(dec, &val->sparseResidency2Samples);
    vn_decode_VkBool32(dec, &val->sparseResidency4Samples);
    vn_decode_VkBool32(dec, &val->sparseResidency8Samples);
    vn_decode_VkBool32(dec, &val->sparseResidency16Samples);
    vn_decode_VkBool32(dec, &val->sparseResidencyAliased);
    vn_decode_VkBool32(dec, &val->variableMultisampleRate);
    vn_decode_VkBool32(dec, &val->inheritedQueries);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFeatures_partial(const VkPhysicalDeviceFeatures *val)
{
    size_t size = 0;
    /* skip val->robustBufferAccess */
    /* skip val->fullDrawIndexUint32 */
    /* skip val->imageCubeArray */
    /* skip val->independentBlend */
    /* skip val->geometryShader */
    /* skip val->tessellationShader */
    /* skip val->sampleRateShading */
    /* skip val->dualSrcBlend */
    /* skip val->logicOp */
    /* skip val->multiDrawIndirect */
    /* skip val->drawIndirectFirstInstance */
    /* skip val->depthClamp */
    /* skip val->depthBiasClamp */
    /* skip val->fillModeNonSolid */
    /* skip val->depthBounds */
    /* skip val->wideLines */
    /* skip val->largePoints */
    /* skip val->alphaToOne */
    /* skip val->multiViewport */
    /* skip val->samplerAnisotropy */
    /* skip val->textureCompressionETC2 */
    /* skip val->textureCompressionASTC_LDR */
    /* skip val->textureCompressionBC */
    /* skip val->occlusionQueryPrecise */
    /* skip val->pipelineStatisticsQuery */
    /* skip val->vertexPipelineStoresAndAtomics */
    /* skip val->fragmentStoresAndAtomics */
    /* skip val->shaderTessellationAndGeometryPointSize */
    /* skip val->shaderImageGatherExtended */
    /* skip val->shaderStorageImageExtendedFormats */
    /* skip val->shaderStorageImageMultisample */
    /* skip val->shaderStorageImageReadWithoutFormat */
    /* skip val->shaderStorageImageWriteWithoutFormat */
    /* skip val->shaderUniformBufferArrayDynamicIndexing */
    /* skip val->shaderSampledImageArrayDynamicIndexing */
    /* skip val->shaderStorageBufferArrayDynamicIndexing */
    /* skip val->shaderStorageImageArrayDynamicIndexing */
    /* skip val->shaderClipDistance */
    /* skip val->shaderCullDistance */
    /* skip val->shaderFloat64 */
    /* skip val->shaderInt64 */
    /* skip val->shaderInt16 */
    /* skip val->shaderResourceResidency */
    /* skip val->shaderResourceMinLod */
    /* skip val->sparseBinding */
    /* skip val->sparseResidencyBuffer */
    /* skip val->sparseResidencyImage2D */
    /* skip val->sparseResidencyImage3D */
    /* skip val->sparseResidency2Samples */
    /* skip val->sparseResidency4Samples */
    /* skip val->sparseResidency8Samples */
    /* skip val->sparseResidency16Samples */
    /* skip val->sparseResidencyAliased */
    /* skip val->variableMultisampleRate */
    /* skip val->inheritedQueries */
    return size;
}

static inline void
vn_encode_VkPhysicalDeviceFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures *val)
{
    /* skip val->robustBufferAccess */
    /* skip val->fullDrawIndexUint32 */
    /* skip val->imageCubeArray */
    /* skip val->independentBlend */
    /* skip val->geometryShader */
    /* skip val->tessellationShader */
    /* skip val->sampleRateShading */
    /* skip val->dualSrcBlend */
    /* skip val->logicOp */
    /* skip val->multiDrawIndirect */
    /* skip val->drawIndirectFirstInstance */
    /* skip val->depthClamp */
    /* skip val->depthBiasClamp */
    /* skip val->fillModeNonSolid */
    /* skip val->depthBounds */
    /* skip val->wideLines */
    /* skip val->largePoints */
    /* skip val->alphaToOne */
    /* skip val->multiViewport */
    /* skip val->samplerAnisotropy */
    /* skip val->textureCompressionETC2 */
    /* skip val->textureCompressionASTC_LDR */
    /* skip val->textureCompressionBC */
    /* skip val->occlusionQueryPrecise */
    /* skip val->pipelineStatisticsQuery */
    /* skip val->vertexPipelineStoresAndAtomics */
    /* skip val->fragmentStoresAndAtomics */
    /* skip val->shaderTessellationAndGeometryPointSize */
    /* skip val->shaderImageGatherExtended */
    /* skip val->shaderStorageImageExtendedFormats */
    /* skip val->shaderStorageImageMultisample */
    /* skip val->shaderStorageImageReadWithoutFormat */
    /* skip val->shaderStorageImageWriteWithoutFormat */
    /* skip val->shaderUniformBufferArrayDynamicIndexing */
    /* skip val->shaderSampledImageArrayDynamicIndexing */
    /* skip val->shaderStorageBufferArrayDynamicIndexing */
    /* skip val->shaderStorageImageArrayDynamicIndexing */
    /* skip val->shaderClipDistance */
    /* skip val->shaderCullDistance */
    /* skip val->shaderFloat64 */
    /* skip val->shaderInt64 */
    /* skip val->shaderInt16 */
    /* skip val->shaderResourceResidency */
    /* skip val->shaderResourceMinLod */
    /* skip val->sparseBinding */
    /* skip val->sparseResidencyBuffer */
    /* skip val->sparseResidencyImage2D */
    /* skip val->sparseResidencyImage3D */
    /* skip val->sparseResidency2Samples */
    /* skip val->sparseResidency4Samples */
    /* skip val->sparseResidency8Samples */
    /* skip val->sparseResidency16Samples */
    /* skip val->sparseResidencyAliased */
    /* skip val->variableMultisampleRate */
    /* skip val->inheritedQueries */
}

/* struct VkFormatProperties */

static inline size_t
vn_sizeof_VkFormatProperties(const VkFormatProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_VkFlags(&val->linearTilingFeatures);
    size += vn_sizeof_VkFlags(&val->optimalTilingFeatures);
    size += vn_sizeof_VkFlags(&val->bufferFeatures);
    return size;
}

static inline void
vn_decode_VkFormatProperties(struct vn_cs_decoder *dec, VkFormatProperties *val)
{
    vn_decode_VkFlags(dec, &val->linearTilingFeatures);
    vn_decode_VkFlags(dec, &val->optimalTilingFeatures);
    vn_decode_VkFlags(dec, &val->bufferFeatures);
}

static inline size_t
vn_sizeof_VkFormatProperties_partial(const VkFormatProperties *val)
{
    size_t size = 0;
    /* skip val->linearTilingFeatures */
    /* skip val->optimalTilingFeatures */
    /* skip val->bufferFeatures */
    return size;
}

static inline void
vn_encode_VkFormatProperties_partial(struct vn_cs_encoder *enc, const VkFormatProperties *val)
{
    /* skip val->linearTilingFeatures */
    /* skip val->optimalTilingFeatures */
    /* skip val->bufferFeatures */
}

/* struct VkImageFormatProperties */

static inline size_t
vn_sizeof_VkImageFormatProperties(const VkImageFormatProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_VkExtent3D(&val->maxExtent);
    size += vn_sizeof_uint32_t(&val->maxMipLevels);
    size += vn_sizeof_uint32_t(&val->maxArrayLayers);
    size += vn_sizeof_VkFlags(&val->sampleCounts);
    size += vn_sizeof_VkDeviceSize(&val->maxResourceSize);
    return size;
}

static inline void
vn_decode_VkImageFormatProperties(struct vn_cs_decoder *dec, VkImageFormatProperties *val)
{
    vn_decode_VkExtent3D(dec, &val->maxExtent);
    vn_decode_uint32_t(dec, &val->maxMipLevels);
    vn_decode_uint32_t(dec, &val->maxArrayLayers);
    vn_decode_VkFlags(dec, &val->sampleCounts);
    vn_decode_VkDeviceSize(dec, &val->maxResourceSize);
}

static inline size_t
vn_sizeof_VkImageFormatProperties_partial(const VkImageFormatProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_VkExtent3D_partial(&val->maxExtent);
    /* skip val->maxMipLevels */
    /* skip val->maxArrayLayers */
    /* skip val->sampleCounts */
    /* skip val->maxResourceSize */
    return size;
}

static inline void
vn_encode_VkImageFormatProperties_partial(struct vn_cs_encoder *enc, const VkImageFormatProperties *val)
{
    vn_encode_VkExtent3D_partial(enc, &val->maxExtent);
    /* skip val->maxMipLevels */
    /* skip val->maxArrayLayers */
    /* skip val->sampleCounts */
    /* skip val->maxResourceSize */
}

/* struct VkDeviceQueueCreateInfo chain */

static inline size_t
vn_sizeof_VkDeviceQueueCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDeviceQueueCreateInfo_self(const VkDeviceQueueCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_uint32_t(&val->queueFamilyIndex);
    size += vn_sizeof_uint32_t(&val->queueCount);
    if (val->pQueuePriorities) {
        size += vn_sizeof_array_size(val->queueCount);
        size += vn_sizeof_float_array(val->pQueuePriorities, val->queueCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkDeviceQueueCreateInfo(const VkDeviceQueueCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDeviceQueueCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkDeviceQueueCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkDeviceQueueCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDeviceQueueCreateInfo_self(struct vn_cs_encoder *enc, const VkDeviceQueueCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_uint32_t(enc, &val->queueFamilyIndex);
    vn_encode_uint32_t(enc, &val->queueCount);
    if (val->pQueuePriorities) {
        vn_encode_array_size(enc, val->queueCount);
        vn_encode_float_array(enc, val->pQueuePriorities, val->queueCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkDeviceQueueCreateInfo(struct vn_cs_encoder *enc, const VkDeviceQueueCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO });
    vn_encode_VkDeviceQueueCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkDeviceQueueCreateInfo_self(enc, val);
}

/* struct VkDevicePrivateDataCreateInfo chain */

static inline size_t
vn_sizeof_VkDevicePrivateDataCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDevicePrivateDataCreateInfo_self(const VkDevicePrivateDataCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->privateDataSlotRequestCount);
    return size;
}

static inline size_t
vn_sizeof_VkDevicePrivateDataCreateInfo(const VkDevicePrivateDataCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDevicePrivateDataCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkDevicePrivateDataCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkDevicePrivateDataCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDevicePrivateDataCreateInfo_self(struct vn_cs_encoder *enc, const VkDevicePrivateDataCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->privateDataSlotRequestCount);
}

static inline void
vn_encode_VkDevicePrivateDataCreateInfo(struct vn_cs_encoder *enc, const VkDevicePrivateDataCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO });
    vn_encode_VkDevicePrivateDataCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkDevicePrivateDataCreateInfo_self(enc, val);
}

/* struct VkPhysicalDevicePrivateDataFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDevicePrivateDataFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrivateDataFeatures_self(const VkPhysicalDevicePrivateDataFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->privateData);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrivateDataFeatures(const VkPhysicalDevicePrivateDataFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePrivateDataFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePrivateDataFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePrivateDataFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->privateData);
}

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevicePrivateDataFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES });
    vn_encode_VkPhysicalDevicePrivateDataFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePrivateDataFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDevicePrivateDataFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDevicePrivateDataFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDevicePrivateDataFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->privateData);
}

static inline void
vn_decode_VkPhysicalDevicePrivateDataFeatures(struct vn_cs_decoder *dec, VkPhysicalDevicePrivateDataFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDevicePrivateDataFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDevicePrivateDataFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrivateDataFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrivateDataFeatures_self_partial(const VkPhysicalDevicePrivateDataFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->privateData */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrivateDataFeatures_partial(const VkPhysicalDevicePrivateDataFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePrivateDataFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePrivateDataFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePrivateDataFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->privateData */
}

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePrivateDataFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES });
    vn_encode_VkPhysicalDevicePrivateDataFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDevicePrivateDataFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVariablePointersFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_self(const VkPhysicalDeviceVariablePointersFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->variablePointersStorageBuffer);
    size += vn_sizeof_VkBool32(&val->variablePointers);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVariablePointersFeatures(const VkPhysicalDeviceVariablePointersFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->variablePointersStorageBuffer);
    vn_encode_VkBool32(enc, &val->variablePointers);
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceVariablePointersFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES });
    vn_encode_VkPhysicalDeviceVariablePointersFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->variablePointersStorageBuffer);
    vn_decode_VkBool32(dec, &val->variablePointers);
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceVariablePointersFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVariablePointersFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVariablePointersFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_self_partial(const VkPhysicalDeviceVariablePointersFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_partial(const VkPhysicalDeviceVariablePointersFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVariablePointersFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES });
    vn_encode_VkPhysicalDeviceVariablePointersFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVariablePointersFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceMultiviewFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewFeatures_self(const VkPhysicalDeviceMultiviewFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->multiview);
    size += vn_sizeof_VkBool32(&val->multiviewGeometryShader);
    size += vn_sizeof_VkBool32(&val->multiviewTessellationShader);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewFeatures(const VkPhysicalDeviceMultiviewFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMultiviewFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMultiviewFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->multiview);
    vn_encode_VkBool32(enc, &val->multiviewGeometryShader);
    vn_encode_VkBool32(enc, &val->multiviewTessellationShader);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES });
    vn_encode_VkPhysicalDeviceMultiviewFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiviewFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->multiview);
    vn_decode_VkBool32(dec, &val->multiviewGeometryShader);
    vn_decode_VkBool32(dec, &val->multiviewTessellationShader);
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceMultiviewFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceMultiviewFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewFeatures_self_partial(const VkPhysicalDeviceMultiviewFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewFeatures_partial(const VkPhysicalDeviceMultiviewFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMultiviewFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMultiviewFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES });
    vn_encode_VkPhysicalDeviceMultiviewFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiviewFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDevice16BitStorageFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDevice16BitStorageFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevice16BitStorageFeatures_self(const VkPhysicalDevice16BitStorageFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->storageBuffer16BitAccess);
    size += vn_sizeof_VkBool32(&val->uniformAndStorageBuffer16BitAccess);
    size += vn_sizeof_VkBool32(&val->storagePushConstant16);
    size += vn_sizeof_VkBool32(&val->storageInputOutput16);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevice16BitStorageFeatures(const VkPhysicalDevice16BitStorageFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevice16BitStorageFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDevice16BitStorageFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->storageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant16);
    vn_encode_VkBool32(enc, &val->storageInputOutput16);
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevice16BitStorageFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES });
    vn_encode_VkPhysicalDevice16BitStorageFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevice16BitStorageFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->storageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant16);
    vn_decode_VkBool32(dec, &val->storageInputOutput16);
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures(struct vn_cs_decoder *dec, VkPhysicalDevice16BitStorageFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDevice16BitStorageFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDevice16BitStorageFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDevice16BitStorageFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevice16BitStorageFeatures_self_partial(const VkPhysicalDevice16BitStorageFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevice16BitStorageFeatures_partial(const VkPhysicalDevice16BitStorageFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevice16BitStorageFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDevice16BitStorageFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDevice16BitStorageFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES });
    vn_encode_VkPhysicalDevice16BitStorageFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDevice16BitStorageFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderSubgroupExtendedTypes);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderSubgroupExtendedTypes);
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES });
    vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderSubgroupExtendedTypes);
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial(const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderSubgroupExtendedTypes */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_partial(const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderSubgroupExtendedTypes */
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES });
    vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceSamplerYcbcrConversionFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->samplerYcbcrConversion);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures(const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->samplerYcbcrConversion);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES });
    vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->samplerYcbcrConversion);
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial(const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->samplerYcbcrConversion */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_partial(const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->samplerYcbcrConversion */
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES });
    vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceProtectedMemoryFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_self(const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->protectedMemory);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures(const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->protectedMemory);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES });
    vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->protectedMemory);
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_self_partial(const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->protectedMemory */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_partial(const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->protectedMemory */
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES });
    vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceInlineUniformBlockFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_self(const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->inlineUniformBlock);
    size += vn_sizeof_VkBool32(&val->descriptorBindingInlineUniformBlockUpdateAfterBind);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures(const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->inlineUniformBlock);
    vn_encode_VkBool32(enc, &val->descriptorBindingInlineUniformBlockUpdateAfterBind);
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES });
    vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->inlineUniformBlock);
    vn_decode_VkBool32(dec, &val->descriptorBindingInlineUniformBlockUpdateAfterBind);
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial(const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->inlineUniformBlock */
    /* skip val->descriptorBindingInlineUniformBlockUpdateAfterBind */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_partial(const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->inlineUniformBlock */
    /* skip val->descriptorBindingInlineUniformBlockUpdateAfterBind */
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES });
    vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceMaintenance4Features chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Features_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Features_self(const VkPhysicalDeviceMaintenance4Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->maintenance4);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Features(const VkPhysicalDeviceMaintenance4Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMaintenance4Features_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMaintenance4Features_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->maintenance4);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES });
    vn_encode_VkPhysicalDeviceMaintenance4Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance4Features_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Features_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Features_self(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->maintenance4);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Features(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceMaintenance4Features_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceMaintenance4Features_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Features_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Features_self_partial(const VkPhysicalDeviceMaintenance4Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maintenance4 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Features_partial(const VkPhysicalDeviceMaintenance4Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMaintenance4Features_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMaintenance4Features_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maintenance4 */
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES });
    vn_encode_VkPhysicalDeviceMaintenance4Features_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance4Features_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderDrawParametersFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_self(const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderDrawParameters);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures(const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderDrawParameters);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES });
    vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderDrawParameters);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial(const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderDrawParameters */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_partial(const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderDrawParameters */
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES });
    vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderFloat16Int8Features chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_self(const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderFloat16);
    size += vn_sizeof_VkBool32(&val->shaderInt8);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features(const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderFloat16);
    vn_encode_VkBool32(enc, &val->shaderInt8);
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES });
    vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderFloat16);
    vn_decode_VkBool32(dec, &val->shaderInt8);
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_self_partial(const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_partial(const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES });
    vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self_partial(enc, val);
}

/* struct VkPhysicalDeviceHostQueryResetFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_self(const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->hostQueryReset);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures(const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->hostQueryReset);
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES });
    vn_encode_VkPhysicalDeviceHostQueryResetFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->hostQueryReset);
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceHostQueryResetFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceHostQueryResetFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_self_partial(const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->hostQueryReset */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_partial(const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->hostQueryReset */
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES });
    vn_encode_VkPhysicalDeviceHostQueryResetFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceDescriptorIndexingFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_self(const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderInputAttachmentArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderUniformTexelBufferArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageTexelBufferArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderUniformBufferArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderSampledImageArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageBufferArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderInputAttachmentArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderUniformTexelBufferArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageTexelBufferArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->descriptorBindingUniformBufferUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingSampledImageUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingStorageImageUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingStorageBufferUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingUpdateUnusedWhilePending);
    size += vn_sizeof_VkBool32(&val->descriptorBindingPartiallyBound);
    size += vn_sizeof_VkBool32(&val->descriptorBindingVariableDescriptorCount);
    size += vn_sizeof_VkBool32(&val->runtimeDescriptorArray);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures(const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_encode_VkBool32(enc, &val->descriptorBindingPartiallyBound);
    vn_encode_VkBool32(enc, &val->descriptorBindingVariableDescriptorCount);
    vn_encode_VkBool32(enc, &val->runtimeDescriptorArray);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES });
    vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_decode_VkBool32(dec, &val->descriptorBindingPartiallyBound);
    vn_decode_VkBool32(dec, &val->descriptorBindingVariableDescriptorCount);
    vn_decode_VkBool32(dec, &val->runtimeDescriptorArray);
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial(const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_partial(const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES });
    vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceTimelineSemaphoreFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_self(const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->timelineSemaphore);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures(const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->timelineSemaphore);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES });
    vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->timelineSemaphore);
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial(const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->timelineSemaphore */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_partial(const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->timelineSemaphore */
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES });
    vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDevice8BitStorageFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDevice8BitStorageFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevice8BitStorageFeatures_self(const VkPhysicalDevice8BitStorageFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->storageBuffer8BitAccess);
    size += vn_sizeof_VkBool32(&val->uniformAndStorageBuffer8BitAccess);
    size += vn_sizeof_VkBool32(&val->storagePushConstant8);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevice8BitStorageFeatures(const VkPhysicalDevice8BitStorageFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevice8BitStorageFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDevice8BitStorageFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->storageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant8);
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevice8BitStorageFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES });
    vn_encode_VkPhysicalDevice8BitStorageFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevice8BitStorageFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->storageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant8);
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures(struct vn_cs_decoder *dec, VkPhysicalDevice8BitStorageFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDevice8BitStorageFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDevice8BitStorageFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDevice8BitStorageFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevice8BitStorageFeatures_self_partial(const VkPhysicalDevice8BitStorageFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevice8BitStorageFeatures_partial(const VkPhysicalDevice8BitStorageFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevice8BitStorageFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDevice8BitStorageFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDevice8BitStorageFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES });
    vn_encode_VkPhysicalDevice8BitStorageFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDevice8BitStorageFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVulkanMemoryModelFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_self(const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->vulkanMemoryModel);
    size += vn_sizeof_VkBool32(&val->vulkanMemoryModelDeviceScope);
    size += vn_sizeof_VkBool32(&val->vulkanMemoryModelAvailabilityVisibilityChains);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures(const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->vulkanMemoryModel);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelDeviceScope);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelAvailabilityVisibilityChains);
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES });
    vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->vulkanMemoryModel);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelDeviceScope);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelAvailabilityVisibilityChains);
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial(const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_partial(const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES });
    vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderAtomicInt64Features chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_self(const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderBufferInt64Atomics);
    size += vn_sizeof_VkBool32(&val->shaderSharedInt64Atomics);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features(const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderBufferInt64Atomics);
    vn_encode_VkBool32(enc, &val->shaderSharedInt64Atomics);
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES });
    vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderBufferInt64Atomics);
    vn_decode_VkBool32(dec, &val->shaderSharedInt64Atomics);
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_self_partial(const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_partial(const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES });
    vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self_partial(enc, val);
}

/* struct VkPhysicalDeviceTransformFeedbackFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->transformFeedback);
    size += vn_sizeof_VkBool32(&val->geometryStreams);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT(const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->transformFeedback);
    vn_encode_VkBool32(enc, &val->geometryStreams);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->transformFeedback);
    vn_decode_VkBool32(dec, &val->geometryStreams);
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial(const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->transformFeedback */
    /* skip val->geometryStreams */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_partial(const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->transformFeedback */
    /* skip val->geometryStreams */
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceScalarBlockLayoutFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_self(const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->scalarBlockLayout);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures(const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->scalarBlockLayout);
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES });
    vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->scalarBlockLayout);
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial(const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->scalarBlockLayout */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_partial(const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->scalarBlockLayout */
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES });
    vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceUniformBufferStandardLayoutFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->uniformBufferStandardLayout);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->uniformBufferStandardLayout);
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES });
    vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->uniformBufferStandardLayout);
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial(const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->uniformBufferStandardLayout */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_partial(const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->uniformBufferStandardLayout */
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES });
    vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceBufferDeviceAddressFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_self(const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->bufferDeviceAddress);
    size += vn_sizeof_VkBool32(&val->bufferDeviceAddressCaptureReplay);
    size += vn_sizeof_VkBool32(&val->bufferDeviceAddressMultiDevice);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures(const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->bufferDeviceAddress);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressCaptureReplay);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressMultiDevice);
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES });
    vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->bufferDeviceAddress);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressCaptureReplay);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressMultiDevice);
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial(const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_partial(const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES });
    vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceImagelessFramebufferFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_self(const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->imagelessFramebuffer);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures(const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->imagelessFramebuffer);
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES });
    vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->imagelessFramebuffer);
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial(const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->imagelessFramebuffer */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_partial(const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->imagelessFramebuffer */
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES });
    vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceTextureCompressionASTCHDRFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->textureCompressionASTC_HDR);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->textureCompressionASTC_HDR);
}

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES });
    vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->textureCompressionASTC_HDR);
}

static inline void
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial(const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->textureCompressionASTC_HDR */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_partial(const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->textureCompressionASTC_HDR */
}

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES });
    vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->separateDepthStencilLayouts);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->separateDepthStencilLayouts);
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES });
    vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->separateDepthStencilLayouts);
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial(const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->separateDepthStencilLayouts */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_partial(const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->separateDepthStencilLayouts */
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES });
    vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderDemoteToHelperInvocation);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderDemoteToHelperInvocation);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES });
    vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderDemoteToHelperInvocation);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial(const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderDemoteToHelperInvocation */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_partial(const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderDemoteToHelperInvocation */
}

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES });
    vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->texelBufferAlignment);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->texelBufferAlignment);
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->texelBufferAlignment);
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial(const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->texelBufferAlignment */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_partial(const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->texelBufferAlignment */
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceSubgroupSizeControlFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_self(const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->subgroupSizeControl);
    size += vn_sizeof_VkBool32(&val->computeFullSubgroups);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures(const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->subgroupSizeControl);
    vn_encode_VkBool32(enc, &val->computeFullSubgroups);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES });
    vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->subgroupSizeControl);
    vn_decode_VkBool32(dec, &val->computeFullSubgroups);
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial(const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->subgroupSizeControl */
    /* skip val->computeFullSubgroups */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_partial(const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->subgroupSizeControl */
    /* skip val->computeFullSubgroups */
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES });
    vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDevicePipelineCreationCacheControlFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->pipelineCreationCacheControl);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures(const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->pipelineCreationCacheControl);
}

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES });
    vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->pipelineCreationCacheControl);
}

static inline void
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial(const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->pipelineCreationCacheControl */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_partial(const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->pipelineCreationCacheControl */
}

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES });
    vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVulkan11Features chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Features_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Features_self(const VkPhysicalDeviceVulkan11Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->storageBuffer16BitAccess);
    size += vn_sizeof_VkBool32(&val->uniformAndStorageBuffer16BitAccess);
    size += vn_sizeof_VkBool32(&val->storagePushConstant16);
    size += vn_sizeof_VkBool32(&val->storageInputOutput16);
    size += vn_sizeof_VkBool32(&val->multiview);
    size += vn_sizeof_VkBool32(&val->multiviewGeometryShader);
    size += vn_sizeof_VkBool32(&val->multiviewTessellationShader);
    size += vn_sizeof_VkBool32(&val->variablePointersStorageBuffer);
    size += vn_sizeof_VkBool32(&val->variablePointers);
    size += vn_sizeof_VkBool32(&val->protectedMemory);
    size += vn_sizeof_VkBool32(&val->samplerYcbcrConversion);
    size += vn_sizeof_VkBool32(&val->shaderDrawParameters);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Features(const VkPhysicalDeviceVulkan11Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan11Features_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan11Features_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->storageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant16);
    vn_encode_VkBool32(enc, &val->storageInputOutput16);
    vn_encode_VkBool32(enc, &val->multiview);
    vn_encode_VkBool32(enc, &val->multiviewGeometryShader);
    vn_encode_VkBool32(enc, &val->multiviewTessellationShader);
    vn_encode_VkBool32(enc, &val->variablePointersStorageBuffer);
    vn_encode_VkBool32(enc, &val->variablePointers);
    vn_encode_VkBool32(enc, &val->protectedMemory);
    vn_encode_VkBool32(enc, &val->samplerYcbcrConversion);
    vn_encode_VkBool32(enc, &val->shaderDrawParameters);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan11Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan11Features_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->storageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant16);
    vn_decode_VkBool32(dec, &val->storageInputOutput16);
    vn_decode_VkBool32(dec, &val->multiview);
    vn_decode_VkBool32(dec, &val->multiviewGeometryShader);
    vn_decode_VkBool32(dec, &val->multiviewTessellationShader);
    vn_decode_VkBool32(dec, &val->variablePointersStorageBuffer);
    vn_decode_VkBool32(dec, &val->variablePointers);
    vn_decode_VkBool32(dec, &val->protectedMemory);
    vn_decode_VkBool32(dec, &val->samplerYcbcrConversion);
    vn_decode_VkBool32(dec, &val->shaderDrawParameters);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVulkan11Features_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVulkan11Features_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Features_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Features_self_partial(const VkPhysicalDeviceVulkan11Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
    /* skip val->protectedMemory */
    /* skip val->samplerYcbcrConversion */
    /* skip val->shaderDrawParameters */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Features_partial(const VkPhysicalDeviceVulkan11Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan11Features_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan11Features_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
    /* skip val->protectedMemory */
    /* skip val->samplerYcbcrConversion */
    /* skip val->shaderDrawParameters */
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan11Features_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan11Features_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVulkan12Features chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Features_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Features_self(const VkPhysicalDeviceVulkan12Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->samplerMirrorClampToEdge);
    size += vn_sizeof_VkBool32(&val->drawIndirectCount);
    size += vn_sizeof_VkBool32(&val->storageBuffer8BitAccess);
    size += vn_sizeof_VkBool32(&val->uniformAndStorageBuffer8BitAccess);
    size += vn_sizeof_VkBool32(&val->storagePushConstant8);
    size += vn_sizeof_VkBool32(&val->shaderBufferInt64Atomics);
    size += vn_sizeof_VkBool32(&val->shaderSharedInt64Atomics);
    size += vn_sizeof_VkBool32(&val->shaderFloat16);
    size += vn_sizeof_VkBool32(&val->shaderInt8);
    size += vn_sizeof_VkBool32(&val->descriptorIndexing);
    size += vn_sizeof_VkBool32(&val->shaderInputAttachmentArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderUniformTexelBufferArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageTexelBufferArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderUniformBufferArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderSampledImageArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageBufferArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderInputAttachmentArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderUniformTexelBufferArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageTexelBufferArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->descriptorBindingUniformBufferUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingSampledImageUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingStorageImageUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingStorageBufferUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingUpdateUnusedWhilePending);
    size += vn_sizeof_VkBool32(&val->descriptorBindingPartiallyBound);
    size += vn_sizeof_VkBool32(&val->descriptorBindingVariableDescriptorCount);
    size += vn_sizeof_VkBool32(&val->runtimeDescriptorArray);
    size += vn_sizeof_VkBool32(&val->samplerFilterMinmax);
    size += vn_sizeof_VkBool32(&val->scalarBlockLayout);
    size += vn_sizeof_VkBool32(&val->imagelessFramebuffer);
    size += vn_sizeof_VkBool32(&val->uniformBufferStandardLayout);
    size += vn_sizeof_VkBool32(&val->shaderSubgroupExtendedTypes);
    size += vn_sizeof_VkBool32(&val->separateDepthStencilLayouts);
    size += vn_sizeof_VkBool32(&val->hostQueryReset);
    size += vn_sizeof_VkBool32(&val->timelineSemaphore);
    size += vn_sizeof_VkBool32(&val->bufferDeviceAddress);
    size += vn_sizeof_VkBool32(&val->bufferDeviceAddressCaptureReplay);
    size += vn_sizeof_VkBool32(&val->bufferDeviceAddressMultiDevice);
    size += vn_sizeof_VkBool32(&val->vulkanMemoryModel);
    size += vn_sizeof_VkBool32(&val->vulkanMemoryModelDeviceScope);
    size += vn_sizeof_VkBool32(&val->vulkanMemoryModelAvailabilityVisibilityChains);
    size += vn_sizeof_VkBool32(&val->shaderOutputViewportIndex);
    size += vn_sizeof_VkBool32(&val->shaderOutputLayer);
    size += vn_sizeof_VkBool32(&val->subgroupBroadcastDynamicId);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Features(const VkPhysicalDeviceVulkan12Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan12Features_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan12Features_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->samplerMirrorClampToEdge);
    vn_encode_VkBool32(enc, &val->drawIndirectCount);
    vn_encode_VkBool32(enc, &val->storageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant8);
    vn_encode_VkBool32(enc, &val->shaderBufferInt64Atomics);
    vn_encode_VkBool32(enc, &val->shaderSharedInt64Atomics);
    vn_encode_VkBool32(enc, &val->shaderFloat16);
    vn_encode_VkBool32(enc, &val->shaderInt8);
    vn_encode_VkBool32(enc, &val->descriptorIndexing);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_encode_VkBool32(enc, &val->descriptorBindingPartiallyBound);
    vn_encode_VkBool32(enc, &val->descriptorBindingVariableDescriptorCount);
    vn_encode_VkBool32(enc, &val->runtimeDescriptorArray);
    vn_encode_VkBool32(enc, &val->samplerFilterMinmax);
    vn_encode_VkBool32(enc, &val->scalarBlockLayout);
    vn_encode_VkBool32(enc, &val->imagelessFramebuffer);
    vn_encode_VkBool32(enc, &val->uniformBufferStandardLayout);
    vn_encode_VkBool32(enc, &val->shaderSubgroupExtendedTypes);
    vn_encode_VkBool32(enc, &val->separateDepthStencilLayouts);
    vn_encode_VkBool32(enc, &val->hostQueryReset);
    vn_encode_VkBool32(enc, &val->timelineSemaphore);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddress);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressCaptureReplay);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressMultiDevice);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModel);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelDeviceScope);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelAvailabilityVisibilityChains);
    vn_encode_VkBool32(enc, &val->shaderOutputViewportIndex);
    vn_encode_VkBool32(enc, &val->shaderOutputLayer);
    vn_encode_VkBool32(enc, &val->subgroupBroadcastDynamicId);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan12Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan12Features_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->samplerMirrorClampToEdge);
    vn_decode_VkBool32(dec, &val->drawIndirectCount);
    vn_decode_VkBool32(dec, &val->storageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant8);
    vn_decode_VkBool32(dec, &val->shaderBufferInt64Atomics);
    vn_decode_VkBool32(dec, &val->shaderSharedInt64Atomics);
    vn_decode_VkBool32(dec, &val->shaderFloat16);
    vn_decode_VkBool32(dec, &val->shaderInt8);
    vn_decode_VkBool32(dec, &val->descriptorIndexing);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_decode_VkBool32(dec, &val->descriptorBindingPartiallyBound);
    vn_decode_VkBool32(dec, &val->descriptorBindingVariableDescriptorCount);
    vn_decode_VkBool32(dec, &val->runtimeDescriptorArray);
    vn_decode_VkBool32(dec, &val->samplerFilterMinmax);
    vn_decode_VkBool32(dec, &val->scalarBlockLayout);
    vn_decode_VkBool32(dec, &val->imagelessFramebuffer);
    vn_decode_VkBool32(dec, &val->uniformBufferStandardLayout);
    vn_decode_VkBool32(dec, &val->shaderSubgroupExtendedTypes);
    vn_decode_VkBool32(dec, &val->separateDepthStencilLayouts);
    vn_decode_VkBool32(dec, &val->hostQueryReset);
    vn_decode_VkBool32(dec, &val->timelineSemaphore);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddress);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressCaptureReplay);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressMultiDevice);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModel);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelDeviceScope);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelAvailabilityVisibilityChains);
    vn_decode_VkBool32(dec, &val->shaderOutputViewportIndex);
    vn_decode_VkBool32(dec, &val->shaderOutputLayer);
    vn_decode_VkBool32(dec, &val->subgroupBroadcastDynamicId);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVulkan12Features_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVulkan12Features_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Features_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Features_self_partial(const VkPhysicalDeviceVulkan12Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->samplerMirrorClampToEdge */
    /* skip val->drawIndirectCount */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
    /* skip val->descriptorIndexing */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
    /* skip val->samplerFilterMinmax */
    /* skip val->scalarBlockLayout */
    /* skip val->imagelessFramebuffer */
    /* skip val->uniformBufferStandardLayout */
    /* skip val->shaderSubgroupExtendedTypes */
    /* skip val->separateDepthStencilLayouts */
    /* skip val->hostQueryReset */
    /* skip val->timelineSemaphore */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
    /* skip val->shaderOutputViewportIndex */
    /* skip val->shaderOutputLayer */
    /* skip val->subgroupBroadcastDynamicId */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Features_partial(const VkPhysicalDeviceVulkan12Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan12Features_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan12Features_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->samplerMirrorClampToEdge */
    /* skip val->drawIndirectCount */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
    /* skip val->descriptorIndexing */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
    /* skip val->samplerFilterMinmax */
    /* skip val->scalarBlockLayout */
    /* skip val->imagelessFramebuffer */
    /* skip val->uniformBufferStandardLayout */
    /* skip val->shaderSubgroupExtendedTypes */
    /* skip val->separateDepthStencilLayouts */
    /* skip val->hostQueryReset */
    /* skip val->timelineSemaphore */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
    /* skip val->shaderOutputViewportIndex */
    /* skip val->shaderOutputLayer */
    /* skip val->subgroupBroadcastDynamicId */
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan12Features_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan12Features_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVulkan13Features chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Features_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Features_self(const VkPhysicalDeviceVulkan13Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->robustImageAccess);
    size += vn_sizeof_VkBool32(&val->inlineUniformBlock);
    size += vn_sizeof_VkBool32(&val->descriptorBindingInlineUniformBlockUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->pipelineCreationCacheControl);
    size += vn_sizeof_VkBool32(&val->privateData);
    size += vn_sizeof_VkBool32(&val->shaderDemoteToHelperInvocation);
    size += vn_sizeof_VkBool32(&val->shaderTerminateInvocation);
    size += vn_sizeof_VkBool32(&val->subgroupSizeControl);
    size += vn_sizeof_VkBool32(&val->computeFullSubgroups);
    size += vn_sizeof_VkBool32(&val->synchronization2);
    size += vn_sizeof_VkBool32(&val->textureCompressionASTC_HDR);
    size += vn_sizeof_VkBool32(&val->shaderZeroInitializeWorkgroupMemory);
    size += vn_sizeof_VkBool32(&val->dynamicRendering);
    size += vn_sizeof_VkBool32(&val->shaderIntegerDotProduct);
    size += vn_sizeof_VkBool32(&val->maintenance4);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Features(const VkPhysicalDeviceVulkan13Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan13Features_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan13Features_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->robustImageAccess);
    vn_encode_VkBool32(enc, &val->inlineUniformBlock);
    vn_encode_VkBool32(enc, &val->descriptorBindingInlineUniformBlockUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->pipelineCreationCacheControl);
    vn_encode_VkBool32(enc, &val->privateData);
    vn_encode_VkBool32(enc, &val->shaderDemoteToHelperInvocation);
    vn_encode_VkBool32(enc, &val->shaderTerminateInvocation);
    vn_encode_VkBool32(enc, &val->subgroupSizeControl);
    vn_encode_VkBool32(enc, &val->computeFullSubgroups);
    vn_encode_VkBool32(enc, &val->synchronization2);
    vn_encode_VkBool32(enc, &val->textureCompressionASTC_HDR);
    vn_encode_VkBool32(enc, &val->shaderZeroInitializeWorkgroupMemory);
    vn_encode_VkBool32(enc, &val->dynamicRendering);
    vn_encode_VkBool32(enc, &val->shaderIntegerDotProduct);
    vn_encode_VkBool32(enc, &val->maintenance4);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan13Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan13Features_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Features_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Features_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->robustImageAccess);
    vn_decode_VkBool32(dec, &val->inlineUniformBlock);
    vn_decode_VkBool32(dec, &val->descriptorBindingInlineUniformBlockUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->pipelineCreationCacheControl);
    vn_decode_VkBool32(dec, &val->privateData);
    vn_decode_VkBool32(dec, &val->shaderDemoteToHelperInvocation);
    vn_decode_VkBool32(dec, &val->shaderTerminateInvocation);
    vn_decode_VkBool32(dec, &val->subgroupSizeControl);
    vn_decode_VkBool32(dec, &val->computeFullSubgroups);
    vn_decode_VkBool32(dec, &val->synchronization2);
    vn_decode_VkBool32(dec, &val->textureCompressionASTC_HDR);
    vn_decode_VkBool32(dec, &val->shaderZeroInitializeWorkgroupMemory);
    vn_decode_VkBool32(dec, &val->dynamicRendering);
    vn_decode_VkBool32(dec, &val->shaderIntegerDotProduct);
    vn_decode_VkBool32(dec, &val->maintenance4);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Features(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVulkan13Features_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVulkan13Features_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Features_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Features_self_partial(const VkPhysicalDeviceVulkan13Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->robustImageAccess */
    /* skip val->inlineUniformBlock */
    /* skip val->descriptorBindingInlineUniformBlockUpdateAfterBind */
    /* skip val->pipelineCreationCacheControl */
    /* skip val->privateData */
    /* skip val->shaderDemoteToHelperInvocation */
    /* skip val->shaderTerminateInvocation */
    /* skip val->subgroupSizeControl */
    /* skip val->computeFullSubgroups */
    /* skip val->synchronization2 */
    /* skip val->textureCompressionASTC_HDR */
    /* skip val->shaderZeroInitializeWorkgroupMemory */
    /* skip val->dynamicRendering */
    /* skip val->shaderIntegerDotProduct */
    /* skip val->maintenance4 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Features_partial(const VkPhysicalDeviceVulkan13Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan13Features_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan13Features_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->robustImageAccess */
    /* skip val->inlineUniformBlock */
    /* skip val->descriptorBindingInlineUniformBlockUpdateAfterBind */
    /* skip val->pipelineCreationCacheControl */
    /* skip val->privateData */
    /* skip val->shaderDemoteToHelperInvocation */
    /* skip val->shaderTerminateInvocation */
    /* skip val->subgroupSizeControl */
    /* skip val->computeFullSubgroups */
    /* skip val->synchronization2 */
    /* skip val->textureCompressionASTC_HDR */
    /* skip val->shaderZeroInitializeWorkgroupMemory */
    /* skip val->dynamicRendering */
    /* skip val->shaderIntegerDotProduct */
    /* skip val->maintenance4 */
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan13Features_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan13Features_self_partial(enc, val);
}

/* struct VkPhysicalDeviceExtendedDynamicStateFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->extendedDynamicState);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->extendedDynamicState);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->extendedDynamicState);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial(const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->extendedDynamicState */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_partial(const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->extendedDynamicState */
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceExtendedDynamicState2FeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->extendedDynamicState2);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState2LogicOp);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState2PatchControlPoints);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->extendedDynamicState2);
    vn_encode_VkBool32(enc, &val->extendedDynamicState2LogicOp);
    vn_encode_VkBool32(enc, &val->extendedDynamicState2PatchControlPoints);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->extendedDynamicState2);
    vn_decode_VkBool32(dec, &val->extendedDynamicState2LogicOp);
    vn_decode_VkBool32(dec, &val->extendedDynamicState2PatchControlPoints);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial(const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->extendedDynamicState2 */
    /* skip val->extendedDynamicState2LogicOp */
    /* skip val->extendedDynamicState2PatchControlPoints */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_partial(const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->extendedDynamicState2 */
    /* skip val->extendedDynamicState2LogicOp */
    /* skip val->extendedDynamicState2PatchControlPoints */
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderZeroInitializeWorkgroupMemory);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderZeroInitializeWorkgroupMemory);
}

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES });
    vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderZeroInitializeWorkgroupMemory);
}

static inline void
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial(const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderZeroInitializeWorkgroupMemory */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_partial(const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderZeroInitializeWorkgroupMemory */
}

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES });
    vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceImageRobustnessFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_self(const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->robustImageAccess);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures(const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->robustImageAccess);
}

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES });
    vn_encode_VkPhysicalDeviceImageRobustnessFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceImageRobustnessFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceImageRobustnessFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->robustImageAccess);
}

static inline void
vn_decode_VkPhysicalDeviceImageRobustnessFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceImageRobustnessFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceImageRobustnessFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_self_partial(const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->robustImageAccess */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_partial(const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->robustImageAccess */
}

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES });
    vn_encode_VkPhysicalDeviceImageRobustnessFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDevice4444FormatsFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_self(const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->formatA4R4G4B4);
    size += vn_sizeof_VkBool32(&val->formatA4B4G4R4);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT(const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->formatA4R4G4B4);
    vn_encode_VkBool32(enc, &val->formatA4B4G4R4);
}

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT });
    vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->formatA4R4G4B4);
    vn_decode_VkBool32(dec, &val->formatA4B4G4R4);
}

static inline void
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial(const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->formatA4R4G4B4 */
    /* skip val->formatA4B4G4R4 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_partial(const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->formatA4R4G4B4 */
    /* skip val->formatA4B4G4R4 */
}

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT });
    vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderTerminateInvocationFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderTerminateInvocation);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures(const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderTerminateInvocation);
}

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES });
    vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderTerminateInvocation);
}

static inline void
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial(const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderTerminateInvocation */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_partial(const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderTerminateInvocation */
}

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES });
    vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceSynchronization2Features chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceSynchronization2Features_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSynchronization2Features_self(const VkPhysicalDeviceSynchronization2Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->synchronization2);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSynchronization2Features(const VkPhysicalDeviceSynchronization2Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSynchronization2Features_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSynchronization2Features_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSynchronization2Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->synchronization2);
}

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceSynchronization2Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES });
    vn_encode_VkPhysicalDeviceSynchronization2Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSynchronization2Features_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceSynchronization2Features_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceSynchronization2Features_self(struct vn_cs_decoder *dec, VkPhysicalDeviceSynchronization2Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->synchronization2);
}

static inline void
vn_decode_VkPhysicalDeviceSynchronization2Features(struct vn_cs_decoder *dec, VkPhysicalDeviceSynchronization2Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceSynchronization2Features_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceSynchronization2Features_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSynchronization2Features_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSynchronization2Features_self_partial(const VkPhysicalDeviceSynchronization2Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->synchronization2 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSynchronization2Features_partial(const VkPhysicalDeviceSynchronization2Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSynchronization2Features_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSynchronization2Features_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSynchronization2Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->synchronization2 */
}

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSynchronization2Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES });
    vn_encode_VkPhysicalDeviceSynchronization2Features_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSynchronization2Features_self_partial(enc, val);
}

/* struct VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->ycbcr2plane444Formats);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->ycbcr2plane444Formats);
}

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->ycbcr2plane444Formats);
}

static inline void
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial(const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->ycbcr2plane444Formats */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_partial(const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->ycbcr2plane444Formats */
}

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderIntegerDotProductFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderIntegerDotProduct);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures(const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderIntegerDotProduct);
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES });
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderIntegerDotProduct);
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial(const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderIntegerDotProduct */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_partial(const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderIntegerDotProduct */
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES });
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceDynamicRenderingFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_self(const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->dynamicRendering);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures(const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->dynamicRendering);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES });
    vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->dynamicRendering);
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_self_partial(const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->dynamicRendering */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_partial(const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->dynamicRendering */
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES });
    vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceFeatures2 chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceFeatures2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePrivateDataFeatures_self((const VkPhysicalDevicePrivateDataFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_self((const VkPhysicalDeviceVariablePointersFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMultiviewFeatures_self((const VkPhysicalDeviceMultiviewFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice16BitStorageFeatures_self((const VkPhysicalDevice16BitStorageFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self((const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self((const VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_self((const VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_self((const VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMaintenance4Features_self((const VkPhysicalDeviceMaintenance4Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_self((const VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_self((const VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_self((const VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_self((const VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_self((const VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice8BitStorageFeatures_self((const VkPhysicalDevice8BitStorageFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_self((const VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_self((const VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self((const VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_self((const VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self((const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_self((const VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_self((const VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self((const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self((const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self((const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self((const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_self((const VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_self((const VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan11Features_self((const VkPhysicalDeviceVulkan11Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan12Features_self((const VkPhysicalDeviceVulkan12Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan13Features_self((const VkPhysicalDeviceVulkan13Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self((const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self((const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self((const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_self((const VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_self((const VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_self((const VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSynchronization2Features_self((const VkPhysicalDeviceSynchronization2Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self((const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_self((const VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_self((const VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFeatures2_self(const VkPhysicalDeviceFeatures2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkPhysicalDeviceFeatures(&val->features);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFeatures2(const VkPhysicalDeviceFeatures2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceFeatures2_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrivateDataFeatures_self(enc, (const VkPhysicalDevicePrivateDataFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(enc, (const VkPhysicalDeviceVariablePointersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiviewFeatures_self(enc, (const VkPhysicalDeviceMultiviewFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice16BitStorageFeatures_self(enc, (const VkPhysicalDevice16BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(enc, (const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(enc, (const VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(enc, (const VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self(enc, (const VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance4Features_self(enc, (const VkPhysicalDeviceMaintenance4Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(enc, (const VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(enc, (const VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(enc, (const VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(enc, (const VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(enc, (const VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice8BitStorageFeatures_self(enc, (const VkPhysicalDevice8BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(enc, (const VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(enc, (const VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(enc, (const VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(enc, (const VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(enc, (const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(enc, (const VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(enc, (const VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(enc, (const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(enc, (const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(enc, (const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(enc, (const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(enc, (const VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(enc, (const VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan11Features_self(enc, (const VkPhysicalDeviceVulkan11Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan12Features_self(enc, (const VkPhysicalDeviceVulkan12Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan13Features_self(enc, (const VkPhysicalDeviceVulkan13Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(enc, (const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(enc, (const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(enc, (const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self(enc, (const VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self(enc, (const VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(enc, (const VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSynchronization2Features_self(enc, (const VkPhysicalDeviceSynchronization2Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(enc, (const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(enc, (const VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self(enc, (const VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPhysicalDeviceFeatures(enc, &val->features);
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2 });
    vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFeatures2_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    VkBaseOutStructure *pnext = (VkBaseOutStructure *)val;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return;

    vn_decode_VkStructureType(dec, &stype);
    while (true) {
        assert(pnext);
        if (pnext->sType == stype)
            break;
    }

    switch ((int32_t)pnext->sType) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDevicePrivateDataFeatures_self(dec, (VkPhysicalDevicePrivateDataFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVariablePointersFeatures_self(dec, (VkPhysicalDeviceVariablePointersFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceMultiviewFeatures_self(dec, (VkPhysicalDeviceMultiviewFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDevice16BitStorageFeatures_self(dec, (VkPhysicalDevice16BitStorageFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(dec, (VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(dec, (VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self(dec, (VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self(dec, (VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceMaintenance4Features_self(dec, (VkPhysicalDeviceMaintenance4Features *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self(dec, (VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self(dec, (VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self(dec, (VkPhysicalDeviceHostQueryResetFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self(dec, (VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(dec, (VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDevice8BitStorageFeatures_self(dec, (VkPhysicalDevice8BitStorageFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(dec, (VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self(dec, (VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(dec, (VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(dec, (VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(dec, (VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(dec, (VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self(dec, (VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(dec, (VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(dec, (VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(dec, (VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(dec, (VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(dec, (VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(dec, (VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVulkan11Features_self(dec, (VkPhysicalDeviceVulkan11Features *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVulkan12Features_self(dec, (VkPhysicalDeviceVulkan12Features *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVulkan13Features_self(dec, (VkPhysicalDeviceVulkan13Features *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(dec, (VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(dec, (VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(dec, (VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self(dec, (VkPhysicalDeviceImageRobustnessFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self(dec, (VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(dec, (VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceSynchronization2Features_self(dec, (VkPhysicalDeviceSynchronization2Features *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(dec, (VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(dec, (VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self(dec, (VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2_self(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPhysicalDeviceFeatures(dec, &val->features);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceFeatures2_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePrivateDataFeatures_self_partial((const VkPhysicalDevicePrivateDataFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_self_partial((const VkPhysicalDeviceVariablePointersFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMultiviewFeatures_self_partial((const VkPhysicalDeviceMultiviewFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice16BitStorageFeatures_self_partial((const VkPhysicalDevice16BitStorageFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial((const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial((const VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_self_partial((const VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial((const VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMaintenance4Features_self_partial((const VkPhysicalDeviceMaintenance4Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial((const VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_self_partial((const VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_self_partial((const VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial((const VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial((const VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice8BitStorageFeatures_self_partial((const VkPhysicalDevice8BitStorageFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial((const VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_self_partial((const VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial((const VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial((const VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial((const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial((const VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial((const VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial((const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial((const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial((const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial((const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial((const VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial((const VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan11Features_self_partial((const VkPhysicalDeviceVulkan11Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan12Features_self_partial((const VkPhysicalDeviceVulkan12Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan13Features_self_partial((const VkPhysicalDeviceVulkan13Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial((const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial((const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial((const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_self_partial((const VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial((const VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial((const VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSynchronization2Features_self_partial((const VkPhysicalDeviceSynchronization2Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial((const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial((const VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_self_partial((const VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFeatures2_self_partial(const VkPhysicalDeviceFeatures2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkPhysicalDeviceFeatures_partial(&val->features);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFeatures2_partial(const VkPhysicalDeviceFeatures2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceFeatures2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrivateDataFeatures_self_partial(enc, (const VkPhysicalDevicePrivateDataFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVariablePointersFeatures_self_partial(enc, (const VkPhysicalDeviceVariablePointersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiviewFeatures_self_partial(enc, (const VkPhysicalDeviceMultiviewFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice16BitStorageFeatures_self_partial(enc, (const VkPhysicalDevice16BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial(enc, (const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial(enc, (const VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self_partial(enc, (const VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial(enc, (const VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance4Features_self_partial(enc, (const VkPhysicalDeviceMaintenance4Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial(enc, (const VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self_partial(enc, (const VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self_partial(enc, (const VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial(enc, (const VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial(enc, (const VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice8BitStorageFeatures_self_partial(enc, (const VkPhysicalDevice8BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial(enc, (const VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self_partial(enc, (const VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial(enc, (const VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial(enc, (const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial(enc, (const VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial(enc, (const VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial(enc, (const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial(enc, (const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial(enc, (const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial(enc, (const VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial(enc, (const VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan11Features_self_partial(enc, (const VkPhysicalDeviceVulkan11Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan12Features_self_partial(enc, (const VkPhysicalDeviceVulkan12Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan13Features_self_partial(enc, (const VkPhysicalDeviceVulkan13Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial(enc, (const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial(enc, (const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self_partial(enc, (const VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial(enc, (const VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial(enc, (const VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSynchronization2Features_self_partial(enc, (const VkPhysicalDeviceSynchronization2Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial(enc, (const VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self_partial(enc, (const VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPhysicalDeviceFeatures_partial(enc, &val->features);
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2 });
    vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFeatures2_self_partial(enc, val);
}

/* struct VkDeviceGroupDeviceCreateInfo chain */

static inline size_t
vn_sizeof_VkDeviceGroupDeviceCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDeviceGroupDeviceCreateInfo_self(const VkDeviceGroupDeviceCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->physicalDeviceCount);
    if (val->pPhysicalDevices) {
        size += vn_sizeof_array_size(val->physicalDeviceCount);
        for (uint32_t i = 0; i < val->physicalDeviceCount; i++)
            size += vn_sizeof_VkPhysicalDevice(&val->pPhysicalDevices[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkDeviceGroupDeviceCreateInfo(const VkDeviceGroupDeviceCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDeviceGroupDeviceCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkDeviceGroupDeviceCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkDeviceGroupDeviceCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDeviceGroupDeviceCreateInfo_self(struct vn_cs_encoder *enc, const VkDeviceGroupDeviceCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->physicalDeviceCount);
    if (val->pPhysicalDevices) {
        vn_encode_array_size(enc, val->physicalDeviceCount);
        for (uint32_t i = 0; i < val->physicalDeviceCount; i++)
            vn_encode_VkPhysicalDevice(enc, &val->pPhysicalDevices[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkDeviceGroupDeviceCreateInfo(struct vn_cs_encoder *enc, const VkDeviceGroupDeviceCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO });
    vn_encode_VkDeviceGroupDeviceCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkDeviceGroupDeviceCreateInfo_self(enc, val);
}

/* struct VkDeviceCreateInfo chain */

static inline size_t
vn_sizeof_VkDeviceCreateInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkDevicePrivateDataCreateInfo_self((const VkDevicePrivateDataCreateInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePrivateDataFeatures_self((const VkPhysicalDevicePrivateDataFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_self((const VkPhysicalDeviceFeatures2 *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_self((const VkPhysicalDeviceVariablePointersFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMultiviewFeatures_self((const VkPhysicalDeviceMultiviewFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkDeviceGroupDeviceCreateInfo_self((const VkDeviceGroupDeviceCreateInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice16BitStorageFeatures_self((const VkPhysicalDevice16BitStorageFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self((const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self((const VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_self((const VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_self((const VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMaintenance4Features_self((const VkPhysicalDeviceMaintenance4Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_self((const VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_self((const VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_self((const VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_self((const VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_self((const VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice8BitStorageFeatures_self((const VkPhysicalDevice8BitStorageFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_self((const VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_self((const VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self((const VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_self((const VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self((const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_self((const VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_self((const VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self((const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self((const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self((const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self((const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_self((const VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_self((const VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan11Features_self((const VkPhysicalDeviceVulkan11Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan12Features_self((const VkPhysicalDeviceVulkan12Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan13Features_self((const VkPhysicalDeviceVulkan13Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self((const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self((const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self((const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_self((const VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_self((const VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_self((const VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSynchronization2Features_self((const VkPhysicalDeviceSynchronization2Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self((const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_self((const VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_self((const VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDeviceCreateInfo_self(const VkDeviceCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_uint32_t(&val->queueCreateInfoCount);
    if (val->pQueueCreateInfos) {
        size += vn_sizeof_array_size(val->queueCreateInfoCount);
        for (uint32_t i = 0; i < val->queueCreateInfoCount; i++)
            size += vn_sizeof_VkDeviceQueueCreateInfo(&val->pQueueCreateInfos[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->enabledLayerCount);
    if (val->ppEnabledLayerNames) {
        size += vn_sizeof_array_size(val->enabledLayerCount);
        for (uint32_t i = 0; i < val->enabledLayerCount; i++) {
            const size_t string_size = strlen(val->ppEnabledLayerNames[i]) + 1;
            size += vn_sizeof_array_size(string_size);
            size += vn_sizeof_char_array(val->ppEnabledLayerNames[i], string_size);
        }
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->enabledExtensionCount);
    if (val->ppEnabledExtensionNames) {
        size += vn_sizeof_array_size(val->enabledExtensionCount);
        for (uint32_t i = 0; i < val->enabledExtensionCount; i++) {
            const size_t string_size = strlen(val->ppEnabledExtensionNames[i]) + 1;
            size += vn_sizeof_array_size(string_size);
            size += vn_sizeof_char_array(val->ppEnabledExtensionNames[i], string_size);
        }
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_simple_pointer(val->pEnabledFeatures);
    if (val->pEnabledFeatures)
        size += vn_sizeof_VkPhysicalDeviceFeatures(val->pEnabledFeatures);
    return size;
}

static inline size_t
vn_sizeof_VkDeviceCreateInfo(const VkDeviceCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDeviceCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkDeviceCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkDeviceCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkDevicePrivateDataCreateInfo_self(enc, (const VkDevicePrivateDataCreateInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrivateDataFeatures_self(enc, (const VkPhysicalDevicePrivateDataFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceFeatures2_self(enc, (const VkPhysicalDeviceFeatures2 *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(enc, (const VkPhysicalDeviceVariablePointersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiviewFeatures_self(enc, (const VkPhysicalDeviceMultiviewFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkDeviceGroupDeviceCreateInfo_self(enc, (const VkDeviceGroupDeviceCreateInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice16BitStorageFeatures_self(enc, (const VkPhysicalDevice16BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(enc, (const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(enc, (const VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(enc, (const VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self(enc, (const VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance4Features_self(enc, (const VkPhysicalDeviceMaintenance4Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(enc, (const VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(enc, (const VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(enc, (const VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(enc, (const VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(enc, (const VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice8BitStorageFeatures_self(enc, (const VkPhysicalDevice8BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(enc, (const VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(enc, (const VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(enc, (const VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(enc, (const VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(enc, (const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(enc, (const VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(enc, (const VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(enc, (const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(enc, (const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(enc, (const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(enc, (const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(enc, (const VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(enc, (const VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan11Features_self(enc, (const VkPhysicalDeviceVulkan11Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan12Features_self(enc, (const VkPhysicalDeviceVulkan12Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan13Features_self(enc, (const VkPhysicalDeviceVulkan13Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(enc, (const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(enc, (const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(enc, (const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self(enc, (const VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self(enc, (const VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(enc, (const VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSynchronization2Features_self(enc, (const VkPhysicalDeviceSynchronization2Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(enc, (const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(enc, (const VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self(enc, (const VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDeviceCreateInfo_self(struct vn_cs_encoder *enc, const VkDeviceCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_uint32_t(enc, &val->queueCreateInfoCount);
    if (val->pQueueCreateInfos) {
        vn_encode_array_size(enc, val->queueCreateInfoCount);
        for (uint32_t i = 0; i < val->queueCreateInfoCount; i++)
            vn_encode_VkDeviceQueueCreateInfo(enc, &val->pQueueCreateInfos[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->enabledLayerCount);
    if (val->ppEnabledLayerNames) {
        vn_encode_array_size(enc, val->enabledLayerCount);
        for (uint32_t i = 0; i < val->enabledLayerCount; i++) {
            const size_t string_size = strlen(val->ppEnabledLayerNames[i]) + 1;
            vn_encode_array_size(enc, string_size);
            vn_encode_char_array(enc, val->ppEnabledLayerNames[i], string_size);
        }
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->enabledExtensionCount);
    if (val->ppEnabledExtensionNames) {
        vn_encode_array_size(enc, val->enabledExtensionCount);
        for (uint32_t i = 0; i < val->enabledExtensionCount; i++) {
            const size_t string_size = strlen(val->ppEnabledExtensionNames[i]) + 1;
            vn_encode_array_size(enc, string_size);
            vn_encode_char_array(enc, val->ppEnabledExtensionNames[i], string_size);
        }
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (vn_encode_simple_pointer(enc, val->pEnabledFeatures))
        vn_encode_VkPhysicalDeviceFeatures(enc, val->pEnabledFeatures);
}

static inline void
vn_encode_VkDeviceCreateInfo(struct vn_cs_encoder *enc, const VkDeviceCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO });
    vn_encode_VkDeviceCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkDeviceCreateInfo_self(enc, val);
}

/* struct VkConformanceVersion */

static inline size_t
vn_sizeof_VkConformanceVersion(const VkConformanceVersion *val)
{
    size_t size = 0;
    size += vn_sizeof_uint8_t(&val->major);
    size += vn_sizeof_uint8_t(&val->minor);
    size += vn_sizeof_uint8_t(&val->subminor);
    size += vn_sizeof_uint8_t(&val->patch);
    return size;
}

static inline void
vn_decode_VkConformanceVersion(struct vn_cs_decoder *dec, VkConformanceVersion *val)
{
    vn_decode_uint8_t(dec, &val->major);
    vn_decode_uint8_t(dec, &val->minor);
    vn_decode_uint8_t(dec, &val->subminor);
    vn_decode_uint8_t(dec, &val->patch);
}

static inline size_t
vn_sizeof_VkConformanceVersion_partial(const VkConformanceVersion *val)
{
    size_t size = 0;
    /* skip val->major */
    /* skip val->minor */
    /* skip val->subminor */
    /* skip val->patch */
    return size;
}

static inline void
vn_encode_VkConformanceVersion_partial(struct vn_cs_encoder *enc, const VkConformanceVersion *val)
{
    /* skip val->major */
    /* skip val->minor */
    /* skip val->subminor */
    /* skip val->patch */
}

/* struct VkPhysicalDeviceDriverProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceDriverProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDriverProperties_self(const VkPhysicalDeviceDriverProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDriverId(&val->driverID);
    size += vn_sizeof_array_size(VK_MAX_DRIVER_NAME_SIZE);
    size += vn_sizeof_char_array(val->driverName, VK_MAX_DRIVER_NAME_SIZE);
    size += vn_sizeof_array_size(VK_MAX_DRIVER_INFO_SIZE);
    size += vn_sizeof_char_array(val->driverInfo, VK_MAX_DRIVER_INFO_SIZE);
    size += vn_sizeof_VkConformanceVersion(&val->conformanceVersion);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDriverProperties(const VkPhysicalDeviceDriverProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDriverProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDriverProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceDriverProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceDriverProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceDriverProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkDriverId(dec, &val->driverID);
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_DRIVER_NAME_SIZE);
        vn_decode_char_array(dec, val->driverName, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_DRIVER_INFO_SIZE);
        vn_decode_char_array(dec, val->driverInfo, array_size);
    }
    vn_decode_VkConformanceVersion(dec, &val->conformanceVersion);
}

static inline void
vn_decode_VkPhysicalDeviceDriverProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceDriverProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceDriverProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceDriverProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDriverProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDriverProperties_self_partial(const VkPhysicalDeviceDriverProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->driverID */
    /* skip val->driverName */
    /* skip val->driverInfo */
    size += vn_sizeof_VkConformanceVersion_partial(&val->conformanceVersion);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDriverProperties_partial(const VkPhysicalDeviceDriverProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDriverProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDriverProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDriverProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDriverProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDriverProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->driverID */
    /* skip val->driverName */
    /* skip val->driverInfo */
    vn_encode_VkConformanceVersion_partial(enc, &val->conformanceVersion);
}

static inline void
vn_encode_VkPhysicalDeviceDriverProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDriverProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES });
    vn_encode_VkPhysicalDeviceDriverProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDriverProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceIDProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceIDProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceIDProperties_self(const VkPhysicalDeviceIDProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_array_size(VK_UUID_SIZE);
    size += vn_sizeof_uint8_t_array(val->deviceUUID, VK_UUID_SIZE);
    size += vn_sizeof_array_size(VK_UUID_SIZE);
    size += vn_sizeof_uint8_t_array(val->driverUUID, VK_UUID_SIZE);
    size += vn_sizeof_array_size(VK_LUID_SIZE);
    size += vn_sizeof_uint8_t_array(val->deviceLUID, VK_LUID_SIZE);
    size += vn_sizeof_uint32_t(&val->deviceNodeMask);
    size += vn_sizeof_VkBool32(&val->deviceLUIDValid);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceIDProperties(const VkPhysicalDeviceIDProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceIDProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceIDProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceIDProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceIDProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceIDProperties *val)
{
    /* skip val->{sType,pNext} */
    {
        const size_t array_size = vn_decode_array_size(dec, VK_UUID_SIZE);
        vn_decode_uint8_t_array(dec, val->deviceUUID, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_UUID_SIZE);
        vn_decode_uint8_t_array(dec, val->driverUUID, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_LUID_SIZE);
        vn_decode_uint8_t_array(dec, val->deviceLUID, array_size);
    }
    vn_decode_uint32_t(dec, &val->deviceNodeMask);
    vn_decode_VkBool32(dec, &val->deviceLUIDValid);
}

static inline void
vn_decode_VkPhysicalDeviceIDProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceIDProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceIDProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceIDProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceIDProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceIDProperties_self_partial(const VkPhysicalDeviceIDProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->deviceUUID */
    /* skip val->driverUUID */
    /* skip val->deviceLUID */
    /* skip val->deviceNodeMask */
    /* skip val->deviceLUIDValid */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceIDProperties_partial(const VkPhysicalDeviceIDProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceIDProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceIDProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceIDProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceIDProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceIDProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->deviceUUID */
    /* skip val->driverUUID */
    /* skip val->deviceLUID */
    /* skip val->deviceNodeMask */
    /* skip val->deviceLUIDValid */
}

static inline void
vn_encode_VkPhysicalDeviceIDProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceIDProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES });
    vn_encode_VkPhysicalDeviceIDProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceIDProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceMultiviewProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewProperties_self(const VkPhysicalDeviceMultiviewProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->maxMultiviewViewCount);
    size += vn_sizeof_uint32_t(&val->maxMultiviewInstanceIndex);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewProperties(const VkPhysicalDeviceMultiviewProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMultiviewProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMultiviewProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->maxMultiviewViewCount);
    vn_decode_uint32_t(dec, &val->maxMultiviewInstanceIndex);
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceMultiviewProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceMultiviewProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewProperties_self_partial(const VkPhysicalDeviceMultiviewProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxMultiviewViewCount */
    /* skip val->maxMultiviewInstanceIndex */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewProperties_partial(const VkPhysicalDeviceMultiviewProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMultiviewProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMultiviewProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxMultiviewViewCount */
    /* skip val->maxMultiviewInstanceIndex */
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES });
    vn_encode_VkPhysicalDeviceMultiviewProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiviewProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceSubgroupProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupProperties_self(const VkPhysicalDeviceSubgroupProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->subgroupSize);
    size += vn_sizeof_VkFlags(&val->supportedStages);
    size += vn_sizeof_VkFlags(&val->supportedOperations);
    size += vn_sizeof_VkBool32(&val->quadOperationsInAllStages);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupProperties(const VkPhysicalDeviceSubgroupProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSubgroupProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSubgroupProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->subgroupSize);
    vn_decode_VkFlags(dec, &val->supportedStages);
    vn_decode_VkFlags(dec, &val->supportedOperations);
    vn_decode_VkBool32(dec, &val->quadOperationsInAllStages);
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceSubgroupProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceSubgroupProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupProperties_self_partial(const VkPhysicalDeviceSubgroupProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->subgroupSize */
    /* skip val->supportedStages */
    /* skip val->supportedOperations */
    /* skip val->quadOperationsInAllStages */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupProperties_partial(const VkPhysicalDeviceSubgroupProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSubgroupProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSubgroupProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->subgroupSize */
    /* skip val->supportedStages */
    /* skip val->supportedOperations */
    /* skip val->quadOperationsInAllStages */
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES });
    vn_encode_VkPhysicalDeviceSubgroupProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSubgroupProperties_self_partial(enc, val);
}

/* struct VkPhysicalDevicePointClippingProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDevicePointClippingProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePointClippingProperties_self(const VkPhysicalDevicePointClippingProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkPointClippingBehavior(&val->pointClippingBehavior);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePointClippingProperties(const VkPhysicalDevicePointClippingProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePointClippingProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePointClippingProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDevicePointClippingProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDevicePointClippingProperties_self(struct vn_cs_decoder *dec, VkPhysicalDevicePointClippingProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPointClippingBehavior(dec, &val->pointClippingBehavior);
}

static inline void
vn_decode_VkPhysicalDevicePointClippingProperties(struct vn_cs_decoder *dec, VkPhysicalDevicePointClippingProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDevicePointClippingProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDevicePointClippingProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePointClippingProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePointClippingProperties_self_partial(const VkPhysicalDevicePointClippingProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->pointClippingBehavior */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePointClippingProperties_partial(const VkPhysicalDevicePointClippingProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePointClippingProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePointClippingProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevicePointClippingProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePointClippingProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePointClippingProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->pointClippingBehavior */
}

static inline void
vn_encode_VkPhysicalDevicePointClippingProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePointClippingProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES });
    vn_encode_VkPhysicalDevicePointClippingProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDevicePointClippingProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceProtectedMemoryProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_self(const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->protectedNoFault);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties(const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->protectedNoFault);
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceProtectedMemoryProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceProtectedMemoryProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_self_partial(const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->protectedNoFault */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_partial(const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->protectedNoFault */
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES });
    vn_encode_VkPhysicalDeviceProtectedMemoryProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProtectedMemoryProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceSamplerFilterMinmaxProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->filterMinmaxSingleComponentFormats);
    size += vn_sizeof_VkBool32(&val->filterMinmaxImageComponentMapping);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties(const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->filterMinmaxSingleComponentFormats);
    vn_decode_VkBool32(dec, &val->filterMinmaxImageComponentMapping);
}

static inline void
vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial(const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->filterMinmaxSingleComponentFormats */
    /* skip val->filterMinmaxImageComponentMapping */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_partial(const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->filterMinmaxSingleComponentFormats */
    /* skip val->filterMinmaxImageComponentMapping */
}

static inline void
vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES });
    vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceInlineUniformBlockProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_self(const VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->maxInlineUniformBlockSize);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorInlineUniformBlocks);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetInlineUniformBlocks);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties(const VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->maxInlineUniformBlockSize);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorInlineUniformBlocks);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetInlineUniformBlocks);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks);
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_self_partial(const VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxInlineUniformBlockSize */
    /* skip val->maxPerStageDescriptorInlineUniformBlocks */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxDescriptorSetInlineUniformBlocks */
    /* skip val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_partial(const VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxInlineUniformBlockSize */
    /* skip val->maxPerStageDescriptorInlineUniformBlocks */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxDescriptorSetInlineUniformBlocks */
    /* skip val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks */
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES });
    vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceMaintenance3Properties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance3Properties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance3Properties_self(const VkPhysicalDeviceMaintenance3Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->maxPerSetDescriptors);
    size += vn_sizeof_VkDeviceSize(&val->maxMemoryAllocationSize);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance3Properties(const VkPhysicalDeviceMaintenance3Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMaintenance3Properties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMaintenance3Properties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance3Properties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance3Properties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance3Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->maxPerSetDescriptors);
    vn_decode_VkDeviceSize(dec, &val->maxMemoryAllocationSize);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance3Properties(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance3Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceMaintenance3Properties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceMaintenance3Properties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance3Properties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance3Properties_self_partial(const VkPhysicalDeviceMaintenance3Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxPerSetDescriptors */
    /* skip val->maxMemoryAllocationSize */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance3Properties_partial(const VkPhysicalDeviceMaintenance3Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMaintenance3Properties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMaintenance3Properties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance3Properties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance3Properties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance3Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxPerSetDescriptors */
    /* skip val->maxMemoryAllocationSize */
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance3Properties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance3Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES });
    vn_encode_VkPhysicalDeviceMaintenance3Properties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance3Properties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceMaintenance4Properties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Properties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Properties_self(const VkPhysicalDeviceMaintenance4Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDeviceSize(&val->maxBufferSize);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Properties(const VkPhysicalDeviceMaintenance4Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMaintenance4Properties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMaintenance4Properties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Properties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Properties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkDeviceSize(dec, &val->maxBufferSize);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Properties(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceMaintenance4Properties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceMaintenance4Properties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Properties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Properties_self_partial(const VkPhysicalDeviceMaintenance4Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxBufferSize */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Properties_partial(const VkPhysicalDeviceMaintenance4Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMaintenance4Properties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMaintenance4Properties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Properties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Properties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxBufferSize */
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Properties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES });
    vn_encode_VkPhysicalDeviceMaintenance4Properties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance4Properties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceFloatControlsProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceFloatControlsProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFloatControlsProperties_self(const VkPhysicalDeviceFloatControlsProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkShaderFloatControlsIndependence(&val->denormBehaviorIndependence);
    size += vn_sizeof_VkShaderFloatControlsIndependence(&val->roundingModeIndependence);
    size += vn_sizeof_VkBool32(&val->shaderSignedZeroInfNanPreserveFloat16);
    size += vn_sizeof_VkBool32(&val->shaderSignedZeroInfNanPreserveFloat32);
    size += vn_sizeof_VkBool32(&val->shaderSignedZeroInfNanPreserveFloat64);
    size += vn_sizeof_VkBool32(&val->shaderDenormPreserveFloat16);
    size += vn_sizeof_VkBool32(&val->shaderDenormPreserveFloat32);
    size += vn_sizeof_VkBool32(&val->shaderDenormPreserveFloat64);
    size += vn_sizeof_VkBool32(&val->shaderDenormFlushToZeroFloat16);
    size += vn_sizeof_VkBool32(&val->shaderDenormFlushToZeroFloat32);
    size += vn_sizeof_VkBool32(&val->shaderDenormFlushToZeroFloat64);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTEFloat16);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTEFloat32);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTEFloat64);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTZFloat16);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTZFloat32);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTZFloat64);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFloatControlsProperties(const VkPhysicalDeviceFloatControlsProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceFloatControlsProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceFloatControlsProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceFloatControlsProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceFloatControlsProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceFloatControlsProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkShaderFloatControlsIndependence(dec, &val->denormBehaviorIndependence);
    vn_decode_VkShaderFloatControlsIndependence(dec, &val->roundingModeIndependence);
    vn_decode_VkBool32(dec, &val->shaderSignedZeroInfNanPreserveFloat16);
    vn_decode_VkBool32(dec, &val->shaderSignedZeroInfNanPreserveFloat32);
    vn_decode_VkBool32(dec, &val->shaderSignedZeroInfNanPreserveFloat64);
    vn_decode_VkBool32(dec, &val->shaderDenormPreserveFloat16);
    vn_decode_VkBool32(dec, &val->shaderDenormPreserveFloat32);
    vn_decode_VkBool32(dec, &val->shaderDenormPreserveFloat64);
    vn_decode_VkBool32(dec, &val->shaderDenormFlushToZeroFloat16);
    vn_decode_VkBool32(dec, &val->shaderDenormFlushToZeroFloat32);
    vn_decode_VkBool32(dec, &val->shaderDenormFlushToZeroFloat64);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTEFloat16);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTEFloat32);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTEFloat64);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTZFloat16);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTZFloat32);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTZFloat64);
}

static inline void
vn_decode_VkPhysicalDeviceFloatControlsProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceFloatControlsProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceFloatControlsProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceFloatControlsProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFloatControlsProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFloatControlsProperties_self_partial(const VkPhysicalDeviceFloatControlsProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->denormBehaviorIndependence */
    /* skip val->roundingModeIndependence */
    /* skip val->shaderSignedZeroInfNanPreserveFloat16 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat32 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat64 */
    /* skip val->shaderDenormPreserveFloat16 */
    /* skip val->shaderDenormPreserveFloat32 */
    /* skip val->shaderDenormPreserveFloat64 */
    /* skip val->shaderDenormFlushToZeroFloat16 */
    /* skip val->shaderDenormFlushToZeroFloat32 */
    /* skip val->shaderDenormFlushToZeroFloat64 */
    /* skip val->shaderRoundingModeRTEFloat16 */
    /* skip val->shaderRoundingModeRTEFloat32 */
    /* skip val->shaderRoundingModeRTEFloat64 */
    /* skip val->shaderRoundingModeRTZFloat16 */
    /* skip val->shaderRoundingModeRTZFloat32 */
    /* skip val->shaderRoundingModeRTZFloat64 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFloatControlsProperties_partial(const VkPhysicalDeviceFloatControlsProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceFloatControlsProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceFloatControlsProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceFloatControlsProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFloatControlsProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceFloatControlsProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->denormBehaviorIndependence */
    /* skip val->roundingModeIndependence */
    /* skip val->shaderSignedZeroInfNanPreserveFloat16 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat32 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat64 */
    /* skip val->shaderDenormPreserveFloat16 */
    /* skip val->shaderDenormPreserveFloat32 */
    /* skip val->shaderDenormPreserveFloat64 */
    /* skip val->shaderDenormFlushToZeroFloat16 */
    /* skip val->shaderDenormFlushToZeroFloat32 */
    /* skip val->shaderDenormFlushToZeroFloat64 */
    /* skip val->shaderRoundingModeRTEFloat16 */
    /* skip val->shaderRoundingModeRTEFloat32 */
    /* skip val->shaderRoundingModeRTEFloat64 */
    /* skip val->shaderRoundingModeRTZFloat16 */
    /* skip val->shaderRoundingModeRTZFloat32 */
    /* skip val->shaderRoundingModeRTZFloat64 */
}

static inline void
vn_encode_VkPhysicalDeviceFloatControlsProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceFloatControlsProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES });
    vn_encode_VkPhysicalDeviceFloatControlsProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFloatControlsProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceDescriptorIndexingProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_self(const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->maxUpdateAfterBindDescriptorsInAllPools);
    size += vn_sizeof_VkBool32(&val->shaderUniformBufferArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->shaderSampledImageArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->shaderStorageBufferArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->shaderInputAttachmentArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->robustBufferAccessUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->quadDivergentImplicitLod);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindSamplers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindUniformBuffers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindStorageBuffers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindSampledImages);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindStorageImages);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindInputAttachments);
    size += vn_sizeof_uint32_t(&val->maxPerStageUpdateAfterBindResources);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindSamplers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindUniformBuffers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindStorageBuffers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindSampledImages);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindStorageImages);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindInputAttachments);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties(const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->maxUpdateAfterBindDescriptorsInAllPools);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->robustBufferAccessUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->quadDivergentImplicitLod);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindSamplers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindUniformBuffers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindStorageBuffers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindSampledImages);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindStorageImages);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindInputAttachments);
    vn_decode_uint32_t(dec, &val->maxPerStageUpdateAfterBindResources);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindSamplers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindUniformBuffers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindStorageBuffers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindSampledImages);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindStorageImages);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindInputAttachments);
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_self_partial(const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxUpdateAfterBindDescriptorsInAllPools */
    /* skip val->shaderUniformBufferArrayNonUniformIndexingNative */
    /* skip val->shaderSampledImageArrayNonUniformIndexingNative */
    /* skip val->shaderStorageBufferArrayNonUniformIndexingNative */
    /* skip val->shaderStorageImageArrayNonUniformIndexingNative */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexingNative */
    /* skip val->robustBufferAccessUpdateAfterBind */
    /* skip val->quadDivergentImplicitLod */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSamplers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindUniformBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSampledImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInputAttachments */
    /* skip val->maxPerStageUpdateAfterBindResources */
    /* skip val->maxDescriptorSetUpdateAfterBindSamplers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindSampledImages */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageImages */
    /* skip val->maxDescriptorSetUpdateAfterBindInputAttachments */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_partial(const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxUpdateAfterBindDescriptorsInAllPools */
    /* skip val->shaderUniformBufferArrayNonUniformIndexingNative */
    /* skip val->shaderSampledImageArrayNonUniformIndexingNative */
    /* skip val->shaderStorageBufferArrayNonUniformIndexingNative */
    /* skip val->shaderStorageImageArrayNonUniformIndexingNative */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexingNative */
    /* skip val->robustBufferAccessUpdateAfterBind */
    /* skip val->quadDivergentImplicitLod */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSamplers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindUniformBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSampledImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInputAttachments */
    /* skip val->maxPerStageUpdateAfterBindResources */
    /* skip val->maxDescriptorSetUpdateAfterBindSamplers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindSampledImages */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageImages */
    /* skip val->maxDescriptorSetUpdateAfterBindInputAttachments */
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES });
    vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceTimelineSemaphoreProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_self(const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint64_t(&val->maxTimelineSemaphoreValueDifference);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties(const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint64_t(dec, &val->maxTimelineSemaphoreValueDifference);
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial(const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxTimelineSemaphoreValueDifference */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_partial(const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxTimelineSemaphoreValueDifference */
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES });
    vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceDepthStencilResolveProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_self(const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->supportedDepthResolveModes);
    size += vn_sizeof_VkFlags(&val->supportedStencilResolveModes);
    size += vn_sizeof_VkBool32(&val->independentResolveNone);
    size += vn_sizeof_VkBool32(&val->independentResolve);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties(const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->supportedDepthResolveModes);
    vn_decode_VkFlags(dec, &val->supportedStencilResolveModes);
    vn_decode_VkBool32(dec, &val->independentResolveNone);
    vn_decode_VkBool32(dec, &val->independentResolve);
}

static inline void
vn_decode_VkPhysicalDeviceDepthStencilResolveProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_self_partial(const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->supportedDepthResolveModes */
    /* skip val->supportedStencilResolveModes */
    /* skip val->independentResolveNone */
    /* skip val->independentResolve */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_partial(const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->supportedDepthResolveModes */
    /* skip val->supportedStencilResolveModes */
    /* skip val->independentResolveNone */
    /* skip val->independentResolve */
}

static inline void
vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES });
    vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceTransformFeedbackPropertiesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->maxTransformFeedbackStreams);
    size += vn_sizeof_uint32_t(&val->maxTransformFeedbackBuffers);
    size += vn_sizeof_VkDeviceSize(&val->maxTransformFeedbackBufferSize);
    size += vn_sizeof_uint32_t(&val->maxTransformFeedbackStreamDataSize);
    size += vn_sizeof_uint32_t(&val->maxTransformFeedbackBufferDataSize);
    size += vn_sizeof_uint32_t(&val->maxTransformFeedbackBufferDataStride);
    size += vn_sizeof_VkBool32(&val->transformFeedbackQueries);
    size += vn_sizeof_VkBool32(&val->transformFeedbackStreamsLinesTriangles);
    size += vn_sizeof_VkBool32(&val->transformFeedbackRasterizationStreamSelect);
    size += vn_sizeof_VkBool32(&val->transformFeedbackDraw);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT(const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->maxTransformFeedbackStreams);
    vn_decode_uint32_t(dec, &val->maxTransformFeedbackBuffers);
    vn_decode_VkDeviceSize(dec, &val->maxTransformFeedbackBufferSize);
    vn_decode_uint32_t(dec, &val->maxTransformFeedbackStreamDataSize);
    vn_decode_uint32_t(dec, &val->maxTransformFeedbackBufferDataSize);
    vn_decode_uint32_t(dec, &val->maxTransformFeedbackBufferDataStride);
    vn_decode_VkBool32(dec, &val->transformFeedbackQueries);
    vn_decode_VkBool32(dec, &val->transformFeedbackStreamsLinesTriangles);
    vn_decode_VkBool32(dec, &val->transformFeedbackRasterizationStreamSelect);
    vn_decode_VkBool32(dec, &val->transformFeedbackDraw);
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial(const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxTransformFeedbackStreams */
    /* skip val->maxTransformFeedbackBuffers */
    /* skip val->maxTransformFeedbackBufferSize */
    /* skip val->maxTransformFeedbackStreamDataSize */
    /* skip val->maxTransformFeedbackBufferDataSize */
    /* skip val->maxTransformFeedbackBufferDataStride */
    /* skip val->transformFeedbackQueries */
    /* skip val->transformFeedbackStreamsLinesTriangles */
    /* skip val->transformFeedbackRasterizationStreamSelect */
    /* skip val->transformFeedbackDraw */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_partial(const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxTransformFeedbackStreams */
    /* skip val->maxTransformFeedbackBuffers */
    /* skip val->maxTransformFeedbackBufferSize */
    /* skip val->maxTransformFeedbackStreamDataSize */
    /* skip val->maxTransformFeedbackBufferDataSize */
    /* skip val->maxTransformFeedbackBufferDataStride */
    /* skip val->transformFeedbackQueries */
    /* skip val->transformFeedbackStreamsLinesTriangles */
    /* skip val->transformFeedbackRasterizationStreamSelect */
    /* skip val->transformFeedbackDraw */
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceTexelBufferAlignmentProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_self(const VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDeviceSize(&val->storageTexelBufferOffsetAlignmentBytes);
    size += vn_sizeof_VkBool32(&val->storageTexelBufferOffsetSingleTexelAlignment);
    size += vn_sizeof_VkDeviceSize(&val->uniformTexelBufferOffsetAlignmentBytes);
    size += vn_sizeof_VkBool32(&val->uniformTexelBufferOffsetSingleTexelAlignment);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties(const VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkDeviceSize(dec, &val->storageTexelBufferOffsetAlignmentBytes);
    vn_decode_VkBool32(dec, &val->storageTexelBufferOffsetSingleTexelAlignment);
    vn_decode_VkDeviceSize(dec, &val->uniformTexelBufferOffsetAlignmentBytes);
    vn_decode_VkBool32(dec, &val->uniformTexelBufferOffsetSingleTexelAlignment);
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial(const VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->storageTexelBufferOffsetAlignmentBytes */
    /* skip val->storageTexelBufferOffsetSingleTexelAlignment */
    /* skip val->uniformTexelBufferOffsetAlignmentBytes */
    /* skip val->uniformTexelBufferOffsetSingleTexelAlignment */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_partial(const VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageTexelBufferOffsetAlignmentBytes */
    /* skip val->storageTexelBufferOffsetSingleTexelAlignment */
    /* skip val->uniformTexelBufferOffsetAlignmentBytes */
    /* skip val->uniformTexelBufferOffsetSingleTexelAlignment */
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES });
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceSubgroupSizeControlProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_self(const VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->minSubgroupSize);
    size += vn_sizeof_uint32_t(&val->maxSubgroupSize);
    size += vn_sizeof_uint32_t(&val->maxComputeWorkgroupSubgroups);
    size += vn_sizeof_VkFlags(&val->requiredSubgroupSizeStages);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties(const VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->minSubgroupSize);
    vn_decode_uint32_t(dec, &val->maxSubgroupSize);
    vn_decode_uint32_t(dec, &val->maxComputeWorkgroupSubgroups);
    vn_decode_VkFlags(dec, &val->requiredSubgroupSizeStages);
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial(const VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->minSubgroupSize */
    /* skip val->maxSubgroupSize */
    /* skip val->maxComputeWorkgroupSubgroups */
    /* skip val->requiredSubgroupSizeStages */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_partial(const VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->minSubgroupSize */
    /* skip val->maxSubgroupSize */
    /* skip val->maxComputeWorkgroupSubgroups */
    /* skip val->requiredSubgroupSizeStages */
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES });
    vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVulkan11Properties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Properties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Properties_self(const VkPhysicalDeviceVulkan11Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_array_size(VK_UUID_SIZE);
    size += vn_sizeof_uint8_t_array(val->deviceUUID, VK_UUID_SIZE);
    size += vn_sizeof_array_size(VK_UUID_SIZE);
    size += vn_sizeof_uint8_t_array(val->driverUUID, VK_UUID_SIZE);
    size += vn_sizeof_array_size(VK_LUID_SIZE);
    size += vn_sizeof_uint8_t_array(val->deviceLUID, VK_LUID_SIZE);
    size += vn_sizeof_uint32_t(&val->deviceNodeMask);
    size += vn_sizeof_VkBool32(&val->deviceLUIDValid);
    size += vn_sizeof_uint32_t(&val->subgroupSize);
    size += vn_sizeof_VkFlags(&val->subgroupSupportedStages);
    size += vn_sizeof_VkFlags(&val->subgroupSupportedOperations);
    size += vn_sizeof_VkBool32(&val->subgroupQuadOperationsInAllStages);
    size += vn_sizeof_VkPointClippingBehavior(&val->pointClippingBehavior);
    size += vn_sizeof_uint32_t(&val->maxMultiviewViewCount);
    size += vn_sizeof_uint32_t(&val->maxMultiviewInstanceIndex);
    size += vn_sizeof_VkBool32(&val->protectedNoFault);
    size += vn_sizeof_uint32_t(&val->maxPerSetDescriptors);
    size += vn_sizeof_VkDeviceSize(&val->maxMemoryAllocationSize);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Properties(const VkPhysicalDeviceVulkan11Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan11Properties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan11Properties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Properties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Properties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Properties *val)
{
    /* skip val->{sType,pNext} */
    {
        const size_t array_size = vn_decode_array_size(dec, VK_UUID_SIZE);
        vn_decode_uint8_t_array(dec, val->deviceUUID, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_UUID_SIZE);
        vn_decode_uint8_t_array(dec, val->driverUUID, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_LUID_SIZE);
        vn_decode_uint8_t_array(dec, val->deviceLUID, array_size);
    }
    vn_decode_uint32_t(dec, &val->deviceNodeMask);
    vn_decode_VkBool32(dec, &val->deviceLUIDValid);
    vn_decode_uint32_t(dec, &val->subgroupSize);
    vn_decode_VkFlags(dec, &val->subgroupSupportedStages);
    vn_decode_VkFlags(dec, &val->subgroupSupportedOperations);
    vn_decode_VkBool32(dec, &val->subgroupQuadOperationsInAllStages);
    vn_decode_VkPointClippingBehavior(dec, &val->pointClippingBehavior);
    vn_decode_uint32_t(dec, &val->maxMultiviewViewCount);
    vn_decode_uint32_t(dec, &val->maxMultiviewInstanceIndex);
    vn_decode_VkBool32(dec, &val->protectedNoFault);
    vn_decode_uint32_t(dec, &val->maxPerSetDescriptors);
    vn_decode_VkDeviceSize(dec, &val->maxMemoryAllocationSize);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Properties(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVulkan11Properties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVulkan11Properties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Properties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Properties_self_partial(const VkPhysicalDeviceVulkan11Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->deviceUUID */
    /* skip val->driverUUID */
    /* skip val->deviceLUID */
    /* skip val->deviceNodeMask */
    /* skip val->deviceLUIDValid */
    /* skip val->subgroupSize */
    /* skip val->subgroupSupportedStages */
    /* skip val->subgroupSupportedOperations */
    /* skip val->subgroupQuadOperationsInAllStages */
    /* skip val->pointClippingBehavior */
    /* skip val->maxMultiviewViewCount */
    /* skip val->maxMultiviewInstanceIndex */
    /* skip val->protectedNoFault */
    /* skip val->maxPerSetDescriptors */
    /* skip val->maxMemoryAllocationSize */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Properties_partial(const VkPhysicalDeviceVulkan11Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan11Properties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan11Properties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Properties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Properties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->deviceUUID */
    /* skip val->driverUUID */
    /* skip val->deviceLUID */
    /* skip val->deviceNodeMask */
    /* skip val->deviceLUIDValid */
    /* skip val->subgroupSize */
    /* skip val->subgroupSupportedStages */
    /* skip val->subgroupSupportedOperations */
    /* skip val->subgroupQuadOperationsInAllStages */
    /* skip val->pointClippingBehavior */
    /* skip val->maxMultiviewViewCount */
    /* skip val->maxMultiviewInstanceIndex */
    /* skip val->protectedNoFault */
    /* skip val->maxPerSetDescriptors */
    /* skip val->maxMemoryAllocationSize */
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Properties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES });
    vn_encode_VkPhysicalDeviceVulkan11Properties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan11Properties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVulkan12Properties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Properties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Properties_self(const VkPhysicalDeviceVulkan12Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDriverId(&val->driverID);
    size += vn_sizeof_array_size(VK_MAX_DRIVER_NAME_SIZE);
    size += vn_sizeof_char_array(val->driverName, VK_MAX_DRIVER_NAME_SIZE);
    size += vn_sizeof_array_size(VK_MAX_DRIVER_INFO_SIZE);
    size += vn_sizeof_char_array(val->driverInfo, VK_MAX_DRIVER_INFO_SIZE);
    size += vn_sizeof_VkConformanceVersion(&val->conformanceVersion);
    size += vn_sizeof_VkShaderFloatControlsIndependence(&val->denormBehaviorIndependence);
    size += vn_sizeof_VkShaderFloatControlsIndependence(&val->roundingModeIndependence);
    size += vn_sizeof_VkBool32(&val->shaderSignedZeroInfNanPreserveFloat16);
    size += vn_sizeof_VkBool32(&val->shaderSignedZeroInfNanPreserveFloat32);
    size += vn_sizeof_VkBool32(&val->shaderSignedZeroInfNanPreserveFloat64);
    size += vn_sizeof_VkBool32(&val->shaderDenormPreserveFloat16);
    size += vn_sizeof_VkBool32(&val->shaderDenormPreserveFloat32);
    size += vn_sizeof_VkBool32(&val->shaderDenormPreserveFloat64);
    size += vn_sizeof_VkBool32(&val->shaderDenormFlushToZeroFloat16);
    size += vn_sizeof_VkBool32(&val->shaderDenormFlushToZeroFloat32);
    size += vn_sizeof_VkBool32(&val->shaderDenormFlushToZeroFloat64);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTEFloat16);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTEFloat32);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTEFloat64);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTZFloat16);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTZFloat32);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTZFloat64);
    size += vn_sizeof_uint32_t(&val->maxUpdateAfterBindDescriptorsInAllPools);
    size += vn_sizeof_VkBool32(&val->shaderUniformBufferArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->shaderSampledImageArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->shaderStorageBufferArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->shaderInputAttachmentArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->robustBufferAccessUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->quadDivergentImplicitLod);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindSamplers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindUniformBuffers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindStorageBuffers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindSampledImages);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindStorageImages);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindInputAttachments);
    size += vn_sizeof_uint32_t(&val->maxPerStageUpdateAfterBindResources);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindSamplers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindUniformBuffers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindStorageBuffers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindSampledImages);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindStorageImages);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindInputAttachments);
    size += vn_sizeof_VkFlags(&val->supportedDepthResolveModes);
    size += vn_sizeof_VkFlags(&val->supportedStencilResolveModes);
    size += vn_sizeof_VkBool32(&val->independentResolveNone);
    size += vn_sizeof_VkBool32(&val->independentResolve);
    size += vn_sizeof_VkBool32(&val->filterMinmaxSingleComponentFormats);
    size += vn_sizeof_VkBool32(&val->filterMinmaxImageComponentMapping);
    size += vn_sizeof_uint64_t(&val->maxTimelineSemaphoreValueDifference);
    size += vn_sizeof_VkFlags(&val->framebufferIntegerColorSampleCounts);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Properties(const VkPhysicalDeviceVulkan12Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan12Properties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan12Properties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Properties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Properties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkDriverId(dec, &val->driverID);
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_DRIVER_NAME_SIZE);
        vn_decode_char_array(dec, val->driverName, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_DRIVER_INFO_SIZE);
        vn_decode_char_array(dec, val->driverInfo, array_size);
    }
    vn_decode_VkConformanceVersion(dec, &val->conformanceVersion);
    vn_decode_VkShaderFloatControlsIndependence(dec, &val->denormBehaviorIndependence);
    vn_decode_VkShaderFloatControlsIndependence(dec, &val->roundingModeIndependence);
    vn_decode_VkBool32(dec, &val->shaderSignedZeroInfNanPreserveFloat16);
    vn_decode_VkBool32(dec, &val->shaderSignedZeroInfNanPreserveFloat32);
    vn_decode_VkBool32(dec, &val->shaderSignedZeroInfNanPreserveFloat64);
    vn_decode_VkBool32(dec, &val->shaderDenormPreserveFloat16);
    vn_decode_VkBool32(dec, &val->shaderDenormPreserveFloat32);
    vn_decode_VkBool32(dec, &val->shaderDenormPreserveFloat64);
    vn_decode_VkBool32(dec, &val->shaderDenormFlushToZeroFloat16);
    vn_decode_VkBool32(dec, &val->shaderDenormFlushToZeroFloat32);
    vn_decode_VkBool32(dec, &val->shaderDenormFlushToZeroFloat64);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTEFloat16);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTEFloat32);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTEFloat64);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTZFloat16);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTZFloat32);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTZFloat64);
    vn_decode_uint32_t(dec, &val->maxUpdateAfterBindDescriptorsInAllPools);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->robustBufferAccessUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->quadDivergentImplicitLod);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindSamplers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindUniformBuffers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindStorageBuffers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindSampledImages);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindStorageImages);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindInputAttachments);
    vn_decode_uint32_t(dec, &val->maxPerStageUpdateAfterBindResources);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindSamplers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindUniformBuffers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindStorageBuffers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindSampledImages);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindStorageImages);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindInputAttachments);
    vn_decode_VkFlags(dec, &val->supportedDepthResolveModes);
    vn_decode_VkFlags(dec, &val->supportedStencilResolveModes);
    vn_decode_VkBool32(dec, &val->independentResolveNone);
    vn_decode_VkBool32(dec, &val->independentResolve);
    vn_decode_VkBool32(dec, &val->filterMinmaxSingleComponentFormats);
    vn_decode_VkBool32(dec, &val->filterMinmaxImageComponentMapping);
    vn_decode_uint64_t(dec, &val->maxTimelineSemaphoreValueDifference);
    vn_decode_VkFlags(dec, &val->framebufferIntegerColorSampleCounts);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Properties(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVulkan12Properties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVulkan12Properties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Properties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Properties_self_partial(const VkPhysicalDeviceVulkan12Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->driverID */
    /* skip val->driverName */
    /* skip val->driverInfo */
    size += vn_sizeof_VkConformanceVersion_partial(&val->conformanceVersion);
    /* skip val->denormBehaviorIndependence */
    /* skip val->roundingModeIndependence */
    /* skip val->shaderSignedZeroInfNanPreserveFloat16 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat32 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat64 */
    /* skip val->shaderDenormPreserveFloat16 */
    /* skip val->shaderDenormPreserveFloat32 */
    /* skip val->shaderDenormPreserveFloat64 */
    /* skip val->shaderDenormFlushToZeroFloat16 */
    /* skip val->shaderDenormFlushToZeroFloat32 */
    /* skip val->shaderDenormFlushToZeroFloat64 */
    /* skip val->shaderRoundingModeRTEFloat16 */
    /* skip val->shaderRoundingModeRTEFloat32 */
    /* skip val->shaderRoundingModeRTEFloat64 */
    /* skip val->shaderRoundingModeRTZFloat16 */
    /* skip val->shaderRoundingModeRTZFloat32 */
    /* skip val->shaderRoundingModeRTZFloat64 */
    /* skip val->maxUpdateAfterBindDescriptorsInAllPools */
    /* skip val->shaderUniformBufferArrayNonUniformIndexingNative */
    /* skip val->shaderSampledImageArrayNonUniformIndexingNative */
    /* skip val->shaderStorageBufferArrayNonUniformIndexingNative */
    /* skip val->shaderStorageImageArrayNonUniformIndexingNative */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexingNative */
    /* skip val->robustBufferAccessUpdateAfterBind */
    /* skip val->quadDivergentImplicitLod */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSamplers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindUniformBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSampledImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInputAttachments */
    /* skip val->maxPerStageUpdateAfterBindResources */
    /* skip val->maxDescriptorSetUpdateAfterBindSamplers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindSampledImages */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageImages */
    /* skip val->maxDescriptorSetUpdateAfterBindInputAttachments */
    /* skip val->supportedDepthResolveModes */
    /* skip val->supportedStencilResolveModes */
    /* skip val->independentResolveNone */
    /* skip val->independentResolve */
    /* skip val->filterMinmaxSingleComponentFormats */
    /* skip val->filterMinmaxImageComponentMapping */
    /* skip val->maxTimelineSemaphoreValueDifference */
    /* skip val->framebufferIntegerColorSampleCounts */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Properties_partial(const VkPhysicalDeviceVulkan12Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan12Properties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan12Properties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Properties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Properties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->driverID */
    /* skip val->driverName */
    /* skip val->driverInfo */
    vn_encode_VkConformanceVersion_partial(enc, &val->conformanceVersion);
    /* skip val->denormBehaviorIndependence */
    /* skip val->roundingModeIndependence */
    /* skip val->shaderSignedZeroInfNanPreserveFloat16 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat32 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat64 */
    /* skip val->shaderDenormPreserveFloat16 */
    /* skip val->shaderDenormPreserveFloat32 */
    /* skip val->shaderDenormPreserveFloat64 */
    /* skip val->shaderDenormFlushToZeroFloat16 */
    /* skip val->shaderDenormFlushToZeroFloat32 */
    /* skip val->shaderDenormFlushToZeroFloat64 */
    /* skip val->shaderRoundingModeRTEFloat16 */
    /* skip val->shaderRoundingModeRTEFloat32 */
    /* skip val->shaderRoundingModeRTEFloat64 */
    /* skip val->shaderRoundingModeRTZFloat16 */
    /* skip val->shaderRoundingModeRTZFloat32 */
    /* skip val->shaderRoundingModeRTZFloat64 */
    /* skip val->maxUpdateAfterBindDescriptorsInAllPools */
    /* skip val->shaderUniformBufferArrayNonUniformIndexingNative */
    /* skip val->shaderSampledImageArrayNonUniformIndexingNative */
    /* skip val->shaderStorageBufferArrayNonUniformIndexingNative */
    /* skip val->shaderStorageImageArrayNonUniformIndexingNative */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexingNative */
    /* skip val->robustBufferAccessUpdateAfterBind */
    /* skip val->quadDivergentImplicitLod */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSamplers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindUniformBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSampledImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInputAttachments */
    /* skip val->maxPerStageUpdateAfterBindResources */
    /* skip val->maxDescriptorSetUpdateAfterBindSamplers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindSampledImages */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageImages */
    /* skip val->maxDescriptorSetUpdateAfterBindInputAttachments */
    /* skip val->supportedDepthResolveModes */
    /* skip val->supportedStencilResolveModes */
    /* skip val->independentResolveNone */
    /* skip val->independentResolve */
    /* skip val->filterMinmaxSingleComponentFormats */
    /* skip val->filterMinmaxImageComponentMapping */
    /* skip val->maxTimelineSemaphoreValueDifference */
    /* skip val->framebufferIntegerColorSampleCounts */
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Properties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES });
    vn_encode_VkPhysicalDeviceVulkan12Properties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan12Properties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVulkan13Properties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Properties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Properties_self(const VkPhysicalDeviceVulkan13Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->minSubgroupSize);
    size += vn_sizeof_uint32_t(&val->maxSubgroupSize);
    size += vn_sizeof_uint32_t(&val->maxComputeWorkgroupSubgroups);
    size += vn_sizeof_VkFlags(&val->requiredSubgroupSizeStages);
    size += vn_sizeof_uint32_t(&val->maxInlineUniformBlockSize);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorInlineUniformBlocks);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetInlineUniformBlocks);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks);
    size += vn_sizeof_uint32_t(&val->maxInlineUniformTotalSize);
    size += vn_sizeof_VkBool32(&val->integerDotProduct8BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct8BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct8BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct4x8BitPackedUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct4x8BitPackedSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct4x8BitPackedMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct16BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct16BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct16BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct32BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct32BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct32BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct64BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct64BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct64BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating8BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating16BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating32BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating64BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated);
    size += vn_sizeof_VkDeviceSize(&val->storageTexelBufferOffsetAlignmentBytes);
    size += vn_sizeof_VkBool32(&val->storageTexelBufferOffsetSingleTexelAlignment);
    size += vn_sizeof_VkDeviceSize(&val->uniformTexelBufferOffsetAlignmentBytes);
    size += vn_sizeof_VkBool32(&val->uniformTexelBufferOffsetSingleTexelAlignment);
    size += vn_sizeof_VkDeviceSize(&val->maxBufferSize);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Properties(const VkPhysicalDeviceVulkan13Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan13Properties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan13Properties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Properties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Properties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->minSubgroupSize);
    vn_decode_uint32_t(dec, &val->maxSubgroupSize);
    vn_decode_uint32_t(dec, &val->maxComputeWorkgroupSubgroups);
    vn_decode_VkFlags(dec, &val->requiredSubgroupSizeStages);
    vn_decode_uint32_t(dec, &val->maxInlineUniformBlockSize);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorInlineUniformBlocks);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetInlineUniformBlocks);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks);
    vn_decode_uint32_t(dec, &val->maxInlineUniformTotalSize);
    vn_decode_VkBool32(dec, &val->integerDotProduct8BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct8BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct8BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct4x8BitPackedUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct4x8BitPackedSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct4x8BitPackedMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct16BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct16BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct16BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct32BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct32BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct32BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct64BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct64BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct64BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating8BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating16BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating32BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating64BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated);
    vn_decode_VkDeviceSize(dec, &val->storageTexelBufferOffsetAlignmentBytes);
    vn_decode_VkBool32(dec, &val->storageTexelBufferOffsetSingleTexelAlignment);
    vn_decode_VkDeviceSize(dec, &val->uniformTexelBufferOffsetAlignmentBytes);
    vn_decode_VkBool32(dec, &val->uniformTexelBufferOffsetSingleTexelAlignment);
    vn_decode_VkDeviceSize(dec, &val->maxBufferSize);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Properties(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVulkan13Properties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVulkan13Properties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Properties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Properties_self_partial(const VkPhysicalDeviceVulkan13Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->minSubgroupSize */
    /* skip val->maxSubgroupSize */
    /* skip val->maxComputeWorkgroupSubgroups */
    /* skip val->requiredSubgroupSizeStages */
    /* skip val->maxInlineUniformBlockSize */
    /* skip val->maxPerStageDescriptorInlineUniformBlocks */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxDescriptorSetInlineUniformBlocks */
    /* skip val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxInlineUniformTotalSize */
    /* skip val->integerDotProduct8BitUnsignedAccelerated */
    /* skip val->integerDotProduct8BitSignedAccelerated */
    /* skip val->integerDotProduct8BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProduct16BitUnsignedAccelerated */
    /* skip val->integerDotProduct16BitSignedAccelerated */
    /* skip val->integerDotProduct16BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct32BitUnsignedAccelerated */
    /* skip val->integerDotProduct32BitSignedAccelerated */
    /* skip val->integerDotProduct32BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct64BitUnsignedAccelerated */
    /* skip val->integerDotProduct64BitSignedAccelerated */
    /* skip val->integerDotProduct64BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated */
    /* skip val->storageTexelBufferOffsetAlignmentBytes */
    /* skip val->storageTexelBufferOffsetSingleTexelAlignment */
    /* skip val->uniformTexelBufferOffsetAlignmentBytes */
    /* skip val->uniformTexelBufferOffsetSingleTexelAlignment */
    /* skip val->maxBufferSize */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Properties_partial(const VkPhysicalDeviceVulkan13Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan13Properties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan13Properties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Properties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Properties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->minSubgroupSize */
    /* skip val->maxSubgroupSize */
    /* skip val->maxComputeWorkgroupSubgroups */
    /* skip val->requiredSubgroupSizeStages */
    /* skip val->maxInlineUniformBlockSize */
    /* skip val->maxPerStageDescriptorInlineUniformBlocks */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxDescriptorSetInlineUniformBlocks */
    /* skip val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxInlineUniformTotalSize */
    /* skip val->integerDotProduct8BitUnsignedAccelerated */
    /* skip val->integerDotProduct8BitSignedAccelerated */
    /* skip val->integerDotProduct8BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProduct16BitUnsignedAccelerated */
    /* skip val->integerDotProduct16BitSignedAccelerated */
    /* skip val->integerDotProduct16BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct32BitUnsignedAccelerated */
    /* skip val->integerDotProduct32BitSignedAccelerated */
    /* skip val->integerDotProduct32BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct64BitUnsignedAccelerated */
    /* skip val->integerDotProduct64BitSignedAccelerated */
    /* skip val->integerDotProduct64BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated */
    /* skip val->storageTexelBufferOffsetAlignmentBytes */
    /* skip val->storageTexelBufferOffsetSingleTexelAlignment */
    /* skip val->uniformTexelBufferOffsetAlignmentBytes */
    /* skip val->uniformTexelBufferOffsetSingleTexelAlignment */
    /* skip val->maxBufferSize */
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Properties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES });
    vn_encode_VkPhysicalDeviceVulkan13Properties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan13Properties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderIntegerDotProductProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_self(const VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->integerDotProduct8BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct8BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct8BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct4x8BitPackedUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct4x8BitPackedSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct4x8BitPackedMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct16BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct16BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct16BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct32BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct32BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct32BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct64BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct64BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct64BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating8BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating16BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating32BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating64BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties(const VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->integerDotProduct8BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct8BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct8BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct4x8BitPackedUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct4x8BitPackedSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct4x8BitPackedMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct16BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct16BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct16BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct32BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct32BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct32BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct64BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct64BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct64BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating8BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating16BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating32BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating64BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated);
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial(const VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->integerDotProduct8BitUnsignedAccelerated */
    /* skip val->integerDotProduct8BitSignedAccelerated */
    /* skip val->integerDotProduct8BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProduct16BitUnsignedAccelerated */
    /* skip val->integerDotProduct16BitSignedAccelerated */
    /* skip val->integerDotProduct16BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct32BitUnsignedAccelerated */
    /* skip val->integerDotProduct32BitSignedAccelerated */
    /* skip val->integerDotProduct32BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct64BitUnsignedAccelerated */
    /* skip val->integerDotProduct64BitSignedAccelerated */
    /* skip val->integerDotProduct64BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_partial(const VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->integerDotProduct8BitUnsignedAccelerated */
    /* skip val->integerDotProduct8BitSignedAccelerated */
    /* skip val->integerDotProduct8BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProduct16BitUnsignedAccelerated */
    /* skip val->integerDotProduct16BitSignedAccelerated */
    /* skip val->integerDotProduct16BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct32BitUnsignedAccelerated */
    /* skip val->integerDotProduct32BitSignedAccelerated */
    /* skip val->integerDotProduct32BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct64BitUnsignedAccelerated */
    /* skip val->integerDotProduct64BitSignedAccelerated */
    /* skip val->integerDotProduct64BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated */
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES });
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceProperties2 chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceProperties2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDriverProperties_self((const VkPhysicalDeviceDriverProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceIDProperties_self((const VkPhysicalDeviceIDProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMultiviewProperties_self((const VkPhysicalDeviceMultiviewProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSubgroupProperties_self((const VkPhysicalDeviceSubgroupProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePointClippingProperties_self((const VkPhysicalDevicePointClippingProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_self((const VkPhysicalDeviceProtectedMemoryProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_self((const VkPhysicalDeviceSamplerFilterMinmaxProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_self((const VkPhysicalDeviceInlineUniformBlockProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMaintenance3Properties_self((const VkPhysicalDeviceMaintenance3Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMaintenance4Properties_self((const VkPhysicalDeviceMaintenance4Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceFloatControlsProperties_self((const VkPhysicalDeviceFloatControlsProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_self((const VkPhysicalDeviceDescriptorIndexingProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_self((const VkPhysicalDeviceTimelineSemaphoreProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_self((const VkPhysicalDeviceDepthStencilResolveProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self((const VkPhysicalDeviceTransformFeedbackPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_self((const VkPhysicalDeviceTexelBufferAlignmentProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_self((const VkPhysicalDeviceSubgroupSizeControlProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan11Properties_self((const VkPhysicalDeviceVulkan11Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan12Properties_self((const VkPhysicalDeviceVulkan12Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan13Properties_self((const VkPhysicalDeviceVulkan13Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_self((const VkPhysicalDeviceShaderIntegerDotProductProperties *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProperties2_self(const VkPhysicalDeviceProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkPhysicalDeviceProperties(&val->properties);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProperties2(const VkPhysicalDeviceProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceProperties2_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceProperties2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    VkBaseOutStructure *pnext = (VkBaseOutStructure *)val;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return;

    vn_decode_VkStructureType(dec, &stype);
    while (true) {
        assert(pnext);
        if (pnext->sType == stype)
            break;
    }

    switch ((int32_t)pnext->sType) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceDriverProperties_self(dec, (VkPhysicalDeviceDriverProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceIDProperties_self(dec, (VkPhysicalDeviceIDProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceMultiviewProperties_self(dec, (VkPhysicalDeviceMultiviewProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceSubgroupProperties_self(dec, (VkPhysicalDeviceSubgroupProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDevicePointClippingProperties_self(dec, (VkPhysicalDevicePointClippingProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceProtectedMemoryProperties_self(dec, (VkPhysicalDeviceProtectedMemoryProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(dec, (VkPhysicalDeviceSamplerFilterMinmaxProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_self(dec, (VkPhysicalDeviceInlineUniformBlockProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceMaintenance3Properties_self(dec, (VkPhysicalDeviceMaintenance3Properties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceMaintenance4Properties_self(dec, (VkPhysicalDeviceMaintenance4Properties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceFloatControlsProperties_self(dec, (VkPhysicalDeviceFloatControlsProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_self(dec, (VkPhysicalDeviceDescriptorIndexingProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_self(dec, (VkPhysicalDeviceTimelineSemaphoreProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_self(dec, (VkPhysicalDeviceDepthStencilResolveProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(dec, (VkPhysicalDeviceTransformFeedbackPropertiesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_self(dec, (VkPhysicalDeviceTexelBufferAlignmentProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_self(dec, (VkPhysicalDeviceSubgroupSizeControlProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVulkan11Properties_self(dec, (VkPhysicalDeviceVulkan11Properties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVulkan12Properties_self(dec, (VkPhysicalDeviceVulkan12Properties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVulkan13Properties_self(dec, (VkPhysicalDeviceVulkan13Properties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_self(dec, (VkPhysicalDeviceShaderIntegerDotProductProperties *)pnext);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_decode_VkPhysicalDeviceProperties2_self(struct vn_cs_decoder *dec, VkPhysicalDeviceProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPhysicalDeviceProperties(dec, &val->properties);
}

static inline void
vn_decode_VkPhysicalDeviceProperties2(struct vn_cs_decoder *dec, VkPhysicalDeviceProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceProperties2_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceProperties2_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDriverProperties_self_partial((const VkPhysicalDeviceDriverProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceIDProperties_self_partial((const VkPhysicalDeviceIDProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMultiviewProperties_self_partial((const VkPhysicalDeviceMultiviewProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSubgroupProperties_self_partial((const VkPhysicalDeviceSubgroupProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePointClippingProperties_self_partial((const VkPhysicalDevicePointClippingProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_self_partial((const VkPhysicalDeviceProtectedMemoryProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial((const VkPhysicalDeviceSamplerFilterMinmaxProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_self_partial((const VkPhysicalDeviceInlineUniformBlockProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMaintenance3Properties_self_partial((const VkPhysicalDeviceMaintenance3Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMaintenance4Properties_self_partial((const VkPhysicalDeviceMaintenance4Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceFloatControlsProperties_self_partial((const VkPhysicalDeviceFloatControlsProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_self_partial((const VkPhysicalDeviceDescriptorIndexingProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial((const VkPhysicalDeviceTimelineSemaphoreProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_self_partial((const VkPhysicalDeviceDepthStencilResolveProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial((const VkPhysicalDeviceTransformFeedbackPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial((const VkPhysicalDeviceTexelBufferAlignmentProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial((const VkPhysicalDeviceSubgroupSizeControlProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan11Properties_self_partial((const VkPhysicalDeviceVulkan11Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan12Properties_self_partial((const VkPhysicalDeviceVulkan12Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan13Properties_self_partial((const VkPhysicalDeviceVulkan13Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial((const VkPhysicalDeviceShaderIntegerDotProductProperties *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProperties2_self_partial(const VkPhysicalDeviceProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkPhysicalDeviceProperties_partial(&val->properties);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProperties2_partial(const VkPhysicalDeviceProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceProperties2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceProperties2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDriverProperties_self_partial(enc, (const VkPhysicalDeviceDriverProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceIDProperties_self_partial(enc, (const VkPhysicalDeviceIDProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiviewProperties_self_partial(enc, (const VkPhysicalDeviceMultiviewProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupProperties_self_partial(enc, (const VkPhysicalDeviceSubgroupProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePointClippingProperties_self_partial(enc, (const VkPhysicalDevicePointClippingProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProtectedMemoryProperties_self_partial(enc, (const VkPhysicalDeviceProtectedMemoryProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial(enc, (const VkPhysicalDeviceSamplerFilterMinmaxProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_self_partial(enc, (const VkPhysicalDeviceInlineUniformBlockProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance3Properties_self_partial(enc, (const VkPhysicalDeviceMaintenance3Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance4Properties_self_partial(enc, (const VkPhysicalDeviceMaintenance4Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceFloatControlsProperties_self_partial(enc, (const VkPhysicalDeviceFloatControlsProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_self_partial(enc, (const VkPhysicalDeviceDescriptorIndexingProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial(enc, (const VkPhysicalDeviceTimelineSemaphoreProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_self_partial(enc, (const VkPhysicalDeviceDepthStencilResolveProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial(enc, (const VkPhysicalDeviceTransformFeedbackPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial(enc, (const VkPhysicalDeviceTexelBufferAlignmentProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial(enc, (const VkPhysicalDeviceSubgroupSizeControlProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan11Properties_self_partial(enc, (const VkPhysicalDeviceVulkan11Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan12Properties_self_partial(enc, (const VkPhysicalDeviceVulkan12Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan13Properties_self_partial(enc, (const VkPhysicalDeviceVulkan13Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial(enc, (const VkPhysicalDeviceShaderIntegerDotProductProperties *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProperties2_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPhysicalDeviceProperties_partial(enc, &val->properties);
}

static inline void
vn_encode_VkPhysicalDeviceProperties2_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2 });
    vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProperties2_self_partial(enc, val);
}

/* struct VkDrmFormatModifierPropertiesEXT */

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesEXT(const VkDrmFormatModifierPropertiesEXT *val)
{
    size_t size = 0;
    size += vn_sizeof_uint64_t(&val->drmFormatModifier);
    size += vn_sizeof_uint32_t(&val->drmFormatModifierPlaneCount);
    size += vn_sizeof_VkFlags(&val->drmFormatModifierTilingFeatures);
    return size;
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesEXT(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesEXT *val)
{
    vn_decode_uint64_t(dec, &val->drmFormatModifier);
    vn_decode_uint32_t(dec, &val->drmFormatModifierPlaneCount);
    vn_decode_VkFlags(dec, &val->drmFormatModifierTilingFeatures);
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesEXT_partial(const VkDrmFormatModifierPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->drmFormatModifier */
    /* skip val->drmFormatModifierPlaneCount */
    /* skip val->drmFormatModifierTilingFeatures */
    return size;
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesEXT_partial(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesEXT *val)
{
    /* skip val->drmFormatModifier */
    /* skip val->drmFormatModifierPlaneCount */
    /* skip val->drmFormatModifierTilingFeatures */
}

/* struct VkDrmFormatModifierPropertiesListEXT chain */

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesListEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesListEXT_self(const VkDrmFormatModifierPropertiesListEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->drmFormatModifierCount);
    if (val->pDrmFormatModifierProperties) {
        size += vn_sizeof_array_size(val->drmFormatModifierCount);
        for (uint32_t i = 0; i < val->drmFormatModifierCount; i++)
            size += vn_sizeof_VkDrmFormatModifierPropertiesEXT(&val->pDrmFormatModifierProperties[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesListEXT(const VkDrmFormatModifierPropertiesListEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDrmFormatModifierPropertiesListEXT_pnext(val->pNext);
    size += vn_sizeof_VkDrmFormatModifierPropertiesListEXT_self(val);

    return size;
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesListEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesListEXT_self(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesListEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->drmFormatModifierCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->drmFormatModifierCount);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkDrmFormatModifierPropertiesEXT(dec, &val->pDrmFormatModifierProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pDrmFormatModifierProperties = NULL;
    }
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesListEXT(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesListEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT);

    assert(val->sType == stype);
    vn_decode_VkDrmFormatModifierPropertiesListEXT_pnext(dec, val->pNext);
    vn_decode_VkDrmFormatModifierPropertiesListEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesListEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesListEXT_self_partial(const VkDrmFormatModifierPropertiesListEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* WA1: size += vn_sizeof_uint32_t(&val->drmFormatModifierCount) */(void)0;
    if (val->pDrmFormatModifierProperties) {
        size += vn_sizeof_array_size(val->drmFormatModifierCount);
        for (uint32_t i = 0; i < val->drmFormatModifierCount; i++)
            size += vn_sizeof_VkDrmFormatModifierPropertiesEXT_partial(&val->pDrmFormatModifierProperties[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesListEXT_partial(const VkDrmFormatModifierPropertiesListEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDrmFormatModifierPropertiesListEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkDrmFormatModifierPropertiesListEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesListEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesListEXT_self_partial(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesListEXT *val)
{
    /* skip val->{sType,pNext} */
    /* WA1: vn_encode_uint32_t(enc, &val->drmFormatModifierCount) */(void)0;
    if (val->pDrmFormatModifierProperties) {
        vn_encode_array_size(enc, val->drmFormatModifierCount);
        for (uint32_t i = 0; i < val->drmFormatModifierCount; i++)
            vn_encode_VkDrmFormatModifierPropertiesEXT_partial(enc, &val->pDrmFormatModifierProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesListEXT_partial(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesListEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT });
    vn_encode_VkDrmFormatModifierPropertiesListEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkDrmFormatModifierPropertiesListEXT_self_partial(enc, val);
}

/* struct VkFormatProperties3 chain */

static inline size_t
vn_sizeof_VkFormatProperties3_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkFormatProperties3_self(const VkFormatProperties3 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags64(&val->linearTilingFeatures);
    size += vn_sizeof_VkFlags64(&val->optimalTilingFeatures);
    size += vn_sizeof_VkFlags64(&val->bufferFeatures);
    return size;
}

static inline size_t
vn_sizeof_VkFormatProperties3(const VkFormatProperties3 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkFormatProperties3_pnext(val->pNext);
    size += vn_sizeof_VkFormatProperties3_self(val);

    return size;
}

static inline void
vn_decode_VkFormatProperties3_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkFormatProperties3_self(struct vn_cs_decoder *dec, VkFormatProperties3 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags64(dec, &val->linearTilingFeatures);
    vn_decode_VkFlags64(dec, &val->optimalTilingFeatures);
    vn_decode_VkFlags64(dec, &val->bufferFeatures);
}

static inline void
vn_decode_VkFormatProperties3(struct vn_cs_decoder *dec, VkFormatProperties3 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3);

    assert(val->sType == stype);
    vn_decode_VkFormatProperties3_pnext(dec, val->pNext);
    vn_decode_VkFormatProperties3_self(dec, val);
}

static inline size_t
vn_sizeof_VkFormatProperties3_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkFormatProperties3_self_partial(const VkFormatProperties3 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->linearTilingFeatures */
    /* skip val->optimalTilingFeatures */
    /* skip val->bufferFeatures */
    return size;
}

static inline size_t
vn_sizeof_VkFormatProperties3_partial(const VkFormatProperties3 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkFormatProperties3_pnext_partial(val->pNext);
    size += vn_sizeof_VkFormatProperties3_self_partial(val);

    return size;
}

static inline void
vn_encode_VkFormatProperties3_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkFormatProperties3_self_partial(struct vn_cs_encoder *enc, const VkFormatProperties3 *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->linearTilingFeatures */
    /* skip val->optimalTilingFeatures */
    /* skip val->bufferFeatures */
}

static inline void
vn_encode_VkFormatProperties3_partial(struct vn_cs_encoder *enc, const VkFormatProperties3 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3 });
    vn_encode_VkFormatProperties3_pnext_partial(enc, val->pNext);
    vn_encode_VkFormatProperties3_self_partial(enc, val);
}

/* struct VkDrmFormatModifierProperties2EXT */

static inline size_t
vn_sizeof_VkDrmFormatModifierProperties2EXT(const VkDrmFormatModifierProperties2EXT *val)
{
    size_t size = 0;
    size += vn_sizeof_uint64_t(&val->drmFormatModifier);
    size += vn_sizeof_uint32_t(&val->drmFormatModifierPlaneCount);
    size += vn_sizeof_VkFlags64(&val->drmFormatModifierTilingFeatures);
    return size;
}

static inline void
vn_decode_VkDrmFormatModifierProperties2EXT(struct vn_cs_decoder *dec, VkDrmFormatModifierProperties2EXT *val)
{
    vn_decode_uint64_t(dec, &val->drmFormatModifier);
    vn_decode_uint32_t(dec, &val->drmFormatModifierPlaneCount);
    vn_decode_VkFlags64(dec, &val->drmFormatModifierTilingFeatures);
}

static inline size_t
vn_sizeof_VkDrmFormatModifierProperties2EXT_partial(const VkDrmFormatModifierProperties2EXT *val)
{
    size_t size = 0;
    /* skip val->drmFormatModifier */
    /* skip val->drmFormatModifierPlaneCount */
    /* skip val->drmFormatModifierTilingFeatures */
    return size;
}

static inline void
vn_encode_VkDrmFormatModifierProperties2EXT_partial(struct vn_cs_encoder *enc, const VkDrmFormatModifierProperties2EXT *val)
{
    /* skip val->drmFormatModifier */
    /* skip val->drmFormatModifierPlaneCount */
    /* skip val->drmFormatModifierTilingFeatures */
}

/* struct VkDrmFormatModifierPropertiesList2EXT chain */

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_self(const VkDrmFormatModifierPropertiesList2EXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->drmFormatModifierCount);
    if (val->pDrmFormatModifierProperties) {
        size += vn_sizeof_array_size(val->drmFormatModifierCount);
        for (uint32_t i = 0; i < val->drmFormatModifierCount; i++)
            size += vn_sizeof_VkDrmFormatModifierProperties2EXT(&val->pDrmFormatModifierProperties[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesList2EXT(const VkDrmFormatModifierPropertiesList2EXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_pnext(val->pNext);
    size += vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_self(val);

    return size;
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesList2EXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesList2EXT_self(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesList2EXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->drmFormatModifierCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->drmFormatModifierCount);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkDrmFormatModifierProperties2EXT(dec, &val->pDrmFormatModifierProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pDrmFormatModifierProperties = NULL;
    }
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesList2EXT(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesList2EXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT);

    assert(val->sType == stype);
    vn_decode_VkDrmFormatModifierPropertiesList2EXT_pnext(dec, val->pNext);
    vn_decode_VkDrmFormatModifierPropertiesList2EXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_self_partial(const VkDrmFormatModifierPropertiesList2EXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* WA1: size += vn_sizeof_uint32_t(&val->drmFormatModifierCount) */(void)0;
    if (val->pDrmFormatModifierProperties) {
        size += vn_sizeof_array_size(val->drmFormatModifierCount);
        for (uint32_t i = 0; i < val->drmFormatModifierCount; i++)
            size += vn_sizeof_VkDrmFormatModifierProperties2EXT_partial(&val->pDrmFormatModifierProperties[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_partial(const VkDrmFormatModifierPropertiesList2EXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesList2EXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesList2EXT_self_partial(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesList2EXT *val)
{
    /* skip val->{sType,pNext} */
    /* WA1: vn_encode_uint32_t(enc, &val->drmFormatModifierCount) */(void)0;
    if (val->pDrmFormatModifierProperties) {
        vn_encode_array_size(enc, val->drmFormatModifierCount);
        for (uint32_t i = 0; i < val->drmFormatModifierCount; i++)
            vn_encode_VkDrmFormatModifierProperties2EXT_partial(enc, &val->pDrmFormatModifierProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesList2EXT_partial(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesList2EXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT });
    vn_encode_VkDrmFormatModifierPropertiesList2EXT_pnext_partial(enc, val->pNext);
    vn_encode_VkDrmFormatModifierPropertiesList2EXT_self_partial(enc, val);
}

/* struct VkFormatProperties2 chain */

static inline size_t
vn_sizeof_VkFormatProperties2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkFormatProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkDrmFormatModifierPropertiesListEXT_self((const VkDrmFormatModifierPropertiesListEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkFormatProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkFormatProperties3_self((const VkFormatProperties3 *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkFormatProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_self((const VkDrmFormatModifierPropertiesList2EXT *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkFormatProperties2_self(const VkFormatProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFormatProperties(&val->formatProperties);
    return size;
}

static inline size_t
vn_sizeof_VkFormatProperties2(const VkFormatProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkFormatProperties2_pnext(val->pNext);
    size += vn_sizeof_VkFormatProperties2_self(val);

    return size;
}

static inline void
vn_decode_VkFormatProperties2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    VkBaseOutStructure *pnext = (VkBaseOutStructure *)val;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return;

    vn_decode_VkStructureType(dec, &stype);
    while (true) {
        assert(pnext);
        if (pnext->sType == stype)
            break;
    }

    switch ((int32_t)pnext->sType) {
    case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
        vn_decode_VkFormatProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkDrmFormatModifierPropertiesListEXT_self(dec, (VkDrmFormatModifierPropertiesListEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
        vn_decode_VkFormatProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkFormatProperties3_self(dec, (VkFormatProperties3 *)pnext);
        break;
    case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
        vn_decode_VkFormatProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkDrmFormatModifierPropertiesList2EXT_self(dec, (VkDrmFormatModifierPropertiesList2EXT *)pnext);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_decode_VkFormatProperties2_self(struct vn_cs_decoder *dec, VkFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFormatProperties(dec, &val->formatProperties);
}

static inline void
vn_decode_VkFormatProperties2(struct vn_cs_decoder *dec, VkFormatProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2);

    assert(val->sType == stype);
    vn_decode_VkFormatProperties2_pnext(dec, val->pNext);
    vn_decode_VkFormatProperties2_self(dec, val);
}

static inline size_t
vn_sizeof_VkFormatProperties2_pnext_partial(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkFormatProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkDrmFormatModifierPropertiesListEXT_self_partial((const VkDrmFormatModifierPropertiesListEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkFormatProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkFormatProperties3_self_partial((const VkFormatProperties3 *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkFormatProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_self_partial((const VkDrmFormatModifierPropertiesList2EXT *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkFormatProperties2_self_partial(const VkFormatProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFormatProperties_partial(&val->formatProperties);
    return size;
}

static inline size_t
vn_sizeof_VkFormatProperties2_partial(const VkFormatProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkFormatProperties2_pnext_partial(val->pNext);
    size += vn_sizeof_VkFormatProperties2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkFormatProperties2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkFormatProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkDrmFormatModifierPropertiesListEXT_self_partial(enc, (const VkDrmFormatModifierPropertiesListEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkFormatProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkFormatProperties3_self_partial(enc, (const VkFormatProperties3 *)pnext);
            return;
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkFormatProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkDrmFormatModifierPropertiesList2EXT_self_partial(enc, (const VkDrmFormatModifierPropertiesList2EXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkFormatProperties2_self_partial(struct vn_cs_encoder *enc, const VkFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFormatProperties_partial(enc, &val->formatProperties);
}

static inline void
vn_encode_VkFormatProperties2_partial(struct vn_cs_encoder *enc, const VkFormatProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2 });
    vn_encode_VkFormatProperties2_pnext_partial(enc, val->pNext);
    vn_encode_VkFormatProperties2_self_partial(enc, val);
}

/* struct VkPhysicalDeviceExternalImageFormatInfo chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalImageFormatInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalImageFormatInfo_self(const VkPhysicalDeviceExternalImageFormatInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkExternalMemoryHandleTypeFlagBits(&val->handleType);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalImageFormatInfo(const VkPhysicalDeviceExternalImageFormatInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExternalImageFormatInfo_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExternalImageFormatInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExternalImageFormatInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExternalImageFormatInfo_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExternalImageFormatInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkExternalMemoryHandleTypeFlagBits(enc, &val->handleType);
}

static inline void
vn_encode_VkPhysicalDeviceExternalImageFormatInfo(struct vn_cs_encoder *enc, const VkPhysicalDeviceExternalImageFormatInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO });
    vn_encode_VkPhysicalDeviceExternalImageFormatInfo_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExternalImageFormatInfo_self(enc, val);
}

/* struct VkPhysicalDeviceImageDrmFormatModifierInfoEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self(const VkPhysicalDeviceImageDrmFormatModifierInfoEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint64_t(&val->drmFormatModifier);
    size += vn_sizeof_VkSharingMode(&val->sharingMode);
    size += vn_sizeof_uint32_t(&val->queueFamilyIndexCount);
    if (val->pQueueFamilyIndices) {
        size += vn_sizeof_array_size(val->queueFamilyIndexCount);
        size += vn_sizeof_uint32_t_array(val->pQueueFamilyIndices, val->queueFamilyIndexCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(const VkPhysicalDeviceImageDrmFormatModifierInfoEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageDrmFormatModifierInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint64_t(enc, &val->drmFormatModifier);
    vn_encode_VkSharingMode(enc, &val->sharingMode);
    vn_encode_uint32_t(enc, &val->queueFamilyIndexCount);
    if (val->pQueueFamilyIndices) {
        vn_encode_array_size(enc, val->queueFamilyIndexCount);
        vn_encode_uint32_t_array(enc, val->pQueueFamilyIndices, val->queueFamilyIndexCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageDrmFormatModifierInfoEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT });
    vn_encode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self(enc, val);
}

/* struct VkPhysicalDeviceImageFormatInfo2 chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceImageFormatInfo2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceImageFormatInfo2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExternalImageFormatInfo_self((const VkPhysicalDeviceExternalImageFormatInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceImageFormatInfo2_pnext(pnext->pNext);
            size += vn_sizeof_VkImageFormatListCreateInfo_self((const VkImageFormatListCreateInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceImageFormatInfo2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self((const VkPhysicalDeviceImageDrmFormatModifierInfoEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceImageFormatInfo2_pnext(pnext->pNext);
            size += vn_sizeof_VkImageStencilUsageCreateInfo_self((const VkImageStencilUsageCreateInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageFormatInfo2_self(const VkPhysicalDeviceImageFormatInfo2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFormat(&val->format);
    size += vn_sizeof_VkImageType(&val->type);
    size += vn_sizeof_VkImageTiling(&val->tiling);
    size += vn_sizeof_VkFlags(&val->usage);
    size += vn_sizeof_VkFlags(&val->flags);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageFormatInfo2(const VkPhysicalDeviceImageFormatInfo2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceImageFormatInfo2_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceImageFormatInfo2_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceImageFormatInfo2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceImageFormatInfo2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExternalImageFormatInfo_self(enc, (const VkPhysicalDeviceExternalImageFormatInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceImageFormatInfo2_pnext(enc, pnext->pNext);
            vn_encode_VkImageFormatListCreateInfo_self(enc, (const VkImageFormatListCreateInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceImageFormatInfo2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self(enc, (const VkPhysicalDeviceImageDrmFormatModifierInfoEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceImageFormatInfo2_pnext(enc, pnext->pNext);
            vn_encode_VkImageStencilUsageCreateInfo_self(enc, (const VkImageStencilUsageCreateInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImageFormatInfo2_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageFormatInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFormat(enc, &val->format);
    vn_encode_VkImageType(enc, &val->type);
    vn_encode_VkImageTiling(enc, &val->tiling);
    vn_encode_VkFlags(enc, &val->usage);
    vn_encode_VkFlags(enc, &val->flags);
}

static inline void
vn_encode_VkPhysicalDeviceImageFormatInfo2(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageFormatInfo2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2 });
    vn_encode_VkPhysicalDeviceImageFormatInfo2_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImageFormatInfo2_self(enc, val);
}

/* struct VkExternalMemoryProperties */

static inline size_t
vn_sizeof_VkExternalMemoryProperties(const VkExternalMemoryProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_VkFlags(&val->externalMemoryFeatures);
    size += vn_sizeof_VkFlags(&val->exportFromImportedHandleTypes);
    size += vn_sizeof_VkFlags(&val->compatibleHandleTypes);
    return size;
}

static inline void
vn_decode_VkExternalMemoryProperties(struct vn_cs_decoder *dec, VkExternalMemoryProperties *val)
{
    vn_decode_VkFlags(dec, &val->externalMemoryFeatures);
    vn_decode_VkFlags(dec, &val->exportFromImportedHandleTypes);
    vn_decode_VkFlags(dec, &val->compatibleHandleTypes);
}

static inline size_t
vn_sizeof_VkExternalMemoryProperties_partial(const VkExternalMemoryProperties *val)
{
    size_t size = 0;
    /* skip val->externalMemoryFeatures */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
    return size;
}

static inline void
vn_encode_VkExternalMemoryProperties_partial(struct vn_cs_encoder *enc, const VkExternalMemoryProperties *val)
{
    /* skip val->externalMemoryFeatures */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
}

/* struct VkExternalImageFormatProperties chain */

static inline size_t
vn_sizeof_VkExternalImageFormatProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalImageFormatProperties_self(const VkExternalImageFormatProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkExternalMemoryProperties(&val->externalMemoryProperties);
    return size;
}

static inline size_t
vn_sizeof_VkExternalImageFormatProperties(const VkExternalImageFormatProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalImageFormatProperties_pnext(val->pNext);
    size += vn_sizeof_VkExternalImageFormatProperties_self(val);

    return size;
}

static inline void
vn_decode_VkExternalImageFormatProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkExternalImageFormatProperties_self(struct vn_cs_decoder *dec, VkExternalImageFormatProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkExternalMemoryProperties(dec, &val->externalMemoryProperties);
}

static inline void
vn_decode_VkExternalImageFormatProperties(struct vn_cs_decoder *dec, VkExternalImageFormatProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkExternalImageFormatProperties_pnext(dec, val->pNext);
    vn_decode_VkExternalImageFormatProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkExternalImageFormatProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalImageFormatProperties_self_partial(const VkExternalImageFormatProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkExternalMemoryProperties_partial(&val->externalMemoryProperties);
    return size;
}

static inline size_t
vn_sizeof_VkExternalImageFormatProperties_partial(const VkExternalImageFormatProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalImageFormatProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkExternalImageFormatProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkExternalImageFormatProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalImageFormatProperties_self_partial(struct vn_cs_encoder *enc, const VkExternalImageFormatProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkExternalMemoryProperties_partial(enc, &val->externalMemoryProperties);
}

static inline void
vn_encode_VkExternalImageFormatProperties_partial(struct vn_cs_encoder *enc, const VkExternalImageFormatProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES });
    vn_encode_VkExternalImageFormatProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkExternalImageFormatProperties_self_partial(enc, val);
}

/* struct VkSamplerYcbcrConversionImageFormatProperties chain */

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_self(const VkSamplerYcbcrConversionImageFormatProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->combinedImageSamplerDescriptorCount);
    return size;
}

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties(const VkSamplerYcbcrConversionImageFormatProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_pnext(val->pNext);
    size += vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_self(val);

    return size;
}

static inline void
vn_decode_VkSamplerYcbcrConversionImageFormatProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkSamplerYcbcrConversionImageFormatProperties_self(struct vn_cs_decoder *dec, VkSamplerYcbcrConversionImageFormatProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->combinedImageSamplerDescriptorCount);
}

static inline void
vn_decode_VkSamplerYcbcrConversionImageFormatProperties(struct vn_cs_decoder *dec, VkSamplerYcbcrConversionImageFormatProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkSamplerYcbcrConversionImageFormatProperties_pnext(dec, val->pNext);
    vn_decode_VkSamplerYcbcrConversionImageFormatProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_self_partial(const VkSamplerYcbcrConversionImageFormatProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->combinedImageSamplerDescriptorCount */
    return size;
}

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_partial(const VkSamplerYcbcrConversionImageFormatProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkSamplerYcbcrConversionImageFormatProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSamplerYcbcrConversionImageFormatProperties_self_partial(struct vn_cs_encoder *enc, const VkSamplerYcbcrConversionImageFormatProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->combinedImageSamplerDescriptorCount */
}

static inline void
vn_encode_VkSamplerYcbcrConversionImageFormatProperties_partial(struct vn_cs_encoder *enc, const VkSamplerYcbcrConversionImageFormatProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES });
    vn_encode_VkSamplerYcbcrConversionImageFormatProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkSamplerYcbcrConversionImageFormatProperties_self_partial(enc, val);
}

/* struct VkImageFormatProperties2 chain */

static inline size_t
vn_sizeof_VkImageFormatProperties2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageFormatProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkExternalImageFormatProperties_self((const VkExternalImageFormatProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageFormatProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_self((const VkSamplerYcbcrConversionImageFormatProperties *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageFormatProperties2_self(const VkImageFormatProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImageFormatProperties(&val->imageFormatProperties);
    return size;
}

static inline size_t
vn_sizeof_VkImageFormatProperties2(const VkImageFormatProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageFormatProperties2_pnext(val->pNext);
    size += vn_sizeof_VkImageFormatProperties2_self(val);

    return size;
}

static inline void
vn_decode_VkImageFormatProperties2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    VkBaseOutStructure *pnext = (VkBaseOutStructure *)val;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return;

    vn_decode_VkStructureType(dec, &stype);
    while (true) {
        assert(pnext);
        if (pnext->sType == stype)
            break;
    }

    switch ((int32_t)pnext->sType) {
    case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
        vn_decode_VkImageFormatProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkExternalImageFormatProperties_self(dec, (VkExternalImageFormatProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
        vn_decode_VkImageFormatProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkSamplerYcbcrConversionImageFormatProperties_self(dec, (VkSamplerYcbcrConversionImageFormatProperties *)pnext);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_decode_VkImageFormatProperties2_self(struct vn_cs_decoder *dec, VkImageFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImageFormatProperties(dec, &val->imageFormatProperties);
}

static inline void
vn_decode_VkImageFormatProperties2(struct vn_cs_decoder *dec, VkImageFormatProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2);

    assert(val->sType == stype);
    vn_decode_VkImageFormatProperties2_pnext(dec, val->pNext);
    vn_decode_VkImageFormatProperties2_self(dec, val);
}

static inline size_t
vn_sizeof_VkImageFormatProperties2_pnext_partial(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageFormatProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkExternalImageFormatProperties_self_partial((const VkExternalImageFormatProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageFormatProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_self_partial((const VkSamplerYcbcrConversionImageFormatProperties *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageFormatProperties2_self_partial(const VkImageFormatProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImageFormatProperties_partial(&val->imageFormatProperties);
    return size;
}

static inline size_t
vn_sizeof_VkImageFormatProperties2_partial(const VkImageFormatProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageFormatProperties2_pnext_partial(val->pNext);
    size += vn_sizeof_VkImageFormatProperties2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkImageFormatProperties2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageFormatProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkExternalImageFormatProperties_self_partial(enc, (const VkExternalImageFormatProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageFormatProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkSamplerYcbcrConversionImageFormatProperties_self_partial(enc, (const VkSamplerYcbcrConversionImageFormatProperties *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageFormatProperties2_self_partial(struct vn_cs_encoder *enc, const VkImageFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImageFormatProperties_partial(enc, &val->imageFormatProperties);
}

static inline void
vn_encode_VkImageFormatProperties2_partial(struct vn_cs_encoder *enc, const VkImageFormatProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2 });
    vn_encode_VkImageFormatProperties2_pnext_partial(enc, val->pNext);
    vn_encode_VkImageFormatProperties2_self_partial(enc, val);
}

/* struct VkQueueFamilyProperties2 chain */

static inline size_t
vn_sizeof_VkQueueFamilyProperties2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkQueueFamilyProperties2_self(const VkQueueFamilyProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkQueueFamilyProperties(&val->queueFamilyProperties);
    return size;
}

static inline size_t
vn_sizeof_VkQueueFamilyProperties2(const VkQueueFamilyProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkQueueFamilyProperties2_pnext(val->pNext);
    size += vn_sizeof_VkQueueFamilyProperties2_self(val);

    return size;
}

static inline void
vn_decode_VkQueueFamilyProperties2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkQueueFamilyProperties2_self(struct vn_cs_decoder *dec, VkQueueFamilyProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkQueueFamilyProperties(dec, &val->queueFamilyProperties);
}

static inline void
vn_decode_VkQueueFamilyProperties2(struct vn_cs_decoder *dec, VkQueueFamilyProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2);

    assert(val->sType == stype);
    vn_decode_VkQueueFamilyProperties2_pnext(dec, val->pNext);
    vn_decode_VkQueueFamilyProperties2_self(dec, val);
}

static inline size_t
vn_sizeof_VkQueueFamilyProperties2_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkQueueFamilyProperties2_self_partial(const VkQueueFamilyProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkQueueFamilyProperties_partial(&val->queueFamilyProperties);
    return size;
}

static inline size_t
vn_sizeof_VkQueueFamilyProperties2_partial(const VkQueueFamilyProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkQueueFamilyProperties2_pnext_partial(val->pNext);
    size += vn_sizeof_VkQueueFamilyProperties2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkQueueFamilyProperties2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkQueueFamilyProperties2_self_partial(struct vn_cs_encoder *enc, const VkQueueFamilyProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkQueueFamilyProperties_partial(enc, &val->queueFamilyProperties);
}

static inline void
vn_encode_VkQueueFamilyProperties2_partial(struct vn_cs_encoder *enc, const VkQueueFamilyProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2 });
    vn_encode_VkQueueFamilyProperties2_pnext_partial(enc, val->pNext);
    vn_encode_VkQueueFamilyProperties2_self_partial(enc, val);
}

/* struct VkPhysicalDeviceMemoryProperties2 chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryProperties2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryProperties2_self(const VkPhysicalDeviceMemoryProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkPhysicalDeviceMemoryProperties(&val->memoryProperties);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryProperties2(const VkPhysicalDeviceMemoryProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMemoryProperties2_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMemoryProperties2_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceMemoryProperties2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceMemoryProperties2_self(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPhysicalDeviceMemoryProperties(dec, &val->memoryProperties);
}

static inline void
vn_decode_VkPhysicalDeviceMemoryProperties2(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceMemoryProperties2_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceMemoryProperties2_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryProperties2_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryProperties2_self_partial(const VkPhysicalDeviceMemoryProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkPhysicalDeviceMemoryProperties_partial(&val->memoryProperties);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryProperties2_partial(const VkPhysicalDeviceMemoryProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMemoryProperties2_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMemoryProperties2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties2_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPhysicalDeviceMemoryProperties_partial(enc, &val->memoryProperties);
}

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties2_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2 });
    vn_encode_VkPhysicalDeviceMemoryProperties2_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMemoryProperties2_self_partial(enc, val);
}

/* struct VkPhysicalDeviceSparseImageFormatInfo2 chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceSparseImageFormatInfo2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSparseImageFormatInfo2_self(const VkPhysicalDeviceSparseImageFormatInfo2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFormat(&val->format);
    size += vn_sizeof_VkImageType(&val->type);
    size += vn_sizeof_VkSampleCountFlagBits(&val->samples);
    size += vn_sizeof_VkFlags(&val->usage);
    size += vn_sizeof_VkImageTiling(&val->tiling);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSparseImageFormatInfo2(const VkPhysicalDeviceSparseImageFormatInfo2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSparseImageFormatInfo2_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSparseImageFormatInfo2_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSparseImageFormatInfo2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSparseImageFormatInfo2_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSparseImageFormatInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFormat(enc, &val->format);
    vn_encode_VkImageType(enc, &val->type);
    vn_encode_VkSampleCountFlagBits(enc, &val->samples);
    vn_encode_VkFlags(enc, &val->usage);
    vn_encode_VkImageTiling(enc, &val->tiling);
}

static inline void
vn_encode_VkPhysicalDeviceSparseImageFormatInfo2(struct vn_cs_encoder *enc, const VkPhysicalDeviceSparseImageFormatInfo2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2 });
    vn_encode_VkPhysicalDeviceSparseImageFormatInfo2_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSparseImageFormatInfo2_self(enc, val);
}

/* struct VkSparseImageFormatProperties2 chain */

static inline size_t
vn_sizeof_VkSparseImageFormatProperties2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSparseImageFormatProperties2_self(const VkSparseImageFormatProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkSparseImageFormatProperties(&val->properties);
    return size;
}

static inline size_t
vn_sizeof_VkSparseImageFormatProperties2(const VkSparseImageFormatProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSparseImageFormatProperties2_pnext(val->pNext);
    size += vn_sizeof_VkSparseImageFormatProperties2_self(val);

    return size;
}

static inline void
vn_decode_VkSparseImageFormatProperties2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkSparseImageFormatProperties2_self(struct vn_cs_decoder *dec, VkSparseImageFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkSparseImageFormatProperties(dec, &val->properties);
}

static inline void
vn_decode_VkSparseImageFormatProperties2(struct vn_cs_decoder *dec, VkSparseImageFormatProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2);

    assert(val->sType == stype);
    vn_decode_VkSparseImageFormatProperties2_pnext(dec, val->pNext);
    vn_decode_VkSparseImageFormatProperties2_self(dec, val);
}

static inline size_t
vn_sizeof_VkSparseImageFormatProperties2_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSparseImageFormatProperties2_self_partial(const VkSparseImageFormatProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkSparseImageFormatProperties_partial(&val->properties);
    return size;
}

static inline size_t
vn_sizeof_VkSparseImageFormatProperties2_partial(const VkSparseImageFormatProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSparseImageFormatProperties2_pnext_partial(val->pNext);
    size += vn_sizeof_VkSparseImageFormatProperties2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkSparseImageFormatProperties2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSparseImageFormatProperties2_self_partial(struct vn_cs_encoder *enc, const VkSparseImageFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkSparseImageFormatProperties_partial(enc, &val->properties);
}

static inline void
vn_encode_VkSparseImageFormatProperties2_partial(struct vn_cs_encoder *enc, const VkSparseImageFormatProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2 });
    vn_encode_VkSparseImageFormatProperties2_pnext_partial(enc, val->pNext);
    vn_encode_VkSparseImageFormatProperties2_self_partial(enc, val);
}

/* struct VkPhysicalDeviceExternalBufferInfo chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalBufferInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalBufferInfo_self(const VkPhysicalDeviceExternalBufferInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkFlags(&val->usage);
    size += vn_sizeof_VkExternalMemoryHandleTypeFlagBits(&val->handleType);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalBufferInfo(const VkPhysicalDeviceExternalBufferInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExternalBufferInfo_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExternalBufferInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExternalBufferInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExternalBufferInfo_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExternalBufferInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkFlags(enc, &val->usage);
    vn_encode_VkExternalMemoryHandleTypeFlagBits(enc, &val->handleType);
}

static inline void
vn_encode_VkPhysicalDeviceExternalBufferInfo(struct vn_cs_encoder *enc, const VkPhysicalDeviceExternalBufferInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO });
    vn_encode_VkPhysicalDeviceExternalBufferInfo_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExternalBufferInfo_self(enc, val);
}

/* struct VkExternalBufferProperties chain */

static inline size_t
vn_sizeof_VkExternalBufferProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalBufferProperties_self(const VkExternalBufferProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkExternalMemoryProperties(&val->externalMemoryProperties);
    return size;
}

static inline size_t
vn_sizeof_VkExternalBufferProperties(const VkExternalBufferProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalBufferProperties_pnext(val->pNext);
    size += vn_sizeof_VkExternalBufferProperties_self(val);

    return size;
}

static inline void
vn_decode_VkExternalBufferProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkExternalBufferProperties_self(struct vn_cs_decoder *dec, VkExternalBufferProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkExternalMemoryProperties(dec, &val->externalMemoryProperties);
}

static inline void
vn_decode_VkExternalBufferProperties(struct vn_cs_decoder *dec, VkExternalBufferProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkExternalBufferProperties_pnext(dec, val->pNext);
    vn_decode_VkExternalBufferProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkExternalBufferProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalBufferProperties_self_partial(const VkExternalBufferProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkExternalMemoryProperties_partial(&val->externalMemoryProperties);
    return size;
}

static inline size_t
vn_sizeof_VkExternalBufferProperties_partial(const VkExternalBufferProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalBufferProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkExternalBufferProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkExternalBufferProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalBufferProperties_self_partial(struct vn_cs_encoder *enc, const VkExternalBufferProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkExternalMemoryProperties_partial(enc, &val->externalMemoryProperties);
}

static inline void
vn_encode_VkExternalBufferProperties_partial(struct vn_cs_encoder *enc, const VkExternalBufferProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES });
    vn_encode_VkExternalBufferProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkExternalBufferProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceExternalSemaphoreInfo chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalSemaphoreInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceExternalSemaphoreInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkSemaphoreTypeCreateInfo_self((const VkSemaphoreTypeCreateInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalSemaphoreInfo_self(const VkPhysicalDeviceExternalSemaphoreInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkExternalSemaphoreHandleTypeFlagBits(&val->handleType);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalSemaphoreInfo(const VkPhysicalDeviceExternalSemaphoreInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExternalSemaphoreInfo_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExternalSemaphoreInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExternalSemaphoreInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceExternalSemaphoreInfo_pnext(enc, pnext->pNext);
            vn_encode_VkSemaphoreTypeCreateInfo_self(enc, (const VkSemaphoreTypeCreateInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExternalSemaphoreInfo_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExternalSemaphoreInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkExternalSemaphoreHandleTypeFlagBits(enc, &val->handleType);
}

static inline void
vn_encode_VkPhysicalDeviceExternalSemaphoreInfo(struct vn_cs_encoder *enc, const VkPhysicalDeviceExternalSemaphoreInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO });
    vn_encode_VkPhysicalDeviceExternalSemaphoreInfo_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExternalSemaphoreInfo_self(enc, val);
}

/* struct VkExternalSemaphoreProperties chain */

static inline size_t
vn_sizeof_VkExternalSemaphoreProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalSemaphoreProperties_self(const VkExternalSemaphoreProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->exportFromImportedHandleTypes);
    size += vn_sizeof_VkFlags(&val->compatibleHandleTypes);
    size += vn_sizeof_VkFlags(&val->externalSemaphoreFeatures);
    return size;
}

static inline size_t
vn_sizeof_VkExternalSemaphoreProperties(const VkExternalSemaphoreProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalSemaphoreProperties_pnext(val->pNext);
    size += vn_sizeof_VkExternalSemaphoreProperties_self(val);

    return size;
}

static inline void
vn_decode_VkExternalSemaphoreProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkExternalSemaphoreProperties_self(struct vn_cs_decoder *dec, VkExternalSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->exportFromImportedHandleTypes);
    vn_decode_VkFlags(dec, &val->compatibleHandleTypes);
    vn_decode_VkFlags(dec, &val->externalSemaphoreFeatures);
}

static inline void
vn_decode_VkExternalSemaphoreProperties(struct vn_cs_decoder *dec, VkExternalSemaphoreProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkExternalSemaphoreProperties_pnext(dec, val->pNext);
    vn_decode_VkExternalSemaphoreProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkExternalSemaphoreProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalSemaphoreProperties_self_partial(const VkExternalSemaphoreProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
    /* skip val->externalSemaphoreFeatures */
    return size;
}

static inline size_t
vn_sizeof_VkExternalSemaphoreProperties_partial(const VkExternalSemaphoreProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalSemaphoreProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkExternalSemaphoreProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkExternalSemaphoreProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalSemaphoreProperties_self_partial(struct vn_cs_encoder *enc, const VkExternalSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
    /* skip val->externalSemaphoreFeatures */
}

static inline void
vn_encode_VkExternalSemaphoreProperties_partial(struct vn_cs_encoder *enc, const VkExternalSemaphoreProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES });
    vn_encode_VkExternalSemaphoreProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkExternalSemaphoreProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceExternalFenceInfo chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalFenceInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalFenceInfo_self(const VkPhysicalDeviceExternalFenceInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkExternalFenceHandleTypeFlagBits(&val->handleType);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalFenceInfo(const VkPhysicalDeviceExternalFenceInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExternalFenceInfo_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExternalFenceInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExternalFenceInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExternalFenceInfo_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExternalFenceInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkExternalFenceHandleTypeFlagBits(enc, &val->handleType);
}

static inline void
vn_encode_VkPhysicalDeviceExternalFenceInfo(struct vn_cs_encoder *enc, const VkPhysicalDeviceExternalFenceInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO });
    vn_encode_VkPhysicalDeviceExternalFenceInfo_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExternalFenceInfo_self(enc, val);
}

/* struct VkExternalFenceProperties chain */

static inline size_t
vn_sizeof_VkExternalFenceProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalFenceProperties_self(const VkExternalFenceProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->exportFromImportedHandleTypes);
    size += vn_sizeof_VkFlags(&val->compatibleHandleTypes);
    size += vn_sizeof_VkFlags(&val->externalFenceFeatures);
    return size;
}

static inline size_t
vn_sizeof_VkExternalFenceProperties(const VkExternalFenceProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalFenceProperties_pnext(val->pNext);
    size += vn_sizeof_VkExternalFenceProperties_self(val);

    return size;
}

static inline void
vn_decode_VkExternalFenceProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkExternalFenceProperties_self(struct vn_cs_decoder *dec, VkExternalFenceProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->exportFromImportedHandleTypes);
    vn_decode_VkFlags(dec, &val->compatibleHandleTypes);
    vn_decode_VkFlags(dec, &val->externalFenceFeatures);
}

static inline void
vn_decode_VkExternalFenceProperties(struct vn_cs_decoder *dec, VkExternalFenceProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkExternalFenceProperties_pnext(dec, val->pNext);
    vn_decode_VkExternalFenceProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkExternalFenceProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalFenceProperties_self_partial(const VkExternalFenceProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
    /* skip val->externalFenceFeatures */
    return size;
}

static inline size_t
vn_sizeof_VkExternalFenceProperties_partial(const VkExternalFenceProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalFenceProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkExternalFenceProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkExternalFenceProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalFenceProperties_self_partial(struct vn_cs_encoder *enc, const VkExternalFenceProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
    /* skip val->externalFenceFeatures */
}

static inline void
vn_encode_VkExternalFenceProperties_partial(struct vn_cs_encoder *enc, const VkExternalFenceProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES });
    vn_encode_VkExternalFenceProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkExternalFenceProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceGroupProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceGroupProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceGroupProperties_self(const VkPhysicalDeviceGroupProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->physicalDeviceCount);
    size += vn_sizeof_array_size(VK_MAX_DEVICE_GROUP_SIZE);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; i++)
        size += vn_sizeof_VkPhysicalDevice(&val->physicalDevices[i]);
    size += vn_sizeof_VkBool32(&val->subsetAllocation);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceGroupProperties(const VkPhysicalDeviceGroupProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceGroupProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceGroupProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceGroupProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceGroupProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceGroupProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->physicalDeviceCount);
    {
        const uint32_t iter_count = vn_decode_array_size(dec, VK_MAX_DEVICE_GROUP_SIZE);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPhysicalDevice(dec, &val->physicalDevices[i]);
    }
    vn_decode_VkBool32(dec, &val->subsetAllocation);
}

static inline void
vn_decode_VkPhysicalDeviceGroupProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceGroupProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceGroupProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceGroupProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceGroupProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceGroupProperties_self_partial(const VkPhysicalDeviceGroupProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->physicalDeviceCount */
    size += vn_sizeof_array_size(VK_MAX_DEVICE_GROUP_SIZE);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; i++)
        size += vn_sizeof_VkPhysicalDevice(&val->physicalDevices[i]);
    /* skip val->subsetAllocation */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceGroupProperties_partial(const VkPhysicalDeviceGroupProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceGroupProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceGroupProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceGroupProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceGroupProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceGroupProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->physicalDeviceCount */
    vn_encode_array_size(enc, VK_MAX_DEVICE_GROUP_SIZE);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; i++)
        vn_encode_VkPhysicalDevice(enc, &val->physicalDevices[i]);
    /* skip val->subsetAllocation */
}

static inline void
vn_encode_VkPhysicalDeviceGroupProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceGroupProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES });
    vn_encode_VkPhysicalDeviceGroupProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceGroupProperties_self_partial(enc, val);
}

/* struct VkDeviceQueueInfo2 chain */

static inline size_t
vn_sizeof_VkDeviceQueueInfo2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDeviceQueueInfo2_self(const VkDeviceQueueInfo2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_uint32_t(&val->queueFamilyIndex);
    size += vn_sizeof_uint32_t(&val->queueIndex);
    return size;
}

static inline size_t
vn_sizeof_VkDeviceQueueInfo2(const VkDeviceQueueInfo2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDeviceQueueInfo2_pnext(val->pNext);
    size += vn_sizeof_VkDeviceQueueInfo2_self(val);

    return size;
}

static inline void
vn_encode_VkDeviceQueueInfo2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDeviceQueueInfo2_self(struct vn_cs_encoder *enc, const VkDeviceQueueInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_uint32_t(enc, &val->queueFamilyIndex);
    vn_encode_uint32_t(enc, &val->queueIndex);
}

static inline void
vn_encode_VkDeviceQueueInfo2(struct vn_cs_encoder *enc, const VkDeviceQueueInfo2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2 });
    vn_encode_VkDeviceQueueInfo2_pnext(enc, val->pNext);
    vn_encode_VkDeviceQueueInfo2_self(enc, val);
}

/* struct VkPhysicalDeviceToolProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceToolProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceToolProperties_self(const VkPhysicalDeviceToolProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_array_size(VK_MAX_EXTENSION_NAME_SIZE);
    size += vn_sizeof_char_array(val->name, VK_MAX_EXTENSION_NAME_SIZE);
    size += vn_sizeof_array_size(VK_MAX_EXTENSION_NAME_SIZE);
    size += vn_sizeof_char_array(val->version, VK_MAX_EXTENSION_NAME_SIZE);
    size += vn_sizeof_VkFlags(&val->purposes);
    size += vn_sizeof_array_size(VK_MAX_DESCRIPTION_SIZE);
    size += vn_sizeof_char_array(val->description, VK_MAX_DESCRIPTION_SIZE);
    size += vn_sizeof_array_size(VK_MAX_EXTENSION_NAME_SIZE);
    size += vn_sizeof_char_array(val->layer, VK_MAX_EXTENSION_NAME_SIZE);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceToolProperties(const VkPhysicalDeviceToolProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceToolProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceToolProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceToolProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceToolProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceToolProperties *val)
{
    /* skip val->{sType,pNext} */
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_EXTENSION_NAME_SIZE);
        vn_decode_char_array(dec, val->name, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_EXTENSION_NAME_SIZE);
        vn_decode_char_array(dec, val->version, array_size);
    }
    vn_decode_VkFlags(dec, &val->purposes);
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_DESCRIPTION_SIZE);
        vn_decode_char_array(dec, val->description, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_EXTENSION_NAME_SIZE);
        vn_decode_char_array(dec, val->layer, array_size);
    }
}

static inline void
vn_decode_VkPhysicalDeviceToolProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceToolProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceToolProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceToolProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceToolProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceToolProperties_self_partial(const VkPhysicalDeviceToolProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->name */
    /* skip val->version */
    /* skip val->purposes */
    /* skip val->description */
    /* skip val->layer */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceToolProperties_partial(const VkPhysicalDeviceToolProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceToolProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceToolProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceToolProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceToolProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceToolProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->name */
    /* skip val->version */
    /* skip val->purposes */
    /* skip val->description */
    /* skip val->layer */
}

static inline void
vn_encode_VkPhysicalDeviceToolProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceToolProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES });
    vn_encode_VkPhysicalDeviceToolProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceToolProperties_self_partial(enc, val);
}

static inline size_t vn_sizeof_vkEnumeratePhysicalDevices(VkInstance instance, uint32_t* pPhysicalDeviceCount, VkPhysicalDevice* pPhysicalDevices)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumeratePhysicalDevices_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkInstance(&instance);
    cmd_size += vn_sizeof_simple_pointer(pPhysicalDeviceCount);
    if (pPhysicalDeviceCount)
        cmd_size += vn_sizeof_uint32_t(pPhysicalDeviceCount);
    if (pPhysicalDevices) {
        cmd_size += vn_sizeof_array_size((pPhysicalDeviceCount ? *pPhysicalDeviceCount : 0));
        for (uint32_t i = 0; i < (pPhysicalDeviceCount ? *pPhysicalDeviceCount : 0); i++)
            cmd_size += vn_sizeof_VkPhysicalDevice(&pPhysicalDevices[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkEnumeratePhysicalDevices(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkInstance instance, uint32_t* pPhysicalDeviceCount, VkPhysicalDevice* pPhysicalDevices)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumeratePhysicalDevices_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkInstance(enc, &instance);
    if (vn_encode_simple_pointer(enc, pPhysicalDeviceCount))
        vn_encode_uint32_t(enc, pPhysicalDeviceCount);
    if (pPhysicalDevices) {
        vn_encode_array_size(enc, (pPhysicalDeviceCount ? *pPhysicalDeviceCount : 0));
        for (uint32_t i = 0; i < (pPhysicalDeviceCount ? *pPhysicalDeviceCount : 0); i++)
            vn_encode_VkPhysicalDevice(enc, &pPhysicalDevices[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkEnumeratePhysicalDevices_reply(VkInstance instance, uint32_t* pPhysicalDeviceCount, VkPhysicalDevice* pPhysicalDevices)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumeratePhysicalDevices_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip instance */
    cmd_size += vn_sizeof_simple_pointer(pPhysicalDeviceCount);
    if (pPhysicalDeviceCount)
        cmd_size += vn_sizeof_uint32_t(pPhysicalDeviceCount);
    if (pPhysicalDevices) {
        cmd_size += vn_sizeof_array_size((pPhysicalDeviceCount ? *pPhysicalDeviceCount : 0));
        for (uint32_t i = 0; i < (pPhysicalDeviceCount ? *pPhysicalDeviceCount : 0); i++)
            cmd_size += vn_sizeof_VkPhysicalDevice(&pPhysicalDevices[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline VkResult vn_decode_vkEnumeratePhysicalDevices_reply(struct vn_cs_decoder *dec, VkInstance instance, uint32_t* pPhysicalDeviceCount, VkPhysicalDevice* pPhysicalDevices)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkEnumeratePhysicalDevices_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip instance */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint32_t(dec, pPhysicalDeviceCount);
    } else {
        pPhysicalDeviceCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (pPhysicalDeviceCount ? *pPhysicalDeviceCount : 0));
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPhysicalDevice(dec, &pPhysicalDevices[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pPhysicalDevices = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceProperties_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_simple_pointer(pProperties);
    if (pProperties)
        cmd_size += vn_sizeof_VkPhysicalDeviceProperties_partial(pProperties);

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceProperties(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceProperties_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (vn_encode_simple_pointer(enc, pProperties))
        vn_encode_VkPhysicalDeviceProperties_partial(enc, pProperties);
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceProperties_reply(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceProperties_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip physicalDevice */
    cmd_size += vn_sizeof_simple_pointer(pProperties);
    if (pProperties)
        cmd_size += vn_sizeof_VkPhysicalDeviceProperties(pProperties);

    return cmd_size;
}

static inline void vn_decode_vkGetPhysicalDeviceProperties_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceProperties_EXT);

    /* skip physicalDevice */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkPhysicalDeviceProperties(dec, pProperties);
    } else {
        pProperties = NULL;
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceQueueFamilyProperties(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties* pQueueFamilyProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceQueueFamilyProperties_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_simple_pointer(pQueueFamilyPropertyCount);
    if (pQueueFamilyPropertyCount)
        cmd_size += vn_sizeof_uint32_t(pQueueFamilyPropertyCount);
    if (pQueueFamilyProperties) {
        cmd_size += vn_sizeof_array_size((pQueueFamilyPropertyCount ? *pQueueFamilyPropertyCount : 0));
        for (uint32_t i = 0; i < (pQueueFamilyPropertyCount ? *pQueueFamilyPropertyCount : 0); i++)
            cmd_size += vn_sizeof_VkQueueFamilyProperties_partial(&pQueueFamilyProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceQueueFamilyProperties(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties* pQueueFamilyProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceQueueFamilyProperties_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (vn_encode_simple_pointer(enc, pQueueFamilyPropertyCount))
        vn_encode_uint32_t(enc, pQueueFamilyPropertyCount);
    if (pQueueFamilyProperties) {
        vn_encode_array_size(enc, (pQueueFamilyPropertyCount ? *pQueueFamilyPropertyCount : 0));
        for (uint32_t i = 0; i < (pQueueFamilyPropertyCount ? *pQueueFamilyPropertyCount : 0); i++)
            vn_encode_VkQueueFamilyProperties_partial(enc, &pQueueFamilyProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceQueueFamilyProperties_reply(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties* pQueueFamilyProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceQueueFamilyProperties_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip physicalDevice */
    cmd_size += vn_sizeof_simple_pointer(pQueueFamilyPropertyCount);
    if (pQueueFamilyPropertyCount)
        cmd_size += vn_sizeof_uint32_t(pQueueFamilyPropertyCount);
    if (pQueueFamilyProperties) {
        cmd_size += vn_sizeof_array_size((pQueueFamilyPropertyCount ? *pQueueFamilyPropertyCount : 0));
        for (uint32_t i = 0; i < (pQueueFamilyPropertyCount ? *pQueueFamilyPropertyCount : 0); i++)
            cmd_size += vn_sizeof_VkQueueFamilyProperties(&pQueueFamilyProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_decode_vkGetPhysicalDeviceQueueFamilyProperties_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties* pQueueFamilyProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceQueueFamilyProperties_EXT);

    /* skip physicalDevice */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint32_t(dec, pQueueFamilyPropertyCount);
    } else {
        pQueueFamilyPropertyCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (pQueueFamilyPropertyCount ? *pQueueFamilyPropertyCount : 0));
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkQueueFamilyProperties(dec, &pQueueFamilyProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pQueueFamilyProperties = NULL;
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceMemoryProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties* pMemoryProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceMemoryProperties_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_simple_pointer(pMemoryProperties);
    if (pMemoryProperties)
        cmd_size += vn_sizeof_VkPhysicalDeviceMemoryProperties_partial(pMemoryProperties);

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceMemoryProperties(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties* pMemoryProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceMemoryProperties_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (vn_encode_simple_pointer(enc, pMemoryProperties))
        vn_encode_VkPhysicalDeviceMemoryProperties_partial(enc, pMemoryProperties);
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceMemoryProperties_reply(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties* pMemoryProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceMemoryProperties_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip physicalDevice */
    cmd_size += vn_sizeof_simple_pointer(pMemoryProperties);
    if (pMemoryProperties)
        cmd_size += vn_sizeof_VkPhysicalDeviceMemoryProperties(pMemoryProperties);

    return cmd_size;
}

static inline void vn_decode_vkGetPhysicalDeviceMemoryProperties_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties* pMemoryProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceMemoryProperties_EXT);

    /* skip physicalDevice */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkPhysicalDeviceMemoryProperties(dec, pMemoryProperties);
    } else {
        pMemoryProperties = NULL;
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceFeatures(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceFeatures_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_simple_pointer(pFeatures);
    if (pFeatures)
        cmd_size += vn_sizeof_VkPhysicalDeviceFeatures_partial(pFeatures);

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceFeatures(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceFeatures_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (vn_encode_simple_pointer(enc, pFeatures))
        vn_encode_VkPhysicalDeviceFeatures_partial(enc, pFeatures);
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceFeatures_reply(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceFeatures_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip physicalDevice */
    cmd_size += vn_sizeof_simple_pointer(pFeatures);
    if (pFeatures)
        cmd_size += vn_sizeof_VkPhysicalDeviceFeatures(pFeatures);

    return cmd_size;
}

static inline void vn_decode_vkGetPhysicalDeviceFeatures_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceFeatures_EXT);

    /* skip physicalDevice */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkPhysicalDeviceFeatures(dec, pFeatures);
    } else {
        pFeatures = NULL;
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties* pFormatProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceFormatProperties_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_VkFormat(&format);
    cmd_size += vn_sizeof_simple_pointer(pFormatProperties);
    if (pFormatProperties)
        cmd_size += vn_sizeof_VkFormatProperties_partial(pFormatProperties);

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceFormatProperties(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties* pFormatProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceFormatProperties_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    vn_encode_VkFormat(enc, &format);
    if (vn_encode_simple_pointer(enc, pFormatProperties))
        vn_encode_VkFormatProperties_partial(enc, pFormatProperties);
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceFormatProperties_reply(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties* pFormatProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceFormatProperties_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip physicalDevice */
    /* skip format */
    cmd_size += vn_sizeof_simple_pointer(pFormatProperties);
    if (pFormatProperties)
        cmd_size += vn_sizeof_VkFormatProperties(pFormatProperties);

    return cmd_size;
}

static inline void vn_decode_vkGetPhysicalDeviceFormatProperties_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties* pFormatProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceFormatProperties_EXT);

    /* skip physicalDevice */
    /* skip format */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkFormatProperties(dec, pFormatProperties);
    } else {
        pFormatProperties = NULL;
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkImageFormatProperties* pImageFormatProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceImageFormatProperties_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_VkFormat(&format);
    cmd_size += vn_sizeof_VkImageType(&type);
    cmd_size += vn_sizeof_VkImageTiling(&tiling);
    cmd_size += vn_sizeof_VkFlags(&usage);
    cmd_size += vn_sizeof_VkFlags(&flags);
    cmd_size += vn_sizeof_simple_pointer(pImageFormatProperties);
    if (pImageFormatProperties)
        cmd_size += vn_sizeof_VkImageFormatProperties_partial(pImageFormatProperties);

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceImageFormatProperties(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkImageFormatProperties* pImageFormatProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceImageFormatProperties_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    vn_encode_VkFormat(enc, &format);
    vn_encode_VkImageType(enc, &type);
    vn_encode_VkImageTiling(enc, &tiling);
    vn_encode_VkFlags(enc, &usage);
    vn_encode_VkFlags(enc, &flags);
    if (vn_encode_simple_pointer(enc, pImageFormatProperties))
        vn_encode_VkImageFormatProperties_partial(enc, pImageFormatProperties);
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceImageFormatProperties_reply(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkImageFormatProperties* pImageFormatProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceImageFormatProperties_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip physicalDevice */
    /* skip format */
    /* skip type */
    /* skip tiling */
    /* skip usage */
    /* skip flags */
    cmd_size += vn_sizeof_simple_pointer(pImageFormatProperties);
    if (pImageFormatProperties)
        cmd_size += vn_sizeof_VkImageFormatProperties(pImageFormatProperties);

    return cmd_size;
}

static inline VkResult vn_decode_vkGetPhysicalDeviceImageFormatProperties_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkImageFormatProperties* pImageFormatProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceImageFormatProperties_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip physicalDevice */
    /* skip format */
    /* skip type */
    /* skip tiling */
    /* skip usage */
    /* skip flags */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkImageFormatProperties(dec, pImageFormatProperties);
    } else {
        pImageFormatProperties = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkCreateDevice(VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDevice* pDevice)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateDevice_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_simple_pointer(pCreateInfo);
    if (pCreateInfo)
        cmd_size += vn_sizeof_VkDeviceCreateInfo(pCreateInfo);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);
    cmd_size += vn_sizeof_simple_pointer(pDevice);
    if (pDevice)
        cmd_size += vn_sizeof_VkDevice(pDevice);

    return cmd_size;
}

static inline void vn_encode_vkCreateDevice(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDevice* pDevice)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateDevice_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (vn_encode_simple_pointer(enc, pCreateInfo))
        vn_encode_VkDeviceCreateInfo(enc, pCreateInfo);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
    if (vn_encode_simple_pointer(enc, pDevice))
        vn_encode_VkDevice(enc, pDevice);
}

static inline size_t vn_sizeof_vkCreateDevice_reply(VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDevice* pDevice)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateDevice_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip physicalDevice */
    /* skip pCreateInfo */
    /* skip pAllocator */
    cmd_size += vn_sizeof_simple_pointer(pDevice);
    if (pDevice)
        cmd_size += vn_sizeof_VkDevice(pDevice);

    return cmd_size;
}

static inline VkResult vn_decode_vkCreateDevice_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDevice* pDevice)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCreateDevice_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip physicalDevice */
    /* skip pCreateInfo */
    /* skip pAllocator */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkDevice(dec, pDevice);
    } else {
        pDevice = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkDestroyDevice(VkDevice device, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyDevice_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);

    return cmd_size;
}

static inline void vn_encode_vkDestroyDevice(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyDevice_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
}

static inline size_t vn_sizeof_vkDestroyDevice_reply(VkDevice device, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyDevice_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip pAllocator */

    return cmd_size;
}

static inline void vn_decode_vkDestroyDevice_reply(struct vn_cs_decoder *dec, VkDevice device, const VkAllocationCallbacks* pAllocator)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkDestroyDevice_EXT);

    /* skip device */
    /* skip pAllocator */
}

static inline size_t vn_sizeof_vkEnumerateDeviceLayerProperties(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkLayerProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumerateDeviceLayerProperties_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_simple_pointer(pPropertyCount);
    if (pPropertyCount)
        cmd_size += vn_sizeof_uint32_t(pPropertyCount);
    if (pProperties) {
        cmd_size += vn_sizeof_array_size((pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            cmd_size += vn_sizeof_VkLayerProperties_partial(&pProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkEnumerateDeviceLayerProperties(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkLayerProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumerateDeviceLayerProperties_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (vn_encode_simple_pointer(enc, pPropertyCount))
        vn_encode_uint32_t(enc, pPropertyCount);
    if (pProperties) {
        vn_encode_array_size(enc, (pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            vn_encode_VkLayerProperties_partial(enc, &pProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkEnumerateDeviceLayerProperties_reply(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkLayerProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumerateDeviceLayerProperties_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip physicalDevice */
    cmd_size += vn_sizeof_simple_pointer(pPropertyCount);
    if (pPropertyCount)
        cmd_size += vn_sizeof_uint32_t(pPropertyCount);
    if (pProperties) {
        cmd_size += vn_sizeof_array_size((pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            cmd_size += vn_sizeof_VkLayerProperties(&pProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline VkResult vn_decode_vkEnumerateDeviceLayerProperties_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkLayerProperties* pProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkEnumerateDeviceLayerProperties_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip physicalDevice */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint32_t(dec, pPropertyCount);
    } else {
        pPropertyCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkLayerProperties(dec, &pProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pProperties = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkEnumerateDeviceExtensionProperties(VkPhysicalDevice physicalDevice, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumerateDeviceExtensionProperties_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    if (pLayerName) {
        const size_t string_size = strlen(pLayerName) + 1;
        cmd_size += vn_sizeof_array_size(string_size);
        cmd_size += vn_sizeof_char_array(pLayerName, string_size);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_simple_pointer(pPropertyCount);
    if (pPropertyCount)
        cmd_size += vn_sizeof_uint32_t(pPropertyCount);
    if (pProperties) {
        cmd_size += vn_sizeof_array_size((pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            cmd_size += vn_sizeof_VkExtensionProperties_partial(&pProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkEnumerateDeviceExtensionProperties(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumerateDeviceExtensionProperties_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (pLayerName) {
        const size_t string_size = strlen(pLayerName) + 1;
        vn_encode_array_size(enc, string_size);
        vn_encode_char_array(enc, pLayerName, string_size);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (vn_encode_simple_pointer(enc, pPropertyCount))
        vn_encode_uint32_t(enc, pPropertyCount);
    if (pProperties) {
        vn_encode_array_size(enc, (pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            vn_encode_VkExtensionProperties_partial(enc, &pProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkEnumerateDeviceExtensionProperties_reply(VkPhysicalDevice physicalDevice, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumerateDeviceExtensionProperties_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip physicalDevice */
    /* skip pLayerName */
    cmd_size += vn_sizeof_simple_pointer(pPropertyCount);
    if (pPropertyCount)
        cmd_size += vn_sizeof_uint32_t(pPropertyCount);
    if (pProperties) {
        cmd_size += vn_sizeof_array_size((pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            cmd_size += vn_sizeof_VkExtensionProperties(&pProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline VkResult vn_decode_vkEnumerateDeviceExtensionProperties_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkEnumerateDeviceExtensionProperties_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip physicalDevice */
    /* skip pLayerName */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint32_t(dec, pPropertyCount);
    } else {
        pPropertyCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkExtensionProperties(dec, &pProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pProperties = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkGetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceQueue_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_uint32_t(&queueFamilyIndex);
    cmd_size += vn_sizeof_uint32_t(&queueIndex);
    cmd_size += vn_sizeof_simple_pointer(pQueue);
    if (pQueue)
        cmd_size += vn_sizeof_VkQueue(pQueue);

    return cmd_size;
}

static inline void vn_encode_vkGetDeviceQueue(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceQueue_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_uint32_t(enc, &queueFamilyIndex);
    vn_encode_uint32_t(enc, &queueIndex);
    if (vn_encode_simple_pointer(enc, pQueue))
        vn_encode_VkQueue(enc, pQueue);
}

static inline size_t vn_sizeof_vkGetDeviceQueue_reply(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceQueue_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip queueFamilyIndex */
    /* skip queueIndex */
    cmd_size += vn_sizeof_simple_pointer(pQueue);
    if (pQueue)
        cmd_size += vn_sizeof_VkQueue(pQueue);

    return cmd_size;
}

static inline void vn_decode_vkGetDeviceQueue_reply(struct vn_cs_decoder *dec, VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetDeviceQueue_EXT);

    /* skip device */
    /* skip queueFamilyIndex */
    /* skip queueIndex */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkQueue(dec, pQueue);
    } else {
        pQueue = NULL;
    }
}

static inline size_t vn_sizeof_vkDeviceWaitIdle(VkDevice device)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDeviceWaitIdle_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);

    return cmd_size;
}

static inline void vn_encode_vkDeviceWaitIdle(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDeviceWaitIdle_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
}

static inline size_t vn_sizeof_vkDeviceWaitIdle_reply(VkDevice device)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDeviceWaitIdle_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */

    return cmd_size;
}

static inline VkResult vn_decode_vkDeviceWaitIdle_reply(struct vn_cs_decoder *dec, VkDevice device)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkDeviceWaitIdle_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */

    return ret;
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceSparseImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling, uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceSparseImageFormatProperties_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_VkFormat(&format);
    cmd_size += vn_sizeof_VkImageType(&type);
    cmd_size += vn_sizeof_VkSampleCountFlagBits(&samples);
    cmd_size += vn_sizeof_VkFlags(&usage);
    cmd_size += vn_sizeof_VkImageTiling(&tiling);
    cmd_size += vn_sizeof_simple_pointer(pPropertyCount);
    if (pPropertyCount)
        cmd_size += vn_sizeof_uint32_t(pPropertyCount);
    if (pProperties) {
        cmd_size += vn_sizeof_array_size((pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            cmd_size += vn_sizeof_VkSparseImageFormatProperties_partial(&pProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceSparseImageFormatProperties(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling, uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceSparseImageFormatProperties_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    vn_encode_VkFormat(enc, &format);
    vn_encode_VkImageType(enc, &type);
    vn_encode_VkSampleCountFlagBits(enc, &samples);
    vn_encode_VkFlags(enc, &usage);
    vn_encode_VkImageTiling(enc, &tiling);
    if (vn_encode_simple_pointer(enc, pPropertyCount))
        vn_encode_uint32_t(enc, pPropertyCount);
    if (pProperties) {
        vn_encode_array_size(enc, (pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            vn_encode_VkSparseImageFormatProperties_partial(enc, &pProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceSparseImageFormatProperties_reply(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling, uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceSparseImageFormatProperties_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip physicalDevice */
    /* skip format */
    /* skip type */
    /* skip samples */
    /* skip usage */
    /* skip tiling */
    cmd_size += vn_sizeof_simple_pointer(pPropertyCount);
    if (pPropertyCount)
        cmd_size += vn_sizeof_uint32_t(pPropertyCount);
    if (pProperties) {
        cmd_size += vn_sizeof_array_size((pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            cmd_size += vn_sizeof_VkSparseImageFormatProperties(&pProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_decode_vkGetPhysicalDeviceSparseImageFormatProperties_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling, uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceSparseImageFormatProperties_EXT);

    /* skip physicalDevice */
    /* skip format */
    /* skip type */
    /* skip samples */
    /* skip usage */
    /* skip tiling */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint32_t(dec, pPropertyCount);
    } else {
        pPropertyCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkSparseImageFormatProperties(dec, &pProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pProperties = NULL;
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceFeatures2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceFeatures2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_simple_pointer(pFeatures);
    if (pFeatures)
        cmd_size += vn_sizeof_VkPhysicalDeviceFeatures2_partial(pFeatures);

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceFeatures2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceFeatures2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (vn_encode_simple_pointer(enc, pFeatures))
        vn_encode_VkPhysicalDeviceFeatures2_partial(enc, pFeatures);
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceFeatures2_reply(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceFeatures2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip physicalDevice */
    cmd_size += vn_sizeof_simple_pointer(pFeatures);
    if (pFeatures)
        cmd_size += vn_sizeof_VkPhysicalDeviceFeatures2(pFeatures);

    return cmd_size;
}

static inline void vn_decode_vkGetPhysicalDeviceFeatures2_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceFeatures2_EXT);

    /* skip physicalDevice */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkPhysicalDeviceFeatures2(dec, pFeatures);
    } else {
        pFeatures = NULL;
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceProperties2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_simple_pointer(pProperties);
    if (pProperties)
        cmd_size += vn_sizeof_VkPhysicalDeviceProperties2_partial(pProperties);

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceProperties2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceProperties2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (vn_encode_simple_pointer(enc, pProperties))
        vn_encode_VkPhysicalDeviceProperties2_partial(enc, pProperties);
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceProperties2_reply(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceProperties2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip physicalDevice */
    cmd_size += vn_sizeof_simple_pointer(pProperties);
    if (pProperties)
        cmd_size += vn_sizeof_VkPhysicalDeviceProperties2(pProperties);

    return cmd_size;
}

static inline void vn_decode_vkGetPhysicalDeviceProperties2_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceProperties2_EXT);

    /* skip physicalDevice */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkPhysicalDeviceProperties2(dec, pProperties);
    } else {
        pProperties = NULL;
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceFormatProperties2(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceFormatProperties2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_VkFormat(&format);
    cmd_size += vn_sizeof_simple_pointer(pFormatProperties);
    if (pFormatProperties)
        cmd_size += vn_sizeof_VkFormatProperties2_partial(pFormatProperties);

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceFormatProperties2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceFormatProperties2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    vn_encode_VkFormat(enc, &format);
    if (vn_encode_simple_pointer(enc, pFormatProperties))
        vn_encode_VkFormatProperties2_partial(enc, pFormatProperties);
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceFormatProperties2_reply(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceFormatProperties2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip physicalDevice */
    /* skip format */
    cmd_size += vn_sizeof_simple_pointer(pFormatProperties);
    if (pFormatProperties)
        cmd_size += vn_sizeof_VkFormatProperties2(pFormatProperties);

    return cmd_size;
}

static inline void vn_decode_vkGetPhysicalDeviceFormatProperties2_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceFormatProperties2_EXT);

    /* skip physicalDevice */
    /* skip format */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkFormatProperties2(dec, pFormatProperties);
    } else {
        pFormatProperties = NULL;
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceImageFormatProperties2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_simple_pointer(pImageFormatInfo);
    if (pImageFormatInfo)
        cmd_size += vn_sizeof_VkPhysicalDeviceImageFormatInfo2(pImageFormatInfo);
    cmd_size += vn_sizeof_simple_pointer(pImageFormatProperties);
    if (pImageFormatProperties)
        cmd_size += vn_sizeof_VkImageFormatProperties2_partial(pImageFormatProperties);

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceImageFormatProperties2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceImageFormatProperties2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (vn_encode_simple_pointer(enc, pImageFormatInfo))
        vn_encode_VkPhysicalDeviceImageFormatInfo2(enc, pImageFormatInfo);
    if (vn_encode_simple_pointer(enc, pImageFormatProperties))
        vn_encode_VkImageFormatProperties2_partial(enc, pImageFormatProperties);
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceImageFormatProperties2_reply(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceImageFormatProperties2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip physicalDevice */
    /* skip pImageFormatInfo */
    cmd_size += vn_sizeof_simple_pointer(pImageFormatProperties);
    if (pImageFormatProperties)
        cmd_size += vn_sizeof_VkImageFormatProperties2(pImageFormatProperties);

    return cmd_size;
}

static inline VkResult vn_decode_vkGetPhysicalDeviceImageFormatProperties2_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceImageFormatProperties2_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip physicalDevice */
    /* skip pImageFormatInfo */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkImageFormatProperties2(dec, pImageFormatProperties);
    } else {
        pImageFormatProperties = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceQueueFamilyProperties2(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceQueueFamilyProperties2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_simple_pointer(pQueueFamilyPropertyCount);
    if (pQueueFamilyPropertyCount)
        cmd_size += vn_sizeof_uint32_t(pQueueFamilyPropertyCount);
    if (pQueueFamilyProperties) {
        cmd_size += vn_sizeof_array_size((pQueueFamilyPropertyCount ? *pQueueFamilyPropertyCount : 0));
        for (uint32_t i = 0; i < (pQueueFamilyPropertyCount ? *pQueueFamilyPropertyCount : 0); i++)
            cmd_size += vn_sizeof_VkQueueFamilyProperties2_partial(&pQueueFamilyProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceQueueFamilyProperties2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceQueueFamilyProperties2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (vn_encode_simple_pointer(enc, pQueueFamilyPropertyCount))
        vn_encode_uint32_t(enc, pQueueFamilyPropertyCount);
    if (pQueueFamilyProperties) {
        vn_encode_array_size(enc, (pQueueFamilyPropertyCount ? *pQueueFamilyPropertyCount : 0));
        for (uint32_t i = 0; i < (pQueueFamilyPropertyCount ? *pQueueFamilyPropertyCount : 0); i++)
            vn_encode_VkQueueFamilyProperties2_partial(enc, &pQueueFamilyProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceQueueFamilyProperties2_reply(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceQueueFamilyProperties2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip physicalDevice */
    cmd_size += vn_sizeof_simple_pointer(pQueueFamilyPropertyCount);
    if (pQueueFamilyPropertyCount)
        cmd_size += vn_sizeof_uint32_t(pQueueFamilyPropertyCount);
    if (pQueueFamilyProperties) {
        cmd_size += vn_sizeof_array_size((pQueueFamilyPropertyCount ? *pQueueFamilyPropertyCount : 0));
        for (uint32_t i = 0; i < (pQueueFamilyPropertyCount ? *pQueueFamilyPropertyCount : 0); i++)
            cmd_size += vn_sizeof_VkQueueFamilyProperties2(&pQueueFamilyProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_decode_vkGetPhysicalDeviceQueueFamilyProperties2_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceQueueFamilyProperties2_EXT);

    /* skip physicalDevice */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint32_t(dec, pQueueFamilyPropertyCount);
    } else {
        pQueueFamilyPropertyCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (pQueueFamilyPropertyCount ? *pQueueFamilyPropertyCount : 0));
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkQueueFamilyProperties2(dec, &pQueueFamilyProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pQueueFamilyProperties = NULL;
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceMemoryProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceMemoryProperties2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_simple_pointer(pMemoryProperties);
    if (pMemoryProperties)
        cmd_size += vn_sizeof_VkPhysicalDeviceMemoryProperties2_partial(pMemoryProperties);

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceMemoryProperties2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceMemoryProperties2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (vn_encode_simple_pointer(enc, pMemoryProperties))
        vn_encode_VkPhysicalDeviceMemoryProperties2_partial(enc, pMemoryProperties);
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceMemoryProperties2_reply(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceMemoryProperties2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip physicalDevice */
    cmd_size += vn_sizeof_simple_pointer(pMemoryProperties);
    if (pMemoryProperties)
        cmd_size += vn_sizeof_VkPhysicalDeviceMemoryProperties2(pMemoryProperties);

    return cmd_size;
}

static inline void vn_decode_vkGetPhysicalDeviceMemoryProperties2_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceMemoryProperties2_EXT);

    /* skip physicalDevice */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkPhysicalDeviceMemoryProperties2(dec, pMemoryProperties);
    } else {
        pMemoryProperties = NULL;
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceSparseImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceSparseImageFormatProperties2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_simple_pointer(pFormatInfo);
    if (pFormatInfo)
        cmd_size += vn_sizeof_VkPhysicalDeviceSparseImageFormatInfo2(pFormatInfo);
    cmd_size += vn_sizeof_simple_pointer(pPropertyCount);
    if (pPropertyCount)
        cmd_size += vn_sizeof_uint32_t(pPropertyCount);
    if (pProperties) {
        cmd_size += vn_sizeof_array_size((pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            cmd_size += vn_sizeof_VkSparseImageFormatProperties2_partial(&pProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceSparseImageFormatProperties2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceSparseImageFormatProperties2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (vn_encode_simple_pointer(enc, pFormatInfo))
        vn_encode_VkPhysicalDeviceSparseImageFormatInfo2(enc, pFormatInfo);
    if (vn_encode_simple_pointer(enc, pPropertyCount))
        vn_encode_uint32_t(enc, pPropertyCount);
    if (pProperties) {
        vn_encode_array_size(enc, (pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            vn_encode_VkSparseImageFormatProperties2_partial(enc, &pProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceSparseImageFormatProperties2_reply(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceSparseImageFormatProperties2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip physicalDevice */
    /* skip pFormatInfo */
    cmd_size += vn_sizeof_simple_pointer(pPropertyCount);
    if (pPropertyCount)
        cmd_size += vn_sizeof_uint32_t(pPropertyCount);
    if (pProperties) {
        cmd_size += vn_sizeof_array_size((pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < (pPropertyCount ? *pPropertyCount : 0); i++)
            cmd_size += vn_sizeof_VkSparseImageFormatProperties2(&pProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_decode_vkGetPhysicalDeviceSparseImageFormatProperties2_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceSparseImageFormatProperties2_EXT);

    /* skip physicalDevice */
    /* skip pFormatInfo */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint32_t(dec, pPropertyCount);
    } else {
        pPropertyCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (pPropertyCount ? *pPropertyCount : 0));
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkSparseImageFormatProperties2(dec, &pProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pProperties = NULL;
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceExternalBufferProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalBufferProperties_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_simple_pointer(pExternalBufferInfo);
    if (pExternalBufferInfo)
        cmd_size += vn_sizeof_VkPhysicalDeviceExternalBufferInfo(pExternalBufferInfo);
    cmd_size += vn_sizeof_simple_pointer(pExternalBufferProperties);
    if (pExternalBufferProperties)
        cmd_size += vn_sizeof_VkExternalBufferProperties_partial(pExternalBufferProperties);

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceExternalBufferProperties(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalBufferProperties_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (vn_encode_simple_pointer(enc, pExternalBufferInfo))
        vn_encode_VkPhysicalDeviceExternalBufferInfo(enc, pExternalBufferInfo);
    if (vn_encode_simple_pointer(enc, pExternalBufferProperties))
        vn_encode_VkExternalBufferProperties_partial(enc, pExternalBufferProperties);
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceExternalBufferProperties_reply(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalBufferProperties_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip physicalDevice */
    /* skip pExternalBufferInfo */
    cmd_size += vn_sizeof_simple_pointer(pExternalBufferProperties);
    if (pExternalBufferProperties)
        cmd_size += vn_sizeof_VkExternalBufferProperties(pExternalBufferProperties);

    return cmd_size;
}

static inline void vn_decode_vkGetPhysicalDeviceExternalBufferProperties_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalBufferProperties_EXT);

    /* skip physicalDevice */
    /* skip pExternalBufferInfo */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkExternalBufferProperties(dec, pExternalBufferProperties);
    } else {
        pExternalBufferProperties = NULL;
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceExternalSemaphoreProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalSemaphoreProperties_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_simple_pointer(pExternalSemaphoreInfo);
    if (pExternalSemaphoreInfo)
        cmd_size += vn_sizeof_VkPhysicalDeviceExternalSemaphoreInfo(pExternalSemaphoreInfo);
    cmd_size += vn_sizeof_simple_pointer(pExternalSemaphoreProperties);
    if (pExternalSemaphoreProperties)
        cmd_size += vn_sizeof_VkExternalSemaphoreProperties_partial(pExternalSemaphoreProperties);

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceExternalSemaphoreProperties(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalSemaphoreProperties_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (vn_encode_simple_pointer(enc, pExternalSemaphoreInfo))
        vn_encode_VkPhysicalDeviceExternalSemaphoreInfo(enc, pExternalSemaphoreInfo);
    if (vn_encode_simple_pointer(enc, pExternalSemaphoreProperties))
        vn_encode_VkExternalSemaphoreProperties_partial(enc, pExternalSemaphoreProperties);
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceExternalSemaphoreProperties_reply(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalSemaphoreProperties_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip physicalDevice */
    /* skip pExternalSemaphoreInfo */
    cmd_size += vn_sizeof_simple_pointer(pExternalSemaphoreProperties);
    if (pExternalSemaphoreProperties)
        cmd_size += vn_sizeof_VkExternalSemaphoreProperties(pExternalSemaphoreProperties);

    return cmd_size;
}

static inline void vn_decode_vkGetPhysicalDeviceExternalSemaphoreProperties_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalSemaphoreProperties_EXT);

    /* skip physicalDevice */
    /* skip pExternalSemaphoreInfo */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkExternalSemaphoreProperties(dec, pExternalSemaphoreProperties);
    } else {
        pExternalSemaphoreProperties = NULL;
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceExternalFenceProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalFenceProperties_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_simple_pointer(pExternalFenceInfo);
    if (pExternalFenceInfo)
        cmd_size += vn_sizeof_VkPhysicalDeviceExternalFenceInfo(pExternalFenceInfo);
    cmd_size += vn_sizeof_simple_pointer(pExternalFenceProperties);
    if (pExternalFenceProperties)
        cmd_size += vn_sizeof_VkExternalFenceProperties_partial(pExternalFenceProperties);

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceExternalFenceProperties(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalFenceProperties_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (vn_encode_simple_pointer(enc, pExternalFenceInfo))
        vn_encode_VkPhysicalDeviceExternalFenceInfo(enc, pExternalFenceInfo);
    if (vn_encode_simple_pointer(enc, pExternalFenceProperties))
        vn_encode_VkExternalFenceProperties_partial(enc, pExternalFenceProperties);
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceExternalFenceProperties_reply(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalFenceProperties_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip physicalDevice */
    /* skip pExternalFenceInfo */
    cmd_size += vn_sizeof_simple_pointer(pExternalFenceProperties);
    if (pExternalFenceProperties)
        cmd_size += vn_sizeof_VkExternalFenceProperties(pExternalFenceProperties);

    return cmd_size;
}

static inline void vn_decode_vkGetPhysicalDeviceExternalFenceProperties_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceExternalFenceProperties_EXT);

    /* skip physicalDevice */
    /* skip pExternalFenceInfo */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkExternalFenceProperties(dec, pExternalFenceProperties);
    } else {
        pExternalFenceProperties = NULL;
    }
}

static inline size_t vn_sizeof_vkEnumeratePhysicalDeviceGroups(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumeratePhysicalDeviceGroups_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkInstance(&instance);
    cmd_size += vn_sizeof_simple_pointer(pPhysicalDeviceGroupCount);
    if (pPhysicalDeviceGroupCount)
        cmd_size += vn_sizeof_uint32_t(pPhysicalDeviceGroupCount);
    if (pPhysicalDeviceGroupProperties) {
        cmd_size += vn_sizeof_array_size((pPhysicalDeviceGroupCount ? *pPhysicalDeviceGroupCount : 0));
        for (uint32_t i = 0; i < (pPhysicalDeviceGroupCount ? *pPhysicalDeviceGroupCount : 0); i++)
            cmd_size += vn_sizeof_VkPhysicalDeviceGroupProperties_partial(&pPhysicalDeviceGroupProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkEnumeratePhysicalDeviceGroups(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumeratePhysicalDeviceGroups_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkInstance(enc, &instance);
    if (vn_encode_simple_pointer(enc, pPhysicalDeviceGroupCount))
        vn_encode_uint32_t(enc, pPhysicalDeviceGroupCount);
    if (pPhysicalDeviceGroupProperties) {
        vn_encode_array_size(enc, (pPhysicalDeviceGroupCount ? *pPhysicalDeviceGroupCount : 0));
        for (uint32_t i = 0; i < (pPhysicalDeviceGroupCount ? *pPhysicalDeviceGroupCount : 0); i++)
            vn_encode_VkPhysicalDeviceGroupProperties_partial(enc, &pPhysicalDeviceGroupProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkEnumeratePhysicalDeviceGroups_reply(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEnumeratePhysicalDeviceGroups_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip instance */
    cmd_size += vn_sizeof_simple_pointer(pPhysicalDeviceGroupCount);
    if (pPhysicalDeviceGroupCount)
        cmd_size += vn_sizeof_uint32_t(pPhysicalDeviceGroupCount);
    if (pPhysicalDeviceGroupProperties) {
        cmd_size += vn_sizeof_array_size((pPhysicalDeviceGroupCount ? *pPhysicalDeviceGroupCount : 0));
        for (uint32_t i = 0; i < (pPhysicalDeviceGroupCount ? *pPhysicalDeviceGroupCount : 0); i++)
            cmd_size += vn_sizeof_VkPhysicalDeviceGroupProperties(&pPhysicalDeviceGroupProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline VkResult vn_decode_vkEnumeratePhysicalDeviceGroups_reply(struct vn_cs_decoder *dec, VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkEnumeratePhysicalDeviceGroups_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip instance */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint32_t(dec, pPhysicalDeviceGroupCount);
    } else {
        pPhysicalDeviceGroupCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (pPhysicalDeviceGroupCount ? *pPhysicalDeviceGroupCount : 0));
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPhysicalDeviceGroupProperties(dec, &pPhysicalDeviceGroupProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pPhysicalDeviceGroupProperties = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkGetDeviceGroupPeerMemoryFeatures(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceGroupPeerMemoryFeatures_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_uint32_t(&heapIndex);
    cmd_size += vn_sizeof_uint32_t(&localDeviceIndex);
    cmd_size += vn_sizeof_uint32_t(&remoteDeviceIndex);
    cmd_size += vn_sizeof_simple_pointer(pPeerMemoryFeatures); /* out */

    return cmd_size;
}

static inline void vn_encode_vkGetDeviceGroupPeerMemoryFeatures(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceGroupPeerMemoryFeatures_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_uint32_t(enc, &heapIndex);
    vn_encode_uint32_t(enc, &localDeviceIndex);
    vn_encode_uint32_t(enc, &remoteDeviceIndex);
    vn_encode_simple_pointer(enc, pPeerMemoryFeatures); /* out */
}

static inline size_t vn_sizeof_vkGetDeviceGroupPeerMemoryFeatures_reply(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceGroupPeerMemoryFeatures_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip heapIndex */
    /* skip localDeviceIndex */
    /* skip remoteDeviceIndex */
    cmd_size += vn_sizeof_simple_pointer(pPeerMemoryFeatures);
    if (pPeerMemoryFeatures)
        cmd_size += vn_sizeof_VkFlags(pPeerMemoryFeatures);

    return cmd_size;
}

static inline void vn_decode_vkGetDeviceGroupPeerMemoryFeatures_reply(struct vn_cs_decoder *dec, VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetDeviceGroupPeerMemoryFeatures_EXT);

    /* skip device */
    /* skip heapIndex */
    /* skip localDeviceIndex */
    /* skip remoteDeviceIndex */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkFlags(dec, pPeerMemoryFeatures);
    } else {
        pPeerMemoryFeatures = NULL;
    }
}

static inline size_t vn_sizeof_vkGetDeviceQueue2(VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceQueue2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pQueueInfo);
    if (pQueueInfo)
        cmd_size += vn_sizeof_VkDeviceQueueInfo2(pQueueInfo);
    cmd_size += vn_sizeof_simple_pointer(pQueue);
    if (pQueue)
        cmd_size += vn_sizeof_VkQueue(pQueue);

    return cmd_size;
}

static inline void vn_encode_vkGetDeviceQueue2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceQueue2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pQueueInfo))
        vn_encode_VkDeviceQueueInfo2(enc, pQueueInfo);
    if (vn_encode_simple_pointer(enc, pQueue))
        vn_encode_VkQueue(enc, pQueue);
}

static inline size_t vn_sizeof_vkGetDeviceQueue2_reply(VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetDeviceQueue2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip pQueueInfo */
    cmd_size += vn_sizeof_simple_pointer(pQueue);
    if (pQueue)
        cmd_size += vn_sizeof_VkQueue(pQueue);

    return cmd_size;
}

static inline void vn_decode_vkGetDeviceQueue2_reply(struct vn_cs_decoder *dec, VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetDeviceQueue2_EXT);

    /* skip device */
    /* skip pQueueInfo */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkQueue(dec, pQueue);
    } else {
        pQueue = NULL;
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceToolProperties(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceToolProperties_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkPhysicalDevice(&physicalDevice);
    cmd_size += vn_sizeof_simple_pointer(pToolCount);
    if (pToolCount)
        cmd_size += vn_sizeof_uint32_t(pToolCount);
    if (pToolProperties) {
        cmd_size += vn_sizeof_array_size((pToolCount ? *pToolCount : 0));
        for (uint32_t i = 0; i < (pToolCount ? *pToolCount : 0); i++)
            cmd_size += vn_sizeof_VkPhysicalDeviceToolProperties_partial(&pToolProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkGetPhysicalDeviceToolProperties(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceToolProperties_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkPhysicalDevice(enc, &physicalDevice);
    if (vn_encode_simple_pointer(enc, pToolCount))
        vn_encode_uint32_t(enc, pToolCount);
    if (pToolProperties) {
        vn_encode_array_size(enc, (pToolCount ? *pToolCount : 0));
        for (uint32_t i = 0; i < (pToolCount ? *pToolCount : 0); i++)
            vn_encode_VkPhysicalDeviceToolProperties_partial(enc, &pToolProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkGetPhysicalDeviceToolProperties_reply(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPhysicalDeviceToolProperties_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip physicalDevice */
    cmd_size += vn_sizeof_simple_pointer(pToolCount);
    if (pToolCount)
        cmd_size += vn_sizeof_uint32_t(pToolCount);
    if (pToolProperties) {
        cmd_size += vn_sizeof_array_size((pToolCount ? *pToolCount : 0));
        for (uint32_t i = 0; i < (pToolCount ? *pToolCount : 0); i++)
            cmd_size += vn_sizeof_VkPhysicalDeviceToolProperties(&pToolProperties[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline VkResult vn_decode_vkGetPhysicalDeviceToolProperties_reply(struct vn_cs_decoder *dec, VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPhysicalDeviceToolProperties_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip physicalDevice */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint32_t(dec, pToolCount);
    } else {
        pToolCount = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (pToolCount ? *pToolCount : 0));
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkPhysicalDeviceToolProperties(dec, &pToolProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pToolProperties = NULL;
    }

    return ret;
}

static inline void vn_submit_vkEnumeratePhysicalDevices(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkInstance instance, uint32_t* pPhysicalDeviceCount, VkPhysicalDevice* pPhysicalDevices, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkEnumeratePhysicalDevices(instance, pPhysicalDeviceCount, pPhysicalDevices);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkEnumeratePhysicalDevices_reply(instance, pPhysicalDeviceCount, pPhysicalDevices) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkEnumeratePhysicalDevices(enc, cmd_flags, instance, pPhysicalDeviceCount, pPhysicalDevices);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceProperties(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceProperties(physicalDevice, pProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceProperties_reply(physicalDevice, pProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceProperties(enc, cmd_flags, physicalDevice, pProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceQueueFamilyProperties(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties* pQueueFamilyProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceQueueFamilyProperties(physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceQueueFamilyProperties_reply(physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceQueueFamilyProperties(enc, cmd_flags, physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceMemoryProperties(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties* pMemoryProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceMemoryProperties(physicalDevice, pMemoryProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceMemoryProperties_reply(physicalDevice, pMemoryProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceMemoryProperties(enc, cmd_flags, physicalDevice, pMemoryProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceFeatures(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceFeatures(physicalDevice, pFeatures);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceFeatures_reply(physicalDevice, pFeatures) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceFeatures(enc, cmd_flags, physicalDevice, pFeatures);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceFormatProperties(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties* pFormatProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceFormatProperties(physicalDevice, format, pFormatProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceFormatProperties_reply(physicalDevice, format, pFormatProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceFormatProperties(enc, cmd_flags, physicalDevice, format, pFormatProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceImageFormatProperties(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkImageFormatProperties* pImageFormatProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceImageFormatProperties(physicalDevice, format, type, tiling, usage, flags, pImageFormatProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceImageFormatProperties_reply(physicalDevice, format, type, tiling, usage, flags, pImageFormatProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceImageFormatProperties(enc, cmd_flags, physicalDevice, format, type, tiling, usage, flags, pImageFormatProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCreateDevice(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDevice* pDevice, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCreateDevice(physicalDevice, pCreateInfo, pAllocator, pDevice);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCreateDevice_reply(physicalDevice, pCreateInfo, pAllocator, pDevice) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCreateDevice(enc, cmd_flags, physicalDevice, pCreateInfo, pAllocator, pDevice);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkDestroyDevice(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkAllocationCallbacks* pAllocator, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkDestroyDevice(device, pAllocator);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkDestroyDevice_reply(device, pAllocator) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkDestroyDevice(enc, cmd_flags, device, pAllocator);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkEnumerateDeviceLayerProperties(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkLayerProperties* pProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkEnumerateDeviceLayerProperties(physicalDevice, pPropertyCount, pProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkEnumerateDeviceLayerProperties_reply(physicalDevice, pPropertyCount, pProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkEnumerateDeviceLayerProperties(enc, cmd_flags, physicalDevice, pPropertyCount, pProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkEnumerateDeviceExtensionProperties(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkEnumerateDeviceExtensionProperties(physicalDevice, pLayerName, pPropertyCount, pProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkEnumerateDeviceExtensionProperties_reply(physicalDevice, pLayerName, pPropertyCount, pProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkEnumerateDeviceExtensionProperties(enc, cmd_flags, physicalDevice, pLayerName, pPropertyCount, pProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetDeviceQueue(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetDeviceQueue(device, queueFamilyIndex, queueIndex, pQueue);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetDeviceQueue_reply(device, queueFamilyIndex, queueIndex, pQueue) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetDeviceQueue(enc, cmd_flags, device, queueFamilyIndex, queueIndex, pQueue);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkDeviceWaitIdle(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkDeviceWaitIdle(device);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkDeviceWaitIdle_reply(device) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkDeviceWaitIdle(enc, cmd_flags, device);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceSparseImageFormatProperties(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling, uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceSparseImageFormatProperties(physicalDevice, format, type, samples, usage, tiling, pPropertyCount, pProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceSparseImageFormatProperties_reply(physicalDevice, format, type, samples, usage, tiling, pPropertyCount, pProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceSparseImageFormatProperties(enc, cmd_flags, physicalDevice, format, type, samples, usage, tiling, pPropertyCount, pProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceFeatures2(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceFeatures2(physicalDevice, pFeatures);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceFeatures2_reply(physicalDevice, pFeatures) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceFeatures2(enc, cmd_flags, physicalDevice, pFeatures);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceProperties2(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceProperties2(physicalDevice, pProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceProperties2_reply(physicalDevice, pProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceProperties2(enc, cmd_flags, physicalDevice, pProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceFormatProperties2(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceFormatProperties2(physicalDevice, format, pFormatProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceFormatProperties2_reply(physicalDevice, format, pFormatProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceFormatProperties2(enc, cmd_flags, physicalDevice, format, pFormatProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceImageFormatProperties2(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceImageFormatProperties2(physicalDevice, pImageFormatInfo, pImageFormatProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceImageFormatProperties2_reply(physicalDevice, pImageFormatInfo, pImageFormatProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceImageFormatProperties2(enc, cmd_flags, physicalDevice, pImageFormatInfo, pImageFormatProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceQueueFamilyProperties2(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceQueueFamilyProperties2(physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceQueueFamilyProperties2_reply(physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceQueueFamilyProperties2(enc, cmd_flags, physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceMemoryProperties2(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceMemoryProperties2(physicalDevice, pMemoryProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceMemoryProperties2_reply(physicalDevice, pMemoryProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceMemoryProperties2(enc, cmd_flags, physicalDevice, pMemoryProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceSparseImageFormatProperties2(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceSparseImageFormatProperties2(physicalDevice, pFormatInfo, pPropertyCount, pProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceSparseImageFormatProperties2_reply(physicalDevice, pFormatInfo, pPropertyCount, pProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceSparseImageFormatProperties2(enc, cmd_flags, physicalDevice, pFormatInfo, pPropertyCount, pProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceExternalBufferProperties(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceExternalBufferProperties(physicalDevice, pExternalBufferInfo, pExternalBufferProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceExternalBufferProperties_reply(physicalDevice, pExternalBufferInfo, pExternalBufferProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceExternalBufferProperties(enc, cmd_flags, physicalDevice, pExternalBufferInfo, pExternalBufferProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceExternalSemaphoreProperties(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceExternalSemaphoreProperties(physicalDevice, pExternalSemaphoreInfo, pExternalSemaphoreProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceExternalSemaphoreProperties_reply(physicalDevice, pExternalSemaphoreInfo, pExternalSemaphoreProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceExternalSemaphoreProperties(enc, cmd_flags, physicalDevice, pExternalSemaphoreInfo, pExternalSemaphoreProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceExternalFenceProperties(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceExternalFenceProperties(physicalDevice, pExternalFenceInfo, pExternalFenceProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceExternalFenceProperties_reply(physicalDevice, pExternalFenceInfo, pExternalFenceProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceExternalFenceProperties(enc, cmd_flags, physicalDevice, pExternalFenceInfo, pExternalFenceProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkEnumeratePhysicalDeviceGroups(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkEnumeratePhysicalDeviceGroups(instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkEnumeratePhysicalDeviceGroups_reply(instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkEnumeratePhysicalDeviceGroups(enc, cmd_flags, instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetDeviceGroupPeerMemoryFeatures(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetDeviceGroupPeerMemoryFeatures(device, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetDeviceGroupPeerMemoryFeatures_reply(device, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetDeviceGroupPeerMemoryFeatures(enc, cmd_flags, device, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetDeviceQueue2(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetDeviceQueue2(device, pQueueInfo, pQueue);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetDeviceQueue2_reply(device, pQueueInfo, pQueue) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetDeviceQueue2(enc, cmd_flags, device, pQueueInfo, pQueue);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPhysicalDeviceToolProperties(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPhysicalDeviceToolProperties(physicalDevice, pToolCount, pToolProperties);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPhysicalDeviceToolProperties_reply(physicalDevice, pToolCount, pToolProperties) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPhysicalDeviceToolProperties(enc, cmd_flags, physicalDevice, pToolCount, pToolProperties);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline VkResult vn_call_vkEnumeratePhysicalDevices(struct vn_instance *vn_instance, VkInstance instance, uint32_t* pPhysicalDeviceCount, VkPhysicalDevice* pPhysicalDevices)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkEnumeratePhysicalDevices(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, instance, pPhysicalDeviceCount, pPhysicalDevices, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkEnumeratePhysicalDevices_reply(dec, instance, pPhysicalDeviceCount, pPhysicalDevices);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkEnumeratePhysicalDevices(struct vn_instance *vn_instance, VkInstance instance, uint32_t* pPhysicalDeviceCount, VkPhysicalDevice* pPhysicalDevices)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkEnumeratePhysicalDevices(vn_instance, 0, instance, pPhysicalDeviceCount, pPhysicalDevices, &submit);
}

static inline void vn_call_vkGetPhysicalDeviceProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceProperties(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetPhysicalDeviceProperties_reply(dec, physicalDevice, pProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetPhysicalDeviceProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceProperties(vn_instance, 0, physicalDevice, pProperties, &submit);
}

static inline void vn_call_vkGetPhysicalDeviceQueueFamilyProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties* pQueueFamilyProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceQueueFamilyProperties(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetPhysicalDeviceQueueFamilyProperties_reply(dec, physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetPhysicalDeviceQueueFamilyProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties* pQueueFamilyProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceQueueFamilyProperties(vn_instance, 0, physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties, &submit);
}

static inline void vn_call_vkGetPhysicalDeviceMemoryProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties* pMemoryProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceMemoryProperties(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pMemoryProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetPhysicalDeviceMemoryProperties_reply(dec, physicalDevice, pMemoryProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetPhysicalDeviceMemoryProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties* pMemoryProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceMemoryProperties(vn_instance, 0, physicalDevice, pMemoryProperties, &submit);
}

static inline void vn_call_vkGetPhysicalDeviceFeatures(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceFeatures(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pFeatures, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetPhysicalDeviceFeatures_reply(dec, physicalDevice, pFeatures);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetPhysicalDeviceFeatures(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceFeatures(vn_instance, 0, physicalDevice, pFeatures, &submit);
}

static inline void vn_call_vkGetPhysicalDeviceFormatProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties* pFormatProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceFormatProperties(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, format, pFormatProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetPhysicalDeviceFormatProperties_reply(dec, physicalDevice, format, pFormatProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetPhysicalDeviceFormatProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties* pFormatProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceFormatProperties(vn_instance, 0, physicalDevice, format, pFormatProperties, &submit);
}

static inline VkResult vn_call_vkGetPhysicalDeviceImageFormatProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkImageFormatProperties* pImageFormatProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceImageFormatProperties(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, format, type, tiling, usage, flags, pImageFormatProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkGetPhysicalDeviceImageFormatProperties_reply(dec, physicalDevice, format, type, tiling, usage, flags, pImageFormatProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkGetPhysicalDeviceImageFormatProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkImageFormatProperties* pImageFormatProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceImageFormatProperties(vn_instance, 0, physicalDevice, format, type, tiling, usage, flags, pImageFormatProperties, &submit);
}

static inline VkResult vn_call_vkCreateDevice(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDevice* pDevice)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkCreateDevice(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pCreateInfo, pAllocator, pDevice, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkCreateDevice_reply(dec, physicalDevice, pCreateInfo, pAllocator, pDevice);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCreateDevice(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDevice* pDevice)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCreateDevice(vn_instance, 0, physicalDevice, pCreateInfo, pAllocator, pDevice, &submit);
}

static inline void vn_call_vkDestroyDevice(struct vn_instance *vn_instance, VkDevice device, const VkAllocationCallbacks* pAllocator)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkDestroyDevice(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pAllocator, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkDestroyDevice_reply(dec, device, pAllocator);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkDestroyDevice(struct vn_instance *vn_instance, VkDevice device, const VkAllocationCallbacks* pAllocator)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkDestroyDevice(vn_instance, 0, device, pAllocator, &submit);
}

static inline VkResult vn_call_vkEnumerateDeviceLayerProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkLayerProperties* pProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkEnumerateDeviceLayerProperties(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pPropertyCount, pProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkEnumerateDeviceLayerProperties_reply(dec, physicalDevice, pPropertyCount, pProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkEnumerateDeviceLayerProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkLayerProperties* pProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkEnumerateDeviceLayerProperties(vn_instance, 0, physicalDevice, pPropertyCount, pProperties, &submit);
}

static inline VkResult vn_call_vkEnumerateDeviceExtensionProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkEnumerateDeviceExtensionProperties(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pLayerName, pPropertyCount, pProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkEnumerateDeviceExtensionProperties_reply(dec, physicalDevice, pLayerName, pPropertyCount, pProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkEnumerateDeviceExtensionProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkEnumerateDeviceExtensionProperties(vn_instance, 0, physicalDevice, pLayerName, pPropertyCount, pProperties, &submit);
}

static inline void vn_call_vkGetDeviceQueue(struct vn_instance *vn_instance, VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetDeviceQueue(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, queueFamilyIndex, queueIndex, pQueue, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetDeviceQueue_reply(dec, device, queueFamilyIndex, queueIndex, pQueue);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetDeviceQueue(struct vn_instance *vn_instance, VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetDeviceQueue(vn_instance, 0, device, queueFamilyIndex, queueIndex, pQueue, &submit);
}

static inline VkResult vn_call_vkDeviceWaitIdle(struct vn_instance *vn_instance, VkDevice device)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkDeviceWaitIdle(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkDeviceWaitIdle_reply(dec, device);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkDeviceWaitIdle(struct vn_instance *vn_instance, VkDevice device)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkDeviceWaitIdle(vn_instance, 0, device, &submit);
}

static inline void vn_call_vkGetPhysicalDeviceSparseImageFormatProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling, uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceSparseImageFormatProperties(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, format, type, samples, usage, tiling, pPropertyCount, pProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetPhysicalDeviceSparseImageFormatProperties_reply(dec, physicalDevice, format, type, samples, usage, tiling, pPropertyCount, pProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetPhysicalDeviceSparseImageFormatProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling, uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceSparseImageFormatProperties(vn_instance, 0, physicalDevice, format, type, samples, usage, tiling, pPropertyCount, pProperties, &submit);
}

static inline void vn_call_vkGetPhysicalDeviceFeatures2(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceFeatures2(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pFeatures, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetPhysicalDeviceFeatures2_reply(dec, physicalDevice, pFeatures);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetPhysicalDeviceFeatures2(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceFeatures2(vn_instance, 0, physicalDevice, pFeatures, &submit);
}

static inline void vn_call_vkGetPhysicalDeviceProperties2(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceProperties2(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetPhysicalDeviceProperties2_reply(dec, physicalDevice, pProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetPhysicalDeviceProperties2(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceProperties2(vn_instance, 0, physicalDevice, pProperties, &submit);
}

static inline void vn_call_vkGetPhysicalDeviceFormatProperties2(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceFormatProperties2(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, format, pFormatProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetPhysicalDeviceFormatProperties2_reply(dec, physicalDevice, format, pFormatProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetPhysicalDeviceFormatProperties2(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceFormatProperties2(vn_instance, 0, physicalDevice, format, pFormatProperties, &submit);
}

static inline VkResult vn_call_vkGetPhysicalDeviceImageFormatProperties2(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceImageFormatProperties2(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pImageFormatInfo, pImageFormatProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkGetPhysicalDeviceImageFormatProperties2_reply(dec, physicalDevice, pImageFormatInfo, pImageFormatProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkGetPhysicalDeviceImageFormatProperties2(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceImageFormatProperties2(vn_instance, 0, physicalDevice, pImageFormatInfo, pImageFormatProperties, &submit);
}

static inline void vn_call_vkGetPhysicalDeviceQueueFamilyProperties2(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceQueueFamilyProperties2(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetPhysicalDeviceQueueFamilyProperties2_reply(dec, physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetPhysicalDeviceQueueFamilyProperties2(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceQueueFamilyProperties2(vn_instance, 0, physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties, &submit);
}

static inline void vn_call_vkGetPhysicalDeviceMemoryProperties2(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceMemoryProperties2(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pMemoryProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetPhysicalDeviceMemoryProperties2_reply(dec, physicalDevice, pMemoryProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetPhysicalDeviceMemoryProperties2(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceMemoryProperties2(vn_instance, 0, physicalDevice, pMemoryProperties, &submit);
}

static inline void vn_call_vkGetPhysicalDeviceSparseImageFormatProperties2(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceSparseImageFormatProperties2(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pFormatInfo, pPropertyCount, pProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetPhysicalDeviceSparseImageFormatProperties2_reply(dec, physicalDevice, pFormatInfo, pPropertyCount, pProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetPhysicalDeviceSparseImageFormatProperties2(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceSparseImageFormatProperties2(vn_instance, 0, physicalDevice, pFormatInfo, pPropertyCount, pProperties, &submit);
}

static inline void vn_call_vkGetPhysicalDeviceExternalBufferProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceExternalBufferProperties(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pExternalBufferInfo, pExternalBufferProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetPhysicalDeviceExternalBufferProperties_reply(dec, physicalDevice, pExternalBufferInfo, pExternalBufferProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetPhysicalDeviceExternalBufferProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceExternalBufferProperties(vn_instance, 0, physicalDevice, pExternalBufferInfo, pExternalBufferProperties, &submit);
}

static inline void vn_call_vkGetPhysicalDeviceExternalSemaphoreProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceExternalSemaphoreProperties(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pExternalSemaphoreInfo, pExternalSemaphoreProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetPhysicalDeviceExternalSemaphoreProperties_reply(dec, physicalDevice, pExternalSemaphoreInfo, pExternalSemaphoreProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetPhysicalDeviceExternalSemaphoreProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceExternalSemaphoreProperties(vn_instance, 0, physicalDevice, pExternalSemaphoreInfo, pExternalSemaphoreProperties, &submit);
}

static inline void vn_call_vkGetPhysicalDeviceExternalFenceProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceExternalFenceProperties(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pExternalFenceInfo, pExternalFenceProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetPhysicalDeviceExternalFenceProperties_reply(dec, physicalDevice, pExternalFenceInfo, pExternalFenceProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetPhysicalDeviceExternalFenceProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceExternalFenceProperties(vn_instance, 0, physicalDevice, pExternalFenceInfo, pExternalFenceProperties, &submit);
}

static inline VkResult vn_call_vkEnumeratePhysicalDeviceGroups(struct vn_instance *vn_instance, VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkEnumeratePhysicalDeviceGroups(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkEnumeratePhysicalDeviceGroups_reply(dec, instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkEnumeratePhysicalDeviceGroups(struct vn_instance *vn_instance, VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkEnumeratePhysicalDeviceGroups(vn_instance, 0, instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties, &submit);
}

static inline void vn_call_vkGetDeviceGroupPeerMemoryFeatures(struct vn_instance *vn_instance, VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetDeviceGroupPeerMemoryFeatures(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetDeviceGroupPeerMemoryFeatures_reply(dec, device, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetDeviceGroupPeerMemoryFeatures(struct vn_instance *vn_instance, VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetDeviceGroupPeerMemoryFeatures(vn_instance, 0, device, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures, &submit);
}

static inline void vn_call_vkGetDeviceQueue2(struct vn_instance *vn_instance, VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetDeviceQueue2(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pQueueInfo, pQueue, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetDeviceQueue2_reply(dec, device, pQueueInfo, pQueue);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetDeviceQueue2(struct vn_instance *vn_instance, VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetDeviceQueue2(vn_instance, 0, device, pQueueInfo, pQueue, &submit);
}

static inline VkResult vn_call_vkGetPhysicalDeviceToolProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceToolProperties(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, physicalDevice, pToolCount, pToolProperties, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkGetPhysicalDeviceToolProperties_reply(dec, physicalDevice, pToolCount, pToolProperties);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkGetPhysicalDeviceToolProperties(struct vn_instance *vn_instance, VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPhysicalDeviceToolProperties(vn_instance, 0, physicalDevice, pToolCount, pToolProperties, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_DEVICE_H */
