/* -*- mode: c; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/*
 * Copyright (c) 2006 Kungliga Tekniska Högskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "k5-int.h"

#define U(x) (uint8_t *)x

/*
 * This PAC and keys are copied (with permission) from Samba torture
 * regression test suite, they where created by Andrew Bartlet.
 */

static const unsigned char saved_pac[] = {
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xd8, 0x01, 0x00, 0x00,
    0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
    0x20, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
    0x40, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
    0x58, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc,
    0xc8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x30, 0xdf, 0xa6, 0xcb,
    0x4f, 0x7d, 0xc5, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0xc0, 0x3c, 0x4e, 0x59, 0x62, 0x73, 0xc5, 0x01, 0xc0, 0x3c, 0x4e, 0x59,
    0x62, 0x73, 0xc5, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x16, 0x00, 0x16, 0x00,
    0x04, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x14, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x02, 0x00, 0x65, 0x00, 0x00, 0x00,
    0xed, 0x03, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x02, 0x00,
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x16, 0x00, 0x20, 0x00, 0x02, 0x00, 0x16, 0x00, 0x18, 0x00,
    0x24, 0x00, 0x02, 0x00, 0x28, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
    0x57, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x33, 0x00, 0x46, 0x00, 0x49, 0x00, 0x4e, 0x00,
    0x41, 0x00, 0x4c, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
    0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x57, 0x00, 0x32, 0x00,
    0x30, 0x00, 0x30, 0x00, 0x33, 0x00, 0x46, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x41, 0x00, 0x4c, 0x00,
    0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x57, 0x00, 0x49, 0x00,
    0x4e, 0x00, 0x32, 0x00, 0x4b, 0x00, 0x33, 0x00, 0x54, 0x00, 0x48, 0x00, 0x49, 0x00, 0x4e, 0x00,
    0x4b, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
    0x15, 0x00, 0x00, 0x00, 0x11, 0x2f, 0xaf, 0xb5, 0x90, 0x04, 0x1b, 0xec, 0x50, 0x3b, 0xec, 0xdc,
    0x01, 0x00, 0x00, 0x00, 0x30, 0x00, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x80, 0x66, 0x28, 0xea, 0x37, 0x80, 0xc5, 0x01, 0x16, 0x00, 0x77, 0x00, 0x32, 0x00, 0x30, 0x00,
    0x30, 0x00, 0x33, 0x00, 0x66, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x6c, 0x00, 0x24, 0x00,
    0x76, 0xff, 0xff, 0xff, 0x37, 0xd5, 0xb0, 0xf7, 0x24, 0xf0, 0xd6, 0xd4, 0xec, 0x09, 0x86, 0x5a,
    0xa0, 0xe8, 0xc3, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0xff, 0xb4, 0xd8, 0xb8, 0xfe,
    0x83, 0xb3, 0x13, 0x3f, 0xfc, 0x5c, 0x41, 0xad, 0xe2, 0x64, 0x83, 0xe0, 0x00, 0x00, 0x00, 0x00
};

static unsigned int type_1_length = 472;

static const krb5_keyblock kdc_keyblock = {
    0, ENCTYPE_ARCFOUR_HMAC,
    16, U("\xB2\x86\x75\x71\x48\xAF\x7F\xD2\x52\xC5\x36\x03\xA1\x50\xB7\xE7")
};

static const krb5_keyblock member_keyblock = {
    0, ENCTYPE_ARCFOUR_HMAC,
    16, U("\xD2\x17\xFA\xEA\xE5\xE6\xB5\xF9\x5C\xCC\x94\x07\x7A\xB8\xA5\xFC")
};

static time_t authtime = 1120440609;
static const char *user = "w2003final$@WIN2K3.THINKER.LOCAL";

/* The S4U2Self PACs below were collected by debugging krb5-mit code on
 * Linux, talking with a Windows 2008 KDC server over the network. */

static const unsigned char s4u_pac_regular[] = {
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0xa0, 0x01, 0x00, 0x00,
    0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0a, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
    0xf8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0c, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00,
    0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
    0x48, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x07, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
    0x58, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc,
    0x90, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0xc9, 0x36, 0xfd, 0x57,
    0x5b, 0x59, 0xd4, 0x01, 0xc9, 0x36, 0xfd, 0x57,
    0x5b, 0x59, 0xd4, 0x01, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0x0a, 0x00, 0x0a, 0x00,
    0x04, 0x00, 0x02, 0x00, 0x0a, 0x00, 0x0a, 0x00,
    0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x14, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x76, 0x04, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x02, 0x00,
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x08, 0x00,
    0x20, 0x00, 0x02, 0x00, 0x08, 0x00, 0x0a, 0x00,
    0x24, 0x00, 0x02, 0x00, 0x28, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x38, 0x00,
    0x75, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x38, 0x00,
    0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x01, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x00, 0x00, 0x00, 0x57, 0x00, 0x44, 0x00,
    0x43, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
    0x41, 0x00, 0x43, 0x00, 0x4d, 0x00, 0x45, 0x00,
    0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00,
    0x74, 0xa0, 0x8d, 0x00, 0x3f, 0xa5, 0xc2, 0xe9,
    0x60, 0x91, 0xe1, 0x22, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x89, 0xa1, 0x25, 0xd0, 0x59, 0xd4, 0x01,
    0x0a, 0x00, 0x77, 0x00, 0x32, 0x00, 0x6b, 0x00,
    0x38, 0x00, 0x75, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x12, 0x00, 0x10, 0x00, 0x10, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x38, 0x00,
    0x75, 0x00, 0x40, 0x00, 0x61, 0x00, 0x62, 0x00,
    0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x41, 0x00, 0x43, 0x00, 0x4d, 0x00, 0x45, 0x00,
    0x2e, 0x00, 0x43, 0x00, 0x4f, 0x00, 0x4d, 0x00,
    0x10, 0x00, 0x00, 0x00, 0x88, 0x1d, 0x40, 0x84,
    0x7a, 0x01, 0x7c, 0x80, 0x74, 0xe3, 0x6a, 0x6b,
    0x76, 0xff, 0xff, 0xff, 0x1a, 0x1d, 0x97, 0xd2,
    0x39, 0xf4, 0xb8, 0xb2, 0x53, 0xae, 0x77, 0xdb,
    0x6c, 0x02, 0xd4, 0x3d, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char s4u_pac_enterprise[] = {
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0xa0, 0x01, 0x00, 0x00,
    0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0a, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
    0xf8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0c, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00,
    0x18, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
    0x50, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x07, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
    0x60, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc,
    0x90, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0xc9, 0x36, 0xfd, 0x57,
    0x5b, 0x59, 0xd4, 0x01, 0xc9, 0x36, 0xfd, 0x57,
    0x5b, 0x59, 0xd4, 0x01, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0x0a, 0x00, 0x0a, 0x00,
    0x04, 0x00, 0x02, 0x00, 0x0a, 0x00, 0x0a, 0x00,
    0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x14, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x76, 0x04, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x02, 0x00,
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x08, 0x00,
    0x20, 0x00, 0x02, 0x00, 0x08, 0x00, 0x0a, 0x00,
    0x24, 0x00, 0x02, 0x00, 0x28, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x38, 0x00,
    0x75, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x38, 0x00,
    0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x01, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x00, 0x00, 0x00, 0x57, 0x00, 0x44, 0x00,
    0x43, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
    0x41, 0x00, 0x43, 0x00, 0x4d, 0x00, 0x45, 0x00,
    0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00,
    0x74, 0xa0, 0x8d, 0x00, 0x3f, 0xa5, 0xc2, 0xe9,
    0x60, 0x91, 0xe1, 0x22, 0x00, 0x00, 0x00, 0x00,
    0x80, 0xe1, 0x9b, 0xe2, 0xe0, 0x59, 0xd4, 0x01,
    0x12, 0x00, 0x77, 0x00, 0x32, 0x00, 0x6b, 0x00,
    0x38, 0x00, 0x75, 0x00, 0x40, 0x00, 0x61, 0x00,
    0x62, 0x00, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x12, 0x00, 0x10, 0x00, 0x10, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x38, 0x00,
    0x75, 0x00, 0x40, 0x00, 0x61, 0x00, 0x62, 0x00,
    0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x41, 0x00, 0x43, 0x00, 0x4d, 0x00, 0x45, 0x00,
    0x2e, 0x00, 0x43, 0x00, 0x4f, 0x00, 0x4d, 0x00,
    0x10, 0x00, 0x00, 0x00, 0xfb, 0xe5, 0x03, 0x12,
    0x13, 0x00, 0x6c, 0x8e, 0x81, 0x97, 0x09, 0xea,
    0x76, 0xff, 0xff, 0xff, 0xba, 0xcd, 0x3a, 0xbc,
    0x67, 0x61, 0x16, 0x9f, 0xb8, 0x96, 0xbc, 0xe1,
    0xbe, 0x34, 0xe1, 0x77, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char s4u_pac_xrealm[] = {
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0xa0, 0x01, 0x00, 0x00,
    0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0a, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00,
    0xf8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0c, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00,
    0x20, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
    0x58, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x07, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
    0x68, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc,
    0x90, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0xc9, 0x36, 0xfd, 0x57,
    0x5b, 0x59, 0xd4, 0x01, 0xc9, 0x36, 0xfd, 0x57,
    0x5b, 0x59, 0xd4, 0x01, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0x0a, 0x00, 0x0a, 0x00,
    0x04, 0x00, 0x02, 0x00, 0x0a, 0x00, 0x0a, 0x00,
    0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x14, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x76, 0x04, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x02, 0x00,
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x08, 0x00,
    0x20, 0x00, 0x02, 0x00, 0x08, 0x00, 0x0a, 0x00,
    0x24, 0x00, 0x02, 0x00, 0x28, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x38, 0x00,
    0x75, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x38, 0x00,
    0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x01, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x00, 0x00, 0x00, 0x57, 0x00, 0x44, 0x00,
    0x43, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
    0x41, 0x00, 0x43, 0x00, 0x4d, 0x00, 0x45, 0x00,
    0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00,
    0x74, 0xa0, 0x8d, 0x00, 0x3f, 0xa5, 0xc2, 0xe9,
    0x60, 0x91, 0xe1, 0x22, 0x00, 0x00, 0x00, 0x00,
    0x80, 0xa8, 0x60, 0x1b, 0x2b, 0x5a, 0xd4, 0x01,
    0x1c, 0x00, 0x77, 0x00, 0x32, 0x00, 0x6b, 0x00,
    0x38, 0x00, 0x75, 0x00, 0x40, 0x00, 0x41, 0x00,
    0x43, 0x00, 0x4d, 0x00, 0x45, 0x00, 0x2e, 0x00,
    0x43, 0x00, 0x4f, 0x00, 0x4d, 0x00, 0x00, 0x00,
    0x12, 0x00, 0x10, 0x00, 0x10, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x38, 0x00,
    0x75, 0x00, 0x40, 0x00, 0x61, 0x00, 0x62, 0x00,
    0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x41, 0x00, 0x43, 0x00, 0x4d, 0x00, 0x45, 0x00,
    0x2e, 0x00, 0x43, 0x00, 0x4f, 0x00, 0x4d, 0x00,
    0x10, 0x00, 0x00, 0x00, 0x11, 0x27, 0x3a, 0xa5,
    0x41, 0x84, 0x87, 0xdf, 0xc6, 0xd7, 0x29, 0x26,
    0x76, 0xff, 0xff, 0xff, 0xba, 0x7c, 0x7a, 0x84,
    0xd2, 0x2b, 0x9c, 0x58, 0xed, 0x2f, 0xdf, 0x23,
    0x09, 0x15, 0x05, 0x6b, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char s4u_pac_ent_xrealm[] = {
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0xa0, 0x01, 0x00, 0x00,
    0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0a, 0x00, 0x00, 0x00, 0x2e, 0x00, 0x00, 0x00,
    0xf8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0c, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00,
    0x28, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
    0x60, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x07, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
    0x70, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x10, 0x08, 0x00, 0xcc, 0xcc, 0xcc, 0xcc,
    0x90, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0xc9, 0x36, 0xfd, 0x57,
    0x5b, 0x59, 0xd4, 0x01, 0xc9, 0x36, 0xfd, 0x57,
    0x5b, 0x59, 0xd4, 0x01, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0x0a, 0x00, 0x0a, 0x00,
    0x04, 0x00, 0x02, 0x00, 0x0a, 0x00, 0x0a, 0x00,
    0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0c, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x14, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x76, 0x04, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x02, 0x00,
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x08, 0x00,
    0x20, 0x00, 0x02, 0x00, 0x08, 0x00, 0x0a, 0x00,
    0x24, 0x00, 0x02, 0x00, 0x28, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x38, 0x00,
    0x75, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x38, 0x00,
    0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x01, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
    0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x03, 0x00, 0x00, 0x00, 0x57, 0x00, 0x44, 0x00,
    0x43, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
    0x41, 0x00, 0x43, 0x00, 0x4d, 0x00, 0x45, 0x00,
    0x04, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x15, 0x00, 0x00, 0x00,
    0x74, 0xa0, 0x8d, 0x00, 0x3f, 0xa5, 0xc2, 0xe9,
    0x60, 0x91, 0xe1, 0x22, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x87, 0x39, 0x5b, 0x4f, 0x5a, 0xd4, 0x01,
    0x24, 0x00, 0x77, 0x00, 0x32, 0x00, 0x6b, 0x00,
    0x38, 0x00, 0x75, 0x00, 0x40, 0x00, 0x61, 0x00,
    0x62, 0x00, 0x63, 0x00, 0x40, 0x00, 0x41, 0x00,
    0x43, 0x00, 0x4d, 0x00, 0x45, 0x00, 0x2e, 0x00,
    0x43, 0x00, 0x4f, 0x00, 0x4d, 0x00, 0x00, 0x00,
    0x12, 0x00, 0x10, 0x00, 0x10, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x77, 0x00, 0x32, 0x00, 0x6b, 0x00, 0x38, 0x00,
    0x75, 0x00, 0x40, 0x00, 0x61, 0x00, 0x62, 0x00,
    0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x41, 0x00, 0x43, 0x00, 0x4d, 0x00, 0x45, 0x00,
    0x2e, 0x00, 0x43, 0x00, 0x4f, 0x00, 0x4d, 0x00,
    0x10, 0x00, 0x00, 0x00, 0xa3, 0x5d, 0xc5, 0xfe,
    0x80, 0x6b, 0x62, 0x0c, 0xb1, 0x2f, 0x43, 0xa2,
    0x76, 0xff, 0xff, 0xff, 0x95, 0x40, 0x76, 0xe4,
    0x0a, 0x0a, 0xb9, 0xe7, 0x93, 0x0f, 0x05, 0xf8,
    0x8a, 0x81, 0x9c, 0x9c, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char fuzz1[] = {
    0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
    0x06, 0xff, 0xff, 0xff, 0x00, 0x00, 0xf5
};

static const unsigned char fuzz2[] = {
    0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x20
};

static const char *s4u_principal = "w2k8u@ACME.COM";
static const char *s4u_enterprise = "w2k8u@abc@ACME.COM";

static const krb5_keyblock s4u_srv_key = {
    0, ENCTYPE_AES256_CTS_HMAC_SHA1_96,
    32, U("\x14\xDF\xB5\xB2\xCD\xB4\x2C\x88\x94\xDA\x2F\xA8\x82\xE9\x72\x9F"
          "\x4A\x4D\xC7\x4B\xA0\x2A\x24\x2C\xC6\xA8\xD7\x10\x79\xB9\xAD\x9A")
};

static const krb5_keyblock s4u_tgt_srv_key = {
    0, ENCTYPE_AES256_CTS_HMAC_SHA1_96,
    32, U("\x42\x0C\x39\xC5\x1A\x17\x54\x04\x45\x1F\x95\x6B\x8C\x58\xE0\xF4"
          "\x1B\xCA\x66\x9A\x64\x47\x95\xCA\x6E\x3A\xD5\x5A\x3B\x91\x8C\x9F")
};

static size_t s4u_logon_info_buffer_len = 416;

struct pac_and_info {
    time_t authtime;
    krb5_boolean is_enterprise;
    krb5_boolean is_xrealm;
    const unsigned char *data;
    size_t length;
};

static const struct pac_and_info s4u_pacs[] = {
    { 1538430362, 0, 0, s4u_pac_regular, sizeof(s4u_pac_regular) },
    { 1538437551, 1, 0, s4u_pac_enterprise, sizeof(s4u_pac_enterprise) },
    { 1538469429, 0, 1, s4u_pac_xrealm, sizeof(s4u_pac_xrealm) },
    { 1538484998, 1, 1, s4u_pac_ent_xrealm, sizeof(s4u_pac_ent_xrealm) },
    { 0, 0, 0, NULL, 0 }
};

#if !defined(__cplusplus) && (__GNUC__ > 2)
static void err(krb5_context ctx, krb5_error_code code, const char *fmt, ...)
    __attribute__((__format__(__printf__, 3, 0)));
#endif

static void
err(krb5_context ctx, krb5_error_code code, const char *fmt, ...)
{
    va_list ap;
    char *msg;
    const char *errmsg = NULL;

    va_start(ap, fmt);
    if (vasprintf(&msg, fmt, ap) < 0)
        exit(1);
    va_end(ap);
    if (ctx && code)
        errmsg = krb5_get_error_message(ctx, code);
    if (errmsg)
        fprintf(stderr, "t_pac: %s: %s\n", msg, errmsg);
    else
        fprintf(stderr, "t_pac: %s\n", msg);
    exit(1);
}

static void
check_pac(krb5_context context, int index, const unsigned char *pdata,
          size_t plen, time_t auth_time, krb5_principal p,
          size_t type_one_buffer_length, krb5_boolean with_realm,
          const krb5_keyblock *server_key, const krb5_keyblock *kdc_key)
{
    krb5_error_code ret;
    const krb5_keyblock *kdc_sign_key;
    krb5_data data;
    krb5_pac pac;

    /* If we don't have the KDC key (S4U cases), just use another key as we'd
     * skip the KDC signature when verifying. */
    kdc_sign_key = (kdc_key == NULL) ? &kdc_keyblock : kdc_key;

    ret = krb5_pac_parse(context, pdata, plen, &pac);
    if (ret)
        err(context, ret, "[pac: %d] krb5_pac_parse", index);

    ret = krb5_pac_verify_ext(context, pac, auth_time, p, server_key, kdc_key,
                              with_realm);
    if (ret)
        err(context, ret, "[pac: %d] krb5_pac_verify_ext", index);

    ret = krb5_pac_sign_ext(context, pac, auth_time, p, server_key,
                            kdc_sign_key, with_realm, &data);
    if (ret)
        err(context, ret, "[pac: %d] krb5_pac_sign_ext", index);

    krb5_pac_free(context, pac);

    ret = krb5_pac_parse(context, data.data, data.length, &pac);
    krb5_free_data_contents(context, &data);
    if (ret)
        err(context, ret, "[pac: %d] krb5_pac_parse 2", index);

    ret = krb5_pac_verify_ext(context, pac, auth_time, p, server_key, kdc_key,
                              with_realm);
    if (ret)
        err(context, ret, "[pac: %d] krb5_pac_verify_ext 2", index);

    /* make a copy and try to reproduce it */
    {
        uint32_t *list;
        size_t len, i;
        krb5_pac pac2;

        ret = krb5_pac_init(context, &pac2);
        if (ret)
            err(context, ret, "[pac: %d] krb5_pac_init", index);

        /* our two user buffer plus the three "system" buffers */
        ret = krb5_pac_get_types(context, pac, &len, &list);
        if (ret)
            err(context, ret, "[pac: %d] krb5_pac_get_types", index);

        for (i = 0; i < len; i++) {
            /* skip server_cksum, privsvr_cksum, and logon_name */
            if (list[i] == 6 || list[i] == 7 || list[i] == 10)
                continue;

            ret = krb5_pac_get_buffer(context, pac, list[i], &data);
            if (ret)
                err(context, ret, "[pac: %d] krb5_pac_get_buffer", index);

            if (list[i] == 1) {
                if (type_one_buffer_length != data.length) {
                    err(context, 0, "[pac: %d] type 1 have wrong length: %lu",
                        index, (unsigned long)data.length);
                }
            } else if (list[i] != 12) {
                err(context, 0, "[pac: %d] unknown type %lu",
                    index, (unsigned long)list[i]);
            }

            ret = krb5_pac_add_buffer(context, pac2, list[i], &data);
            if (ret)
                err(context, ret, "[pac: %d] krb5_pac_add_buffer", index);
            krb5_free_data_contents(context, &data);
        }
        free(list);

        ret = krb5_pac_sign_ext(context, pac2, auth_time, p, server_key,
                                kdc_sign_key, with_realm, &data);
        if (ret)
            err(context, ret, "[pac: %d] krb5_pac_sign_ext 4", index);

        krb5_pac_free(context, pac2);

        ret = krb5_pac_parse(context, data.data, data.length, &pac2);
        if (ret)
            err(context, ret, "[pac: %d] krb5_pac_parse 4", index);

        ret = krb5_pac_verify_ext(context, pac2, auth_time, p, server_key,
                                  kdc_key, with_realm);
        if (ret)
            err(context, ret, "[pac: %d] krb5_pac_verify_ext 4", index);

        krb5_free_data_contents(context, &data);

        krb5_pac_free(context, pac2);
    }

    krb5_pac_free(context, pac);
}

static const krb5_keyblock ticket_sig_krbtgt_key = {
    0, ENCTYPE_AES256_CTS_HMAC_SHA1_96,
    32, U("\x03\x73\x81\xEC\x43\x96\x7B\xC2\xAC\x3D\xF5\x2A\xAE\x95\xA6\x8E"
          "\xBE\x24\x58\xDB\xCE\x52\x28\x20\xAF\x5E\xB7\x04\xA2\x22\x71\x4F")
};

static const krb5_keyblock ticket_sig_server_key = {
    0, ENCTYPE_AES256_CTS_HMAC_SHA1_96,
    32, U("\x11\x4A\x84\xE3\x14\x8F\xAA\xB1\xFA\x7B\x53\x51\xB2\x8A\xC2\xF1"
          "\xFD\x19\x6D\x61\xE0\xF3\xF2\x3E\x1F\xDB\xD3\xC1\x79\x7D\xC1\xEE")
};

/* A ticket issued by an Active Directory KDC (Windows Server 2022), containing
 * a PAC with a full checksum. */
static const krb5_data ticket_data = {
    .length = 1307, .data =
    "\x61\x82\x05\x17\x30\x82\x05\x13\xA0\x03\x02\x01\x05\xA1\x0F\x1B"
    "\x0D\x57\x32\x30\x32\x32\x2D\x4C\x37\x2E\x42\x41\x53\x45\xA2\x2A"
    "\x30\x28\xA0\x03\x02\x01\x01\xA1\x21\x30\x1F\x1B\x04\x63\x69\x66"
    "\x73\x1B\x17\x77\x32\x30\x32\x32\x2D\x31\x31\x38\x2E\x77\x32\x30"
    "\x32\x32\x2D\x6C\x37\x2E\x62\x61\x73\x65\xA3\x82\x04\xCD\x30\x82"
    "\x04\xC9\xA0\x03\x02\x01\x12\xA1\x03\x02\x01\x05\xA2\x82\x04\xBB"
    "\x04\x82\x04\xB7\x44\x5C\x7B\x5A\x3F\x2E\xA3\x50\x34\xDE\xB0\x69"
    "\x23\x2D\x47\x89\x2C\xC0\xA3\xF9\xDD\x70\xAA\xA5\x1E\xFE\x74\xE5"
    "\x19\xA2\x4F\x65\x6C\x9E\x00\xB4\x60\x00\x7C\x0C\x29\x43\x31\x99"
    "\x77\x02\x73\xED\xB9\x40\xF5\xD2\xD1\xC9\x20\x0F\xE3\x38\xF9\xCC"
    "\x5E\x2A\xBD\x1F\x91\x66\x1A\xD8\x2A\x80\x3C\x2C\x00\x3C\x1E\xC9"
    "\x2A\x29\x19\x19\x96\x18\x54\x03\x97\x8F\x1D\x5F\xDB\xE9\x66\x68"
    "\xCD\xB1\xD5\x00\x35\x69\x49\x45\xF1\x6A\x78\x7B\x37\x71\x87\x14"
    "\x1C\x98\x4D\x69\xCB\x1B\xD8\xF5\xA3\xD8\x53\x4A\x75\x76\x62\xBA"
    "\x6C\x3F\xEA\x8B\x97\x21\xCA\x8A\x46\x4B\x38\xDA\x09\x9F\x5A\xC8"
    "\x38\xFF\x34\x97\x5B\xA2\xE5\xBA\xC9\x87\x17\xD8\x08\x05\x7A\x83"
    "\x04\xD6\x02\x8E\x9B\x18\xB6\x40\x1A\xF7\x47\x25\x24\x3E\x37\x1E"
    "\xF6\xC1\x3A\x1F\xCA\xB3\x43\x5A\xAE\x94\x83\x31\xAF\xFB\xEE\xED"
    "\x46\x71\xEF\xE2\x37\x37\x15\xFE\x1B\x0B\x9E\xF8\x3E\x0C\x43\x96"
    "\xB6\x0A\x04\x78\xF8\x5E\xAA\x33\x1F\xE2\x07\x5A\x8D\xC4\x4E\x32"
    "\x6D\xD6\xA0\xC5\xEA\x3D\x12\x59\xD4\x41\x40\x4E\xA1\xD8\xBE\xED"
    "\x17\xCB\x68\xCC\x59\xCB\x53\xB2\x0E\x58\x8A\xA9\x33\x7F\x6F\x2B"
    "\x37\x89\x08\x44\xBA\xC7\x67\x17\xBB\x91\xF7\xC3\x0F\x00\xF8\xAA"
    "\xA1\x33\xA6\x08\x47\xCA\xFA\xE8\x49\x27\x45\x46\xF1\xC1\xC3\x5F"
    "\xE2\x45\x0A\x7D\x64\x52\x8C\x2E\xE1\xDE\xFF\xB2\x64\xEC\x69\x98"
    "\x15\xDF\x9E\xB1\xEB\xD6\x9D\x08\x06\x4E\x73\xC1\x0B\x71\x21\x05"
    "\x9E\xBC\xA2\x17\xCF\xB3\x70\xF4\xEF\xB8\x69\xA9\x94\x27\xFD\x5E"
    "\x72\xB1\x2D\xD2\x20\x1B\x57\x80\xAB\x38\x97\xCF\x22\x68\x4F\xB8"
    "\xB7\x17\x53\x25\x67\x0B\xED\xD1\x58\x20\x0D\x45\xF9\x09\xFA\xE7"
    "\x61\x3E\xDB\xC2\x59\x7B\x3A\x3B\x59\x81\x51\xAA\xA4\x81\xF4\x96"
    "\x3B\xE1\x6F\x6F\xF4\x8E\x68\x9E\xBA\x1E\x0F\xF2\x44\x68\x11\xFC"
    "\x2B\x5F\xBE\xF2\xEA\x07\x80\xB9\xCA\x9E\x41\xBD\x2F\x81\xF5\x11"
    "\x2A\x12\xF3\x4F\xD6\x12\x16\x0F\x21\x90\xF1\xD3\x1E\xF1\xA4\x94"
    "\x46\xEA\x30\xF3\x84\x06\xC1\xA4\x51\xFC\x43\x35\xBD\xEF\x4D\x89"
    "\x1D\xA5\x44\xB2\x69\xC4\x0F\xBF\x86\x01\x08\x44\x77\xD5\xB4\xB7"
    "\x5C\x3F\xA7\xD4\x2F\x39\x73\x85\x88\xEE\xB1\x64\x1D\x80\x6C\xEE"
    "\x6E\x31\x90\x92\x0D\xA1\xB7\xC4\x5C\xCC\xEE\x91\xC8\xCB\x11\x2D"
    "\x4A\x1A\x7D\x43\x8F\xEB\x60\x09\xED\x1B\x07\x58\xBE\xBC\xBD\x29"
    "\xF3\xB3\xA3\x4F\xC5\x8A\x30\x33\xB9\xA9\x9F\x43\x08\x27\x15\xC4"
    "\x9C\x5D\x8E\xBD\x5C\x05\xC6\x05\x9C\x87\x60\x08\x1E\xE2\x52\xB8"
    "\x45\x8D\x28\xB6\x2C\x15\x46\x74\x9F\x0E\xAA\x6B\x70\x3A\x2A\x55"
    "\x45\x26\xB2\x58\x4D\x35\xA6\xF1\x96\xBE\x60\xB2\x71\x7B\xF8\x54"
    "\xB9\x90\x21\x8E\xB9\x0F\x35\x98\x5E\x88\xEB\x1A\x53\xB4\x59\x7F"
    "\xAF\x69\x1C\x61\x67\xF4\xF6\xBD\xAC\x24\xCD\xB7\xA9\x67\xE8\xA1"
    "\x83\x85\x5F\x11\x74\x1F\xF7\x4C\x78\x36\xEF\x50\x74\x88\x58\x4B"
    "\x1A\x9F\x84\x9A\x9A\x05\x92\xEC\x1D\xD5\xF3\xC4\x95\x51\x28\xE2"
    "\x3F\x32\x87\xB2\xFD\x21\x27\x66\xE4\x6B\x85\x2F\xDC\x7B\xC0\x22"
    "\xEB\x7A\x94\x20\x5A\x7B\xD3\x7A\xB9\x5B\xF8\x1A\x5A\x84\x4E\xA1"
    "\x73\x41\x53\xD2\x60\xF7\x7C\xEE\x68\x59\x85\x80\xFC\x3D\x70\x4B"
    "\x04\x32\xE7\xF2\xFD\xBD\xB3\xD9\x21\xE2\x37\x56\xA2\x16\xCC\xDE"
    "\x8A\xD3\xBC\x71\xEF\x58\x19\x0E\x45\x8A\x5B\x53\xD6\x77\x30\x6A"
    "\xA7\xF8\x68\x06\x4E\x07\xCA\xCE\x30\xD7\x35\xAB\x1A\xC7\x18\xD4"
    "\xC6\x2F\x1A\xFF\xE9\x7A\x94\x0B\x76\x5E\x7E\x29\x0C\xE6\xD3\x3B"
    "\x5B\x44\x96\xA8\xF1\x29\x23\x95\xD9\x79\xB3\x39\xFC\x76\xED\xE1"
    "\x1E\x67\x4E\xF7\xE8\x7B\x7A\x12\x9E\xD8\x4B\x35\x09\x0A\xF2\xC1"
    "\x63\x5B\xEE\xFD\x2A\xC2\xA6\x66\x30\x3C\x1F\x95\xAF\x65\x22\x95"
    "\x14\x1D\xF5\xD5\xDC\x38\x79\x35\x1C\xCD\x24\x47\xE0\xFD\x08\xC8"
    "\xF4\x15\x55\x9F\xD9\xC7\xAC\x3F\x67\xB3\x4F\xEB\x26\x7C\x8E\xD6"
    "\x74\xB3\x0A\xCD\xE7\xFA\xBE\x7E\xA3\x3E\xEC\x61\x50\x77\x52\x56"
    "\xCF\x90\x5D\x48\xFB\xD4\x2C\x6C\x61\x8B\xDD\x2B\xF5\x92\x1F\x30"
    "\xBF\x3F\x80\x0D\x31\xDB\xB2\x0B\x7D\x84\xE3\xA6\x42\x7F\x00\x38"
    "\x44\x02\xC5\xB8\xD9\x58\x29\x9D\x68\x5C\x32\x8B\x76\xAE\xED\x15"
    "\xF9\x7C\xAE\x7B\xB6\x8E\xD6\x54\x24\xFF\xFA\x87\x05\xEF\x15\x08"
    "\x5E\x4B\x21\xA2\x2F\x49\xE7\x0F\xC3\xD0\xB9\x49\x22\xEF\xD5\xCA"
    "\xB2\x11\xF2\x17\xB6\x77\x24\x68\x76\xB2\x07\xF8\x0A\x73\xDD\x65"
    "\x9C\x75\x64\xF7\xA1\xC6\x23\x08\x84\x72\x3E\x54\x2E\xEB\x9B\x40"
    "\xA6\x83\x87\xEB\xB5\x00\x40\x4F\xE1\x72\x2A\x59\x3A\x06\x60\x29"
    "\x7E\x25\x2F\xD8\x80\x40\x8C\x59\xCA\xCF\x8E\x44\xE4\x2D\x84\x7E"
    "\xCB\xFD\x1E\x3B\xD5\xFF\x9A\xB9\x66\x93\x6D\x5E\xC8\xB7\x13\x26"
    "\xD6\x38\x1B\x2B\xE1\x87\x96\x05\xD5\xF3\xAB\x68\xF7\x12\x62\x2C"
    "\x58\xC1\xC9\x85\x3C\x72\xF1\x26\xEE\xC0\x09\x5F\x1D\x4B\xAC\x01"
    "\x41\xC8\x12\xF8\xF3\x93\x43\x41\xFF\xEC\x0B\x80\xE2\xEE\x20\x85"
    "\x25\xCD\x6C\x30\x8C\x0D\x24\x2E\xBA\x19\xEA\x28\x7F\xCF\xD5\x10"
    "\x5C\xE9\xB2\x9D\x5F\x16\xE4\xC0\xF3\xCC\xD9\x68\x4A\x05\x08\x70"
    "\x17\x26\xC8\x5C\x4A\xBF\x94\x6A\x0E\xD5\xDA\x67\x47\x4B\xAF\x44"
    "\xE3\x94\xAA\x05\xDB\xA2\x49\x74\xFA\x5C\x69\xAB\x44\xB7\xF7\xBA"
    "\xAE\x7A\x23\x87\xEB\x54\x7E\x80\xF1\x5B\x60\xA5\x93\xE5\xD4\x24"
    "\x84\xF7\x0A\x16\x10\xBE\xE9\x4D\xD8\x6B\x15\x40\x5D\x74\xDA\x1B"
    "\xFF\x2E\x4D\x17\x9D\x35\xF7\x0D\xCF\x66\x38\x0D\x8A\xE4\xDD\x6B"
    "\xE1\x0F\x1F\xBD\xFD\x4F\x30\x37\x3F\x96\xB4\x92\x54\xD3\x9A\x7A"
    "\xD1\x5B\x5B\xA9\x54\x16\xE6\x24\xAB\xD4\x23\x39\x7D\xD2\xC7\x09"
    "\xFA\xD4\x86\x55\x4D\x60\xC2\x87\x67\x6B\xE6"
};

static void
test_pac_ticket_signature(krb5_context context)
{
    krb5_error_code ret;
    krb5_ticket *ticket;
    krb5_principal cprinc, sprinc;
    krb5_authdata **authdata1, **authdata2;
    krb5_pac pac, pac2, pac3;
    uint32_t *list;
    size_t len, i;
    krb5_data data;

    ret = krb5_decode_ticket(&ticket_data, &ticket);
    if (ret)
        err(context, ret, "while decoding ticket");

    ret = krb5_decrypt_tkt_part(context, &ticket_sig_server_key, ticket);
    if (ret)
        err(context, ret, "while decrypting ticket");

    ret = krb5_parse_name(context, "administrator@W2022-L7.BASE", &cprinc);
    if (ret)
        err(context, ret, "krb5_parse_name");

    ret = krb5_parse_name(context,
                          "cifs/w2022-118.w2022-l7.base@W2022-L7.BASE",
                          &sprinc);
    if (ret)
        err(context, ret, "krb5_parse_name");

    ret = krb5_kdc_verify_ticket(context, ticket->enc_part2, sprinc,
                                 &ticket_sig_server_key,
                                 &ticket_sig_krbtgt_key, &pac);
    if (ret)
        err(context, ret, "while verifying ticket");

    /* In this test, the server is also the client. */
    ret = krb5_pac_verify(context, pac, ticket->enc_part2->times.authtime,
                          cprinc, NULL, NULL);
    if (ret)
        err(context, ret, "while verifying PAC client info");

    /* We know there is only a PAC in this test's ticket. */
    authdata1 = ticket->enc_part2->authorization_data;
    ticket->enc_part2->authorization_data = NULL;

    ret = krb5_kdc_sign_ticket(context, ticket->enc_part2, pac, sprinc,
                               cprinc, &ticket_sig_server_key,
                               &ticket_sig_krbtgt_key, FALSE);
    if (ret)
        err(context, ret, "while signing ticket");

    authdata2 = ticket->enc_part2->authorization_data;
    assert(authdata2 != NULL);
    assert(authdata2[1] == NULL);

    assert(authdata1[0]->length == authdata2[0]->length);
    assert(memcmp(authdata1[0]->contents, authdata2[0]->contents,
                  authdata1[0]->length) == 0);

    /* Test adding signatures to a new PAC. */
    ret = krb5_pac_init(context, &pac2);
    if (ret)
        err(context, ret, "krb5_pac_init");

    ret = krb5_pac_get_types(context, pac, &len, &list);
    if (ret)
        err(context, ret, "krb5_pac_get_types");

    for (i = 0; i < len; i++) {
        /* Skip server_cksum, privsvr_cksum, and ticket_cksum. */
        if (list[i] == 6 || list[i] == 7 || list[i] == 16)
            continue;

        ret = krb5_pac_get_buffer(context, pac, list[i], &data);
        if (ret)
            err(context, ret, "krb5_pac_get_buffer");

        ret = krb5_pac_add_buffer(context, pac2, list[i], &data);
        if (ret)
            err(context, ret, "krb5_pac_add_buffer");

        krb5_free_data_contents(context, &data);
    }
    free(list);

    krb5_free_authdata(context, authdata1);
    krb5_free_authdata(context, ticket->enc_part2->authorization_data);
    ticket->enc_part2->authorization_data = NULL;

    ret = krb5_kdc_sign_ticket(context, ticket->enc_part2, pac2, sprinc, NULL,
                               &ticket_sig_server_key, &ticket_sig_krbtgt_key,
                               FALSE);
    if (ret)
        err(context, ret, "while signing ticket");

    /* We can't compare the data since the order of the buffers may differ. */
    ret = krb5_kdc_verify_ticket(context, ticket->enc_part2, sprinc,
                                 &ticket_sig_server_key,
                                 &ticket_sig_krbtgt_key, &pac3);
    if (ret)
        err(context, ret, "while verifying ticket");

    krb5_pac_free(context, pac);
    krb5_pac_free(context, pac2);
    krb5_pac_free(context, pac3);
    krb5_free_principal(context, cprinc);
    krb5_free_principal(context, sprinc);
    krb5_free_ticket(context, ticket);
}

int
main(int argc, char **argv)
{
    krb5_error_code ret;
    krb5_context context;
    krb5_pac pac;
    krb5_data data;
    krb5_principal p;

    ret = krb5_init_context(&context);
    if (ret)
        err(NULL, 0, "krb5_init_contex");

    test_pac_ticket_signature(context);

    ret = krb5_set_default_realm(context, "WIN2K3.THINKER.LOCAL");
    if (ret)
        err(context, ret, "krb5_set_default_realm");

    ret = krb5_parse_name(context, user, &p);
    if (ret)
        err(context, ret, "krb5_parse_name");

    /* Check a pre-saved PAC. */
    check_pac(context, -1, saved_pac, sizeof(saved_pac), authtime, p,
              type_1_length, 0, &member_keyblock, &kdc_keyblock);

    /* Check S4U2Self PACs. */
    {
        krb5_principal sp;
        krb5_principal sep;
        const struct pac_and_info *pi;

        ret = krb5_parse_name(context, s4u_principal, &sp);
        if (ret)
            err(context, ret, "krb5_parse_name");

        ret = krb5_parse_name_flags(context, s4u_enterprise,
                                    KRB5_PRINCIPAL_PARSE_ENTERPRISE, &sep);
        if (ret)
            err(context, ret, "krb5_parse_name_flags");

        for (pi = s4u_pacs; pi->data != NULL; pi++) {
            check_pac(context, pi - s4u_pacs, pi->data, pi->length,
                      pi->authtime, pi->is_enterprise ? sep : sp,
                      s4u_logon_info_buffer_len, pi->is_xrealm,
                      pi->is_xrealm ? &s4u_tgt_srv_key : &s4u_srv_key, NULL);
        }

        krb5_free_principal(context, sp);
        krb5_free_principal(context, sep);
    }

    /* Check problematic PACs found by fuzzing. */
    ret = krb5_pac_parse(context, fuzz1, sizeof(fuzz1), &pac);
    if (!ret)
        err(context, ret, "krb5_pac_parse should have failed");
    ret = krb5_pac_parse(context, fuzz2, sizeof(fuzz2), &pac);
    if (!ret)
        err(context, ret, "krb5_pac_parse should have failed");

    /*
     * Test empty free
     */

    ret = krb5_pac_init(context, &pac);
    if (ret)
        err(context, ret, "krb5_pac_init");
    krb5_pac_free(context, pac);

    /*
     * Test add remove buffer
     */

    ret = krb5_pac_init(context, &pac);
    if (ret)
        err(context, ret, "krb5_pac_init");

    {
        const krb5_data cdata = { 0, 2, "\x00\x01" } ;

        ret = krb5_pac_add_buffer(context, pac, 1, &cdata);
        if (ret)
            err(context, ret, "krb5_pac_add_buffer");
    }
    {
        ret = krb5_pac_get_buffer(context, pac, 1, &data);
        if (ret)
            err(context, ret, "krb5_pac_get_buffer");
        if (data.length != 2 || memcmp(data.data, "\x00\x01", 2) != 0)
            err(context, 0, "krb5_pac_get_buffer data not the same");
        krb5_free_data_contents(context, &data);
    }

    {
        const krb5_data cdata = { 0, 2, "\x02\x00" } ;

        ret = krb5_pac_add_buffer(context, pac, 2, &cdata);
        if (ret)
            err(context, ret, "krb5_pac_add_buffer");
    }
    {
        ret = krb5_pac_get_buffer(context, pac, 1, &data);
        if (ret)
            err(context, ret, "krb5_pac_get_buffer");
        if (data.length != 2 || memcmp(data.data, "\x00\x01", 2) != 0)
            err(context, 0, "krb5_pac_get_buffer data not the same");
        krb5_free_data_contents(context, &data);
        /* */
        ret = krb5_pac_get_buffer(context, pac, 2, &data);
        if (ret)
            err(context, ret, "krb5_pac_get_buffer");
        if (data.length != 2 || memcmp(data.data, "\x02\x00", 2) != 0)
            err(context, 0, "krb5_pac_get_buffer data not the same");
        krb5_free_data_contents(context, &data);
    }

    ret = krb5_pac_sign(context, pac, authtime, p,
                        &member_keyblock, &kdc_keyblock, &data);
    if (ret)
        err(context, ret, "krb5_pac_sign");

    krb5_pac_free(context, pac);

    ret = krb5_pac_parse(context, data.data, data.length, &pac);
    krb5_free_data_contents(context, &data);
    if (ret)
        err(context, ret, "krb5_pac_parse 3");

    ret = krb5_pac_verify(context, pac, authtime, p,
                          &member_keyblock, &kdc_keyblock);
    if (ret)
        err(context, ret, "krb5_pac_verify 3");

    {
        uint32_t *list;
        size_t len;

        /* our two user buffer plus the three "system" buffers */
        ret = krb5_pac_get_types(context, pac, &len, &list);
        if (ret)
            err(context, ret, "krb5_pac_get_types");
        if (len != 5)
            err(context, 0, "list wrong length");
        free(list);
    }

    {
        krb5_principal ep, np;

        ret = krb5_parse_name_flags(context, user,
                                    KRB5_PRINCIPAL_PARSE_ENTERPRISE, &ep);
        if (ret)
            err(context, ret, "krb5_parse_name_flags");

        ret = krb5_copy_principal(context, ep, &np);
        if (ret)
            err(context, ret, "krb5_copy_principal");
        np->type = KRB5_NT_MS_PRINCIPAL;

        /* Try to verify as enterprise. */
        ret = krb5_pac_verify(context, pac, authtime, ep, &member_keyblock,
                              &kdc_keyblock);
        if (!ret)
            err(context, ret, "krb5_pac_verify should have failed");

        ret = krb5_pac_sign(context, pac, authtime, ep, &member_keyblock,
                            &kdc_keyblock, &data);
        if (!ret)
            err(context, ret, "krb5_pac_sign should have failed");

        /* Try to verify with realm. */
        ret = krb5_pac_verify_ext(context, pac, authtime, p, &member_keyblock,
                                  &kdc_keyblock, TRUE);
        if (!ret)
            err(context, ret, "krb5_pac_verify_ext with realm should fail");

        /* Currently we can't re-sign the PAC with realm (although that could
         * be useful), only sign a new one. */
        ret = krb5_pac_sign_ext(context, pac, authtime, p, &member_keyblock,
                                &kdc_keyblock, TRUE, &data);
        if (!ret)
            err(context, ret, "krb5_pac_sign_ext with realm should fail");

        krb5_pac_free(context, pac);

        /* Test enterprise. */
        ret = krb5_pac_init(context, &pac);
        if (ret)
            err(context, ret, "krb5_pac_init");

        ret = krb5_pac_sign(context, pac, authtime, ep, &member_keyblock,
                            &kdc_keyblock, &data);
        if (ret)
            err(context, ret, "krb5_pac_sign enterprise failed");

        krb5_pac_free(context, pac);

        ret = krb5_pac_parse(context, data.data, data.length, &pac);
        krb5_free_data_contents(context, &data);
        if (ret)
            err(context, ret, "krb5_pac_parse failed");

        ret = krb5_pac_verify(context, pac, authtime, ep, &member_keyblock,
                              &kdc_keyblock);
        if (ret)
            err(context, ret, "krb5_pac_verify enterprise failed");

        /* Also verify enterprise as KRB5_NT_MS_PRINCIPAL. */
        ret = krb5_pac_verify(context, pac, authtime, np, &member_keyblock,
                              &kdc_keyblock);
        if (ret)
            err(context, ret, "krb5_pac_verify enterprise as nt-ms failed");

        ret = krb5_pac_verify(context, pac, authtime, p, &member_keyblock,
                              &kdc_keyblock);
        if (!ret)
            err(context, ret, "krb5_pac_verify should have failed");

        krb5_pac_free(context, pac);

        /* Test nt-ms-principal. */
        ret = krb5_pac_init(context, &pac);
        if (ret)
            err(context, ret, "krb5_pac_init");

        ret = krb5_pac_sign(context, pac, authtime, np, &member_keyblock,
                            &kdc_keyblock, &data);
        if (ret)
            err(context, ret, "krb5_pac_sign enterprise failed");

        krb5_pac_free(context, pac);

        ret = krb5_pac_parse(context, data.data, data.length, &pac);
        krb5_free_data_contents(context, &data);
        if (ret)
            err(context, ret, "krb5_pac_parse failed");

        ret = krb5_pac_verify(context, pac, authtime, np, &member_keyblock,
                              &kdc_keyblock);
        if (ret)
            err(context, ret, "krb5_pac_verify enterprise failed");

        /* Also verify as enterprise principal. */
        ret = krb5_pac_verify(context, pac, authtime, ep, &member_keyblock,
                              &kdc_keyblock);
        if (ret)
            err(context, ret, "krb5_pac_verify nt-ms as enterprise failed");

        ret = krb5_pac_verify(context, pac, authtime, p, &member_keyblock,
                              &kdc_keyblock);
        if (!ret)
            err(context, ret, "krb5_pac_verify should have failed");

        krb5_pac_free(context, pac);

        /* Test with realm. */
        ret = krb5_pac_init(context, &pac);
        if (ret)
            err(context, ret, "krb5_pac_init");

        ret = krb5_pac_sign_ext(context, pac, authtime, p, &member_keyblock,
                                &kdc_keyblock, TRUE, &data);
        if (ret)
            err(context, ret, "krb5_pac_sign_ext with realm failed");

        krb5_pac_free(context, pac);

        ret = krb5_pac_parse(context, data.data, data.length, &pac);
        krb5_free_data_contents(context, &data);
        if (ret)
            err(context, ret, "krb5_pac_parse failed");

        ret = krb5_pac_verify_ext(context, pac, authtime, p, &member_keyblock,
                                  &kdc_keyblock, TRUE);
        if (ret)
            err(context, ret, "krb5_pac_verify_ext with realm failed");

        ret = krb5_pac_verify(context, pac, authtime, p, &member_keyblock,
                              &kdc_keyblock);
        if (!ret)
            err(context, ret, "krb5_pac_verify should have failed");

        krb5_pac_free(context, pac);

        /* Test enterprise with realm. */
        ret = krb5_pac_init(context, &pac);
        if (ret)
            err(context, ret, "krb5_pac_init");

        ret = krb5_pac_sign_ext(context, pac, authtime, ep, &member_keyblock,
                                &kdc_keyblock, TRUE, &data);
        if (ret)
            err(context, ret, "krb5_pac_sign_ext ent with realm failed");

        krb5_pac_free(context, pac);

        ret = krb5_pac_parse(context, data.data, data.length, &pac);
        krb5_free_data_contents(context, &data);
        if (ret)
            err(context, ret, "krb5_pac_parse failed");

        ret = krb5_pac_verify_ext(context, pac, authtime, ep, &member_keyblock,
                                  &kdc_keyblock, TRUE);
        if (ret)
            err(context, ret, "krb5_pac_verify_ext ent with realm failed");

        ret = krb5_pac_verify(context, pac, authtime, p, &member_keyblock,
                              &kdc_keyblock);
        if (!ret)
            err(context, ret, "krb5_pac_verify should have failed");

        ret = krb5_pac_verify(context, pac, authtime, ep, &member_keyblock,
                              &kdc_keyblock);
        if (!ret)
            err(context, ret, "krb5_pac_verify should have failed");

        ret = krb5_pac_verify_ext(context, pac, authtime, p, &member_keyblock,
                                  &kdc_keyblock, TRUE);
        if (!ret)
            err(context, ret, "krb5_pac_verify_ext should have failed");

        krb5_free_principal(context, ep);
        krb5_free_principal(context, np);
    }

    krb5_pac_free(context, pac);

    krb5_free_principal(context, p);
    krb5_free_context(context);

    return 0;
}
