.\" dpkg manual page - dpkg-gencontrol(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006, 2012-2013, 2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2007-2008 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH dpkg\-gencontrol 1 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
dpkg\-gencontrol \- generate Debian control files
.
.SH SYNOPSIS
.B dpkg\-gencontrol
.RI [ option ...]
.
.SH DESCRIPTION
.B dpkg\-gencontrol
reads information from an unpacked Debian source tree and generates a
binary package control file (which defaults to debian/tmp/DEBIAN/control);
during this process it will simplify the relation fields.
.sp
Thus
.BR Pre\-Depends ", " Depends ", " Recommends " and " Suggests
are simplified in this
order by removing dependencies which are known to be true according to the
stronger dependencies already parsed. It will also remove any self-dependency
(in fact it will remove any dependency which evaluates to true given the
current version of the package as installed). Logically it keeps the
intersection of multiple dependencies on the same package. The order
of dependencies is preserved as best as possible: if any dependency
must be discarded due to another dependency appearing further
in the field, the superseding dependency will take the place of the
discarded one.
.sp
The other relation fields
.RB ( Enhances ", " Conflicts ", " Breaks ", " Replaces " and " Provides )
are also simplified individually by computing the union of the various
dependencies when a package is listed multiple times in the field.
.sp
.B dpkg\-gencontrol
also adds an entry for the binary package to
.BR debian/files .
.
.SH OPTIONS
.TP
.BI \-v version
Sets the version number of the binary package which will be generated.
.TP
.BI \-V name = value
Set an output substitution variable. See \fBdeb\-substvars\fP(5) for
discussion of output substitution.
.TP
.BI \-T substvars-file
Read substitution variables in
.IR substvars-file ;
the default is
.BR debian/substvars .
This option can be used multiple times to read substitution variables from
multiple files (since dpkg 1.15.6).
.TP
.BI \-D field = value
Override or add an output control file field.
.TP
.BI \-U field
Remove an output control file field.
.TP
.BI \-c control-file
Specifies the main source control file to read information from. The
default is
.BR debian/control .
.TP
.BI \-l changelog-file
Specifies the changelog file to read information from. The
default is
.BR debian/changelog .
.TP
.BI \-f files-list-file
Read or write the list of files to be uploaded here, rather than using
.BR debian/files .
.TP
.BI \-F changelog-format
Specifies the format of the changelog. See \fBdpkg\-parsechangelog\fP(1)
for information about alternative formats.
.TP
.BI \-p package
Generate information for the binary package
.IR package .
If the source control file lists only one binary package then this
option may be omitted; otherwise it is essential to select which
binary package's information to generate.
.TP
.BI \-n filename
Assume the filename of the package will be
.I filename
instead of the normal package_version_arch.deb filename.
.TP
.BR \-is ", " \-ip ", " \-isp
These options are ignored for compatibility with older versions of the dpkg
build scripts but are now deprecated. Previously they were used to tell
\fBdpkg\-gencontrol\fP to include the Section and Priority fields in the
control file. This is now the default behaviour. If you want to
get the old behaviour you can use the
.B \-U
option to delete the fields from the control file.
.TP
.BI \-P package-build-dir
Tells
.B dpkg\-source
that the package is being built in
.I package-build-dir
instead of
.BR debian/tmp .
This value is used to find the default value of the
.B Installed\-Size
substitution variable and control file field (using
.BR du ),
and for the default location of the output file.
.TP
.BR \-O [\fIfilename\fP]
Print the control file to standard output (or \fIfilename\fP if specified,
since dpkg 1.17.2), rather than to
.B debian/tmp/DEBIAN/control
(or
.IB package-build-dir /DEBIAN/control
if
.B \-P
was used).
.TP
.BR \-? ", " \-\-help
Show the usage message and exit.
.TP
.BR \-\-version
Show the version and exit.
.
.SH FILES
.TP
.B debian/control
The main source control information file, giving version-independent
information about the source package and the binary packages it can
produce.
.TP
.B debian/files
The list of generated files which are part of the upload being
prepared.
.B dpkg\-gencontrol
adds the presumed filenames of binary packages whose control files it
generates here.
.SH SEE ALSO
.ad l
.BR deb\-substvars (5),
.BR deb\-src\-control (5),
.BR deb\-changelog (5),
.BR deb\-control (5).
