/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorBackground;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class ComponentRoseGroupingElse
extends AbstractTextualComponent {
    private final HColor groupBorder;
    private final HColor backgroundColor;

    public ComponentRoseGroupingElse(Style style, HColor groupBorder, FontConfiguration smallFont, CharSequence comment, ISkinSimple spriteContainer, HColor backgroundColor) {
        super(style, LineBreakStrategy.NONE, comment == null ? null : "[" + comment + "]", smallFont, HorizontalAlignment.LEFT, 5, 5, 1, spriteContainer, null, null);
        if (UseStyle.useBetaStyle()) {
            if (spriteContainer instanceof SkinParamBackcolored) {
                style = style.eventuallyOverride(PName.BackGroundColor, ((SkinParamBackcolored)spriteContainer).getBackgroundColor(false));
            }
            this.groupBorder = style.value(PName.LineColor).asColor(spriteContainer.getThemeStyle(), this.getIHtmlColorSet());
            this.backgroundColor = style.value(PName.BackGroundColor).asColor(spriteContainer.getThemeStyle(), this.getIHtmlColorSet());
        } else {
            this.groupBorder = groupBorder;
            this.backgroundColor = backgroundColor;
        }
    }

    @Override
    protected void drawBackgroundInternalU(UGraphic ug, Area area) {
        if (this.backgroundColor instanceof HColorBackground) {
            return;
        }
        Dimension2D dimensionToUse = area.getDimensionToUse();
        URectangle rect = new URectangle(dimensionToUse.getWidth(), dimensionToUse.getHeight());
        ug.apply(new HColorNone()).apply(this.backgroundColor.bg()).draw(rect);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        ug = ArrowConfiguration.stroke(ug, 2.0, 2.0, 1.0).apply(this.groupBorder);
        ug.apply(UTranslate.dy(1.0)).draw(ULine.hline(dimensionToUse.getWidth()));
        ug = ug.apply(new UStroke());
        this.getTextBlock().drawU(ug.apply(new UTranslate(this.getMarginX1(), this.getMarginY())));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder);
    }
}

